/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.content;

public class ContentException
extends Exception {
    private static final long serialVersionUID = -3051194702189345666L;
    private String errorCode;

    public ContentException(String errorCode, String error) {
        super(error);
        this.setErrorCode(errorCode);
    }

    public ContentException(Exception exception) {
        super(exception);
    }

    public ContentException(String errorCode, String error, Exception exception) {
        super(error, exception);
        this.setErrorCode(errorCode);
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        StringBuffer errorMsg = new StringBuffer(this.getClass().getSimpleName());
        errorMsg.append(": {Code}-" + this.getErrorCode());
        errorMsg.append(", {Message}-" + super.getMessage());
        return errorMsg.toString();
    }

    public String getRootCause() {
        Throwable th = this.getCause();
        String rootCauseMessage = this.getMessage();
        if (th instanceof ContentException) {
            ContentException contentException = (ContentException)th;
            rootCauseMessage = contentException.getRootCause();
            if (rootCauseMessage == null || rootCauseMessage.trim().equals("")) {
                rootCauseMessage = this.getMessage();
            }
            return rootCauseMessage;
        }
        return th != null ? rootCauseMessage + "[ " + th.toString() + " ]" : rootCauseMessage;
    }
}

