/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.livecycle.content;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMessages {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryMessages.class);
    private static final String BUNDLE_NAME = "com.adobe.livecycle.content.repositoryMessages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.adobe.livecycle.content.repositoryMessages");
    public static final String ERR_CONFIG_PERSIST = "LCC-CFG-APP-001";
    public static final String ERR_CONFIG_RETRIEVE = "LCC-CFG-APP-002";
    public static final String ERR_CONFIG_REMOVE = "LCC-CFG-APP-003";
    public static final String WARN_APP_ID_ALREADY_REG = "LCC-CFG-APP-004";
    public static final String ERR_APP_ID_NOT_REG = "LCC-CFG-APP-005";
    public static final String ERR_APP_ROOT_ALREADY_PRESENT = "LCC-CFG-APP-006";
    public static final String ERR_APP_ROOT_ABSENT = "LCC-CFG-APP-007";
    public static final String ERR_NOT_SELECTING = "LCC-CFG-XPT-001";
    public static final String ERR_WRONG_TYPE = "LCC-CFG-XPT-002";
    public static final String ERR_UNKNOWN_PROP_CHILD = "LCC-CFG-XPT-003";
    public static final String ERR_XPATH_SYNTAX = "LCC-CFG-XPT-004";
    public static final String ERR_NODE_TYPE = "LCC-CFG-XPT-005";
    public static final String ERR_SUB_NODE_TYPE = "LCC-CFG-XPT-006";
    public static final String ERR_GENERAL_EXCEPTION_TYPE = "LCC-GEN-EXP-001";

    private RepositoryMessages() {
    }

    public static String getString(String key) {
        StringBuffer message = new StringBuffer();
        message.append("{" + key + "}-");
        message.append(RepositoryMessages.getMessage(key));
        return message.toString();
    }

    public static String getString(String key, Object[] params) {
        StringBuffer message = new StringBuffer();
        message.append("{" + key + "}-");
        message.append(RepositoryMessages.getMessage(key, params));
        return message.toString();
    }

    public static String getMessage(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            logger.debug("Ignore this exception", (Throwable)e);
            return '!' + key + '!';
        }
    }

    public static String getMessage(String key, Object[] params) {
        try {
            String message = RESOURCE_BUNDLE.getString(key);
            return MessageFormat.format(message, params);
        }
        catch (MissingResourceException e) {
            logger.debug("Ignore this exception", (Throwable)e);
            return '!' + key + '!';
        }
    }
}

