/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.CodeSigner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class UCFOutputStream {
    protected RandomAccessFile raf;
    protected LittleEndianOutputStream os;
    protected CRC32 crc = new CRC32();
    protected List files = new ArrayList();
    protected CodeSigner codeSigner;

    public UCFOutputStream() {
        this.os = new LittleEndianOutputStream();
    }

    public void setOutput(File output) throws FileNotFoundException {
        if (this.raf != null) {
            throw new IllegalStateException("output already set");
        }
        this.raf = new RandomAccessFile(output, "rw");
    }

    public void setPrivateKey(PrivateKey key) {
        if (this.files.size() > 0) {
            throw new IllegalStateException("files already added");
        }
        if (this.codeSigner != null) {
            throw new IllegalStateException("private key already set");
        }
        this.codeSigner = new CodeSigner();
        this.codeSigner.setPrivateKey(key);
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not yet set");
        }
        this.codeSigner.setCertificateChain(certchain);
    }

    public void setSignerCertificate(Certificate cert) throws CertificateException {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not yet set");
        }
        this.codeSigner.setSignerCertificate(cert);
    }

    public void setTimestampURL(String url) {
        if (this.codeSigner == null) {
            throw new IllegalStateException("private key not yet set");
        }
        this.codeSigner.setTimestampURL(url);
    }

    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
        this.addData(mimeType.getBytes("UTF-8"), "mimetype", new Date(), addToSignature, false);
    }

    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        FileRecord record = new FileRecord(new Date(file.lastModified()));
        record.path = path;
        record.size = file.length();
        this.addFile(record, new FileInputStream(file), addToSignature, true);
    }

    public void addString(String string, String encoding, String path, Date date, boolean addToSignature) throws IOException {
        this.addData(string.getBytes(encoding), path, date, addToSignature, true);
    }

    public void addData(byte[] data, String path, Date date, boolean addToSignature, boolean compress) throws IOException {
        FileRecord record = new FileRecord(date);
        record.path = path;
        record.size = data.length;
        this.addFile(record, new ByteArrayInputStream(data), addToSignature, compress);
    }

    public void finalizeSig() throws IOException, GeneralSecurityException {
        if (this.codeSigner != null) {
            try {
                this.codeSigner.sign();
            }
            catch (Exception e2) {
                throw new IOException("Unable to create signature.");
            }
            byte[] signature = this.codeSigner.getSignatureXML().getBytes("UTF-8");
            FileRecord record = new FileRecord(new Date());
            record.path = "META-INF/signatures.xml";
            record.size = signature.length;
            this.addFile(record, new ByteArrayInputStream(signature), false, true);
        }
    }

    public void close() throws IOException {
        if (this.raf != null) {
            long cdOffset = this.raf.getFilePointer();
            Iterator i2 = this.files.iterator();
            while (i2.hasNext()) {
                FileRecord r2 = (FileRecord)i2.next();
                byte[] cdr = this.getCentralDirectoryRecord(r2);
                this.raf.write(cdr);
            }
            long cdSize = this.raf.getFilePointer() - cdOffset;
            this.os.reset();
            this.os.writeLong(101010256L);
            this.os.writeShort(0);
            this.os.writeShort(0);
            this.os.writeShort(this.files.size());
            this.os.writeShort(this.files.size());
            this.os.writeLong(cdSize);
            this.os.writeLong(cdOffset);
            this.os.writeShort(0);
            byte[] eocdr = this.os.getBytes();
            this.raf.write(eocdr);
            this.beforeClose();
            this.raf.close();
        }
    }

    protected void beforeClose() throws IOException {
    }

    protected void processBytes(byte[] bytes, int numBytes) {
    }

    protected void addFile(FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException {
        int bytesRead;
        if (this.raf == null) {
            throw new IllegalStateException("output not yet set");
        }
        boolean NO_ZLIB_HEADER = true;
        File tempFile = File.createTempFile("ucf", null);
        tempFile.deleteOnExit();
        OutputStream tempOutput = new FileOutputStream(tempFile);
        if (compress) {
            tempOutput = new DeflaterOutputStream(tempOutput, new Deflater(9, true));
        }
        this.crc.reset();
        byte[] buffer = new byte[4096];
        while ((bytesRead = data.read(buffer)) != -1) {
            this.crc.update(buffer, 0, bytesRead);
            tempOutput.write(buffer, 0, bytesRead);
            if (this.codeSigner != null && addToSignature) {
                this.codeSigner.updateFileDigest(buffer, 0, bytesRead);
            }
            this.processBytes(buffer, bytesRead);
        }
        data.close();
        tempOutput.close();
        record.lfhOffset = this.raf.getFilePointer();
        record.crc32 = this.crc.getValue();
        record.compressedSize = record.size;
        InputStream tempInput = new FileInputStream(tempFile);
        if (compress) {
            long compressedSize = tempFile.length();
            if (compressedSize < record.size) {
                record.compressedSize = compressedSize;
            } else {
                tempInput = new InflaterInputStream(tempInput, new Inflater(true));
            }
        }
        byte[] lfh = this.getLocalFileHeader(record);
        this.raf.write(lfh);
        while (true) {
            int bytesRead2 = -1;
            try {
                bytesRead2 = tempInput.read(buffer);
            }
            catch (EOFException e2) {
                // empty catch block
            }
            if (bytesRead2 == -1) break;
            this.raf.write(buffer, 0, bytesRead2);
        }
        tempInput.close();
        tempFile.delete();
        if (this.codeSigner != null && addToSignature) {
            byte[] digest = this.codeSigner.finalizeFileDigest();
            this.codeSigner.addFileDigestToManifest(digest, record.path);
        }
        this.files.add(record);
    }

    protected byte[] getLocalFileHeader(FileRecord r2) throws IOException {
        this.os.reset();
        this.os.writeLong(67324752L);
        this.writeCommonHeaderBlock(r2);
        this.os.writeString(r2.path);
        return this.os.getBytes();
    }

    protected byte[] getCentralDirectoryRecord(FileRecord r2) throws IOException {
        this.os.reset();
        this.os.writeLong(33639248L);
        this.os.writeShort(16128);
        this.writeCommonHeaderBlock(r2);
        this.os.writeShort(0);
        this.os.writeShort(0);
        this.os.writeShort(1);
        this.os.writeLong(0L);
        this.os.writeLong(r2.lfhOffset);
        this.os.writeString(r2.path);
        return this.os.getBytes();
    }

    protected void writeCommonHeaderBlock(FileRecord r2) throws IOException {
        boolean NO_COMPRESSION = false;
        int DEFLATE = 8;
        this.os.writeShort(20);
        this.os.writeShort(0);
        this.os.writeShort(r2.compressedSize == r2.size ? 0 : 8);
        this.os.writeShort(r2.lastModifiedTime);
        this.os.writeShort(r2.lastModifiedDate);
        this.os.writeLong(r2.crc32);
        this.os.writeLong(r2.compressedSize);
        this.os.writeLong(r2.size);
        byte[] utf8name = r2.path.getBytes("UTF-8");
        this.os.writeShort(utf8name.length);
        this.os.writeShort(0);
    }

    public static class FileRecord {
        public String path;
        public long lfhOffset;
        public int lastModifiedDate;
        public int lastModifiedTime;
        public long crc32;
        public long size;
        public long compressedSize;

        public FileRecord(Date date) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(date);
            this.lastModifiedTime = c2.get(11) << 11 | c2.get(12) << 5 | c2.get(13) >> 1;
            this.lastModifiedDate = c2.get(1) - 1980 << 9 | c2.get(2) + 1 << 5 | c2.get(5);
        }
    }

    public static class LittleEndianOutputStream {
        ByteArrayOutputStream os = new ByteArrayOutputStream();

        public void writeLong(long l2) {
            this.os.write((byte)l2);
            this.os.write((byte)(l2 >> 8));
            this.os.write((byte)(l2 >> 16));
            this.os.write((byte)(l2 >> 24));
        }

        public void writeShort(int s2) {
            this.os.write((byte)s2);
            this.os.write((byte)(s2 >> 8));
        }

        public void writeString(String s2) throws IOException {
            byte[] utf8bytes = s2.getBytes("UTF-8");
            this.os.write(utf8bytes);
        }

        public void writeBuffer(byte[] data) throws IOException {
            this.os.write(data);
        }

        public void writeBuffer(byte[] data, int offset, int length) {
            this.os.write(data, offset, length);
        }

        public byte[] getBytes() {
            return this.os.toByteArray();
        }

        public void reset() {
            this.os.reset();
        }
    }
}

