/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.Packager;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class UCFPackager
extends Packager {
    private SortedMap m_metaInfSources = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private String m_metaInfNamespace;

    public void setMetaInfNamespace(String namespace) {
        if (this.m_metaInfNamespace != null) {
            throw new IllegalStateException("META-INF namespace already set");
        }
        this.m_metaInfNamespace = namespace;
    }

    public void addMetaInfSourceWithRoot(File source, File root) {
        String path = root.toURI().relativize(source.toURI()).getPath();
        this.addMetaInfSourceWithPath(source, path);
    }

    public void addMetaInfSourceWithPath(File source, String path) {
        if (!source.isFile()) {
            throw new IllegalArgumentException("File does not exist: " + source.getPath());
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("absolute path");
        }
        if (this.m_metaInfSources.containsKey(path)) {
            File other = (File)this.m_metaInfSources.get(path);
            throw new IllegalArgumentException("Files \"" + other.getPath() + "\" and \"" + source.getPath() + "\" have conflicting package paths");
        }
        this.m_metaInfSources.put(path, source);
    }

    public void createPackage() throws Exception {
        String path;
        File file;
        Map.Entry e2;
        this.getStream().addMimeTypeFile("application/vnd.adobe.air-ucf-package+zip", true);
        Iterator i2 = this.m_metaInfSources.entrySet().iterator();
        while (i2.hasNext()) {
            e2 = i2.next();
            file = (File)e2.getValue();
            path = (String)e2.getKey();
            this.getStream().addFile(file, "META-INF/" + this.m_metaInfNamespace + "/" + path, true);
        }
        i2 = this.getSources().entrySet().iterator();
        while (i2.hasNext()) {
            e2 = i2.next();
            file = (File)e2.getValue();
            path = (String)e2.getKey();
            this.getStream().addFile(file, path, true);
        }
        this.getStream().finalizeSig();
        this.getStream().close();
        this.renameOutput();
    }
}

