/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class NonStandardAttribute
extends X501Attribute
implements Cloneable,
Serializable {
    private byte[] a;
    ASN1Template b;

    public NonStandardAttribute() {
        super(23, "NonStandardAttribute");
    }

    public NonStandardAttribute(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        this();
        this.setOID(byArray, n2, n3);
        this.setValue(byArray2, n4, n5);
    }

    protected void decodeValue(byte[] byArray, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            OfContainer ofContainer = new OfContainer(0, 12544, new EncodedContainer(65280));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (ofContainer.getContainerCount() == 0) {
                this.a = new byte[0];
                return;
            }
            EncodedContainer encodedContainer = (EncodedContainer)ofContainer.containerAt(0);
            this.a = new byte[encodedContainer.dataLen];
            System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, this.a, 0, encodedContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode the non-standard attribute.");
        }
    }

    public void setOID(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 != 0) {
            ((X501Attribute)this).a = new byte[n3];
            System.arraycopy(byArray, n2, ((X501Attribute)this).a, 0, n3);
        }
    }

    public void setValue(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 != 0) {
            this.a = new byte[n3];
            System.arraycopy(byArray, n2, this.a, 0, n3);
        }
    }

    public byte[] getValue() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    protected int derEncodeValueInit() {
        this.b = null;
        if (this.a == null || ((X501Attribute)this).a == null) {
            return 0;
        }
        try {
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            EncodedContainer encodedContainer = new EncodedContainer(65280, true, 0, this.a, 0, this.a.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, endContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.b = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NonStandardAttribute nonStandardAttribute = new NonStandardAttribute();
        if (this.a != null) {
            nonStandardAttribute.a = (byte[])this.a.clone();
        }
        if (((X501Attribute)this).a != null) {
            ((X501Attribute)nonStandardAttribute).a = (byte[])((X501Attribute)this).a.clone();
        }
        super.copyValues(nonStandardAttribute);
        return nonStandardAttribute;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NonStandardAttribute)) {
            return false;
        }
        NonStandardAttribute nonStandardAttribute = (NonStandardAttribute)object;
        if (!CertJUtils.byteArraysEqual(nonStandardAttribute.a, this.a)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(((X501Attribute)nonStandardAttribute).a, ((X501Attribute)this).a);
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

