/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class CertPolicies
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector[] a = this.a(2);
    private ASN1Template b = null;

    public CertPolicies() {
        this.extensionTypeFlag = 32;
        this.criticality = false;
        this.setStandardOID(32);
        this.extensionTypeString = "CertPolicies";
    }

    public CertPolicies(byte[] byArray, int n2, int n3, PolicyQualifiers policyQualifiers, boolean bl2) {
        this.extensionTypeFlag = 32;
        this.criticality = bl2;
        this.setStandardOID(32);
        if (byArray != null && n3 != 0) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.a[0].addElement(byArray2);
            this.a[1].addElement(policyQualifiers);
        }
        this.extensionTypeString = "CertPolicies";
    }

    public void addCertPolicy(byte[] byArray, int n2, int n3, PolicyQualifiers policyQualifiers) {
        if (byArray != null && n3 != 0) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.a[0].addElement(byArray2);
            this.a[1].addElement(policyQualifiers);
        }
    }

    public byte[] getCertPolicyId(int n2) throws CertificateException {
        if (this.a[0].size() <= n2) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.a[0].elementAt(n2);
    }

    public PolicyQualifiers getPolicyQualifiers(int n2) throws CertificateException {
        if (this.a[1].size() <= n2) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (PolicyQualifiers)this.a[1].elementAt(n2);
    }

    public int getPoliciesCount() {
        return this.a[0].size();
    }

    private Vector[] a(int n2) {
        Vector[] vectorArray = new Vector[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            vectorArray[i2] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(77824);
                OIDContainer oIDContainer = new OIDContainer(0);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray2);
                byte[] byArray2 = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                this.a[0].addElement(byArray2);
                if (encodedContainer.dataPresent) {
                    this.a[1].addElement(new PolicyQualifiers(encodedContainer.data, encodedContainer.dataOffset, 65536));
                    continue;
                }
                this.a[1].addElement(null);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode Certificate Policies extension.");
        }
        catch (CertificateException certificateException) {
            throw new CertificateException("Could not decode Certificate Policies extension.");
        }
    }

    public int derEncodeValueInit() {
        if (this.a[0].size() == 0) {
            return 0;
        }
        try {
            Vector<OfContainer> vector = new Vector<OfContainer>();
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12288, new EncodedContainer(12288));
            vector.addElement(ofContainer);
            for (int i2 = 0; i2 < this.a[0].size(); ++i2) {
                EncodedContainer encodedContainer = this.b(i2);
                ofContainer.addContainer(encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private EncodedContainer b(int n2) throws CertificateException {
        EncodedContainer encodedContainer = null;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        ASN1Template aSN1Template = null;
        byte[] byArray = (byte[])this.a[0].elementAt(n2);
        try {
            Object[] objectArray;
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
            PolicyQualifiers policyQualifiers = (PolicyQualifiers)this.a[1].elementAt(n2);
            if (policyQualifiers != null) {
                objectArray = new byte[policyQualifiers.getDERLen(65536)];
                int n3 = policyQualifiers.getDEREncoding((byte[])objectArray, 0, 65536);
                EncodedContainer encodedContainer2 = new EncodedContainer(77824, true, 0, (byte[])objectArray, 0, n3);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer2, endContainer};
                aSN1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                objectArray = new ASN1Container[]{sequenceContainer, oIDContainer, endContainer};
                aSN1Template = new ASN1Template((ASN1Container[])objectArray);
            }
            int n4 = aSN1Template.derEncodeInit();
            byte[] byArray2 = new byte[n4];
            n4 = aSN1Template.derEncode(byArray2, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, byArray2, 0, n4);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode Certificate Policy");
        }
        return encodedContainer;
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int n3 = this.b.derEncode(byArray, n2);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CertPolicies certPolicies = new CertPolicies();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            for (int i3 = 0; i3 < this.a[i2].size(); ++i3) {
                certPolicies.a[i2].addElement(this.a[i2].elementAt(i3));
            }
        }
        if (this.b != null) {
            certPolicies.derEncodeValueInit();
        }
        super.copyValues(certPolicies);
        return certPolicies;
    }

    protected void reset() {
        super.reset();
        this.a = this.a(2);
    }
}

