/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class NonStandardExtension
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension,
CRLExtension,
CRLEntryExtension {
    private byte[] a;

    public NonStandardExtension() {
        this.criticality = false;
        this.extensionTypeFlag = -1;
        this.extensionTypeString = "NonStandardExtension";
    }

    public NonStandardExtension(byte[] byArray, boolean bl2, byte[] byArray2) {
        if (byArray != null) {
            this.f = (byte[])byArray.clone();
            this.g = byArray.length;
        }
        if (byArray2 != null) {
            this.a = (byte[])byArray2.clone();
        }
        this.criticality = bl2;
        this.extensionTypeFlag = -1;
        this.extensionTypeString = "NonStandardExtension";
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            int n3 = 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
            this.a = new byte[n3];
            System.arraycopy(byArray, n2, this.a, 0, n3);
        }
        catch (ASN_Exception aSN_Exception) {
            return;
        }
    }

    public void setOID(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 != 0) {
            this.f = new byte[n3];
            this.g = n3;
            System.arraycopy(byArray, n2, this.f, 0, n3);
        }
    }

    public byte[] getOID() {
        if (this.f != null && this.g != 0) {
            byte[] byArray = new byte[this.g];
            System.arraycopy(this.f, 0, byArray, 0, this.g);
            return byArray;
        }
        return null;
    }

    public void setValueBER(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 != 0) {
            this.a = new byte[n3];
            System.arraycopy(byArray, n2, this.a, 0, n3);
        }
    }

    public byte[] getValueBER() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return byArray;
    }

    public int derEncodeValueInit() {
        if (this.a != null) {
            return this.a.length;
        }
        return 0;
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (this.a == null) {
            return 0;
        }
        System.arraycopy(this.a, 0, byArray, n2, this.a.length);
        return this.a.length;
    }

    public Object clone() throws CloneNotSupportedException {
        NonStandardExtension nonStandardExtension = new NonStandardExtension();
        if (this.a != null) {
            nonStandardExtension.a = (byte[])this.a.clone();
        }
        super.copyValues(nonStandardExtension);
        return nonStandardExtension;
    }

    protected void reset() {
        super.reset();
        this.a = null;
    }
}

