/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Vector;

public class UnformattedPostalAddress
implements Cloneable,
Serializable {
    private String[] a = new String[6];
    private int b = 0;
    private String c;
    protected int special;
    protected ASN1Template asn1Template = null;

    public UnformattedPostalAddress(byte[] byArray, int n2, int n3) throws NameException {
        this.special = n3;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(n3);
            EncodedContainer encodedContainer = new EncodedContainer(77824);
            TeletexStringContainer teletexStringContainer = new TeletexStringContainer(65536, 1, 180);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, teletexStringContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                OfContainer ofContainer = new OfContainer(65536, 12288, new EncodedContainer(4864));
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
                ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray2);
                int n4 = ofContainer.getContainerCount();
                if (n4 > 6) {
                    throw new NameException("Too many entries in PrintableAddress: MAX number is 6.");
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    ASN1Container aSN1Container = ofContainer.containerAt(i2);
                    PrintStringContainer printStringContainer = new PrintStringContainer(0, 1, 30);
                    ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{printStringContainer};
                    ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray3);
                    this.a[this.b] = printStringContainer.getValueAsString();
                    ++this.b;
                }
            }
            if (teletexStringContainer.dataPresent) {
                this.c = teletexStringContainer.getValueAsString();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the UnformattedPostalAddress.");
        }
    }

    public UnformattedPostalAddress() {
    }

    public void setPrintableAddress(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 30) {
            throw new NameException("Specified value is too long.");
        }
        if (this.b < 5) {
            this.a[this.b] = string;
            ++this.b;
        } else {
            throw new NameException("Cannot add PrintableAddress: MAX  number is 6.");
        }
    }

    public void setTeletexString(String string) throws NameException {
        if (string == null) {
            throw new NameException("Specified value is null.");
        }
        if (string.length() > 180) {
            throw new NameException("Specified value is too long.");
        }
        this.c = string;
    }

    public String[] getPrintableAddress() {
        return this.a;
    }

    public String getTeletexString() {
        return this.c;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(new String(this.a[i2]));
        }
        if (this.c != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(new String(this.c));
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) throws NameException {
        this.special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n4 = 0;
            if ((this.asn1Template == null || n3 != this.special) && (n4 = this.getDERLen(n3)) == 0) {
                throw new NameException("Unable to encode UnformattedPostalAddress");
            }
            int n5 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
            return n5;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode UnformattedPostalAddress");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EncodedContainer encodedContainer = null;
            TeletexStringContainer teletexStringContainer = null;
            EndContainer endContainer = new EndContainer();
            if (this.b > 0) {
                encodedContainer = this.b();
                if (this.c != null) {
                    teletexStringContainer = new TeletexStringContainer(65536, true, 0, this.c, 1, 180);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, teletexStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                } else {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                }
            } else if (this.c != null) {
                teletexStringContainer = new TeletexStringContainer(65536, true, 0, this.c, 1, 180);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    private EncodedContainer b() throws NameException {
        EncodedContainer encodedContainer = null;
        EncodedContainer encodedContainer2 = null;
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            Object object;
            Object object2;
            OfContainer ofContainer = new OfContainer(65536, true, 0, 12288, new EncodedContainer(4864));
            vector.addElement(ofContainer);
            for (int i2 = 0; i2 < this.b; ++i2) {
                object2 = new PrintStringContainer(0, true, 0, this.a[i2], 1, 30);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2};
                object = new ASN1Template(aSN1ContainerArray);
                int n2 = ((ASN1Template)object).derEncodeInit();
                byte[] byArray = new byte[n2];
                n2 = ((ASN1Template)object).derEncode(byArray, 0);
                encodedContainer2 = new EncodedContainer(4864, true, 0, byArray, 0, n2);
                ofContainer.addContainer(encodedContainer2);
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            object2 = new ASN1Template((ASN1Container[])objectArray);
            int n3 = ((ASN1Template)object2).derEncodeInit();
            object = new byte[n3];
            n3 = ((ASN1Template)object2).derEncode((byte[])object, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, (byte[])object, 0, n3);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(" Can't encode PrintAddress");
        }
        return encodedContainer;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof UnformattedPostalAddress)) {
            return false;
        }
        UnformattedPostalAddress unformattedPostalAddress = (UnformattedPostalAddress)object;
        if (this.b != unformattedPostalAddress.b) {
            return false;
        }
        if (this.c != null ? !this.c.equals(unformattedPostalAddress.c) : unformattedPostalAddress.c != null) {
            return false;
        }
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (this.a[i2].equals(unformattedPostalAddress.a[i2])) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        UnformattedPostalAddress unformattedPostalAddress = new UnformattedPostalAddress();
        unformattedPostalAddress.b = this.b;
        if (this.c != null) {
            unformattedPostalAddress.c = this.c;
        }
        for (int i2 = 0; i2 < this.b; ++i2) {
            unformattedPostalAddress.a[i2] = this.a[i2];
        }
        unformattedPostalAddress.special = this.special;
        if (this.asn1Template != null) {
            unformattedPostalAddress.a();
        }
        return unformattedPostalAddress;
    }
}

