/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequestControl;

public class OCSPResponder
implements Cloneable {
    public static final int PROFILE_GENERIC = 0;
    public static final int PROFILE_VALICERT = 1;
    public static final int PROFILE_RSAKCA = 2;
    public static final int PROFILE_VERISIGN = 3;
    private static final int a = 3;
    public static final int FLAG_DISABLE_NONCES = 1;
    public static final int FLAG_DISABLE_CERT_SEND = 2;
    public static final int FLAG_ENABLE_CHAIN_SEND = 4;
    public static final int FLAG_RESPONDER_NOCHECK = 8;
    private int b;
    private int c;
    private String[] d;
    private String[] e;
    private OCSPRequestControl f;
    private X509Certificate g;
    private X509Certificate[] h;
    private DatabaseService i;
    private int j;

    public OCSPResponder(int n2, int n3, String[] stringArray, String[] stringArray2, OCSPRequestControl oCSPRequestControl, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, DatabaseService databaseService, int n4) throws InvalidParameterException {
        int n5;
        if (n2 < 0 || n2 > 3) {
            throw new InvalidParameterException("OCSPResponder.profile");
        }
        this.b = n2;
        if ((n3 & 4) != 0 && (n3 & 2) != 0) {
            throw new InvalidParameterException("FLAG_ENABLE_CHAIN_SEND && FLAG_DISABLE_CERT_SEND incompatible");
        }
        this.c = n3;
        if (stringArray == null) {
            this.d = null;
        } else {
            this.d = new String[stringArray.length];
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                if (stringArray[n5] == null) continue;
                this.d[n5] = new String(stringArray[n5]);
            }
        }
        if (stringArray2 == null) {
            this.e = null;
        } else {
            this.e = new String[stringArray2.length];
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                if (stringArray2[n5] == null) continue;
                this.e[n5] = new String(stringArray2[n5]);
            }
        }
        try {
            this.f = oCSPRequestControl == null ? null : (OCSPRequestControl)oCSPRequestControl.clone();
            X509Certificate x509Certificate2 = this.g = x509Certificate == null ? null : (X509Certificate)x509Certificate.clone();
            if (x509CertificateArray == null) {
                throw new InvalidParameterException("responderCACerts == null");
            }
            this.h = new X509Certificate[x509CertificateArray.length];
            for (n5 = 0; n5 < x509CertificateArray.length; ++n5) {
                if (x509CertificateArray[n5] == null) {
                    throw new InvalidParameterException("responderCACerts[" + n5 + "] == null");
                }
                this.h[n5] = (X509Certificate)x509CertificateArray[n5].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.toString());
        }
        this.i = databaseService;
        this.j = n4;
    }

    public OCSPResponder(OCSPRequestControl oCSPRequestControl, X509Certificate[] x509CertificateArray) throws InvalidParameterException {
        try {
            this.b = 0;
            this.c = 0;
            OCSPRequestControl oCSPRequestControl2 = this.f = oCSPRequestControl == null ? null : (OCSPRequestControl)oCSPRequestControl.clone();
            if (x509CertificateArray == null) {
                throw new InvalidParameterException("responderCACerts == null");
            }
            this.h = new X509Certificate[x509CertificateArray.length];
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                if (x509CertificateArray[i2] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i2 + "] == null");
                }
                this.h[i2] = (X509Certificate)x509CertificateArray[i2].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.toString());
        }
        this.i = this.i;
        this.j = 0;
    }

    public OCSPResponder(OCSPResponder oCSPResponder) throws InvalidParameterException {
        int n2;
        int n3;
        if (oCSPResponder == null) {
            throw new InvalidParameterException("responder == null");
        }
        this.b = oCSPResponder.getProfile();
        this.c = oCSPResponder.getFlags();
        String[] stringArray = oCSPResponder.getDestList();
        if (stringArray == null) {
            this.d = null;
        } else {
            int n4 = stringArray.length;
            this.d = new String[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                if (stringArray[n3] == null) continue;
                this.d[n3] = new String(stringArray[n3]);
            }
        }
        String[] stringArray2 = oCSPResponder.getProxyList();
        if (stringArray2 == null) {
            this.e = null;
        } else {
            n3 = stringArray2.length;
            this.e = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                if (stringArray2[n2] == null) continue;
                this.e[n2] = new String(stringArray2[n2]);
            }
        }
        try {
            this.f = oCSPResponder.getRequestControl() == null ? null : (OCSPRequestControl)oCSPResponder.getRequestControl().clone();
            this.g = oCSPResponder.getResponderCert() == null ? null : (X509Certificate)oCSPResponder.getResponderCert().clone();
            X509Certificate[] x509CertificateArray = oCSPResponder.getResponderCACerts();
            if (x509CertificateArray == null) {
                throw new InvalidParameterException("OCSPResponder.responderCACerts");
            }
            this.h = new X509Certificate[x509CertificateArray.length];
            for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
                if (x509CertificateArray[n2] == null) {
                    throw new InvalidParameterException("responderCACerts[" + n2 + "] == null");
                }
                this.h[n2] = (X509Certificate)x509CertificateArray[n2].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.toString());
        }
        this.i = oCSPResponder.getDatabase();
        this.j = oCSPResponder.getTimeTolerance();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OCSPResponder(this);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new CloneNotSupportedException(invalidParameterException.getMessage());
        }
    }

    public int getProfile() {
        return this.b;
    }

    public int getFlags() {
        return this.c;
    }

    public String[] getDestList() {
        return this.d;
    }

    public String[] getProxyList() {
        return this.e;
    }

    public OCSPRequestControl getRequestControl() {
        return this.f;
    }

    public X509Certificate getResponderCert() {
        return this.g;
    }

    public X509Certificate[] getResponderCACerts() {
        return this.h;
    }

    protected X509Certificate getResponderCACert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            if (!x509Certificate.getIssuerName().equals(this.h[i2].getSubjectName())) continue;
            return this.h[i2];
        }
        return null;
    }

    protected X509Certificate getResponderCACert(X509Certificate x509Certificate, String string) {
        if (x509Certificate == null || string == null || this.d == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            X509Certificate x509Certificate2;
            if (!string.equals(this.d[i2]) || (x509Certificate2 = this.getResponderCACert(x509Certificate)) == null) continue;
            return x509Certificate2;
        }
        return null;
    }

    public void setProfile(int n2) throws InvalidParameterException {
        if (n2 < 0 || n2 > 3) {
            throw new InvalidParameterException("OCSPResponder.profile");
        }
        this.b = n2;
    }

    public void setFlags(int n2) throws InvalidParameterException {
        this.c = n2;
    }

    public void setProxyList(String[] stringArray) throws InvalidParameterException {
        if (stringArray == null) {
            this.e = null;
        } else {
            this.e = new String[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null) {
                    throw new InvalidParameterException("proxyList[" + i2 + "] == null");
                }
                this.e[i2] = new String(stringArray[i2]);
            }
        }
    }

    public void setRequestControl(OCSPRequestControl oCSPRequestControl) throws InvalidParameterException {
        try {
            this.f = oCSPRequestControl == null ? null : (OCSPRequestControl)oCSPRequestControl.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public void setResponderCACerts(X509Certificate[] x509CertificateArray) throws InvalidParameterException {
        if (x509CertificateArray == null) {
            throw new InvalidParameterException("responderCACerts");
        }
        try {
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                if (x509CertificateArray[i2] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i2 + "] == null");
                }
                this.h[i2] = (X509Certificate)x509CertificateArray[i2].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public void setDatabase(DatabaseService databaseService) throws InvalidParameterException {
        this.i = databaseService;
    }

    public DatabaseService getDatabase() {
        return this.i;
    }

    public void setTimeTolerance(int n2) {
        this.j = n2;
    }

    public int getTimeTolerance() {
        return this.j;
    }
}

