/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.util.Vector;

public final class OCSPutil {
    public static String getAIALocation(X509Certificate x509Certificate) {
        X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
        if (x509V3Extensions == null) {
            return null;
        }
        try {
            AuthorityInfoAccess authorityInfoAccess = (AuthorityInfoAccess)x509V3Extensions.getExtensionByType(100);
            if (authorityInfoAccess == null) {
                return null;
            }
            for (int i2 = 0; i2 < authorityInfoAccess.getAccessDescriptionCount(); ++i2) {
                GeneralName generalName;
                byte[] byArray = authorityInfoAccess.getAccessMethod(i2);
                if (!CertJUtils.byteArraysEqual(byArray, AuthorityInfoAccess.ID_AD_OCSP) || (generalName = authorityInfoAccess.getAccessLocation(i2)).getGeneralNameType() != 7) continue;
                return (String)generalName.getGeneralName();
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] makeDataDigest(CertJ certJ, String string, byte[] byArray, int n2, int n3) throws InvalidParameterException {
        byte[] byArray2 = null;
        try {
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance(string, certJ.getDevice());
            byArray2 = new byte[jSAFE_MessageDigest.getDigestSize()];
            jSAFE_MessageDigest.digestInit();
            jSAFE_MessageDigest.digestUpdate(byArray, n2, n3);
            jSAFE_MessageDigest.digestFinal(byArray2, 0);
        }
        catch (Exception exception) {
            throw new InvalidParameterException("makeDataDigest:" + exception.toString());
        }
        return byArray2;
    }

    public static byte[] extractKeyDER(byte[] byArray, int n2) throws ASN_Exception {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(65280);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, bitStringContainer, endContainer};
        ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        byte[] byArray2 = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, byArray2, 0, bitStringContainer.dataLen);
        return byArray2;
    }

    public static int selectCertificateByKeyHash(CertJ certJ, DatabaseService databaseService, byte[] byArray, int n2, int n3, Vector vector) throws DatabaseException, NoServiceException, CertificateException, InvalidParameterException {
        int n4 = 0;
        boolean bl2 = true;
        while (databaseService.hasMoreCertificates()) {
            byte[] byArray2;
            byte[] byArray3;
            Certificate certificate;
            if (bl2) {
                certificate = databaseService.firstCertificate();
                bl2 = false;
            } else {
                certificate = databaseService.nextCertificate();
            }
            if (!CertJUtils.byteArraysEqual(byArray3 = OCSPutil.makeDataDigest(certJ, "SHA1", byArray2 = certificate.getSubjectPublicKeyBER(), 0, 0), byArray)) continue;
            vector.addElement(certificate);
            ++n4;
        }
        return n4;
    }
}

