/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.CertJ;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.xml.Cac;
import com.rsa.certj.xml.XMLException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class Canonicalizer {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String S_XMLNS = "xmlns";
    private static final String a = "UTF-8";

    public static byte[] canonicalizeNodeset(Node node, boolean bl2) throws XMLException {
        if (node != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, a);
                if (node.getNodeType() == 9) {
                    Canonicalizer.a(null, null, node, null, bl2, false, outputStreamWriter);
                } else {
                    Canonicalizer.a(node, null, node, null, bl2, true, outputStreamWriter);
                }
                ((Writer)outputStreamWriter).flush();
                ((Writer)outputStreamWriter).close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                throw new XMLException("Can't canonicalize input: " + iOException.getMessage());
            }
        }
        return null;
    }

    public static byte[] canonicalizeNodeset(NodeList nodeList, boolean bl2) throws XMLException {
        if (nodeList != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, a);
                Canonicalizer.a(nodeList, bl2, outputStreamWriter);
                ((Writer)outputStreamWriter).flush();
                ((Writer)outputStreamWriter).close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                throw new XMLException("Can't canonicalize input: " + iOException.getMessage());
            }
        }
        return null;
    }

    private static void a(NodeList nodeList, boolean bl2, Writer writer) throws IOException, XMLException {
        Vector<Object> vector = new Vector<Object>(nodeList.getLength());
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node;
            Object object;
            Hashtable<String, Node> hashtable;
            Node node2 = nodeList.item(i2);
            if (node2.getNodeType() != 2) {
                vector.addElement(node2);
                if (node2.getNodeType() != 1) continue;
                hashtable = null;
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS)) {
                    hashtable = Canonicalizer.collectAncestorsXMLPrefix(node2);
                }
                object = null;
                if (i2 + 1 < nodeList.getLength()) {
                    object = nodeList.item(i2 + 1);
                    if (object.getNodeType() == 2 && ((Attr)object).getOwnerElement() == node2) {
                        if (hashtable == null) {
                            hashtable = new Hashtable<String, Node>();
                        }
                        ++i2;
                        while (i2 < nodeList.getLength() && (node = nodeList.item(i2)).getNodeType() == 2 && node2 == ((Attr)node).getOwnerElement()) {
                            hashtable.put(node.getNodeName(), node);
                            ++i2;
                        }
                        --i2;
                    }
                    if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS) && hashtable != null && hashtable.containsKey(S_XMLNS) && ((Attr)hashtable.get(S_XMLNS)).getNodeValue().length() == 0) {
                        hashtable.remove(S_XMLNS);
                    }
                    vector.addElement(new Cac(node2, hashtable));
                    continue;
                }
                if (hashtable == null) continue;
                vector.addElement(new Cac(node2, hashtable));
                continue;
            }
            hashtable = ((Attr)node2).getOwnerElement();
            object = new Hashtable();
            while (i2 < nodeList.getLength() && (node = nodeList.item(i2)).getNodeType() == 2 && hashtable == ((Attr)node).getOwnerElement()) {
                ((Hashtable)object).put(node.getNodeName(), node);
                ++i2;
            }
            vector.addElement(new Cac((Node)((Object)hashtable), (Hashtable)object));
            --i2;
        }
        Stack stack = new Stack();
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            Canonicalizer.a(stack, vector, i3, bl2, writer);
        }
    }

    private static void a(Stack stack, Vector vector, int n2, boolean bl2, Writer writer) throws IOException, XMLException {
        Node node;
        Object e2 = vector.elementAt(n2);
        if (e2 == null) {
            return;
        }
        if (e2 instanceof Cac) {
            vector.setElementAt(null, n2);
            ((Cac)e2).a(null, writer);
            return;
        }
        Node node2 = (Node)e2;
        short s2 = node2.getNodeType();
        if (s2 == 9) {
            return;
        }
        if (s2 != 1) {
            Canonicalizer.a(null, null, node2, null, bl2, true, writer);
            return;
        }
        writer.write("<");
        writer.write(node2.getNodeName());
        Cac cac = stack.empty() ? null : (Cac)stack.peek();
        Cac cac2 = null;
        int n3 = n2 + 1;
        if (n3 >= vector.size() || vector.elementAt(n3) instanceof Node) {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS) && (node = node2.getParentNode()) != null && node.getNodeType() != 9 && cac != null && cac.b() != null && cac.b().containsKey(S_XMLNS)) {
                writer.write(" xmlns=\"\"");
            }
        } else {
            cac2 = (Cac)vector.elementAt(n3);
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS) && cac2 != null && cac2.b() != null && !cac2.b().containsKey(S_XMLNS) && (node = node2.getParentNode()) != null && node.getNodeType() != 9 && cac != null && cac.b() != null && cac.b().containsKey(S_XMLNS)) {
                writer.write(" xmlns=\"\"");
            }
            cac2.a(cac, writer);
            vector.setElementAt(null, n3);
        }
        writer.write(">");
        stack.push(cac2);
        while (n3 < vector.size()) {
            if (vector.elementAt(n3) == null) {
                ++n3;
                continue;
            }
            if (!Canonicalizer.a(vector.elementAt(n3), node2)) break;
            Canonicalizer.a(stack, vector, n3, bl2, writer);
            vector.setElementAt(null, n3++);
        }
        stack.pop();
        writer.write("</");
        writer.write(node2.getNodeName());
        writer.write(">");
    }

    private static boolean a(Object object, Node node) throws XMLException {
        if (object == null || node == null) {
            throw new XMLException("Can't find out which is ancestor");
        }
        Node node2 = null;
        node2 = object instanceof Cac ? ((Cac)object).a() : (Node)object;
        while (node2 != node) {
            if ((node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    private static void a(Node node, Stack stack, Node node2, Node node3, boolean bl2, boolean bl3, Writer writer) throws IOException, XMLException {
        if (node2 == null) {
            return;
        }
        if (node3 == node2) {
            return;
        }
        switch (node2.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                writer.write("<");
                writer.write(node2.getNodeName());
                Canonicalizer.a(node, stack, (Element)node2, bl3, writer);
                writer.write(">");
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    Canonicalizer.a(node, stack, node4, node3, bl2, bl3, writer);
                }
                stack.pop();
                writer.write("</");
                writer.write(node2.getNodeName());
                writer.write(">");
                break;
            }
            case 3: 
            case 4: {
                String string = node2.getNodeValue();
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c2 == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    if (c2 == '&') {
                        writer.write("&amp;");
                        continue;
                    }
                    if (c2 == '\r') {
                        writer.write("&#xD;");
                        continue;
                    }
                    writer.write(c2);
                }
                break;
            }
            case 5: 
            case 9: {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    Canonicalizer.a(node, stack, node5, node3, bl2, bl3, writer);
                }
                break;
            }
            case 7: {
                Canonicalizer.a(node2, writer);
                break;
            }
            case 8: {
                Canonicalizer.a(node2, writer, bl2);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                Canonicalizer.canonicalizeAttribute((Attr)node2, writer);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new XMLException("Invalid Node Type: " + node2.getNodeType());
            }
        }
    }

    private static boolean a(Node node, Element element) throws XMLException {
        if (node == element) {
            return true;
        }
        Node node2 = element.getParentNode();
        if (node2 != null) {
            switch (node2.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    node2 = node2.getParentNode();
                }
            }
            throw new XMLException("Unexpected node type: " + node2.getNodeType());
        }
        return true;
    }

    private static void a(Node node, Stack stack, Element element, boolean bl2, Writer writer) throws IOException, XMLException {
        Object object;
        String[] stringArray;
        Hashtable hashtable;
        Hashtable hashtable2 = Canonicalizer.collectNSNodesInAncestors(element, false);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            hashtable2.put(namedNodeMap.item(i2).getNodeName(), namedNodeMap.item(i2));
        }
        if (bl2 && (hashtable = Canonicalizer.collectAncestorsXMLPrefix(element)) != null) {
            stringArray = hashtable.elements();
            while (stringArray.hasMoreElements()) {
                object = (Attr)stringArray.nextElement();
                hashtable2.put(object.getNodeName(), object);
            }
        }
        Hashtable hashtable3 = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable2);
        n2 = hashtable2.size();
        stringArray = new String[n2];
        object = new int[n2];
        Attr[] attrArray = new Attr[n2];
        int n3 = 0;
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            object[n3] = n3;
            attrArray[n3] = attr;
            stringArray[n3] = Canonicalizer.createSortedString(attr, element);
            ++n3;
        }
        Canonicalizer.heapSort((int[])object, stringArray, n2);
        for (int i3 = 0; i3 < n2; ++i3) {
            Attr attr;
            Attr attr2 = attrArray[object[i3]];
            String string = attr2.getNodeName();
            if (string.equals("xmlns:xml")) continue;
            if (string.equals(S_XMLNS) && attr2.getNodeValue().length() == 0) {
                if (Canonicalizer.a(node, element)) continue;
                boolean bl3 = false;
                for (int i4 = stack.size() - 1; i4 >= 0; --i4) {
                    Hashtable hashtable4 = (Hashtable)stack.elementAt(i4);
                    Attr attr3 = (Attr)hashtable4.get(S_XMLNS);
                    if (attr3 == null || attr3.getNodeValue().length() <= 0) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) continue;
            }
            if ((string.equals(S_XMLNS) || string.startsWith("xmlns:")) && hashtable3 != null && (attr = (Attr)hashtable3.get(string)) != null && attr.getNodeValue().equals(attr2.getNodeValue())) continue;
            Canonicalizer.canonicalizeAttribute(attr2, writer);
        }
    }

    private static void a(Node node, Writer writer, boolean bl2) throws IOException {
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            return;
        }
        if (node.getParentNode().getNodeType() == 9) {
            Node node2 = node;
            while ((node2 = node2.getPreviousSibling()) != null && node2.getNodeType() != 1) {
            }
            if (node2 == null) {
                bl3 = true;
            } else {
                bl4 = true;
            }
        }
        if (bl4) {
            writer.write("\n");
        }
        writer.write("<!--");
        writer.write(node.getNodeValue());
        writer.write("-->");
        if (bl3) {
            writer.write("\n");
        }
    }

    private static void a(Node node, Writer writer) throws IOException {
        Node node2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (node.getParentNode().getNodeType() == 9) {
            node2 = node;
            while ((node2 = node2.getPreviousSibling()) != null && node2.getNodeType() != 1) {
            }
            if (node2 == null) {
                bl2 = true;
            } else {
                bl3 = true;
            }
        }
        node2 = (ProcessingInstruction)node;
        if (bl3) {
            writer.write("\n");
        }
        writer.write("<?");
        writer.write(node2.getTarget());
        if (node2.getData() != null && node2.getData().length() > 0) {
            writer.write(" ");
            String string = node2.getData();
            int n2 = 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (string.charAt(i2) != '\r') continue;
                if (i2 > n2) {
                    writer.write(string, n2, i2 - n2);
                }
                writer.write("&#xD;");
                n2 = i2 + 1;
            }
            if (n2 < string.length()) {
                writer.write(string, n2, string.length() - n2);
            }
        }
        writer.write("?>");
        if (bl2) {
            writer.write("\n");
        }
    }

    protected static void canonicalizeAttribute(Attr attr, Writer writer) throws IOException, XMLException {
        String string = attr.getNodeName();
        boolean bl2 = string.equals(S_XMLNS) || string.startsWith("xmlns:");
        writer.write(" ");
        writer.write(string);
        writer.write("=\"");
        String string2 = attr.getNodeValue();
        boolean bl3 = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c2 == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c2 == '\"') {
                writer.write("&quot;");
                continue;
            }
            if (c2 == '\t') {
                writer.write("&#x9;");
                continue;
            }
            if (c2 == '\n') {
                writer.write("&#xA;");
                continue;
            }
            if (c2 == '\r') {
                writer.write("&#xD;");
                continue;
            }
            if (bl2) {
                if (c2 == ':') {
                    bl3 = true;
                } else if (c2 == '/' && !bl3) {
                    throw new XMLException("No relative URI: " + string2 + " allowed");
                }
            }
            writer.write(c2);
        }
        if (string2.length() > 0 && bl2 && !bl3) {
            throw new XMLException("No relative URI: " + string2 + " allowed");
        }
        writer.write("\"");
    }

    protected static Hashtable collectNSNodesInAncestors(Node node, boolean bl2) {
        Object object;
        Node node2 = node;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Document document = node.getOwnerDocument();
        if (bl2) {
            hashtable.put("xmlns:xml", (Object)new AttrHelper(node, document, "xmlns:xml", XML_NAMESPACE));
        } else {
            object = document.createAttribute("xmlns:xml");
            object.setNodeValue(XML_NAMESPACE);
            hashtable.put("xmlns:xml", object);
        }
        do {
            if ((object = node2.getAttributes()) == null) continue;
            int n2 = object.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2;
                Attr attr = (Attr)object.item(i2);
                String string = attr.getNodeName();
                if (!string.equals(S_XMLNS) && !string.startsWith("xmlns:") || hashtable.containsKey(string)) continue;
                if (node2 == node) {
                    hashtable.put(string, attr);
                    continue;
                }
                if (bl2) {
                    object2 = new AttrHelper(node, document, string, attr.getNodeValue());
                    hashtable.put(string, object2);
                    continue;
                }
                object2 = document.createAttribute(string);
                object2.setNodeValue(attr.getNodeValue());
                hashtable.put(string, object2);
            }
        } while ((node2 = node2.getParentNode()) != null);
        return hashtable;
    }

    protected static Hashtable collectAncestorsXMLPrefix(Node node) {
        String string;
        Attr attr;
        int n2;
        int n3;
        NamedNodeMap namedNodeMap;
        Hashtable<String, Attr> hashtable = null;
        Node node2 = node;
        while ((node2 = node2.getParentNode()) != null) {
            namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            n3 = namedNodeMap.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                attr = (Attr)namedNodeMap.item(n2);
                string = attr.getNodeName();
                if (!string.startsWith("xml:") || hashtable != null && hashtable.containsKey(string)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Attr>();
                }
                hashtable.put(string, attr);
            }
        }
        if (hashtable != null && (namedNodeMap = node.getAttributes()) != null) {
            n3 = namedNodeMap.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                attr = (Attr)namedNodeMap.item(n2);
                string = attr.getNodeName();
                if (!string.startsWith("xml:") || !hashtable.containsKey(string)) continue;
                hashtable.remove(string);
            }
        }
        return hashtable;
    }

    protected static String createSortedString(Attr attr, Node node) throws XMLException {
        String string = null;
        if (attr == null) {
            return null;
        }
        if (attr.getNodeType() == 2) {
            String string2 = attr.getNodeName();
            if (string2.equals(S_XMLNS)) {
                return "\u0000";
            }
            int n2 = string2.indexOf(58);
            if (n2 <= 0) {
                return "\u0001" + string2;
            }
            String string3 = string2.substring(0, n2).intern();
            if (string3.equals(S_XMLNS)) {
                return "\u0000" + string2.substring(n2 + 1);
            }
            String string4 = Canonicalizer.getNSForPrefix(string3, node);
            string = string4 == null || string4.length() == 0 ? "\u0001" + string2 : string4 + "\u0001" + string2.substring(n2 + 1);
        } else {
            throw new XMLException("Requires an Attr node.");
        }
        return string;
    }

    protected static String getNSForPrefix(String string, Node node) {
        if (string == null) {
            return null;
        }
        if (string.equals("xml")) {
            return XML_NAMESPACE;
        }
        if (string.equals(S_XMLNS)) {
            return string;
        }
        String string2 = string.length() == 0 ? S_XMLNS : "xmlns:" + string;
        Node node2 = node;
        do {
            short s2;
            Attr attr;
            Attr attr2 = attr = node2.getAttributes().getLength() == 0 ? null : ((Element)node2).getAttributeNode(string2);
            if (attr != null) {
                return attr.getNodeValue();
            }
            do {
                if ((node2 = node2.getParentNode()) != null) continue;
                return string2 == S_XMLNS ? "" : null;
            } while ((s2 = node2.getNodeType()) == 5);
            if (s2 == 1) continue;
            return string2 == S_XMLNS ? "" : null;
        } while (node2 != null);
        return null;
    }

    protected static void heapSort(int[] nArray, String[] stringArray, int n2) {
        int n3;
        for (n3 = n2 / 2; n3 >= 0; --n3) {
            Canonicalizer.a(nArray, stringArray, n2, n3);
        }
        for (n3 = n2 - 1; n3 > 0; --n3) {
            int n4 = nArray[0];
            nArray[0] = nArray[n3];
            nArray[n3] = n4;
            Canonicalizer.a(nArray, stringArray, n3, 0);
        }
    }

    private static void a(int[] nArray, String[] stringArray, int n2, int n3) {
        int n4 = 2 * n3 + 1;
        if (n4 < n2) {
            if (n4 + 1 < n2 && 0 > stringArray[nArray[n4]].compareTo(stringArray[nArray[n4 + 1]])) {
                n4 = 2 * n3 + 2;
            }
            if (0 > Canonicalizer.a(stringArray[nArray[n3]], stringArray[nArray[n4]])) {
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                Canonicalizer.a(nArray, stringArray, n2, n4);
            }
        }
    }

    private static final int a(String string, String string2) {
        int n2;
        int n3 = string.length();
        int n4 = n3 < (n2 = string2.length()) ? n3 : n2;
        int n5 = 0;
        int n6 = 0;
        while (n4-- != 0) {
            char c2;
            char c3;
            if ((c3 = string.charAt(n5++)) == (c2 = string2.charAt(n6++))) continue;
            return c3 - c2;
        }
        return n3 - n2;
    }

    private static class AttrHelper
    extends AttrImpl {
        private Element a;

        AttrHelper(Node node, Document document, String string, String string2) {
            super((CoreDocumentImpl)((DocumentImpl)document), string);
            this.setValue(string2);
            this.a = (Element)node;
        }

        public Element getOwnerElement() {
            return this.a;
        }
    }
}

