/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_MultiPrimeCount;
import com.rsa.jsafe.JA_RSA;
import com.rsa.jsafe.JA_SSLCKeyEncode;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.by;
import com.rsa.jsafe.q;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JA_RSAPrivateKey
extends JSAFE_PrivateKey
implements Cloneable,
Serializable {
    private int a;
    private byte[][] b;
    private transient q[] c;
    private transient q d;
    private transient q e;
    private byte[] f;
    private byte[] g;

    public String getAlgorithm() {
        return "RSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"RSAPrivateKeyCRT", "RSAMultiPrimePrivateKeyCRT", "RSAPrivateKey", "RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyPEM"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.b == null || this.b.length < 2) {
            return new String[0];
        }
        if (this.b[0] == null || this.b[1] == null) {
            return new String[0];
        }
        if (this.a == 0) {
            String[] stringArray = new String[]{"RSAPrivateKey", "SSLCPKCS1RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyPEM"};
            return stringArray;
        }
        if (this.a > 2) {
            String[] stringArray = new String[]{"RSAMultiPrimePrivateKeyCRT", "RSAPrivateKeyBlind", "RSAPrivateKey", "RSAPrivateKeyBER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"RSAMultiPrimePrivateKeyCRT", "RSAPrivateKeyCRT", "RSAPrivateKeyBlind", "RSAPrivateKey", "RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyBER", "SSLCPKCS1RSAPrivateKeyPEM"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("RSAPrivateKeyCRT") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("RSAMultiPrimePrivateKeyCRT") == 0) {
            this.a(byArray);
            return;
        }
        if (string.compareTo("RSAPrivateKey") == 0) {
            this.b(byArray);
            return;
        }
        if (string.compareTo("RSAPrivateKeyBER") == 0) {
            if (byArray.length != 1) {
                this.g();
                throw new JSAFE_InvalidKeyException("Invalid BER RSA private key data.");
            }
            this.a(byArray[0], 0);
            return;
        }
        if (string.equals("SSLCPKCS1RSAPrivateKeyBER") || string.equals("SSLCPKCS1RSAPrivateKeyPEM")) {
            byte[] byArray2;
            if (byArray.length != 1) {
                throw new JSAFE_InvalidKeyException("Invalid SSLC RSA private key data.");
            }
            byte[][] byArray3 = null;
            String[] stringArray = new String[1];
            byte[] byArray4 = new byte[8];
            byte[] byArray5 = byArray[0];
            if (string.compareTo("SSLCPKCS1RSAPrivateKeyPEM") == 0) {
                byArray2 = JA_SSLCKeyEncode.pemDecodeNotEncrypted(byArray[0]);
                byArray5 = JA_SSLCKeyEncode.base64Decode(byArray2);
            }
            byArray2 = JA_SSLCKeyEncode.convertPKCS1ToPKCS8(byArray5);
            this.a(byArray2, 0);
            return;
        }
        this.g();
        throw new JSAFE_UnimplementedException("Unimplemented RSA Private Key Format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.g();
        if (byArray.length != 8) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        this.a = 2;
        this.b = new byte[8][];
        this.c = new q[6];
        boolean bl2 = false;
        int n2 = 0;
        int n3 = -2;
        while (n2 < 8 && (bl2 = this.a(byArray[n2], 0, byArray[n2].length, n2, n3))) {
            ++n2;
            ++n3;
        }
        if (!bl2) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
    }

    public void a(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.g();
        if (byArray == null || byArray.length < 4) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        if (byArray[3] == null || byArray[3].length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        this.a = byArray[3][0] & 0xFF;
        int n2 = this.a * 3 + 2;
        if (byArray.length != n2 + 1) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
        this.b = new byte[n2][];
        this.c = new q[n2 - 2];
        boolean bl2 = false;
        int n3 = -2;
        int n4 = 0;
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            if (i2 == 3) continue;
            bl2 = this.a(byArray[i2], 0, byArray[i2].length, n4, n3);
            ++n4;
            if (!bl2) break;
            ++n3;
        }
        if (!bl2) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
    }

    private void b(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.g();
        if (byArray.length != 2) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key Data Format.");
        }
        this.b = new byte[2][];
        this.c = new q[1];
        boolean bl2 = false;
        int n2 = 0;
        int n3 = -1;
        while (n2 < 2 && (bl2 = this.a(byArray[n2], 0, byArray[n2].length, n2, n3))) {
            ++n2;
            ++n3;
        }
        if (!bl2) {
            throw new JSAFE_InvalidKeyException("Invalid RSA Private Key data format");
        }
    }

    public void a(byte[] byArray, int n2) throws JSAFE_InvalidKeyException {
        this.g();
        by.a(this, byArray, n2);
    }

    int a(int n2) {
        int n3 = n2 * 3 + 2;
        this.b = new byte[n3][];
        this.c = new q[n3 - 2];
        this.a = n2;
        return n3;
    }

    void b(int n2) {
        this.g();
        this.a = n2;
        this.b = new byte[n2 * 3 + 2][];
        this.c = new q[n2 * 3];
    }

    boolean a(byte[] byArray, int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (n2 >= byArray.length) {
                return false;
            }
            if (byArray[n2] != 0) break;
            ++n2;
            --n3;
        }
        this.b[n4] = new byte[n3];
        System.arraycopy(byArray, n2, this.b[n4], 0, n3);
        if (n5 < 0) {
            return true;
        }
        this.c[n5] = JSAFE_Obfuscator.b(this.b[n4]);
        return true;
    }

    private boolean c(int n2) {
        if (this.b == null || this.b[0] == null) {
            return false;
        }
        int n3 = this.b[0].length * 8;
        int n4 = this.b[0][0] & 0xFF;
        int n5 = 0;
        while (n4 == 0) {
            if (++n5 >= this.b[0].length) {
                return false;
            }
            n4 = this.b[0][n5];
        }
        while ((n4 & 0x80) == 0) {
            --n3;
            n4 <<= 1;
        }
        return JA_MultiPrimeCount.a(n2, n3);
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("RSAPrivateKeyCRT") == 0) {
            return this.getKeyData();
        }
        if (string.compareTo("RSAPrivateKeyBlind") == 0) {
            return this.c();
        }
        if (string.compareTo("RSAMultiPrimePrivateKeyCRT") == 0) {
            return this.a(false);
        }
        if (string.compareTo("RSAPrivateKeyBER") == 0) {
            return this.i();
        }
        if (string.compareTo("RSAPrivateKey") == 0) {
            return this.h();
        }
        if (string.equals("SSLCPKCS1RSAPrivateKeyBER") || string.equals("SSLCPKCS1RSAPrivateKeyPEM")) {
            byte[] byArray;
            byte[][] byArrayArray = new byte[][]{null};
            byte[][] byArray2 = this.i();
            try {
                byArray = JA_SSLCKeyEncode.convertPKCS8ToPKCS1(byArray2[0]);
                byArrayArray[0] = byArray;
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_UnimplementedException(jSAFE_InvalidKeyException.getMessage());
            }
            if (string.compareTo("SSLCPKCS1RSAPrivateKeyPEM") != 0) {
                return byArrayArray;
            }
            byArray = null;
            byte[] byArray3 = byArrayArray[0];
            try {
                byArray = JA_SSLCKeyEncode.base64Encode(byArray3);
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_UnimplementedException(jSAFE_InvalidKeyException.getMessage());
            }
            byte[] byArray4 = new byte[8];
            byte[] byArray5 = JA_SSLCKeyEncode.pemEncode(byArray, "CLEAR", byArray4);
            byte[][] byArrayArray2 = new byte[][]{byArray5};
            return byArrayArray2;
        }
        throw new JSAFE_UnimplementedException("Unimplemented Key Data Format");
    }

    public byte[][] getKeyData() {
        if (this.a != 2) {
            return new byte[0][];
        }
        byte[][] byArrayArray = new byte[8][];
        for (int i2 = 0; i2 < 8; ++i2) {
            if (i2 > 1) {
                this.c[i2 - 2].d();
                byArrayArray[i2] = (byte[])this.b[i2].clone();
                this.c[i2 - 2].c();
                continue;
            }
            byArrayArray[i2] = (byte[])this.b[i2].clone();
        }
        return byArrayArray;
    }

    public byte[][] a(boolean bl2) {
        if (this.a < 2) {
            return new byte[0][];
        }
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        int n3 = this.a * 3 + 3;
        byte[][] byArrayArray = new byte[n3 + n2][];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 == 3) {
                byArrayArray[i2] = new byte[1];
                byArrayArray[i2][0] = (byte)this.a;
                continue;
            }
            if (n4 > 1) {
                this.c[n4 - 2].d();
                byArrayArray[i2] = (byte[])this.b[n4].clone();
                this.c[n4 - 2].c();
            } else {
                byArrayArray[i2] = (byte[])this.b[n4].clone();
            }
            ++n4;
        }
        if (n2 != 0) {
            this.d.d();
            byArrayArray[i2] = (byte[])this.f.clone();
            this.d.c();
            this.e.d();
            byArrayArray[i2 + 1] = (byte[])this.g.clone();
            this.e.c();
        }
        return byArrayArray;
    }

    public byte[][] c() {
        if (this.a < 2) {
            return new byte[0][];
        }
        if (this.f == null || this.g == null) {
            int n2;
            byte[] byArray = new byte[8];
            long l2 = System.currentTimeMillis();
            for (n2 = 0; n2 < 8; ++n2) {
                byArray[n2] = (byte)l2;
                l2 >>= 8;
            }
            this.f = new byte[this.b[0].length];
            this.g = new byte[this.b[0].length];
            n2 = JA_RSA.a(this.b[0], this.b[3], this.b[4], this.b[1], byArray, 0, 8, this.f, this.g) ? 1 : 0;
            if (n2 == 0) {
                this.f = null;
                this.g = null;
                return new byte[0][];
            }
            this.d = JSAFE_Obfuscator.b(this.f);
            this.e = JSAFE_Obfuscator.b(this.g);
        }
        return this.a(true);
    }

    private byte[][] h() {
        if (this.b == null) {
            return new byte[0][];
        }
        int n2 = 0;
        int n3 = 1;
        if (this.a > 0) {
            n3 = 2;
        }
        if (this.b.length < n3 + 1 || this.b[n2] == null || this.b[n3] == null) {
            return new byte[0][];
        }
        this.c[0].d();
        byte[][] byArrayArray = new byte[][]{(byte[])this.b[n2].clone(), (byte[])this.b[n3].clone()};
        this.c[0].d();
        return byArrayArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] i() {
        byte[][] byArrayArray;
        int n2;
        if (this.a == 0) {
            return new byte[0][];
        }
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2].d();
        }
        try {
            byte[][] byArrayArray2;
            byte[] byArray = by.a(this.a, this.b);
            byArrayArray = byArrayArray2 = new byte[][]{byArray};
            Object var6_7 = null;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            byte[][] byArrayArray3;
            try {
                byArrayArray3 = new byte[][]{};
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                for (n2 = 0; n2 < this.c.length; ++n2) {
                    this.c[n2].c();
                }
                throw throwable;
            }
            for (n2 = 0; n2 < this.c.length; ++n2) {
                this.c[n2].c();
            }
            return byArrayArray3;
        }
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2].c();
        }
        return byArrayArray;
    }

    public int getMaximumKeyLength() {
        return 4096;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_RSAPrivateKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dataEquals(Object object) {
        byte[][] byArray;
        block14: {
            boolean bl2;
            block15: {
                boolean bl3;
                block13: {
                    boolean bl4;
                    block12: {
                        byArray = null;
                        try {
                            try {
                                JSAFE_PrivateKey jSAFE_PrivateKey = (JSAFE_PrivateKey)object;
                                if (this.b == null || this.b.length < 2) {
                                    if (jSAFE_PrivateKey.getAlgorithm().compareTo("RSA") != 0) {
                                        bl4 = false;
                                        Object var8_10 = null;
                                        if (byArray == null) return bl4;
                                        break block12;
                                    } else {
                                        boolean bl5;
                                        String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                                        for (bl5 = false; bl5 < stringArray.length; bl5 += 1) {
                                            if (!stringArray[bl5].equals("RSAPrivateKey")) continue;
                                            boolean bl6 = false;
                                            Object var8_11 = null;
                                            if (byArray == null) return bl6;
                                            if (byArray.length < 2) return bl6;
                                            this.overwrite(byArray[1]);
                                            return bl6;
                                        }
                                        bl5 = true;
                                        Object var8_12 = null;
                                        if (byArray == null) return bl5;
                                        if (byArray.length < 2) return bl5;
                                        this.overwrite(byArray[1]);
                                        return bl5;
                                    }
                                }
                                byArray = jSAFE_PrivateKey.getKeyData("RSAPrivateKey");
                                if (!this.a(this.b[0], null, byArray[0], null)) {
                                    bl3 = false;
                                    break block13;
                                }
                                int n2 = 1;
                                if (this.b.length > 2) {
                                    n2 = 2;
                                }
                                if (this.a(this.b[n2], this.c[0], byArray[1], null)) break block14;
                                bl2 = false;
                                break block15;
                            }
                            catch (Exception exception) {
                                boolean bl7 = false;
                                Object var8_16 = null;
                                if (byArray == null) return bl7;
                                if (byArray.length < 2) return bl7;
                                this.overwrite(byArray[1]);
                                return bl7;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_17 = null;
                            if (byArray == null) throw throwable;
                            if (byArray.length < 2) throw throwable;
                            this.overwrite(byArray[1]);
                            throw throwable;
                        }
                    }
                    if (byArray.length < 2) return bl4;
                    this.overwrite(byArray[1]);
                    return bl4;
                }
                Object var8_13 = null;
                if (byArray == null) return bl3;
                if (byArray.length < 2) return bl3;
                this.overwrite(byArray[1]);
                return bl3;
            }
            Object var8_14 = null;
            if (byArray == null) return bl2;
            if (byArray.length < 2) return bl2;
            this.overwrite(byArray[1]);
            return bl2;
        }
        Object var8_15 = null;
        if (byArray == null) return true;
        if (byArray.length < 2) return true;
        this.overwrite(byArray[1]);
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.d();
        objectOutputStream.defaultWriteObject();
        this.e();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.f();
    }

    protected void d() {
        if (this.c == null) {
            return;
        }
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            if (this.c[i2] == null) continue;
            this.c[i2].d();
        }
    }

    protected void e() {
        if (this.c == null) {
            return;
        }
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            if (this.c[i2] == null) continue;
            this.c[i2].c();
        }
    }

    protected void f() {
        if (this.b == null) {
            return;
        }
        if (this.a == 0) {
            if (this.b.length < 2) {
                return;
            }
            if (this.b[1] == null) {
                return;
            }
            this.c = new q[1];
            this.c[0] = JSAFE_Obfuscator.b(this.b[1]);
            return;
        }
        this.c = new q[this.a * 3];
        for (int i2 = 2; i2 < this.b.length; ++i2) {
            if (this.b[1] == null) {
                return;
            }
            this.c[i2 - 2] = JSAFE_Obfuscator.b(this.b[i2]);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RSAPrivateKey jA_RSAPrivateKey = new JA_RSAPrivateKey();
        this.a(jA_RSAPrivateKey);
        return jA_RSAPrivateKey;
    }

    protected void a(JA_RSAPrivateKey jA_RSAPrivateKey) throws CloneNotSupportedException {
        jA_RSAPrivateKey.a = this.a;
        jA_RSAPrivateKey.a((JSAFE_PrivateKey)this);
        if (this.b == null) {
            return;
        }
        if (this.f != null) {
            jA_RSAPrivateKey.f = (byte[])this.f.clone();
            jA_RSAPrivateKey.d = JSAFE_Obfuscator.b(this.f);
        }
        if (this.g != null) {
            jA_RSAPrivateKey.g = (byte[])this.g.clone();
            jA_RSAPrivateKey.e = JSAFE_Obfuscator.b(this.g);
        }
        jA_RSAPrivateKey.b = new byte[this.b.length][];
        jA_RSAPrivateKey.c = new q[this.c.length];
        int n2 = -1;
        if (this.a != 0) {
            n2 = -2;
        }
        int n3 = 0;
        while (n3 < this.b.length) {
            if (this.b[n3] != null) {
                if (n2 < 0) {
                    jA_RSAPrivateKey.b[n3] = (byte[])this.b[n3].clone();
                } else {
                    jA_RSAPrivateKey.b[n3] = (byte[])JSAFE_Obfuscator.a(this.b[n3], this.c[n2]);
                    jA_RSAPrivateKey.c[n2] = JSAFE_Obfuscator.a(jA_RSAPrivateKey.b[n3]);
                }
            }
            ++n3;
            ++n2;
        }
    }

    protected void g() {
        if (this.b == null || this.c == null) {
            this.j();
            return;
        }
        if (this.a == 0) {
            if (this.b.length == 2 && this.c.length == 1) {
                JSAFE_Obfuscator.c(this.b[1], this.c[0]);
            }
            this.j();
            return;
        }
        int n2 = this.a * 3;
        if (this.b.length == n2 + 2 && this.c.length == n2) {
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                JSAFE_Obfuscator.c(this.b[i2 + 2], this.c[i2]);
            }
        }
        JSAFE_Obfuscator.c(this.f, this.d);
        JSAFE_Obfuscator.c(this.g, this.e);
        this.j();
    }

    private void j() {
        this.a = 0;
        this.b = null;
        this.c = null;
        this.f = null;
        this.g = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.g();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.clearSensitiveData();
        }
        finally {
            super.finalize();
        }
    }
}

