/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.Descriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import com.adobe.ucf.UCF;
import com.adobe.ucf.UCFOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class ADTOutputStream
extends UCFOutputStream {
    protected static final String ICON_PNG = "Icon.png";
    protected static final String ICON_SMALL_PNG = "Icon-Small.png";
    protected static final String ITUNES_ARTWORK = "iTunesArtwork";
    private static Set<Pattern> RESTRICTED_PATTERNS;
    protected static final Map<String, Integer> SPECIAL_ICON_SIZES;
    protected boolean m_validate = true;
    protected Listener m_listener;
    protected Descriptor m_descriptor;
    private ZipEntry m_signatureEntry = null;

    public void addAIRFile(ZipFile inputFile, boolean inputSigned) throws InvalidInputException {
        try {
            CentralDirectoryReader cdr = new CentralDirectoryReader(inputFile);
            this.addMimeTypeFile("application/vnd.adobe.air-application-installer-package+zip", true);
            Enumeration<? extends ZipEntry> entries = inputFile.entries();
            boolean sawInitialContent = false;
            HashSet<String> seenIconPaths = new HashSet<String>();
            int index = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                cdr.advanceHeader(name);
                ZipEntryInputStream is = new ZipEntryInputStream(inputFile, entry);
                if (name.equals("mimetype")) {
                    if (index != 0) {
                        throw new InvalidInputException("mimetype out of place");
                    }
                    String inputMimeType = inputSigned ? "application/vnd.adobe.air-application-installer-package+zip" : "application/vnd.adobe.air-application-intermediate-package+zip";
                    String currentMimeType = UCF.stringFromInputStream(is);
                    if (!currentMimeType.equals(inputMimeType)) {
                        throw new InvalidInputException("wrong mimetype");
                    }
                } else if (name.equals("META-INF/AIR/application.xml")) {
                    if (index != 1) {
                        throw new InvalidInputException("application descriptor out of place");
                    }
                    this.addDescriptorFromZipEntry(entry, is);
                    this.addHashFile("META-INF/AIR/hash");
                } else if (name.equals("META-INF/AIR/hash")) {
                    if (index != 2) {
                        throw new InvalidInputException("hash file out of place");
                    }
                } else {
                    if (index < 3) {
                        throw new InvalidInputException("incorrect file order");
                    }
                    if (name.equals("META-INF/signatures.xml")) {
                        if (!inputSigned) {
                            throw new InvalidInputException("intermediate file contains a signature");
                        }
                        if (this.m_signatureEntry != null) {
                            throw new InvalidInputException("contains more than one signature file");
                        }
                        this.m_signatureEntry = entry;
                    } else if (this.m_descriptor != null && this.m_descriptor.initialContent().equals(name)) {
                        this.addInitialContentFromZipEntry(entry, is, cdr.getPermissions());
                        sawInitialContent = true;
                    } else if (this.m_descriptor != null && this.m_descriptor.icons().contains(name)) {
                        this.addIconFromZipEntry(entry, is, cdr.getPermissions());
                        seenIconPaths.add(name);
                    } else {
                        this.addFileFromZipEntry(entry, is, cdr.getPermissions());
                    }
                }
                ((InputStream)is).close();
                ++index;
            }
            if (!inputSigned && index < 3) {
                throw new InvalidInputException("not a complete airi file");
            }
            if (inputSigned && (index < 4 || this.m_signatureEntry == null)) {
                throw new InvalidInputException("not a complete air file");
            }
            if (!sawInitialContent) {
                throw new InvalidInputException("initial content missing: " + this.m_descriptor.initialContent());
            }
            for (String iconPath : this.m_descriptor.icons()) {
                if (seenIconPaths.contains(iconPath)) continue;
                throw new InvalidInputException("icon missing: " + iconPath);
            }
        }
        catch (ApplicationDescriptorValidationException e2) {
            throw new InvalidInputException("File " + inputFile.getName() + " has an invalid descriptor: " + e2.getMessage());
        }
        catch (InvalidInputException e3) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed: " + e3.getMessage());
        }
        catch (IOException e4) {
            throw new InvalidInputException("File " + inputFile.getName() + " is malformed");
        }
    }

    public ZipEntry getSignatureEntry() {
        return this.m_signatureEntry;
    }

    public void addDescriptor(Descriptor descriptor, boolean sign) throws IOException {
        this.m_descriptor = descriptor;
        if (this.m_validate) {
            ADTOutputStream.addRestrictedFileName(this.getDescriptor().filename() + ".exe");
            ADTOutputStream.addRestrictedFileName(this.getDescriptor().filename());
        }
    }

    public abstract void addHashFile(String var1) throws IOException;

    public abstract void addInitialContentFromZipEntry(ZipEntry var1, InputStream var2, long var3) throws IOException;

    public abstract void addIconFromZipEntry(ZipEntry var1, InputStream var2, long var3) throws IOException;

    public abstract void addDescriptorFromZipEntry(ZipEntry var1, InputStream var2) throws IOException;

    public void addFileFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.checkPath(entry.getName());
        this.addFileFromStream(entry.getName(), data, entry.getSize(), permissions, entry.getTime(), true);
    }

    protected void addFileFromStream(String name, InputStream in, long permissions, boolean addToSignature) throws IOException {
        this.addFileFromStream(name, in, in.available(), permissions, new Date().getTime(), addToSignature);
    }

    protected void addFileFromStream(String name, InputStream in, long size, long permissions, long time, boolean addToSignature) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(time));
        record.path = name;
        record.size = in.available();
        record.permissions = permissions != 0L ? permissions : DEFAULT_FILE_PERMISSONS;
        this.addFile(record, in, addToSignature, true);
    }

    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        if (this.m_validate) {
            this.checkPath(path);
        }
        super.addFile(file, path, addToSignature);
    }

    protected void checkPath(String path) throws InvalidInputException {
        for (String icon : SPECIAL_ICON_SIZES.keySet()) {
            if (icon.compareToIgnoreCase(path) != 0) continue;
            int size = SPECIAL_ICON_SIZES.get(icon);
            if (icon.compareTo(path) != 0) {
                throw new InvalidInputException("The path " + path + " is restricted. If you were trying to package " + icon + " you should correct the case.");
            }
            if (path.equals(this.getDescriptor().getIcon(size))) continue;
            throw new InvalidInputException("The file with the path " + path + " cannot be packaged unless the descriptor field application.icon.image" + size + "x" + size + " is set to " + path);
        }
        for (Pattern restrictedPattern : RESTRICTED_PATTERNS) {
            if (!restrictedPattern.matcher(path).matches()) continue;
            throw new InvalidInputException("The path " + path + " is restricted. Choose another name for this file.");
        }
    }

    public Descriptor getDescriptor() {
        return this.m_descriptor;
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    private static void addRestrictedFileName(String name) {
        RESTRICTED_PATTERNS.add(Pattern.compile(name, 2));
    }

    protected void setValidate(boolean validate) {
        this.m_validate = validate;
    }

    static {
        String[] restrictedPaths;
        RESTRICTED_PATTERNS = new HashSet<Pattern>();
        for (String path : restrictedPaths = new String[]{"setup.msi", "Icon.icns", "DocumentIcon\\d*\\.icns", "CodeResources", "_CodeSignature", "_Codesignature/.*", "Info.plist", "ResourceRules.plist", "MainWindow.nib"}) {
            ADTOutputStream.addRestrictedFileName(path);
        }
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        tempMap.put(ICON_PNG, 57);
        tempMap.put(ICON_SMALL_PNG, 29);
        tempMap.put(ITUNES_ARTWORK, 512);
        SPECIAL_ICON_SIZES = Collections.unmodifiableMap(tempMap);
    }

    private class ZipEntryInputStream
    extends InputStream {
        private InputStream _in;
        private ZipFile _zip;
        private ZipEntry _entry;

        public ZipEntryInputStream(ZipFile zip, ZipEntry entry) throws IOException {
            this._zip = zip;
            this._entry = entry;
            this._in = zip.getInputStream(entry);
        }

        public int read() throws IOException {
            return this._in.read();
        }

        public int read(byte[] b3, int off, int len) throws IOException {
            return this._in.read(b3, off, len);
        }

        public int read(byte[] b3) throws IOException {
            return this._in.read(b3);
        }

        public int available() throws IOException {
            return this._in.available();
        }

        public void close() throws IOException {
            this._in.close();
        }

        public void reset() throws IOException {
            this._in.close();
            this._in = this._zip.getInputStream(this._entry);
        }
    }

    private class CentralDirectoryReader {
        private int _permissions;
        private RandomAccessFile _raf;

        public CentralDirectoryReader(ZipFile zipFile) throws IOException {
            this._raf = new RandomAccessFile(zipFile.getName(), "r");
            int header = this.readInt();
            while ((long)header != CENTRAL_DIRECTORY_HEADER_MAGIC) {
                this._raf.skipBytes(4);
                short compressionMethod = this.readShort();
                this._raf.skipBytes(8);
                int compressedSize = this.readInt();
                int uncompressedSize = this.readInt();
                short fileNameLength = this.readShort();
                short extraFieldLength = this.readShort();
                this._raf.skipBytes(fileNameLength);
                this._raf.skipBytes(extraFieldLength);
                this._raf.skipBytes(compressionMethod == 8 ? compressedSize : uncompressedSize);
                header = this.readInt();
            }
            this._raf.seek(this._raf.getFilePointer() - 4L);
        }

        public void advanceHeader(String fileName) throws IOException {
            this._raf.skipBytes(28);
            short fileNameLength = this.readShort();
            short extraFieldLength = this.readShort();
            short fileCommentLength = this.readShort();
            this._raf.skipBytes(4);
            this._permissions = this.readInt();
            this._raf.skipBytes(4);
            byte[] fileNameCD = new byte[fileNameLength];
            this._raf.read(fileNameCD);
            if (!fileName.equals(new String(fileNameCD, "UTF-8"))) {
                throw new IOException("Malformed zip file");
            }
            this._raf.skipBytes(extraFieldLength);
            this._raf.skipBytes(fileCommentLength);
        }

        public int getPermissions() {
            return this._permissions;
        }

        private int readInt() throws IOException {
            return Integer.reverseBytes(this._raf.readInt());
        }

        private short readShort() throws IOException {
            return Short.reverseBytes(this._raf.readShort());
        }
    }
}

