/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTOutputStream;
import com.adobe.air.Descriptor;
import com.adobe.air.Listener;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import com.adobe.ucf.Packager;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.zip.ZipFile;

public abstract class ADTPackager
extends Packager {
    protected boolean m_sign = true;
    protected Listener m_listener;
    protected File m_descriptorFile;
    protected Descriptor m_descriptor = null;
    protected File m_airiFile;
    protected File m_airFile;
    protected boolean m_debug = false;
    protected boolean m_validate = true;
    protected File m_runtimeDir = null;

    public void createPackage() throws IOException, GeneralSecurityException {
        this.reportProgress(0);
        if (this.getOutput() == null) {
            throw new IllegalStateException("output not set");
        }
        if (this.m_airFile == null && this.m_airiFile == null && (this.m_descriptorFile == null || this.getSources().isEmpty())) {
            throw new IllegalStateException("inputs not set");
        }
        if (!this.getSources().isEmpty()) {
            this.validateDescriptor();
            this.addSpecialFiles();
            for (String path : this.getSources().keySet()) {
                File file = (File)this.getSources().get(path);
                this.getStream().addFile(file, path, this.m_sign);
            }
        } else {
            boolean inputSigned;
            ZipFile zipFile;
            if (this.m_airiFile != null) {
                zipFile = new ZipFile(this.m_airiFile);
                inputSigned = false;
            } else if (this.m_airFile != null) {
                zipFile = new ZipFile(this.m_airFile);
                inputSigned = true;
            } else {
                throw new IllegalStateException("inputs not set");
            }
            this.getADTStream().addAIRFile(zipFile, inputSigned);
            this.m_descriptor = this.getADTStream().getDescriptor();
            zipFile.close();
        }
        if (this.m_sign) {
            this.getStream().finalizeSig();
        }
        this.getStream().close();
        this.renameOutput();
        this.reportProgress(100);
    }

    private void reportProgress(int percentDone) {
        if (this.m_listener != null) {
            this.m_listener.progress(percentDone, 100);
        }
    }

    protected void validateDescriptor() throws ApplicationDescriptorValidationException {
    }

    protected void addSpecialFiles() throws IOException {
        this.getADTStream().addDescriptor(this.getDescriptor(), this.m_sign);
    }

    protected void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    protected void setValidate(boolean validate) {
        this.m_validate = validate;
        this.getADTStream().setValidate(validate);
    }

    protected void setRuntimeDir(File runtimeDir) {
        this.m_runtimeDir = runtimeDir;
    }

    public void setAIRIFile(File airiFile) {
        if (!this.getSources().isEmpty()) {
            throw new IllegalStateException("sources already added");
        }
        this.m_airiFile = airiFile;
    }

    public void setAIRFile(File airFile) {
        if (!this.getSources().isEmpty()) {
            throw new IllegalStateException("sources already added");
        }
        this.m_airFile = airFile;
    }

    public void addSourceWithPath(File source, String path) {
        if (this.m_airiFile != null) {
            throw new IllegalStateException(".airi input already set");
        }
        super.addSourceWithPath(source, path);
    }

    public void setDescriptor(File descriptorFile) {
        this.m_descriptorFile = descriptorFile;
    }

    public Descriptor getDescriptor() {
        return this.m_descriptor;
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
        this.getADTStream().setListener(listener);
    }

    public ADTOutputStream getADTStream() {
        return (ADTOutputStream)this.getStream();
    }
}

