/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class Utils {
    public static void consumeOutput(Process process) {
        new OutputEater(process.getInputStream(), false, false).run();
        new OutputEater(process.getErrorStream(), false, false).run();
    }

    public static File getSDKLibDir() throws IOException {
        try {
            return new File(new Utils().getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
        }
        catch (Exception e2) {
            throw new IOException("failed to get jar directory");
        }
    }

    public static void copyTo(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            dest.mkdirs();
            for (File sourceChild : source.listFiles()) {
                File destChild = new File(dest, sourceChild.getName());
                Utils.copyTo(sourceChild, destChild);
            }
        } else {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(dest);
            Utils.copyTo(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void copyTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
    }

    public static boolean deleteAll(File file) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                if (Utils.deleteAll(child)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static byte[] readIn(InputStream in) throws IOException {
        byte[] data = new byte[in.available()];
        in.read(data);
        return data;
    }

    public static File getFileWithExtension(String outputFilename, String extension) {
        File outputFile = new File(outputFilename);
        String name = outputFile.getName();
        if (!name.matches(".+\\.[^\\.]+")) {
            name = name + extension;
        }
        return new File(outputFile.getParentFile(), name);
    }

    public static class OutputEater
    extends Thread {
        private InputStream _in;
        private StringBuffer _output;
        boolean _print;
        boolean _store;

        public OutputEater(InputStream in, boolean print, boolean store) {
            this._in = in;
            this._print = print;
            this._store = store;
            this._output = new StringBuffer();
        }

        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this._in));
                while ((line = reader.readLine()) != null) {
                    if (this._print) {
                        System.out.println(line);
                    }
                    if (!this._store) continue;
                    this._output.append(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String output() {
            return this._output.toString();
        }
    }
}

