/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTOutputStream;
import com.adobe.air.Descriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompiler;
import com.adobe.air.ipa.IPASigner;
import com.adobe.air.ipa.InfoPlist;
import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCFOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;

public class IPAOutputStream
extends ADTOutputStream {
    protected static final String CODE_RESOURCES_LINK = "CodeResources";
    protected static final String MAIN_WINDOW_NIB = "MainWindow.nib";
    protected static final String RESOURCE_RULES_PLIST = "ResourceRules.plist";
    protected static final String INFO_PLIST = "Info.plist";
    protected static final String SIGNATURES_PATH = "_CodeSignature/CodeResources";
    protected static final String AOT_SDK_FOLDER_NAME = "lib/aot";
    protected static final String APP_CONTENT_PATH = "appContent/";
    private String m_configType = "ipa-app-store";
    private File m_mobileProvisionProfile = null;
    private boolean m_compressSWF = false;
    private boolean m_verbose = false;
    private boolean m_debugger = false;
    private String m_optimizeLevel = null;
    private Set<String> m_addedFolders = new HashSet<String>();
    private File m_executable = null;

    protected CodeSigner getCodeSigner() {
        return new IPASigner();
    }

    public void addDescriptor(Descriptor descriptor, boolean sign) throws IOException {
        super.addDescriptor(descriptor, sign);
        this.addInfoPlist();
        this.addResourceRulesPlist();
        this.addCodeResources();
        this.addMainWindowNib();
    }

    public void addHashFile(String path) throws IOException {
    }

    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
    }

    public void addDescriptorFromZipEntry(ZipEntry entry, InputStream data) throws IOException {
        this.addDescriptor(new Descriptor(data), true);
        this.m_descriptor.validateForIPAPackaging();
    }

    public void addIconFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.m_descriptor.validateIcon(data, entry.getName(), false);
        data.reset();
        this.addSpecialIcon(data, entry.getName());
        data.reset();
        this.addFileFromZipEntry(entry, data, permissions);
    }

    public void addInitialContentFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.m_descriptor.validateInitialContent(data, false);
        data.reset();
        this.addInitialContent(data);
    }

    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        FileInputStream in = new FileInputStream(file);
        if (path.equals(this.m_descriptor.initialContent())) {
            this.addInitialContent(in);
        } else {
            this.addSpecialIcon(in, path);
            super.addFile(file, path, addToSignature);
        }
        ((InputStream)in).close();
    }

    private void addSpecialIcon(InputStream in, String path) throws IOException {
        if (!this.m_configType.equals("ipa-app-store") && path.equals(this.m_descriptor.getIcon(512)) && !path.equals("iTunesArtwork")) {
            this.addFileFromStream("iTunesArtwork", in, DEFAULT_FILE_PERMISSONS, true);
        }
        if (path.equals(this.m_descriptor.getIcon(57)) && !path.equals("Icon.png")) {
            this.addFileFromStream("Icon.png", in, DEFAULT_FILE_PERMISSONS, true);
        }
        if (path.equals(this.m_descriptor.getIcon(29)) && !path.equals("Icon-Small.png")) {
            this.addFileFromStream("Icon-Small.png", in, DEFAULT_FILE_PERMISSONS, true);
        }
    }

    private void addInitialContent(InputStream data) throws IOException {
        try {
            if (this.m_optimizeLevel == null && (this.m_configType.equals("ipa-ad-hoc") || this.m_configType.equals("ipa-app-store"))) {
                this.m_optimizeLevel = "3";
            }
            AOTCompiler compiler = new AOTCompiler("arm", data, this.getAOTSDKDir().getAbsolutePath(), this.outputDir.getAbsolutePath(), this.m_optimizeLevel, this.m_verbose, this.m_compressSWF, this.m_debugger);
            if (this.m_listener != null) {
                compiler.setListener(this.m_listener);
            }
            compiler.GenerateMacBinary(this.m_configType.equals("ipa-debug"));
            this.m_executable = compiler.getExecutable();
        }
        catch (InvalidInputException e2) {
            throw e2;
        }
        catch (SDKDamagedException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new IOException("Error:" + e4.getMessage());
        }
    }

    private File getAOTSDKDir() throws IOException {
        return new File(Utils.getSDKLibDir().getParentFile(), AOT_SDK_FOLDER_NAME);
    }

    public void addInfoPlist() throws IOException {
        InfoPlist infoPlist = new InfoPlist();
        infoPlist.setName(this.m_descriptor.name());
        infoPlist.setExecutable(this.m_descriptor.filename());
        infoPlist.setIdentifier(this.m_descriptor.id());
        infoPlist.setFullscreen(this.m_descriptor.fullscreen());
        infoPlist.setInitialWindowTitle(this.m_descriptor.initialWindowTitle());
        infoPlist.setVersion(this.m_descriptor.version());
        infoPlist.setVisible(this.m_descriptor.visible());
        infoPlist.setInfoAdditions(this.m_descriptor.infoAdditions());
        infoPlist.setAspectRatio(this.m_descriptor.aspectRatio());
        infoPlist.setAutoOrients(this.m_descriptor.autoOrients());
        infoPlist.setRenderMode(this.m_descriptor.renderMode());
        this.addData(infoPlist.getXML().getBytes("UTF-8"), INFO_PLIST, new Date(), false, true);
    }

    public void addMainWindowNib() throws IOException, SDKDamagedException {
        File mainWindowNib = new File(new File(this.getAOTSDKDir(), "lib"), MAIN_WINDOW_NIB);
        if (!mainWindowNib.exists()) {
            throw new SDKDamagedException(MAIN_WINDOW_NIB);
        }
        this.addFile(mainWindowNib, MAIN_WINDOW_NIB, true, DEFAULT_FILE_PERMISSONS);
    }

    public void addResourceRulesPlist() throws IOException {
        this.addFileFromResource(RESOURCE_RULES_PLIST, false);
    }

    private void addFileFromResource(String name, boolean addToSignature) throws IOException {
        this.addFileFromStream(name, this.getClass().getResourceAsStream(name), DEFAULT_FILE_PERMISSONS, addToSignature);
    }

    public void addCodeResources() throws IOException {
        this.addFileFromStream(CODE_RESOURCES_LINK, new ByteArrayInputStream(SIGNATURES_PATH.getBytes()), SYMLINK_FILE_PERMISSIONS, false);
    }

    protected String getSignaturesPath() {
        return SIGNATURES_PATH;
    }

    protected void addFile(UCFOutputStream.FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException {
        String[] pathParts = record.path.split("/");
        String currentFolder = "";
        for (int i2 = 0; i2 < pathParts.length - 1; ++i2) {
            if (this.m_addedFolders.contains(currentFolder = currentFolder + pathParts[i2] + "/")) continue;
            UCFOutputStream.FileRecord parentRecord = new UCFOutputStream.FileRecord(record);
            parentRecord.path = currentFolder;
            parentRecord.size = 0L;
            parentRecord.permissions = FOLDER_FILE_PERMISSIONS;
            super.addFile(parentRecord, new EmptyInputStream(), false, false);
            this.m_addedFolders.add(currentFolder);
        }
        super.addFile(record, data, addToSignature, compress);
    }

    protected String getZipPath(String path) {
        return "Payload/" + this.m_descriptor.filename() + ".app/" + path;
    }

    protected void processBytes(String path, byte[] bytes, int numBytes) {
        if (path.equals(INFO_PLIST)) {
            ((IPASigner)this.codeSigner).updateInfoPlistDigest(bytes, numBytes);
        } else if (path.equals(SIGNATURES_PATH)) {
            ((IPASigner)this.codeSigner).updateCodeResourcesDigest(bytes, numBytes);
        }
    }

    protected short versionMadeBy(UCFOutputStream.FileRecord r2) {
        return 791;
    }

    protected short getLFExtraFieldLength() {
        return 21;
    }

    protected void writeLFExtraField(UCFOutputStream.FileRecord r2) throws IOException {
        this.os.writeShort(21589);
        this.os.writeShort(9);
        this.os.writeByte(3);
        this.os.writeLong(r2.lastModifiedUnixTime);
        this.os.writeLong(r2.lastModifiedUnixTime);
        this.os.writeShort(30805);
        this.os.writeShort(4);
        this.os.writeShort(203);
        this.os.writeShort(0);
    }

    protected short getCDExtraFieldLength() {
        return 13;
    }

    protected void writeCDExtraField(UCFOutputStream.FileRecord r2) throws IOException {
        this.os.writeShort(21589);
        this.os.writeShort(5);
        this.os.writeByte(3);
        this.os.writeLong(r2.lastModifiedUnixTime);
        this.os.writeShort(30805);
        this.os.writeShort(0);
    }

    public void finalizeSig() throws IOException, GeneralSecurityException, InvalidInputException {
        if (this.m_mobileProvisionProfile == null) {
            throw new InvalidInputException("Mobile provisioning profile not specified.");
        }
        ((IPASigner)this.codeSigner).setAppIdentifier(this.m_descriptor.id());
        ((IPASigner)this.codeSigner).setMobileProvisioningProfile(this.m_mobileProvisionProfile);
        ((IPASigner)this.codeSigner).setMachoFile(this.m_executable);
        super.finalizeSig();
        ((IPASigner)this.codeSigner).signMacho();
        this.addFile(this.m_executable, this.m_descriptor.filename(), false, EXECUTABLE_FILE_PERMISSIONS);
        this.m_executable.delete();
    }

    public void setOptimizeLevel(String optLevel) {
        this.m_optimizeLevel = optLevel;
    }

    protected long determineFilePermissions(File file) {
        return DEFAULT_FILE_PERMISSONS;
    }

    public void setVerbose(boolean verboseFlag) {
        this.m_verbose = verboseFlag;
    }

    public void setCompressSWF(boolean compressSWFFlag) {
        this.m_compressSWF = compressSWFFlag;
    }

    public void setDebugger(boolean debuggerFlag) {
        this.m_debugger = debuggerFlag;
    }

    public void setMobileProvisioningProfile(File mobileProvisionProfile) {
        this.m_mobileProvisionProfile = mobileProvisionProfile;
    }

    public void setPackageConfiguration(String configType) {
        assert (configType.equals("ipa-test") || configType.equals("ipa-debug") || configType.equals("ipa-app-store") || configType.equals("ipa-ad-hoc"));
        if (configType.equals("ipa-debug")) {
            this.m_debugger = true;
        }
        this.m_configType = configType;
    }

    private class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

