/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.InvalidInputException;
import com.adobe.air.ipa.MachoSigner;
import com.adobe.ucf.CodeSigner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Scanner;

public class IPASigner
extends CodeSigner {
    private final MachoSigner machoSigner;
    private File m_machoFile;
    private String m_appIdentifierPrefix;
    private String m_appIdentifier;
    private MessageDigest m_infoPlistDigest;
    private MessageDigest m_codeResourcesDigest;

    public IPASigner() {
        block2: {
            this.m_fileInfoFormat = new MessageFormat(this.readStringFromResource("CodeResourcesInfo.template"));
            try {
                this.m_sharedDigest = MessageDigest.getInstance("SHA-1");
                this.m_infoPlistDigest = MessageDigest.getInstance("SHA-1");
                this.m_codeResourcesDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.machoSigner = new MachoSigner();
    }

    public void setCertificateChain(Certificate[] certchain) {
        this.machoSigner.setCertificateChain(certchain);
    }

    public void setPrivateKey(PrivateKey key) {
        this.machoSigner.setPrivateKey(key);
    }

    public void setSignerCertificate(Certificate cert) {
        this.machoSigner.setSignerCertificate(cert);
    }

    public void setTimestampURL(String url) {
    }

    public String getSignatureXML() throws GeneralSecurityException, IOException {
        MessageFormat codeResourcesFormat = new MessageFormat(this.readStringFromResource("CodeResources.template"));
        return codeResourcesFormat.format(new Object[]{this.m_packageManifest});
    }

    public void setMobileProvisioningProfile(File mobileProvisioningProfile) throws InvalidInputException {
        if (this.m_appIdentifierPrefix != null) {
            throw new InvalidInputException("Signing Error: mobile provisioning profile already specified.");
        }
        this.m_appIdentifierPrefix = this.getAppIdentifierPrefix(mobileProvisioningProfile);
    }

    public void setAppIdentifier(String appIdentifier) {
        this.m_appIdentifier = appIdentifier;
    }

    public void setMachoFile(File machoFile) {
        this.m_machoFile = machoFile;
    }

    public byte[] sign() throws InvalidKeyException, NoSuchAlgorithmException {
        return null;
    }

    public byte[] signMacho() throws IOException, GeneralSecurityException {
        if (this.m_appIdentifierPrefix == null) {
            throw new InvalidInputException("Signing Error: mobile provisioning profile not specified.");
        }
        this.machoSigner.setHashInfoPlist(this.m_infoPlistDigest.digest());
        this.machoSigner.setHashCodeResources(this.m_codeResourcesDigest.digest());
        this.machoSigner.setApplicationIdentifier(this.m_appIdentifier);
        this.machoSigner.setApplicationIdentifierPrefix(this.m_appIdentifierPrefix);
        this.machoSigner.sign(this.m_machoFile);
        return null;
    }

    public void updateInfoPlistDigest(byte[] bytes, int numBytes) {
        this.m_infoPlistDigest.update(bytes, 0, numBytes);
    }

    public void updateCodeResourcesDigest(byte[] bytes, int numBytes) {
        this.m_codeResourcesDigest.update(bytes, 0, numBytes);
    }

    private String getAppIdentifierPrefix(File mobileProvisioningProfile) throws InvalidInputException {
        try {
            Scanner s2 = new Scanner(new BufferedReader(new FileReader(mobileProvisioningProfile)));
            while (s2.hasNext()) {
                if (!s2.next().equals("<key>ApplicationIdentifierPrefix</key>")) continue;
                if (s2.next().equals("<array>")) {
                    String[] prefix = s2.next().split("<|>");
                    s2.close();
                    return prefix[2];
                }
                throw new InvalidInputException("Malformed provisioning profile: unexpected token after ApplicationIdentifierPrefix.");
            }
            throw new InvalidInputException("Malformed provisioning profile: ApplicationIdentifierPrefix not found.");
        }
        catch (IOException ie) {
            throw new InvalidInputException("Unable to open mobile provisioning profile.");
        }
    }
}

