/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ADTPackager;
import com.adobe.air.AIRPackager;
import com.adobe.air.Descriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;

public abstract class NativePackager
extends ADTPackager {
    private static final int NAIP_EXIT_CODE_SUCCESS = 0;
    private static final int NAIP_EXIT_CODE_ERROR_USAGE = 2;
    private static final int NAIP_EXIT_CODE_ERROR_UNKNOWN = 5;
    private static final int NAIP_EXIT_CODE_ERROR_AIR_FILE = 6;
    private static final int NAIP_EXIT_CODE_ERROR_DESCRIPTOR = 7;
    protected static String ENTRYPOINT_NAME = "naip";
    protected UCF.SigningOptions m_nativeSigningOptions = null;
    private AIRPackager m_airPackager = new AIRPackager();
    private File m_airFileTemp = null;
    protected File m_conversionOutput = null;
    protected String m_appName;

    public NativePackager() {
        this.m_airPackager.setNativeMode(true);
    }

    public void setNativeSigningOptions(UCF.SigningOptions options) {
        this.m_nativeSigningOptions = options;
    }

    public void createPackage() throws GeneralSecurityException, IOException {
        if (this.m_airFile == null) {
            this.m_airFileTemp = File.createTempFile("air", null, this.getOutput().getAbsoluteFile().getParentFile());
            this.m_airPackager.setOutput(this.m_airFileTemp);
            this.m_airPackager.createPackage();
            this.m_airFile = this.m_airFileTemp;
            this.m_appName = this.m_airPackager.getDescriptor().filename();
        }
        this.invokePlatformConversion();
        this.assembleInternalFiles();
        if (this.m_nativeSigningOptions != null) {
            this.signInternalFiles();
        }
        this.createFinalPackage();
        if (this.m_nativeSigningOptions != null) {
            this.signFinalPackage();
        }
        this.finalizePackage();
    }

    protected abstract String getPlatformConverterName();

    protected abstract void assembleInternalFiles() throws IOException, SDKDamagedException;

    protected abstract void signInternalFiles() throws IOException, SDKDamagedException, GeneralSecurityException;

    protected abstract void createFinalPackage() throws IOException, SDKDamagedException;

    protected abstract void signFinalPackage() throws IOException, SDKDamagedException, GeneralSecurityException;

    protected abstract void finalizePackage() throws IOException;

    protected abstract File getDescriptorFileFromConversionOutput();

    protected String getFilename() throws IOException {
        try {
            return new Descriptor(this.getDescriptorFileFromConversionOutput()).filename();
        }
        catch (ApplicationDescriptorValidationException e2) {
            throw new IllegalStateException("Conversion produced an invalid descriptor");
        }
    }

    public void invokePlatformConversion() throws IOException {
        File converter = new File(this.getNAISDKBinDir(), this.getPlatformConverterName());
        if (!converter.exists()) {
            throw new SDKDamagedException(converter.getPath());
        }
        ArrayList<String> command = new ArrayList<String>(6);
        command.add(converter.getAbsolutePath());
        if (this.m_runtimeDir != null) {
            command.add("-runtime");
            command.add(this.m_runtimeDir.getAbsolutePath());
        } else {
            File runtimes = new File(Utils.getSDKLibDir().getParent(), "runtimes");
            if (!runtimes.exists()) {
                throw new SDKDamagedException("runtimes/");
            }
        }
        this.m_conversionOutput = new File(this.getTempFile(), "temp");
        command.add("-convert");
        command.add(this.m_airFile.getPath());
        command.add(this.m_conversionOutput.getPath());
        try {
            Process conversion = new ProcessBuilder(command).redirectErrorStream(true).start();
            Utils.OutputEater stdOutEater = new Utils.OutputEater(conversion.getInputStream(), false, true);
            stdOutEater.run();
            new Utils.OutputEater(conversion.getErrorStream(), false, false).run();
            conversion.waitFor();
            switch (conversion.exitValue()) {
                case 0: {
                    break;
                }
                case 7: {
                    throw new InvalidInputException("Descriptor is invalid for native install. The namespace must be at least 2.0 and the app must support the profile extendedDesktop");
                }
                case 2: 
                case 6: {
                    if (this.m_airFile == null) {
                        this.conversionFail();
                    }
                    throw new InvalidInputException("Invalid AIR file ");
                }
                default: {
                    if (this.m_airFileTemp != null) {
                        this.conversionFail("Process exited with error " + conversion.exitValue() + ". Output was \"" + stdOutEater.output() + "\"");
                    }
                    throw new InvalidInputException("AIR file at " + this.m_airFile + " could not be converted.\n The error was \"" + stdOutEater.output() + "\"");
                }
            }
        }
        catch (InterruptedException e2) {
            this.conversionFail("Conversion was interrupted");
        }
        this.m_appName = this.getFilename();
    }

    protected File getNAISDKBinDir() throws IOException {
        return new File(new File(Utils.getSDKLibDir(), "nai"), "bin");
    }

    protected File getNAISDKLibDir() throws IOException {
        return new File(new File(Utils.getSDKLibDir(), "nai"), "lib");
    }

    protected void conversionFail(String reason) throws IOException {
        throw new IOException("Platform conversion failed. " + reason);
    }

    protected void conversionFail() throws IOException {
        this.conversionFail("");
    }

    public void close() {
        this.m_airPackager.close();
        if (this.m_airFileTemp != null) {
            this.m_airFileTemp.delete();
        }
        if (this.getTempFile() != null) {
            Utils.deleteAll(this.getTempFile());
        }
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFolder("adt");
    }

    public void addSourceWithRoot(File source, File root) {
        this.m_airPackager.addSourceWithRoot(source, root);
    }

    public void addSourceWithPath(File source, String path) {
        this.m_airPackager.addSourceWithPath(source, path);
    }

    public void setAIRIFile(File intermediate) {
        this.m_airPackager.setAIRIFile(intermediate);
    }

    public void setDescriptor(File descriptorFile) {
        this.m_airPackager.setDescriptor(descriptorFile);
    }

    protected void setDebug(boolean debug) {
        this.m_airPackager.setDebug(debug);
    }

    public void setPrivateKey(PrivateKey key) {
        this.m_airPackager.setPrivateKey(key);
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.m_airPackager.setCertificateChain(certchain);
    }

    public void setSignerCertificate(Certificate cert) throws CertificateException {
        this.m_airPackager.setSignerCertificate(cert);
    }

    public void setTimestampURL(String url) {
        this.m_airPackager.setTimestampURL(url);
    }
}

