/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator153;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorValidator20beta2
extends ApplicationDescriptorValidator153 {
    public static final String PROFILE_DESKTOP = "desktop";
    public static final String PROFILE_EXTENDED_DESKTOP = "extendedDesktop";
    public static final String PROFILE_MOBILE_DEVICE = "mobileDevice";
    public static final String PROFILE_EXTENDED_MOBILE_DEVICE = "extendedMobileDevice";
    private Set<String> _validAspectRatios = new HashSet<String>();
    private Set<String> _validProfiles = new HashSet<String>();
    private Set<String> _validRenderModes = new HashSet<String>();
    private String _infoAdditions;
    private boolean _fullScreen;
    private String _aspectRatio;
    private String _renderMode;
    private Boolean _autoOrients;
    private Set<String> _supportedProfiles = this._validProfiles;

    public ApplicationDescriptorValidator20beta2() {
        this._validProfiles.add(PROFILE_DESKTOP);
        this._validProfiles.add(PROFILE_EXTENDED_DESKTOP);
        this._validProfiles.add(PROFILE_MOBILE_DEVICE);
        this._validProfiles.add(PROFILE_EXTENDED_MOBILE_DEVICE);
        this._validAspectRatios.add("portrait");
        this._validAspectRatios.add("landscape");
        this._validRenderModes.add("auto");
        this._validRenderModes.add("cpu");
        this._validRenderModes.add("gpu");
    }

    @Override
    protected ApplicationDescriptorValidator.ElementInfo createElementInfoTree() {
        ApplicationDescriptorValidator.ElementInfo root = super.createElementInfoTree();
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("supportedProfiles", 0, 1));
        ApplicationDescriptorValidator.ElementInfo temp = root.getChild("supportedProfiles");
        temp.contentTypeMixed = true;
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new ApplicationDescriptorValidator.AttributeInfo("xml:lang", true));
        temp = root.getChild("initialWindow");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("aspectRatio", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("autoOrients", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("fullScreen", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("renderMode", 0, 1));
        temp = root.getChild("fileTypes").getChild("fileType").getChild("icon");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image29x29", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image512x512", 0, 1));
        temp = root.getChild("icon");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image29x29", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image57x57", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image512x512", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("iPhone", 0, 1));
        temp = root.getChild("iPhone");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("InfoAdditions", 0, 1));
        return root;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.initialWindow.fullScreen")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
            this._fullScreen = ApplicationDescriptorValidator20beta2.evaluateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.aspectRatio")) {
            valid = this._validAspectRatios.contains(value);
            this._aspectRatio = value;
        }
        if (elementPath.equals("application.initialWindow.autoOrients")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
            this._autoOrients = ApplicationDescriptorValidator20beta2.evaluateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.renderMode")) {
            valid = this._validRenderModes.contains(value);
            this._renderMode = value;
        }
        if (elementPath.equals("application.supportedProfiles")) {
            this._supportedProfiles = new HashSet<String>();
            String[] list = value.split("\\s+");
            valid = list.length > 0;
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (this._supportedProfiles.contains(list[i2]) || !this._validProfiles.contains(list[i2])) {
                    valid = false;
                    break;
                }
                this._supportedProfiles.add(list[i2]);
            }
        }
        if (elementPath.equals("application.icon.image29x29") || elementPath.equals("application.icon.image57x57") || elementPath.equals("application.icon.image512x512")) {
            int size = this.getIntFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
            this._appIcons.put(this.getIntFromIconSize(elementPath), imageUri);
        }
        if (elementPath.equals("application.fileTypes.fileType.icon.image29x29") || elementPath.equals("application.fileTypes.fileType.icon.image512x512")) {
            int size = this.getIntFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, size, size);
            boolean bl2 = valid = imageUri != null;
        }
        if (elementPath.equals("application.iPhone.InfoAdditions")) {
            String infoAdditionsPList = "<plist><dict>" + value + "</dict></plist>";
            valid = this.validatePListString(infoAdditionsPList);
            this._infoAdditions = value;
        }
        return valid;
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/2.0beta2";
    }

    public String infoAdditions() {
        return this._infoAdditions;
    }

    public boolean fullScreen() {
        return this._fullScreen;
    }

    public String aspectRatio() {
        return this._aspectRatio;
    }

    public String renderMode() {
        return this._renderMode;
    }

    public Boolean autoOrients() {
        return this._autoOrients;
    }

    public Set<String> supportedProfiles() {
        return this._supportedProfiles;
    }
}

