/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.pki.Base64;
import com.adobe.ucf.UCF;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.MessageFormat;

public abstract class CodeSigner {
    protected StringBuffer m_packageManifest = new StringBuffer();
    protected MessageFormat m_fileInfoFormat;
    protected MessageDigest m_sharedDigest;

    public abstract void setPrivateKey(PrivateKey var1);

    public abstract void setCertificateChain(Certificate[] var1) throws CertificateException;

    public abstract void setSignerCertificate(Certificate var1) throws CertificateException;

    public abstract byte[] sign() throws InvalidKeyException, NoSuchAlgorithmException;

    public abstract void setTimestampURL(String var1);

    public abstract String getSignatureXML() throws GeneralSecurityException, IOException;

    public void updateFileDigest(byte[] bytes, int offset, int length) {
        this.m_sharedDigest.update(bytes, offset, length);
    }

    public byte[] finalizeFileDigest() {
        return this.m_sharedDigest.digest();
    }

    public void addFileDigestToManifest(byte[] digest, String path) {
        String currentFileRef = this.m_fileInfoFormat.format(new Object[]{path.replaceAll("&", "&amp;"), Base64.encodeBytes(digest)});
        this.m_packageManifest.append(currentFileRef);
    }

    protected String readStringFromResource(String resource) {
        String resourceString;
        block2: {
            resourceString = new String();
            try {
                resourceString = UCF.stringFromInputStream(this.getClass().getResourceAsStream(resource));
            }
            catch (IOException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return resourceString;
    }
}

