/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.pki.Base64;
import com.adobe.pki.PKIContext;
import com.adobe.pki.TimestampException;
import com.adobe.pki.TimestampRequest;
import com.adobe.pki.TimestampResponse;
import com.adobe.ucf.CodeSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class UCFSigner
extends CodeSigner {
    private PrivateKey m_key;
    private Certificate[] m_chainBuildingCerts;
    private Certificate m_eeCert;
    private Vector<byte[]> m_certchain;
    private Vector<byte[]> m_crls;
    private Vector<byte[]> m_crlValidationCerts;
    private byte[] signatureValue;
    private byte[] m_manifestDigestValue;
    private String m_timestampURL;
    private byte[] m_timestamp;
    private long m_gracePeriodMilliseconds;

    public UCFSigner() {
        block2: {
            this.m_certchain = new Vector();
            this.m_crls = new Vector();
            this.m_crlValidationCerts = new Vector();
            this.m_gracePeriodMilliseconds = 0L;
            try {
                this.m_sharedDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        String fileRefTemplate = this.readStringFromResource("fileReference.template");
        this.m_fileInfoFormat = new MessageFormat(fileRefTemplate);
    }

    public void setPrivateKey(PrivateKey key) {
        if (key.getAlgorithm() != "RSA") {
            throw new IllegalArgumentException("not an RSA key");
        }
        this.m_key = key;
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        for (int i2 = 0; i2 < certchain.length; ++i2) {
            if (!(certchain[i2] instanceof X509Certificate)) {
                throw new CertificateException("not an X509 certificate");
            }
            this.checkValidityWithGrace((X509Certificate)certchain[i2]);
        }
        this.m_chainBuildingCerts = certchain;
    }

    public void setSignerCertificate(Certificate cert) throws CertificateException {
        if (!(cert instanceof X509Certificate)) {
            throw new CertificateException("not an X509 certificate");
        }
        this.checkValidityWithGrace((X509Certificate)cert);
        this.m_eeCert = cert;
    }

    private void checkValidityWithGrace(X509Certificate cert) throws CertificateException {
        block2: {
            try {
                cert.checkValidity();
            }
            catch (CertificateExpiredException e2) {
                if (this.m_gracePeriodMilliseconds > 0L && new Date().getTime() - cert.getNotAfter().getTime() <= this.m_gracePeriodMilliseconds) break block2;
                throw e2;
            }
        }
    }

    public void setGracePeriodDays(int days) {
        this.m_gracePeriodMilliseconds = (long)days * 24L * 3600L * 1000L;
    }

    public void setTimestampURL(String url) {
        this.m_timestampURL = url;
    }

    public byte[] sign() throws InvalidKeyException, NoSuchAlgorithmException {
        block6: {
            Signature signature;
            byte[] signedInfo;
            block5: {
                if (this.m_key == null) {
                    throw new IllegalStateException("private key must be set before calling sign()");
                }
                signedInfo = this.getSignedInfo();
                signature = null;
                try {
                    signature = Signature.getInstance("SHA1withRSA");
                }
                catch (NoSuchAlgorithmException e2) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            signature.initSign(this.m_key);
            try {
                signature.update(signedInfo);
                this.signatureValue = signature.sign();
            }
            catch (SignatureException e3) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return this.signatureValue;
    }

    public String getSignatureXML() throws GeneralSecurityException, IOException {
        String timestamp;
        if (this.signatureValue == null) {
            throw new IllegalStateException("sign() must be called before calling getSignatureXML().");
        }
        String xmlKeyInfo = null;
        xmlKeyInfo = this.getXMLKeyInfo();
        String string = timestamp = this.m_timestampURL != null ? this.createTimestampXML(this.m_timestampURL) : "";
        if (xmlKeyInfo == null) {
            throw new RuntimeException("encountered internal error when constructing KeyInfo element");
        }
        String template = this.readStringFromResource("PackageSignature.template");
        MessageFormat mf = new MessageFormat(template);
        String signatureXMLString = mf.format(new Object[]{Base64.encodeBytes(this.m_manifestDigestValue), Base64.encodeBytes(this.signatureValue), xmlKeyInfo, this.m_packageManifest, timestamp});
        return signatureXMLString;
    }

    private byte[] getSignedInfo() {
        String template = this.readStringFromResource("SignedInfo.template");
        MessageFormat mf = new MessageFormat(template);
        byte[] manifestBytes = null;
        try {
            manifestBytes = this.getManifestString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
        this.m_manifestDigestValue = this.m_sharedDigest.digest(manifestBytes);
        String encodedDigest = Base64.encodeBytes(this.m_manifestDigestValue);
        String signedInfoString = mf.format(new Object[]{encodedDigest});
        return signedInfoString.getBytes();
    }

    private String getKeyInfoCerts() throws CertificateEncodingException {
        StringBuffer keyInfoBuffer = new StringBuffer();
        if (this.m_chainBuildingCerts != null && this.m_chainBuildingCerts.length > 0) {
            String template = this.readStringFromResource("certificate.template");
            MessageFormat mf = new MessageFormat(template);
            for (int i2 = 0; i2 < this.m_chainBuildingCerts.length; ++i2) {
                keyInfoBuffer.append(mf.format(new Object[]{Base64.encodeBytes(this.m_chainBuildingCerts[i2].getEncoded())}));
            }
        }
        return keyInfoBuffer.toString();
    }

    public String getXMLKeyInfo() throws GeneralSecurityException {
        int i2;
        MessageFormat mf;
        String template;
        this.BuildAndVerifyCertChain();
        StringBuffer outBuffer = new StringBuffer();
        if (this.m_certchain.size() > 0) {
            template = this.readStringFromResource("certificate.template");
            mf = new MessageFormat(template);
            for (i2 = 0; i2 < this.m_certchain.size(); ++i2) {
                outBuffer.append(mf.format(new Object[]{Base64.encodeBytes(this.m_certchain.get(i2))}));
            }
        }
        if (this.m_crls.size() > 0 && this.m_crlValidationCerts.size() > 0) {
            template = this.readStringFromResource("certificate.template");
            mf = new MessageFormat(template);
            for (i2 = 0; i2 < this.m_crlValidationCerts.size(); ++i2) {
                outBuffer.append(mf.format(new Object[]{Base64.encodeBytes(this.m_crlValidationCerts.get(i2))}));
            }
        }
        if (this.m_crls.size() > 0) {
            template = this.readStringFromResource("crl.template");
            mf = new MessageFormat(template);
            for (i2 = 0; i2 < this.m_crls.size(); ++i2) {
                outBuffer.append(mf.format(new Object[]{Base64.encodeBytes(this.m_crls.get(i2))}));
            }
        }
        return outBuffer.toString();
    }

    private void BuildAndVerifyCertChain() throws GeneralSecurityException {
        PKIContext context = new PKIContext();
        context.Init();
        Vector<byte[]> inChainBuildingCerts = new Vector<byte[]>();
        Vector<byte[]> trustAnchors = new Vector<byte[]>();
        if (this.m_chainBuildingCerts != null) {
            for (int i2 = 0; i2 < this.m_chainBuildingCerts.length; ++i2) {
                byte[] rawCert = this.m_chainBuildingCerts[i2].getEncoded();
                inChainBuildingCerts.add(rawCert);
                X509Certificate x509Certificate = (X509Certificate)this.m_chainBuildingCerts[i2];
                X500Principal issuer = x509Certificate.getIssuerX500Principal();
                X500Principal subject = x509Certificate.getSubjectX500Principal();
                if (!issuer.equals(subject)) continue;
                trustAnchors.add(rawCert);
            }
        }
        boolean hasValidPath = context.VerifyCertPath(this.m_eeCert.getEncoded(), trustAnchors, inChainBuildingCerts, this.m_certchain, this.m_crls, this.m_crlValidationCerts, this.m_gracePeriodMilliseconds > 0L);
        boolean pathIsRevoked = false;
        if (hasValidPath && this.m_crls.size() > 0) {
            boolean bl2 = pathIsRevoked = !context.VerifyPathRevocation(this.m_certchain, trustAnchors, inChainBuildingCerts, this.m_crls);
        }
        if (!hasValidPath) {
            throw new GeneralSecurityException("Unable to build a valid certificate chain for the signer.");
        }
        if (pathIsRevoked) {
            throw new GeneralSecurityException("The signer's certificate chain contains a revoked certificate");
        }
    }

    private String getManifestString() {
        String manifestString = null;
        String packageManifestTemplate = this.readStringFromResource("packageManifest.template");
        MessageFormat mf = new MessageFormat(packageManifestTemplate);
        manifestString = mf.format(new Object[]{this.m_packageManifest});
        return manifestString;
    }

    private String createTimestampXML(String url) throws TimestampException {
        if (this.signatureValue == null) {
            throw new IllegalStateException("sign() must be called before calling createTimestampXML().");
        }
        this.m_timestamp = this.computeSignatureTimestamp(url);
        String template = this.readStringFromResource("timestamp.template");
        MessageFormat mf = new MessageFormat(template);
        return mf.format(new Object[]{"#PackageSignatureValue", Base64.encodeBytes(this.m_timestamp)});
    }

    private byte[] computeSignatureTimestamp(String url) throws TimestampException {
        String messageToDigest = "<SignatureValue xmlns=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"PackageSignatureValue\">" + Base64.encodeBytes(this.signatureValue) + "</SignatureValue>";
        byte[] timestamp = null;
        try {
            timestamp = this.getTimeStampFromURL(messageToDigest.getBytes("UTF-8"), url);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
        return timestamp;
    }

    public byte[] getTimeStampFromURL(byte[] dataToTimestamp, String url) throws TimestampException {
        TimestampRequest req = new TimestampRequest(dataToTimestamp);
        byte[] result = null;
        TimestampResponse response = null;
        try {
            URL tspURL = new URL(url);
            URLConnection tspConnection = tspURL.openConnection();
            tspConnection.setRequestProperty("Content-Type", "application/timestamp-query");
            tspConnection.setDoInput(true);
            tspConnection.setDoOutput(true);
            OutputStream outputStream = tspConnection.getOutputStream();
            outputStream.write(req.getEncoded());
            outputStream.flush();
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            byte[] tempArray = new byte[512];
            int bytesRead = 0;
            while ((bytesRead = tspConnection.getInputStream().read(tempArray)) > 0) {
                resultStream.write(tempArray, 0, bytesRead);
            }
            result = resultStream.toByteArray();
            response = new TimestampResponse(result);
        }
        catch (IOException e2) {
            throw new TimestampException("Could not generate timestamp: " + e2.getLocalizedMessage());
        }
        if (!response.isValid()) {
            throw new TimestampException("Timestamp response not valid");
        }
        return response.getTimestampTokenBytes();
    }
}

