/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.UCFPackager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;

public class UCFTask
extends Task {
    private String m_namespace;
    private File m_dest;
    private List m_filesets = new ArrayList();
    private List m_metainfFilesets = new ArrayList();

    public void setNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    public void setDestfile(File dest) {
        this.m_dest = dest;
    }

    public void addZipFileSet(ZipFileSet fileset) {
        this.m_filesets.add(fileset);
    }

    public void addMetainf(ZipFileSet fileset) {
        this.m_metainfFilesets.add(fileset);
    }

    public void execute() throws BuildException {
        if (this.m_dest == null) {
            throw new BuildException("required attribute 'destfile' not set");
        }
        if (this.m_metainfFilesets.size() > 0 && this.m_namespace == null) {
            throw new BuildException("must specified 'namespace' attribute when using <metainf>");
        }
        UCFPackager p2 = new UCFPackager();
        if (this.m_namespace != null) {
            p2.setMetaInfNamespace(this.m_namespace);
        }
        boolean upToDate = true;
        try {
            p2.setOutput(this.m_dest);
            upToDate &= this.addFilesets(p2, this.m_metainfFilesets, true);
            if (!(upToDate &= this.addFilesets(p2, this.m_filesets, false))) {
                p2.createPackage();
            }
        }
        catch (IOException ex) {
            throw new BuildException("could not create output file");
        }
        catch (Exception ex) {
            throw new BuildException("packaging failed: " + ex.getMessage());
        }
        finally {
            p2.close();
        }
        if (upToDate) {
            System.out.println(this.m_dest.getPath() + " is up-to-date");
        } else {
            System.out.println("Packaged " + this.m_dest.getPath());
        }
    }

    private boolean addFilesets(UCFPackager p2, List filesets, boolean isMetaInf) {
        boolean upToDate = true;
        for (ZipFileSet fileset : filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] paths = ds.getIncludedFiles();
            if (paths.length == 0) continue;
            if (fileset.getFullpath(this.getProject()).length() > 0) {
                if (paths.length > 1) {
                    throw new BuildException("cannot use 'fullpath' with more than one file");
                }
                File src = new File(ds.getBasedir(), paths[0]);
                upToDate &= FileUtils.getFileUtils().isUpToDate(src, this.m_dest);
                if (isMetaInf) {
                    p2.addMetaInfSourceWithPath(src, fileset.getFullpath(this.getProject()));
                    continue;
                }
                p2.addSourceWithPath(src, fileset.getFullpath(this.getProject()));
                continue;
            }
            for (int j2 = 0; j2 < paths.length; ++j2) {
                File src = new File(ds.getBasedir(), paths[j2]);
                upToDate &= FileUtils.getFileUtils().isUpToDate(src, this.m_dest);
                String path = ds.getBasedir().toURI().relativize(src.toURI()).getPath();
                if (fileset.getPrefix(this.getProject()).length() > 0) {
                    path = fileset.getPrefix(this.getProject()) + "/" + path;
                }
                if (isMetaInf) {
                    p2.addMetaInfSourceWithPath(src, path);
                    continue;
                }
                p2.addSourceWithPath(src, path);
            }
        }
        return upToDate;
    }
}

