/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ExtendedNetworkAddress;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.PDSParameter;
import com.rsa.certj.cert.extensions.TeletexDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.TeletexPersonalName;
import com.rsa.certj.cert.extensions.UnformattedPostalAddress;
import java.io.Serializable;
import java.util.Vector;

public class ExtensionAttribute
implements Cloneable,
Serializable {
    public static final int COMMON_NAME = 1;
    public static final int TELETEX_COMMON_NAME = 2;
    public static final int TELETEX_ORGANIZATION_NAME = 3;
    public static final int TELETEX_PERSONAL_NAME = 4;
    public static final int TELETEX_ORGANIZATIONAL_UNIT_NAMES = 5;
    public static final int TELETEX_DOMAIN_DEFINED_ATTRIBUTES = 6;
    public static final int PDS_NAME = 7;
    public static final int PHYSICAL_DELIVERY_COUNTRY_NAME = 8;
    public static final int POSTAL_CODE = 9;
    public static final int PHYSICAL_DELIVERY_OFFICE_NAME = 10;
    public static final int PHYSICAL_DELIVERY_OFFICE_NUMBER = 11;
    public static final int EXTENSION_OR_ADDRESS_COMPONENTS = 12;
    public static final int PHYSICAL_DELIVERY_PERSONAL_NAME = 13;
    public static final int PHYSICAL_DELIVERY_ORGANIZATION_NAME = 14;
    public static final int EXTENSION_PHYSICAL_DELIVERY_ADDRESS_COMPONENTS = 15;
    public static final int UNFORMATTED_POSTAL_ADDRESS = 16;
    public static final int STREET_ADDRESS = 17;
    public static final int POST_OFFICE_BOX_ADDRESS = 18;
    public static final int POSTE_RESTANTE_ADDRESS = 19;
    public static final int UNIQUE_POSTAL_NAME = 20;
    public static final int LOCAL_POSTAL_ATTRIBUTES = 21;
    public static final int EXTENDED_NETWORK_ADDRESS = 22;
    public static final int TERMINAL_TYPE = 23;
    private int a;
    private String b;
    private TeletexPersonalName c;
    private String[] d = new String[4];
    private int e = 0;
    private ORName f;
    private PDSParameter g;
    private UnformattedPostalAddress h;
    private ExtendedNetworkAddress i;
    private int j;
    private TeletexDomainDefinedAttributes k;
    protected int special;
    protected ASN1Template asn1Template = null;

    public ExtensionAttribute(byte[] byArray, int n2, int n3) throws NameException {
        this.special = n3;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n3);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0x800000);
            EncodedContainer encodedContainer = new EncodedContainer(8453889);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            this.a = integerContainer.getValueAsInt();
            switch (this.a) {
                case 1: {
                    PrintStringContainer printStringContainer = new PrintStringContainer(0x800001, 1, 64);
                    ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{printStringContainer};
                    ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray2);
                    this.b = printStringContainer.getValueAsString();
                    break;
                }
                case 7: {
                    PrintStringContainer printStringContainer = new PrintStringContainer(0x800001, 1, 16);
                    ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{printStringContainer};
                    ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray3);
                    this.b = printStringContainer.getValueAsString();
                    break;
                }
                case 2: 
                case 3: {
                    TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0x800001, 1, 64);
                    ASN1Container[] aSN1ContainerArray4 = new ASN1Container[]{teletexStringContainer};
                    ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray4);
                    this.b = teletexStringContainer.getValueAsString();
                    break;
                }
                case 4: {
                    this.c = new TeletexPersonalName(encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 5: {
                    OfContainer ofContainer = new OfContainer(0x800001, 12288, new EncodedContainer(5120));
                    ASN1Container[] aSN1ContainerArray5 = new ASN1Container[]{ofContainer};
                    ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray5);
                    int n4 = ofContainer.getContainerCount();
                    if (n4 > 4) {
                        throw new NameException("Too many entries in TeletexOrganizationalUnitNames: MAX number is 4.");
                    }
                    for (int i2 = 0; i2 < n4; ++i2) {
                        ASN1Container aSN1Container = ofContainer.containerAt(i2);
                        TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0, 1, 32);
                        ASN1Container[] aSN1ContainerArray6 = new ASN1Container[]{teletexStringContainer};
                        ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray6);
                        this.d[this.e] = teletexStringContainer.getValueAsString();
                        ++this.e;
                    }
                    break;
                }
                case 6: {
                    this.k = new TeletexDomainDefinedAttributes(encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 8: {
                    this.f = new ORName(4, encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 9: {
                    this.f = new ORName(3, encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    this.g = new PDSParameter(encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 16: {
                    this.h = new UnformattedPostalAddress(encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 22: {
                    this.i = new ExtendedNetworkAddress(encodedContainer.data, encodedContainer.dataOffset, 0x800001);
                    break;
                }
                case 23: {
                    IntegerContainer integerContainer2 = new IntegerContainer(0x800001);
                    ASN1Container[] aSN1ContainerArray7 = new ASN1Container[]{integerContainer2};
                    ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray7);
                    this.j = integerContainer2.getValueAsInt();
                    if (this.j >= 3 && this.j <= 8) break;
                    throw new NameException("Wrong TerminalType value");
                }
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the ExtensionAttribute.");
        }
    }

    public ExtensionAttribute() {
    }

    public void setAttribute(int n2, Object object) throws NameException {
        if (object == null) {
            throw new NameException("Value is null.");
        }
        if (n2 > 23 || n2 < 1) {
            throw new NameException("Wrong type.");
        }
        this.a = n2;
        switch (this.a) {
            case 1: {
                if (object instanceof String && ((String)object).length() < 65) {
                    this.b = (String)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 7: {
                if (object instanceof String && ((String)object).length() < 17) {
                    this.b = (String)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 2: 
            case 3: {
                if (object instanceof String && ((String)object).length() < 65) {
                    this.b = (String)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 4: {
                if (object instanceof TeletexPersonalName) {
                    this.c = (TeletexPersonalName)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 5: {
                if (object instanceof Vector && ((Vector)object).size() < 5) {
                    for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                        if (((Vector)object).elementAt(i2) instanceof String) {
                            this.d[this.e] = (String)((Vector)object).elementAt(i2);
                            ++this.e;
                            continue;
                        }
                        throw new NameException("Wrong value type");
                    }
                    break;
                }
                throw new NameException("Too many entries in TeletexOrganizationalUnitNames: MAX number is 4.");
            }
            case 6: {
                if (object instanceof TeletexDomainDefinedAttributes) {
                    this.k = (TeletexDomainDefinedAttributes)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 8: {
                if (object instanceof ORName && ((ORName)object).getNameType() == 4) {
                    this.f = (ORName)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 9: {
                if (object instanceof ORName && ((ORName)object).getNameType() == 3) {
                    this.f = (ORName)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (object instanceof PDSParameter) {
                    this.g = (PDSParameter)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 16: {
                if (object instanceof UnformattedPostalAddress) {
                    this.h = (UnformattedPostalAddress)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 22: {
                if (object instanceof ExtendedNetworkAddress) {
                    this.i = (ExtendedNetworkAddress)object;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 23: {
                if (!(object instanceof Integer)) {
                    throw new NameException("Wrong value type");
                }
                this.j = (Integer)object;
                if (this.j >= 3 && this.j <= 8) break;
                throw new NameException("Wrong TerminalType value");
            }
        }
    }

    public int getAttributeType() {
        return this.a;
    }

    public Object getAttribute() {
        switch (this.a) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.b;
            }
            case 4: {
                return this.c;
            }
            case 5: {
                Vector<String> vector = new Vector<String>();
                for (int i2 = 0; i2 < this.e; ++i2) {
                    vector.addElement(this.d[i2]);
                }
                return vector;
            }
            case 6: {
                return this.k;
            }
            case 8: 
            case 9: {
                return this.f;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return this.g;
            }
            case 16: {
                return this.h;
            }
            case 22: {
                return this.i;
            }
            case 23: {
                Integer n2 = new Integer(this.j);
                return n2;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.a) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.b;
            }
            case 4: {
                return this.c.toString();
            }
            case 5: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < this.e - 1; ++i2) {
                    stringBuffer.append(this.d[i2]);
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.d[this.e - 1]);
                return stringBuffer.toString();
            }
            case 6: {
                return this.k.toString();
            }
            case 8: 
            case 9: {
                return this.f.toString();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return this.g.toString();
            }
            case 16: {
                return this.h.toString();
            }
            case 22: {
                return this.i.toString();
            }
            case 23: {
                return Integer.toString(this.j);
            }
        }
        return null;
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) throws NameException {
        this.special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n4 = 0;
            if ((this.asn1Template == null || n3 != this.special) && (n4 = this.getDERLen(n3)) == 0) {
                throw new NameException("Unable to encode ExtensionAttribute");
            }
            int n5 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
            return n5;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtensionAttribute");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0x800000, true, 0, this.a);
            switch (this.a) {
                case 1: {
                    PrintStringContainer printStringContainer = new PrintStringContainer(0x800001, true, 0, this.b, 1, 64);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, printStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 7: {
                    PrintStringContainer printStringContainer = new PrintStringContainer(0x800001, true, 0, this.b, 1, 16);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, printStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 2: 
                case 3: {
                    TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0x800001, true, 0, this.b, 1, 64);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, teletexStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 4: {
                    byte[] byArray = new byte[this.c.getDERLen(0x800001)];
                    int n2 = this.c.getDEREncoding(byArray, 0, 0x800001);
                    EncodedContainer encodedContainer = new EncodedContainer(8453889, true, 0, byArray, 0, n2);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 5: {
                    Object object;
                    Object object2;
                    OfContainer ofContainer = new OfContainer(0x800001, true, 0, 12288, new EncodedContainer(5120));
                    Vector<OfContainer> vector = new Vector<OfContainer>();
                    EncodedContainer encodedContainer = null;
                    EncodedContainer encodedContainer2 = null;
                    vector.addElement(ofContainer);
                    for (int i2 = 0; i2 < this.e; ++i2) {
                        object2 = new TeletexStringContainer(0, true, 0, this.d[i2], 1, 32);
                        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object2};
                        object = new ASN1Template(aSN1ContainerArray);
                        int n3 = ((ASN1Template)object).derEncodeInit();
                        byte[] byArray = new byte[n3];
                        n3 = ((ASN1Template)object).derEncode(byArray, 0);
                        encodedContainer = new EncodedContainer(5120, true, 0, byArray, 0, n3);
                        ofContainer.addContainer(encodedContainer);
                    }
                    Object[] objectArray = new ASN1Container[vector.size()];
                    vector.copyInto(objectArray);
                    object2 = new ASN1Template((ASN1Container[])objectArray);
                    int n4 = ((ASN1Template)object2).derEncodeInit();
                    object = new byte[n4];
                    n4 = ((ASN1Template)object2).derEncode((byte[])object, 0);
                    encodedContainer2 = new EncodedContainer(12288, true, 0, (byte[])object, 0, n4);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 6: {
                    byte[] byArray = new byte[this.k.getDERLen(0x800001)];
                    int n5 = this.k.getDEREncoding(byArray, 0, 0x800001);
                    EncodedContainer encodedContainer = new EncodedContainer(8453889, true, 0, byArray, 0, n5);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 8: 
                case 9: {
                    byte[] byArray = new byte[this.f.getDERLen(0x800001)];
                    int n6 = this.f.getDEREncoding(byArray, 0, 0x800001);
                    EncodedContainer encodedContainer = new EncodedContainer(8453889, true, 0, byArray, 0, n6);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    byte[] byArray = new byte[this.g.getDERLen(0x800001)];
                    int n7 = this.g.getDEREncoding(byArray, 0, 0x800001);
                    EncodedContainer encodedContainer = new EncodedContainer(8453889, true, 0, byArray, 0, n7);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 16: {
                    byte[] byArray = new byte[this.h.getDERLen(0x800001)];
                    int n8 = this.h.getDEREncoding(byArray, 0, 0x800001);
                    EncodedContainer encodedContainer = new EncodedContainer(8453889, true, 0, byArray, 0, n8);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 22: {
                    byte[] byArray = new byte[this.i.getDERLen(0x800001)];
                    int n9 = this.i.getDEREncoding(byArray, 0, 0x800001);
                    EncodedContainer encodedContainer = new EncodedContainer(8453889, true, 0, byArray, 0, n9);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 23: {
                    IntegerContainer integerContainer2 = new IntegerContainer(0x800001, true, 0, this.j);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ExtensionAttribute)) {
            return false;
        }
        ExtensionAttribute extensionAttribute = (ExtensionAttribute)object;
        if (this.a != extensionAttribute.a) {
            return false;
        }
        switch (this.a) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                if (this.b.equals(extensionAttribute.b)) break;
                return false;
            }
            case 4: {
                if (this.c.equals(extensionAttribute.c)) break;
                return false;
            }
            case 5: {
                if (this.e != extensionAttribute.e) {
                    return false;
                }
                for (int i2 = 0; i2 < this.e; ++i2) {
                    if (this.d[i2].equals(extensionAttribute.d[i2])) continue;
                    return false;
                }
                break;
            }
            case 6: {
                if (this.k.equals(extensionAttribute.k)) break;
                return false;
            }
            case 8: 
            case 9: {
                if (this.f.equals(extensionAttribute.f)) break;
                return false;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (this.g.equals(extensionAttribute.g)) break;
                return false;
            }
            case 16: {
                if (this.h.equals(extensionAttribute.h)) break;
                return false;
            }
            case 22: {
                if (this.i.equals(extensionAttribute.i)) break;
                return false;
            }
            case 23: {
                if (this.j == extensionAttribute.j) break;
                return false;
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.a = this.a;
        switch (this.a) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                extensionAttribute.b = new String(this.b);
                break;
            }
            case 4: {
                extensionAttribute.c = (TeletexPersonalName)this.c.clone();
                break;
            }
            case 5: {
                extensionAttribute.e = this.e;
                for (int i2 = 0; i2 < this.e; ++i2) {
                    extensionAttribute.d[i2] = new String(this.d[i2]);
                }
                break;
            }
            case 6: {
                extensionAttribute.k = (TeletexDomainDefinedAttributes)this.k.clone();
                break;
            }
            case 8: 
            case 9: {
                extensionAttribute.f = (ORName)this.f.clone();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                extensionAttribute.g = (PDSParameter)this.g.clone();
                break;
            }
            case 16: {
                extensionAttribute.h = (UnformattedPostalAddress)this.h.clone();
                break;
            }
            case 22: {
                extensionAttribute.i = (ExtendedNetworkAddress)this.i.clone();
                break;
            }
            case 23: {
                extensionAttribute.j = this.j;
            }
        }
        extensionAttribute.special = this.special;
        if (this.asn1Template != null) {
            extensionAttribute.a();
        }
        return extensionAttribute;
    }
}

