/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class OCSPNonce
extends X509V3Extension
implements Cloneable,
Serializable,
OCSPRequestExtension {
    private byte[] a;
    private int b;
    ASN1Template c;

    public OCSPNonce() {
        this.extensionTypeFlag = 120;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.OCSP_NONCE_OID);
        this.extensionTypeString = "OCSPNonce";
        this.a = null;
        this.b = 0;
    }

    public OCSPNonce(byte[] byArray, int n2, int n3) {
        this.extensionTypeFlag = 120;
        this.setSpecialOID(X509V3Extension.OCSP_NONCE_OID);
        this.extensionTypeString = "OCSPNonce";
        this.criticality = false;
        this.setNonceValue(byArray, n2, n3);
    }

    public void setNonceValue(byte[] byArray, int n2, int n3) {
        if (byArray == null || n3 == 0) {
            return;
        }
        this.a = new byte[n3];
        System.arraycopy(byArray, n2, this.a, 0, n3);
        this.b = n3;
    }

    public byte[] getNonceValue() {
        if (this.a == null) {
            return null;
        }
        return this.a;
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            this.b = 0;
            throw new CertificateException("Could not decode OCSPNonce extension.");
        }
        this.setNonceValue(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
    }

    public int derEncodeValueInit() {
        if (this.a == null || this.b == 0) {
            return 0;
        }
        try {
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.a, 0, this.b);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{octetStringContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.c.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPNonce oCSPNonce = new OCSPNonce();
        if (this.a != null) {
            oCSPNonce.b = this.b;
            oCSPNonce.a = new byte[oCSPNonce.b];
            System.arraycopy(this.a, 0, oCSPNonce.a, 0, oCSPNonce.b);
        }
        if (this.c != null) {
            oCSPNonce.derEncodeValueInit();
        }
        super.copyValues(oCSPNonce);
        return oCSPNonce;
    }

    protected void reset() {
        super.reset();
        this.c = null;
    }
}

