/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class PDSParameter
implements Cloneable,
Serializable {
    private String a;
    private String b;
    protected int special;
    protected ASN1Template asn1Template = null;

    public PDSParameter(byte[] byArray, int n2, int n3) throws NameException {
        this.special = n3;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(n3);
            PrintStringContainer printStringContainer = new PrintStringContainer(65536, 1, 30);
            TeletexStringContainer teletexStringContainer = new TeletexStringContainer(65536, 1, 30);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, teletexStringContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (printStringContainer.dataPresent) {
                this.a = printStringContainer.getValueAsString();
            }
            if (teletexStringContainer.dataPresent) {
                this.b = teletexStringContainer.getValueAsString();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the RDSParameter.");
        }
    }

    public PDSParameter() {
    }

    public void setPrintableString(String string) {
        if (string != null) {
            this.a = string;
        }
    }

    public void setTeletexString(String string) {
        if (string != null) {
            this.b = string;
        }
    }

    public String getPrintableString() {
        return this.a;
    }

    public String getTeletexString() {
        return this.b;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a);
        }
        if (this.b != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.b);
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) {
        this.special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n4 = 0;
            if ((this.asn1Template == null || n3 != this.special) && (n4 = this.getDERLen(n3)) == 0) {
                throw new NameException("Unable to encode PDSParameter.");
            }
            int n5 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
            return n5;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode PDSParameter.");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            int n2 = 0;
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            TeletexStringContainer teletexStringContainer = null;
            PrintStringContainer printStringContainer = null;
            if (this.a != null) {
                printStringContainer = new PrintStringContainer(65536, true, 0, this.a, 1, 30);
                n2 = 1;
            }
            if (this.b != null) {
                teletexStringContainer = new TeletexStringContainer(65536, true, 0, this.b, 1, 30);
                n2 = n2 == 0 ? 2 : 3;
            }
            switch (n2) {
                case 0: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 1: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 2: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, teletexStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 3: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, teletexStringContainer, endContainer};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PDSParameter)) {
            return false;
        }
        PDSParameter pDSParameter = (PDSParameter)object;
        if (this.a != null ? !this.a.equals(pDSParameter.a) : pDSParameter.a != null) {
            return false;
        }
        return !(this.b != null ? !this.b.equals(pDSParameter.b) : pDSParameter.b != null);
    }

    public Object clone() throws CloneNotSupportedException {
        PDSParameter pDSParameter = new PDSParameter();
        if (this.a != null) {
            pDSParameter.a = new String(this.a);
        }
        if (this.b != null) {
            pDSParameter.b = new String(this.b);
        }
        pDSParameter.special = this.special;
        if (this.asn1Template != null) {
            pDSParameter.a();
        }
        return pDSParameter;
    }
}

