/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EnumeratedContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class ReasonCode
extends X509V3Extension
implements Cloneable,
Serializable,
CRLEntryExtension,
OCSPSingleExtension {
    public static final int REASON_CODE_UNSPECIFIED = 0;
    public static final int REASON_CODE_KEY_COMPROMISE = 1;
    public static final int REASON_CODE_CA_COMPROMISE = 2;
    public static final int REASON_CODE_AFFILIATION_CHANGED = 3;
    public static final int REASON_CODE_SUPERSEDED = 4;
    public static final int REASON_CODE_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CODE_CERTIFICATE_HOLD = 6;
    public static final int REASON_CODE_REMOVED_FROM_CRL = 8;
    private int a;
    ASN1Template b;

    public ReasonCode() {
        this.extensionTypeFlag = 21;
        this.criticality = false;
        this.setStandardOID(21);
        this.extensionTypeString = "ReasonCode";
    }

    public ReasonCode(int n2, boolean bl2) throws CertificateException {
        this.extensionTypeFlag = 21;
        this.criticality = bl2;
        this.a = n2;
        if (n2 < 0 || n2 > 8 || n2 == 7) {
            throw new CertificateException("Invalid Reason Code.");
        }
        this.setStandardOID(21);
        this.extensionTypeString = "ReasonCode";
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a = 0;
        try {
            EnumeratedContainer enumeratedContainer = new EnumeratedContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{enumeratedContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (enumeratedContainer.dataLen == 0) {
                return;
            }
            this.a = enumeratedContainer.getValueAsInt();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode ReasonCode extension.");
        }
        if (this.a < 0 || this.a > 8 || this.a == 7) {
            throw new CertificateException("Could not decode ReasonCode extension: Invalid Reason Code.");
        }
    }

    public void setReasonCode(int n2) {
        this.a = n2;
    }

    public int getReasonCode() {
        return this.a;
    }

    public boolean verifyReasonCode(int n2) {
        return this.a == n2;
    }

    public int derEncodeValueInit() {
        try {
            EnumeratedContainer enumeratedContainer = new EnumeratedContainer(0, true, 0, this.a);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{enumeratedContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ReasonCode reasonCode = new ReasonCode();
        reasonCode.a = this.a;
        if (this.b != null) {
            reasonCode.derEncodeValueInit();
        }
        super.copyValues(reasonCode);
        return reasonCode;
    }

    protected void reset() {
        super.reset();
        this.a = 0;
        this.b = null;
    }
}

