/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.EncryptedContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.Serializable;
import java.security.SecureRandom;

public class EncryptedData
extends ContentInfo
implements Cloneable,
Serializable {
    protected int version = -1;
    protected EncryptedContentInfo info = new EncryptedContentInfo();
    private String a;
    private JSAFE_SecretKey b;
    private byte[] c;
    private char[] d;
    private byte[] e;
    private byte[] f;

    public EncryptedData(CertJ certJ, CertPathCtx certPathCtx) {
        this.contentType = 6;
        this.theCertJ = certJ;
        this.theCertPathCtx = certPathCtx;
    }

    public void setVersionNumber(int n2) {
        this.version = n2;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setIV(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 > 0 && n2 >= 0 && n3 + n2 <= byArray.length) {
            this.e = new byte[n3];
            System.arraycopy(byArray, n2, this.e, 0, n3);
        }
    }

    public byte[] getIV() {
        if (this.e == null) {
            return null;
        }
        byte[] byArray = new byte[this.e.length];
        System.arraycopy(this.e, 0, byArray, 0, this.e.length);
        return byArray;
    }

    public void setSalt(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 > 0 && n2 >= 0 && n3 + n2 <= byArray.length) {
            this.f = new byte[n3];
            System.arraycopy(byArray, n2, this.f, 0, n3);
        }
    }

    public byte[] getSalt() {
        if (this.f == null) {
            return null;
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    public void setEncryptionAlgorithm(String string) throws PKCS7Exception {
        if (string == null) {
            throw new PKCS7Exception("Algorithm name is null");
        }
        this.a = string;
        try {
            Object object;
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(string, this.getDeviceOrJava());
            if (jSAFE_SymmetricCipher.getFeedbackMode() != null && !jSAFE_SymmetricCipher.getFeedbackMode().equals("ECB")) {
                if (this.e == null) {
                    if (this.theCertJ == null) {
                        throw new PKCS7Exception("CertJ object is null; cannot get Random object.");
                    }
                    object = this.theCertJ.getRandomObject();
                    jSAFE_SymmetricCipher.generateIV((SecureRandom)object);
                } else {
                    jSAFE_SymmetricCipher.setIV(this.e, 0, this.e.length);
                }
            }
            if (this.f != null) {
                jSAFE_SymmetricCipher.setSalt(this.f, 0, this.f.length);
            }
            object = jSAFE_SymmetricCipher.getDERAlgorithmID();
            this.info.setEncryptionAlgorithm((byte[])object, 0, ((byte[])object).length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not set algorithm OID: " + jSAFE_Exception.getMessage());
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not set algorithm OID" + randomException.getMessage());
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not set algorithm OID" + noServiceException.getMessage());
        }
    }

    public void setEncryptionAlgorithm(byte[] byArray, int n2, int n3) throws PKCS7Exception {
        if (byArray == null || n3 <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new PKCS7Exception("Invalid content-encryption algorithm ID");
        }
        this.info.setEncryptionAlgorithm(byArray, n2, n3);
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.info == null) {
            return null;
        }
        return this.info.getEncryptionAlgorithm();
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.a != null) {
            return this.a;
        }
        if (this.info == null) {
            return null;
        }
        byte[] byArray = this.info.getEncryptionAlgorithm();
        if (byArray == null) {
            return null;
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(130816);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1.berDecode(byArray, 0, aSN1ContainerArray);
            return OIDList.getTrans(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, 6);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Encryption algorithm is not valid." + aSN_Exception.getMessage());
        }
    }

    public void setSecretKey(JSAFE_SecretKey jSAFE_SecretKey) throws PKCS7Exception {
        if (jSAFE_SecretKey == null) {
            throw new PKCS7Exception("Secret key is null.");
        }
        try {
            this.b = (JSAFE_SecretKey)jSAFE_SecretKey.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Unable to clone Secret Key");
        }
    }

    public JSAFE_SecretKey getSecretKey() throws PKCS7Exception {
        if (this.b == null) {
            return null;
        }
        try {
            return (JSAFE_SecretKey)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Unable to clone Secret Key");
        }
    }

    public void setSecretKeyData(byte[] byArray, int n2, int n3) throws PKCS7Exception {
        if (byArray != null && n3 > 0 && n2 >= 0 && n2 + n3 <= byArray.length) {
            if (this.a == null) {
                this.a = this.getEncryptionAlgorithmName();
            }
            if (this.a == null) {
                this.c = new byte[n3];
                System.arraycopy(byArray, n2, this.c, 0, n3);
            } else {
                try {
                    JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(this.a, "Java");
                    String string = jSAFE_SymmetricCipher.getEncryptionAlgorithm();
                    this.b = JSAFE_SecretKey.getInstance(string, this.getDeviceOrJava());
                    this.b.setSecretKeyData(byArray, n2, n3);
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new PKCS7Exception("Invalid Key Data " + jSAFE_Exception.getMessage());
                }
            }
        } else {
            throw new PKCS7Exception("NULL Key Data ");
        }
    }

    public byte[] getSecretKeyData() {
        if (this.b == null) {
            return null;
        }
        return this.b.getSecretKeyData();
    }

    public void setPassword(char[] cArray, int n2, int n3) {
        if (cArray != null && n3 > 0 && n2 >= 0 && n2 + n3 <= cArray.length) {
            this.d = new char[n3];
            System.arraycopy(cArray, n2, this.d, 0, n3);
        }
    }

    public char[] getPassword() throws PKCS7Exception {
        if (this.d != null) {
            char[] cArray = new char[this.d.length];
            System.arraycopy(this.d, 0, cArray, 0, this.d.length);
            return cArray;
        }
        if (this.b == null) {
            throw new PKCS7Exception("The SecretKey and Password are not set.");
        }
        try {
            return this.b.getPassword();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("The SecretKey is not set with a password.");
        }
    }

    public void setContentInfo(ContentInfo contentInfo) throws PKCS7Exception {
        if (contentInfo == null) {
            throw new PKCS7Exception("content is null.");
        }
        try {
            this.content = (ContentInfo)contentInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Unable to clone ContentInfo type");
        }
    }

    protected int getContentDERLen() throws PKCS7Exception {
        return this.a();
    }

    protected int writeContent(byte[] byArray, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Cannot write EncryptedData: output array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int n3 = this.contentASN1Template.derEncode(byArray, n2);
            this.contentASN1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode EncryptedData message: " + aSN_Exception.getMessage());
        }
    }

    private int a() throws PKCS7Exception {
        if (this.flag == 0) {
            this.b();
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.version);
            int n2 = this.info.getDERLen(0);
            byte[] byArray = new byte[n2];
            n2 = this.info.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n2);
            this.contentASN1Def = new ASN1Container[4];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer;
            this.contentASN1Def[3] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception(aSN_Exception.getMessage());
        }
    }

    private void b() throws PKCS7Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.version == -1) {
            this.version = 0;
        }
        if (this.content == null) {
            throw new PKCS7Exception("There is no content to encrypt.");
        }
        int n2 = this.content.getContentType();
        byte[] byArray = new byte[9];
        System.arraycopy(ContentInfo.a, 0, byArray, 0, 8);
        byArray[8] = (byte)n2;
        this.info.setContentType(byArray, 0, 9);
        byte[] byArray2 = null;
        try {
            int n3 = this.content.getContentInfoDERLen();
            object5 = new byte[n3];
            n3 = this.content.writeMessage((byte[])object5, 0);
            object4 = new SequenceContainer(0);
            object3 = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            object2 = new EncodedContainer(10616576);
            object = new ASN1Container[]{object4, oIDContainer, object2, object3};
            ASN1.berDecode(object5, 0, object);
            if (((ASN1Container)object2).dataPresent) {
                int n4 = 1;
                n4 += ASN1Lengths.determineLengthLen(((ASN1Container)object2).data, ((ASN1Container)object2).dataOffset + 1);
                ++n4;
                n4 += ASN1Lengths.determineLengthLen(((ASN1Container)object2).data, ((ASN1Container)object2).dataOffset + n4);
                byArray2 = new byte[((ASN1Container)object2).dataLen - n4];
                System.arraycopy(((ASN1Container)object2).data, ((ASN1Container)object2).dataOffset + n4, byArray2, 0, ((ASN1Container)object2).dataLen - n4);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: " + aSN_Exception.getMessage());
        }
        try {
            if (byArray2 == null) {
                return;
            }
            byte[] byArray3 = this.info.getEncryptionAlgorithm();
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is null; cannot get Random object.");
            }
            object5 = this.theCertJ.getRandomObject();
            object4 = this.getDeviceOrJava();
            object3 = JSAFE_SymmetricCipher.getInstance(byArray3, 0, (String)object4);
            int n5 = ((JSAFE_SymmetricCipher)object3).getOutputBufferSize(byArray2.length);
            object2 = new byte[n5];
            if (this.b == null) {
                if (this.c != null) {
                    object = ((JSAFE_SymmetricCipher)object3).getEncryptionAlgorithm();
                    this.b = JSAFE_SecretKey.getInstance((String)object, (String)object4);
                    this.b.setSecretKeyData(this.c, 0, this.c.length);
                } else {
                    if (this.d == null) {
                        throw new PKCS7Exception("Secret key is not set.");
                    }
                    this.b = ((JSAFE_SymmetricCipher)object3).getBlankKey();
                    this.b.setPassword(this.d, 0, this.d.length);
                }
            }
            ((JSAFE_SymmetricCipher)object3).encryptInit(this.b, (SecureRandom)object5);
            n5 = ((JSAFE_SymmetricCipher)object3).encryptUpdate(byArray2, 0, byArray2.length, (byte[])object2, 0);
            n5 += ((JSAFE_SymmetricCipher)object3).encryptFinal((byte[])object2, n5);
            this.info.setEncryptedContent((byte[])object2, 0, n5);
            ((JSAFE_SymmetricCipher)object3).clearSensitiveData();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new PKCS7Exception("Could not encrypt content: " + jSAFE_Exception.getMessage());
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo" + randomException.getMessage());
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo" + noServiceException.getMessage());
        }
    }

    protected boolean contentReadInit(byte[] byArray, int n2, int n3) throws PKCS7Exception {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            this.contentASN1Def = new ASN1Container[4];
            this.contentASN1Def[0] = sequenceContainer;
            this.contentASN1Def[1] = integerContainer;
            this.contentASN1Def[2] = encodedContainer;
            this.contentASN1Def[3] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(byArray, n2, n3);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.c();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    private void c() throws PKCS7Exception {
        block12: {
            try {
                byte[] byArray;
                if (this.version == -1) {
                    if (this.contentASN1Def[1].isComplete()) {
                        if (this.incompleteContainer == 1) {
                            byArray = this.copyToOutput(this.contentASN1Def[1]);
                            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
                            this.version = integerContainer.getValueAsInt();
                        } else {
                            this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                        }
                    } else {
                        if (this.contentASN1Def[1].data == null) {
                            return;
                        }
                        this.incompleteContainer = 1;
                        this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                        return;
                    }
                }
                if (this.contentASN1Def[2].isComplete()) {
                    if (this.incompleteContainer == 2) {
                        byArray = this.copyToOutput(this.contentASN1Def[2]);
                        this.a(byArray, 0, byArray.length);
                    } else {
                        this.a(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen);
                    }
                    break block12;
                }
                if (this.contentASN1Def[2].data == null) {
                    return;
                }
                this.incompleteContainer = 2;
                this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, this.maxBufferSize);
                return;
            }
            catch (Exception exception) {
                throw new PKCS7Exception("Cannot set decoded values." + exception.getMessage());
            }
        }
    }

    private void a(byte[] byArray, int n2, int n3) throws PKCS7Exception {
        if (byArray == null || n3 == 0) {
            throw new PKCS7Exception("Cannot decode content: data is null.");
        }
        try {
            this.info = new EncryptedContentInfo(byArray, n2, 0, this.maxBufferSize);
            byte[] byArray2 = this.info.getEncryptionAlgorithm();
            byte[] byArray3 = this.info.getContentType();
            this.content = ContentInfo.getInstance(byArray3, 0, 9, this.theCertJ, this.theCertPathCtx);
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is null; cannot get Random object.");
            }
            JSAFE_SecureRandom jSAFE_SecureRandom = this.theCertJ.getRandomObject();
            byte[] byArray4 = this.info.getEncryptedContent();
            if (byArray4 == null) {
                return;
            }
            String string = this.getDeviceOrJava();
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(byArray2, 0, string);
            int n4 = jSAFE_SymmetricCipher.getOutputBufferSize(byArray4.length);
            byte[] byArray5 = new byte[n4];
            if (this.b == null) {
                if (this.c != null) {
                    String string2 = jSAFE_SymmetricCipher.getEncryptionAlgorithm();
                    this.b = JSAFE_SecretKey.getInstance(string2, string);
                    this.b.setSecretKeyData(this.c, 0, this.c.length);
                } else {
                    if (this.d == null) {
                        throw new PKCS7Exception("Secret key is not set.");
                    }
                    this.b = jSAFE_SymmetricCipher.getBlankKey();
                    this.b.setPassword(this.d, 0, this.d.length);
                }
            }
            jSAFE_SymmetricCipher.decryptInit(this.b, jSAFE_SecureRandom);
            n4 = jSAFE_SymmetricCipher.decryptUpdate(byArray4, 0, byArray4.length, byArray5, 0);
            n4 += jSAFE_SymmetricCipher.decryptFinal(byArray5, n4);
            jSAFE_SymmetricCipher.clearSensitiveData();
            int n5 = n4 + 1 + ASN1Lengths.getLengthLen(n4);
            byte[] byArray6 = new byte[n5];
            byArray6[0] = byArray3[8] == 1 ? 4 : 48;
            n5 = 1 + ASN1Lengths.writeLength(byArray6, 1, n4);
            System.arraycopy(byArray5, 0, byArray6, n5, n4);
            int n6 = byArray6.length + 1 + ASN1Lengths.getLengthLen(byArray6.length);
            byte[] byArray7 = new byte[n6];
            byArray7[0] = -96;
            n6 = 1 + ASN1Lengths.writeLength(byArray7, 1, byArray6.length);
            System.arraycopy(byArray6, 0, byArray7, n6, byArray6.length);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray3, 0, byArray3.length);
            EncodedContainer encodedContainer = new EncodedContainer(10616576, true, 0, byArray7, 0, byArray7.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n7 = aSN1Template.derEncodeInit();
            byte[] byArray8 = new byte[n7];
            aSN1Template.derEncode(byArray8, 0);
            if (this.content.readInit(byArray8, 0, n7, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception exception) {
            throw new PKCS7Exception("Cannot decode content." + exception.getMessage());
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    protected int contentReadUpdate(byte[] byArray, int n2, int n3) throws PKCS7Exception {
        int n4 = 0;
        if (byArray == null) {
            return n4;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return n4;
            }
            n4 = this.contentASN1Template.berDecodeUpdate(byArray, n2, n3);
            this.c();
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Could not decode message: " + aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EncryptedData encryptedData = (EncryptedData)super.clone();
        if (this.b != null) {
            encryptedData.b = (JSAFE_SecretKey)this.b.clone();
        }
        encryptedData.version = this.version;
        if (this.info != null) {
            encryptedData.info = (EncryptedContentInfo)this.info.clone();
        }
        encryptedData.a = this.a;
        if (this.d != null) {
            encryptedData.d = new char[this.d.length];
            System.arraycopy(this.d, 0, encryptedData.d, 0, this.d.length);
        }
        if (this.e != null) {
            encryptedData.e = new byte[this.e.length];
            System.arraycopy(this.e, 0, encryptedData.e, 0, this.e.length);
        }
        if (this.f != null) {
            encryptedData.f = new byte[this.f.length];
            System.arraycopy(this.f, 0, encryptedData.f, 0, this.f.length);
        }
        return encryptedData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null || !(object instanceof EncryptedData)) {
            return false;
        }
        EncryptedData encryptedData = (EncryptedData)object;
        if (this.version != encryptedData.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(encryptedData.content)) {
            return false;
        }
        if (this.e != null && encryptedData.e != null && !CertJUtils.byteArraysEqual(this.e, encryptedData.e)) {
            return false;
        }
        if (this.f != null && encryptedData.f != null && !CertJUtils.byteArraysEqual(this.f, encryptedData.f)) {
            return false;
        }
        if (this.info != null ? !this.info.equals(encryptedData.info) : encryptedData.info != null) {
            return false;
        }
        if (this.d != null) {
            if (encryptedData.d == null) return false;
            if (this.d.length != encryptedData.d.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                if (this.d[i2] == encryptedData.d[i2]) continue;
                return false;
            }
        } else if (encryptedData.d != null) {
            return false;
        }
        if (this.b != null) {
            byte[] byArray;
            if (encryptedData.b == null) return false;
            if (!this.b.getAlgorithm().equals(encryptedData.b.getAlgorithm())) {
                return false;
            }
            byte[] byArray2 = this.b.getSecretKeyData();
            if (CertJUtils.byteArraysEqual(byArray2, byArray = encryptedData.b.getSecretKeyData())) return true;
            return false;
        }
        if (encryptedData.b == null) return true;
        return false;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.b != null) {
            this.b.clearSensitiveData();
        }
        this.version = -1;
        this.info = new EncryptedContentInfo();
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

