/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.OldCertID;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import java.util.Vector;

public final class CMPRevokeResponseMessage
extends CMPResponseCommon {
    private Vector a = new Vector();
    private Vector b = new Vector();
    private X509CRL[] c = null;

    private CMPRevokeResponseMessage(PKIHeader pKIHeader) {
        super(12, pKIHeader, null);
    }

    protected static CMPRevokeResponseMessage berDecodeBody(PKIHeader pKIHeader, byte[] byArray, int n2) throws CMPException {
        CMPRevokeResponseMessage cMPRevokeResponseMessage = new CMPRevokeResponseMessage(pKIHeader);
        cMPRevokeResponseMessage.a(byArray, n2, 10551308);
        return cMPRevokeResponseMessage;
    }

    public X509CRL[] getCRLs() {
        return this.c;
    }

    public int getStatusCount() {
        return this.a.size();
    }

    public PKIStatusInfo getStatusAt(int n2) throws CMPException {
        if (n2 >= this.a.size()) {
            throw new CMPException("CMPrevokeResponseMessage.getStatusAt: index out of range.");
        }
        return (PKIStatusInfo)this.a.elementAt(n2);
    }

    public OldCertID getCertIdAt(int n2) throws CMPException {
        if (n2 >= this.a.size()) {
            throw new CMPException("CMPrevokeResponseMessage.getCertIdAt: index out of range.");
        }
        return (OldCertID)this.b.elementAt(n2);
    }

    private void a(byte[] byArray, int n2, int n3) throws CMPException {
        ASN1Container aSN1Container;
        int n4;
        OfContainer ofContainer = null;
        OfContainer ofContainer2 = null;
        OfContainer ofContainer3 = null;
        try {
            ofContainer = new OfContainer(0, 12288, new EncodedContainer(12288));
            ofContainer2 = new OfContainer(0xA10000, 12288, new EncodedContainer(12288));
            ofContainer3 = new OfContainer(0xA10001, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{new SequenceContainer(n3), ofContainer, ofContainer2, ofContainer3, new EndContainer()};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRevokeResponseMessage.berDecode: decoding RevRepContent faild(" + aSN_Exception.getMessage() + ").");
        }
        int n5 = ofContainer.getContainerCount();
        int n6 = 0;
        if (ofContainer2.dataPresent) {
            n6 = ofContainer2.getContainerCount();
        }
        if (n6 != 0 && n5 < n6) {
            throw new CMPException("CMPRevokeResponseMessage.berDecode: more revCerts items than stauts items in RevRepContent.");
        }
        for (n4 = 0; n4 < n5; ++n4) {
            PKIStatusInfo pKIStatusInfo;
            ASN1Container aSN1Container2 = null;
            aSN1Container = null;
            try {
                aSN1Container2 = ofContainer.containerAt(n4);
                if (ofContainer2.dataPresent && n4 < n6) {
                    aSN1Container = ofContainer2.containerAt(n4);
                }
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to extract OfContainer component(" + aSN_Exception.getMessage() + ").");
            }
            try {
                pKIStatusInfo = new PKIStatusInfo(aSN1Container2.data, aSN1Container2.dataOffset, 0);
            }
            catch (PKIException pKIException) {
                throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to instantiate PKIStatusInfo(" + pKIException.getMessage() + ").");
            }
            OldCertID oldCertID = null;
            if (aSN1Container != null) {
                try {
                    oldCertID = new OldCertID();
                    oldCertID.decodeValue(aSN1Container.data, aSN1Container.dataOffset);
                }
                catch (CRMFException cRMFException) {
                    throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to decode CertId(" + cRMFException.getMessage() + ").");
                }
            }
            this.a(pKIStatusInfo, oldCertID);
        }
        if (ofContainer3.dataPresent) {
            n4 = ofContainer3.getContainerCount();
            this.c = new X509CRL[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                try {
                    aSN1Container = ofContainer3.containerAt(i2);
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to get OfContainer component(" + aSN_Exception.getMessage() + ").");
                }
                try {
                    this.c[i2] = new X509CRL(aSN1Container.data, aSN1Container.dataOffset, 0);
                    continue;
                }
                catch (CertificateException certificateException) {
                    throw new CMPException("CMPRevokeResponseMessage.berDecode: unable to decode CRL(" + certificateException.getMessage() + ").");
                }
            }
        }
    }

    private void a(PKIStatusInfo pKIStatusInfo, OldCertID oldCertID) throws CMPException {
        if (pKIStatusInfo == null) {
            throw new CMPException("CMPrevokeResponseMessage.addOneStatus: status should not be null.");
        }
        this.a.addElement(pKIStatusInfo);
        this.b.addElement(oldCertID);
    }
}

