/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Name;
import adobe.abc.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symtab<E> {
    private HashMap<String, ArrayList<Pair<Name, E>>> m_nameValueMap = new HashMap();
    private ArrayList<E> m_valueList = new ArrayList();

    private Pair<Name, E> getEntry(Name n2) {
        List namelist = this.m_nameValueMap.get(n2.name);
        if (namelist != null) {
            for (Pair p2 : namelist) {
                if (!n2.match((Name)p2.fst)) continue;
                return p2;
            }
        }
        return null;
    }

    E get(Name n2) {
        Pair<Name, E> entry = this.getEntry(n2);
        return entry == null ? null : (E)entry.snd;
    }

    Name getName(Name n2) {
        Pair<Name, E> entry = this.getEntry(n2);
        return entry == null ? null : (Name)entry.fst;
    }

    boolean contains(Name n2) {
        return n2 != null && this.get(n2) != null;
    }

    void put(Name n2, E e2) {
        n2 = Name.getVersionedName(n2);
        assert (n2.nsset.length == 1);
        ArrayList<Pair<Name, Pair<Name, Object>>> namelist = this.m_nameValueMap.get(n2.name);
        if (namelist == null) {
            namelist = new ArrayList();
            this.m_nameValueMap.put(n2.name, namelist);
        }
        namelist.add(new Pair<Name, E>(n2, e2));
        this.m_valueList.add(e2);
    }

    public String toString() {
        StringBuilder b3 = new StringBuilder();
        b3.append('[');
        for (Map.Entry<String, ArrayList<Pair<Name, E>>> namelist : this.m_nameValueMap.entrySet()) {
            if (namelist.getValue() == null) continue;
            for (Pair<Name, E> p2 : namelist.getValue()) {
                b3.append(p2.fst).append('=').append(p2.snd);
                b3.append(", ");
            }
        }
        b3.append(']');
        return b3.toString();
    }

    public Collection<E> values() {
        return this.m_valueList;
    }

    int size() {
        return this.m_valueList.size();
    }
}

