/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.apk.AndroidManifestXMLParser;
import com.adobe.air.apk.OrderManifestHandler;
import com.adobe.air.apk.StringPoolHandler;
import java.io.ByteArrayOutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class OutputHandler
extends DefaultHandler {
    static ByteArrayOutputStream mOut;
    static ByteArrayOutputStream mOutStringPoolStrings;
    static ByteArrayOutputStream mOutStringPoolHeader;
    static RandomAccessFile mOutputFile;
    static int mStringPoolMapResSize;
    private Listener mListener;
    private String mDescriptorFileName;
    private static Locator documentLocator;
    namespaceExt nsExt = new namespaceExt();

    public OutputHandler(Listener listener, String descriptorFile) {
        this.mListener = listener;
        this.mDescriptorFileName = descriptorFile;
    }

    public void setDocumentLocator(Locator locator) {
        documentLocator = locator;
    }

    public void startDocument() throws SAXException {
        mOut = new ByteArrayOutputStream();
        mStringPoolMapResSize = StringPoolHandler.mStringPoolMapRes.size();
    }

    public void endDocument() throws SAXException {
        stringPool_header sPool = new stringPool_header();
        sPool.header.type = this.short_little_endian((short)1);
        sPool.header.headerSize = this.short_little_endian((short)28);
        int stringPoolMapSize = StringPoolHandler.mStringPoolMapNonRes.size() + mStringPoolMapResSize;
        sPool.stringCount = this.int_little_endian(stringPoolMapSize);
        sPool.stringStart = this.int_little_endian(28 + 4 * stringPoolMapSize);
        Iterator<String> iterator = StringPoolHandler.mStringPoolMapRes.keySet().iterator();
        Iterator<Integer> iterator1 = StringPoolHandler.mStringPoolMapRes.values().iterator();
        mOutStringPoolStrings = new ByteArrayOutputStream();
        int totalSize = 0;
        int[] IndexArr = new int[stringPoolMapSize];
        int i2 = 1;
        String[] orderedStrings = new String[stringPoolMapSize];
        while (iterator.hasNext()) {
            orderedStrings[iterator1.next().intValue()] = iterator.next();
        }
        iterator = StringPoolHandler.mStringPoolMapNonRes.keySet().iterator();
        iterator1 = StringPoolHandler.mStringPoolMapNonRes.values().iterator();
        while (iterator.hasNext()) {
            orderedStrings[iterator1.next().intValue() + OutputHandler.mStringPoolMapResSize] = iterator.next();
        }
        IndexArr[0] = 0;
        for (int k2 = 0; k2 < stringPoolMapSize; ++k2) {
            String temp = orderedStrings[k2];
            totalSize += 2 + 2 * temp.length() + 2;
            try {
                mOutStringPoolStrings.write(this.shortToByteArray(this.short_little_endian((short)temp.length())));
                mOutStringPoolStrings.write(this.stringToByteArrayLittleEndian(temp));
                mOutStringPoolStrings.write(this.shortToByteArray((short)0));
            }
            catch (Exception ex) {
                throw new SAXException(ex.getMessage());
            }
            if (i2 < stringPoolMapSize) {
                IndexArr[i2] = IndexArr[i2 - 1] + 4 + 2 * temp.length();
            }
            ++i2;
        }
        int sPoolTotalSize = 28 + 4 * stringPoolMapSize + totalSize;
        if (((sPoolTotalSize | 0x1C) & 3) != 0) {
            totalSize += 2;
            try {
                mOutStringPoolStrings.write(this.shortToByteArray((short)0));
            }
            catch (Exception ex) {
                throw new SAXException(ex.getMessage());
            }
        }
        sPool.header.totalSize = this.int_little_endian(28 + 4 * stringPoolMapSize + totalSize);
        mOutStringPoolHeader = new ByteArrayOutputStream();
        try {
            mOutStringPoolHeader.write(this.shortToByteArray(sPool.header.type));
            mOutStringPoolHeader.write(this.shortToByteArray(sPool.header.headerSize));
            mOutStringPoolHeader.write(this.intToByteArray(sPool.header.totalSize));
            mOutStringPoolHeader.write(this.intToByteArray(sPool.stringCount));
            mOutStringPoolHeader.write(this.intToByteArray(sPool.styleCount));
            mOutStringPoolHeader.write(this.intToByteArray(sPool.flags));
            mOutStringPoolHeader.write(this.intToByteArray(sPool.stringStart));
            mOutStringPoolHeader.write(this.intToByteArray(sPool.styleStart));
            for (i2 = 0; i2 < stringPoolMapSize; ++i2) {
                mOutStringPoolHeader.write(this.intToByteArray(this.int_little_endian(IndexArr[i2])));
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
        chunk_header resourceMapHeader = new chunk_header();
        resourceMapHeader.type = this.short_little_endian((short)384);
        resourceMapHeader.headerSize = this.short_little_endian((short)8);
        resourceMapHeader.totalSize = this.int_little_endian(8 + 4 * mStringPoolMapResSize);
        try {
            mOutStringPoolStrings.write(this.shortToByteArray(resourceMapHeader.type));
            mOutStringPoolStrings.write(this.shortToByteArray(resourceMapHeader.headerSize));
            mOutStringPoolStrings.write(this.intToByteArray(resourceMapHeader.totalSize));
            for (i2 = 0; i2 < mStringPoolMapResSize; ++i2) {
                Integer val = OrderManifestHandler.mResourceMap.get(orderedStrings[i2]);
                if (val == null) {
                    this.mListener.message(new Message(400, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{orderedStrings[i2]}));
                    continue;
                }
                mOutStringPoolStrings.write(this.intToByteArray(this.int_little_endian(val)));
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
        try {
            this.outputData();
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attrs) throws SAXException {
        node sElement = new node();
        sElement.header.type = this.short_little_endian((short)258);
        sElement.header.headerSize = this.short_little_endian((short)16);
        sElement.header.totalSize = this.int_little_endian(36 + 20 * attrs.getLength());
        sElement.lineNumber = this.int_little_endian(documentLocator.getLineNumber());
        sElement.comment.index = -1;
        attrExt sElementAttr = new attrExt();
        sElementAttr.ns.index = uri.equals("") ? -1 : this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(uri) + mStringPoolMapResSize);
        sElementAttr.name.index = this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(rawName) + mStringPoolMapResSize);
        sElementAttr.attributeCount = this.short_little_endian((short)attrs.getLength());
        try {
            mOut.write(this.shortToByteArray(sElement.header.type));
            mOut.write(this.shortToByteArray(sElement.header.headerSize));
            mOut.write(this.intToByteArray(sElement.header.totalSize));
            mOut.write(this.intToByteArray(sElement.lineNumber));
            mOut.write(this.intToByteArray(sElement.comment.index));
            mOut.write(this.intToByteArray(sElementAttr.ns.index));
            mOut.write(this.intToByteArray(sElementAttr.name.index));
            mOut.write(this.shortToByteArray(this.short_little_endian(sElementAttr.attributeStart)));
            mOut.write(this.shortToByteArray(this.short_little_endian(sElementAttr.attributeSize)));
            mOut.write(this.shortToByteArray(sElementAttr.attributeCount));
            mOut.write(this.shortToByteArray(sElementAttr.idIndex));
            mOut.write(this.shortToByteArray(sElementAttr.classIndex));
            mOut.write(this.shortToByteArray(sElementAttr.styleIndex));
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            attribute att = new attribute();
            att.ns.index = attrs.getURI(i2).equals("") ? -1 : this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(attrs.getURI(i2)) + mStringPoolMapResSize);
            String name = attrs.getLocalName(i2);
            String format = StringPoolHandler.mAttributeFormat.get(name);
            if (name.equals("package")) {
                att.name.index = this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(name) + mStringPoolMapResSize);
                format = "string";
            } else {
                att.name.index = this.int_little_endian(StringPoolHandler.mStringPoolMapRes.get(name));
            }
            String value = attrs.getValue(i2);
            if (format.contains("|")) {
                if (StringPoolHandler.isFloat(format, value)) {
                    format = "float";
                } else if (StringPoolHandler.isInteger(format, value)) {
                    format = "integer";
                } else if (StringPoolHandler.isBoolean(format, value)) {
                    format = "boolean";
                } else if (StringPoolHandler.isReference(format, value)) {
                    format = "reference";
                } else if (StringPoolHandler.isColor(format, value)) {
                    format = "color";
                } else if (StringPoolHandler.isString(format, value)) {
                    format = "string";
                } else if (StringPoolHandler.isConstant(format, value)) {
                    format = "constant";
                } else {
                    throw new SAXException("Value " + value + " does not match with any of the supported formats");
                }
            }
            if (format.equals("constant")) {
                att.value.dataType = (byte)16;
                att.rawValue.index = -1;
                String[] a = value.split("\\|");
                int intValue = 0;
                for (int j2 = 0; j2 < a.length; ++j2) {
                    Integer val = StringPoolHandler.mAttributeConstantValue.get(name + "_" + a[j2]);
                    if (val == null) {
                        this.mListener.message(new Message(401, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{a[j2]}));
                        continue;
                    }
                    intValue |= val.intValue();
                }
                att.value.data = this.int_little_endian(intValue);
            } else if (format.equals("boolean")) {
                att.value.dataType = (byte)18;
                att.value.data = value.equals("true") ? -1 : 0;
                att.rawValue.index = -1;
            } else if (format.equals("reference")) {
                att.value.dataType = 1;
                att.value.data = this.int_little_endian(StringPoolHandler.mAttributeRefValue.get(value.substring(1)));
                att.rawValue.index = -1;
            } else if (format.equals("integer")) {
                att.value.dataType = (byte)16;
                att.value.data = name.equals("versionCode") ? this.int_little_endian(Integer.parseInt(AndroidManifestXMLParser.mAppVersionCode)) : this.int_little_endian(Integer.parseInt(value));
                att.rawValue.index = -1;
            } else if (format.equals("color")) {
                int length = value.length();
                if (length == 4) {
                    att.value.dataType = (byte)31;
                } else if (length == 5) {
                    att.value.dataType = (byte)30;
                } else if (length == 7) {
                    att.value.dataType = (byte)29;
                } else if (length == 9) {
                    att.value.dataType = (byte)28;
                } else {
                    throw new SAXException("Color value for attribute " + name + " is incorrect");
                }
                try {
                    att.value.data = this.int_little_endian(this.color_to_int(value.substring(1), length - 1));
                }
                catch (Exception e2) {
                    throw new SAXException(e2.getMessage());
                }
                att.rawValue.index = -1;
            } else if (format.equals("float")) {
                att.value.dataType = (byte)4;
                att.value.data = this.int_little_endian(Float.floatToIntBits(Float.parseFloat(value)));
                att.rawValue.index = -1;
            } else if (format.equals("string")) {
                att.value.dataType = (byte)3;
                att.rawValue.index = name.equals("package") ? this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(AndroidManifestXMLParser.mPackageName) + mStringPoolMapResSize) : (name.equals("label") && value.equals("AppEntry") ? this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(AndroidManifestXMLParser.mAppName) + mStringPoolMapResSize) : (name.equals("versionName") ? this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(AndroidManifestXMLParser.mAppVersionName) + mStringPoolMapResSize) : this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(value) + mStringPoolMapResSize)));
                att.value.data = att.rawValue.index;
            } else {
                throw new SAXException("The format of attribute " + name + " is not supported");
            }
            try {
                mOut.write(this.intToByteArray(att.ns.index));
                mOut.write(this.intToByteArray(att.name.index));
                mOut.write(this.intToByteArray(att.rawValue.index));
                mOut.write(this.shortToByteArray(this.short_little_endian(att.value.size)));
                mOut.write(att.value.res0);
                mOut.write(att.value.dataType);
                mOut.write(this.intToByteArray(att.value.data));
                continue;
            }
            catch (Exception ex) {
                throw new SAXException(ex.getMessage());
            }
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        node eElement = new node();
        eElement.header.type = this.short_little_endian((short)259);
        eElement.header.headerSize = this.short_little_endian((short)16);
        eElement.header.totalSize = this.int_little_endian(24);
        eElement.lineNumber = this.int_little_endian(documentLocator.getLineNumber());
        eElement.comment.index = -1;
        endElementExt eElementExt = new endElementExt();
        eElementExt.ns.index = uri.equals("") ? -1 : this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(uri) + mStringPoolMapResSize);
        eElementExt.name.index = this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(rawName) + mStringPoolMapResSize);
        try {
            mOut.write(this.shortToByteArray(eElement.header.type));
            mOut.write(this.shortToByteArray(eElement.header.headerSize));
            mOut.write(this.intToByteArray(eElement.header.totalSize));
            mOut.write(this.intToByteArray(eElement.lineNumber));
            mOut.write(this.intToByteArray(eElement.comment.index));
            mOut.write(this.intToByteArray(eElementExt.ns.index));
            mOut.write(this.intToByteArray(eElementExt.name.index));
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        node nsElement = new node();
        nsElement.header.type = this.short_little_endian((short)256);
        nsElement.header.headerSize = this.short_little_endian((short)16);
        nsElement.header.totalSize = this.int_little_endian(24);
        nsElement.lineNumber = this.int_little_endian(documentLocator.getLineNumber());
        nsElement.comment.index = -1;
        this.nsExt.prefix.index = this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(prefix) + mStringPoolMapResSize);
        this.nsExt.uri.index = this.int_little_endian(StringPoolHandler.mStringPoolMapNonRes.get(uri) + mStringPoolMapResSize);
        try {
            mOut.write(this.shortToByteArray(nsElement.header.type));
            mOut.write(this.shortToByteArray(nsElement.header.headerSize));
            mOut.write(this.intToByteArray(nsElement.header.totalSize));
            mOut.write(this.intToByteArray(nsElement.lineNumber));
            mOut.write(this.intToByteArray(nsElement.comment.index));
            mOut.write(this.intToByteArray(this.nsExt.prefix.index));
            mOut.write(this.intToByteArray(this.nsExt.uri.index));
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        node endnsElement = new node();
        endnsElement.header.type = this.short_little_endian((short)257);
        endnsElement.header.headerSize = this.short_little_endian((short)16);
        endnsElement.header.totalSize = this.int_little_endian(24);
        endnsElement.lineNumber = this.int_little_endian(documentLocator.getLineNumber());
        endnsElement.comment.index = -1;
        try {
            mOut.write(this.shortToByteArray(endnsElement.header.type));
            mOut.write(this.shortToByteArray(endnsElement.header.headerSize));
            mOut.write(this.intToByteArray(endnsElement.header.totalSize));
            mOut.write(this.intToByteArray(endnsElement.lineNumber));
            mOut.write(this.intToByteArray(endnsElement.comment.index));
            mOut.write(this.intToByteArray(this.nsExt.prefix.index));
            mOut.write(this.intToByteArray(this.nsExt.uri.index));
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    private void outputData() throws Exception {
        chunk_header fileHeader = new chunk_header();
        fileHeader.type = this.short_little_endian((short)3);
        fileHeader.headerSize = this.short_little_endian((short)8);
        byte[] Array1 = mOutStringPoolHeader.toByteArray();
        byte[] Array2 = mOutStringPoolStrings.toByteArray();
        byte[] Array3 = mOut.toByteArray();
        fileHeader.totalSize = this.int_little_endian(8 + Array1.length + Array2.length + Array3.length);
        mOutputFile = new RandomAccessFile(AndroidManifestXMLParser.mOutputFilePath, "rw");
        mOutputFile.write(this.shortToByteArray(fileHeader.type));
        mOutputFile.write(this.shortToByteArray(fileHeader.headerSize));
        mOutputFile.write(this.intToByteArray(fileHeader.totalSize));
        mOutputFile.write(Array1);
        mOutputFile.write(Array2);
        mOutputFile.write(Array3);
        mOutputFile.close();
    }

    private int int_little_endian(int v2) {
        return v2 << 24 | v2 << 8 & 0xFF0000 | v2 >>> 8 & 0xFF00 | v2 >>> 24;
    }

    private short short_little_endian(short a) {
        short b3 = (short)(a << 8);
        short c2 = (short)(a >>> 8);
        return (short)(b3 | c2);
    }

    private int color_to_int(String a, int length) throws Exception {
        char[] result = new char[8];
        if (length == 3) {
            result[0] = 102;
            result[1] = 102;
            result[2] = a.charAt(0);
            result[3] = a.charAt(0);
            result[4] = a.charAt(1);
            result[5] = a.charAt(1);
            result[6] = a.charAt(2);
            result[7] = a.charAt(2);
        }
        if (length == 4) {
            result[0] = a.charAt(0);
            result[1] = a.charAt(0);
            result[2] = a.charAt(1);
            result[3] = a.charAt(1);
            result[4] = a.charAt(2);
            result[5] = a.charAt(2);
            result[6] = a.charAt(3);
            result[7] = a.charAt(3);
        }
        if (length == 6) {
            result[0] = 102;
            result[1] = 102;
            result[2] = a.charAt(0);
            result[3] = a.charAt(1);
            result[4] = a.charAt(2);
            result[5] = a.charAt(3);
            result[6] = a.charAt(4);
            result[7] = a.charAt(5);
        }
        try {
            if (length == 8) {
                return Integer.parseInt(a, 16);
            }
            return Integer.parseInt(new String(result), 16);
        }
        catch (NumberFormatException e2) {
            throw new Exception("Color value " + a + " is invalid");
        }
    }

    private byte[] intToByteArray(int a) {
        return new byte[]{(byte)(a >>> 24), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    private byte[] shortToByteArray(short a) {
        return new byte[]{(byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    private byte[] stringToByteArrayLittleEndian(String s2) throws Exception {
        return s2.getBytes("UTF-16LE");
    }

    private class attribute {
        stringPool_ref ns;
        stringPool_ref name;
        stringPool_ref rawValue;
        attr_value value;

        attribute() {
            this.ns = new stringPool_ref();
            this.name = new stringPool_ref();
            this.rawValue = new stringPool_ref();
            this.value = new attr_value();
        }
    }

    private class attr_value {
        short size = (short)8;
        byte res0 = 0;
        byte dataType;
        int data;

        private attr_value() {
        }
    }

    private class endElementExt {
        stringPool_ref ns;
        stringPool_ref name;

        endElementExt() {
            this.ns = new stringPool_ref();
            this.name = new stringPool_ref();
        }
    }

    private class attrExt {
        stringPool_ref ns;
        stringPool_ref name;
        short attributeStart = (short)20;
        short attributeSize = (short)20;
        short attributeCount;
        short idIndex = 0;
        short classIndex = 0;
        short styleIndex = 0;

        attrExt() {
            this.ns = new stringPool_ref();
            this.name = new stringPool_ref();
        }
    }

    private class namespaceExt {
        stringPool_ref prefix;
        stringPool_ref uri;

        namespaceExt() {
            this.prefix = new stringPool_ref();
            this.uri = new stringPool_ref();
        }
    }

    private class node {
        chunk_header header;
        int lineNumber;
        stringPool_ref comment;

        node() {
            this.comment = new stringPool_ref();
            this.header = new chunk_header();
        }
    }

    private class stringPool_ref {
        int index;

        private stringPool_ref() {
        }
    }

    private class stringPool_header {
        chunk_header header;
        int stringCount;
        int styleCount = 0;
        int flags = 0;
        int stringStart;
        int styleStart = 0;

        stringPool_header() {
            this.header = new chunk_header();
        }
    }

    private class chunk_header {
        short type;
        short headerSize;
        int totalSize;

        private chunk_header() {
        }
    }
}

