/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ipa.ResponseFileParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public final class ResponseFileDatabase {
    private final File m_dir;
    private static ResponseFileDatabase m_inst = null;

    private ResponseFileDatabase(File dir) {
        this.m_dir = dir;
    }

    public static String[] getArgumentsForAppId(String appId) {
        if (m_inst == null) {
            m_inst = ResponseFileDatabase.create();
        }
        return m_inst.getArgumentsForAppIdImpl(appId);
    }

    private String[] getArgumentsForAppIdImpl(String appId) {
        if (this.m_dir != null) {
            File rspFileName = new File(this.m_dir, appId + ".rsp");
            try {
                FileInputStream rspFileStream = new FileInputStream(rspFileName);
                BufferedReader rspFileReader = new BufferedReader(new InputStreamReader(rspFileStream));
                return ResponseFileParser.parse(rspFileReader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static ResponseFileDatabase create() {
        File responseFileDatabaseDir = null;
        String responseFileDatabaseDirName = System.getenv("X_ADOBE_PFI_RESPONSES");
        if (!(responseFileDatabaseDirName == null || (responseFileDatabaseDir = new File(responseFileDatabaseDirName)).isAbsolute() && responseFileDatabaseDir.isDirectory())) {
            responseFileDatabaseDir = null;
        }
        return new ResponseFileDatabase(responseFileDatabaseDir);
    }
}

