/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.Packager;
import com.adobe.ucf.UCFOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class UCFPackager
extends Packager {
    private SortedMap<String, File> m_metaInfSources = new TreeMap<String, File>(String.CASE_INSENSITIVE_ORDER);
    private String m_metaInfNamespace;

    public UCFPackager() {
        this.setStream(new UCFOutputStream());
    }

    public void setMetaInfNamespace(String namespace) {
        if (this.m_metaInfNamespace != null) {
            throw new IllegalStateException("META-INF namespace already set");
        }
        this.m_metaInfNamespace = namespace;
    }

    public void addMetaInfSourceWithRoot(File source, File root) {
        String path = root.toURI().relativize(source.toURI()).getPath();
        this.addMetaInfSourceWithPath(source, path);
    }

    public void addMetaInfSourceWithPath(File source, String path) {
        if (!source.isFile()) {
            throw new IllegalArgumentException("File does not exist: " + source.getPath());
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("absolute path");
        }
        if (this.m_metaInfSources.containsKey(path)) {
            File other = (File)this.m_metaInfSources.get(path);
            throw new IllegalArgumentException("Files \"" + other.getPath() + "\" and \"" + source.getPath() + "\" have conflicting package paths");
        }
        this.m_metaInfSources.put(path, source);
    }

    public void createPackage() throws Exception {
        String path;
        File file;
        this.getStream().addMimeTypeFile("application/vnd.adobe.air-ucf-package+zip", true);
        for (Map.Entry<String, File> e2 : this.m_metaInfSources.entrySet()) {
            file = e2.getValue();
            path = e2.getKey();
            this.getStream().addFile(file, "META-INF/" + this.m_metaInfNamespace + "/" + path, true);
        }
        for (Map.Entry<String, File> e2 : this.getSources().entrySet()) {
            file = e2.getValue();
            path = e2.getKey();
            this.getStream().addFile(file, path, true);
        }
        this.getStream().finalizeSig();
        this.getStream().close();
        this.renameOutput();
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("ucf");
    }
}

