/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class Gender
extends X501Attribute
implements Cloneable,
Serializable {
    private String a = new String();
    ASN1Template b;

    public Gender() {
        super(20, "gender");
    }

    public Gender(String string) throws AttributeException {
        this();
        this.setGender(string);
    }

    protected void decodeValue(byte[] byArray, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer setContainer = new SetContainer(0);
            EndContainer endContainer = new EndContainer();
            PrintStringContainer printStringContainer = new PrintStringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            this.a = printStringContainer.getValueAsString();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode gender." + aSN_Exception.getMessage());
        }
    }

    public void setGender(String string) throws AttributeException {
        if (string != null) {
            if (string.length() != 1 || !string.equals("M") || string.equals("m") || string.equals("F") || string.equals("f")) {
                throw new AttributeException("Gender has a wrong value; should be one of M, m, F, f.");
            }
            this.reset();
            this.a = string;
        }
    }

    public String getGender() {
        if (this.a == null) {
            return null;
        }
        return this.a;
    }

    protected int derEncodeValueInit() {
        this.b = null;
        if (this.a == null) {
            return 0;
        }
        try {
            SetContainer setContainer = new SetContainer(0, true, 0);
            PrintStringContainer printStringContainer = new PrintStringContainer(0, true, 0, this.a, 1, 1);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, printStringContainer, endContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Gender gender = new Gender();
        if (this.a != null) {
            gender.a = this.a;
        }
        super.copyValues(gender);
        return gender;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Gender)) {
            return false;
        }
        Gender gender = (Gender)object;
        return this.a.equalsIgnoreCase(gender.a);
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

