/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class CertificateIssuer
extends X509V3Extension
implements Cloneable,
Serializable,
CRLEntryExtension,
OCSPSingleExtension {
    private GeneralNames a = null;

    public CertificateIssuer() {
        this.extensionTypeFlag = 29;
        this.criticality = false;
        this.setStandardOID(29);
        this.extensionTypeString = "CertificateIssuer";
    }

    public CertificateIssuer(GeneralNames generalNames, boolean bl2) {
        this.extensionTypeFlag = 29;
        this.criticality = bl2;
        if (generalNames != null) {
            this.a = generalNames;
        }
        this.setStandardOID(29);
        this.extensionTypeString = "CertificateIssuer";
    }

    public void setGeneralNames(GeneralNames generalNames) {
        try {
            if (generalNames != null) {
                this.a = (GeneralNames)generalNames.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public GeneralNames getGeneralNames() {
        return this.a;
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.a = new GeneralNames(byArray, n2, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode CertificateIssuer extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            return this.a.getDERLen(this.special);
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (this.a == null) {
            return 0;
        }
        if (byArray == null) {
            return 0;
        }
        try {
            int n3 = this.a.getDEREncoding(byArray, n2, 0);
            return n3;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CertificateIssuer certificateIssuer = new CertificateIssuer();
        if (this.a != null) {
            certificateIssuer.a = (GeneralNames)this.a.clone();
        }
        super.copyValues(certificateIssuer);
        return certificateIssuer;
    }

    protected void reset() {
        super.reset();
        this.a = null;
    }
}

