/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class ProtocolEncryptionKey
extends Control
implements Cloneable,
Serializable {
    private byte[] a;
    ASN1Template b;
    private int c = 0;

    public ProtocolEncryptionKey() {
        this.controlTypeFlag = 5;
        ((Control)this).a = new byte[Control.OID_LIST[5].length];
        System.arraycopy(Control.OID_LIST[5], 0, ((Control)this).a, 0, ((Control)this).a.length);
        this.controlTypeString = "ProtocolEncryptionKey";
    }

    protected void decodeValue(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("ProtocolEncryptionKey Encoding is null.");
        }
        this.setSubjectPublicKey(byArray, n2);
    }

    public void setSubjectPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws CRMFException {
        if (jSAFE_PublicKey == null) {
            throw new CRMFException("Public key is null.");
        }
        try {
            String string = null;
            string = jSAFE_PublicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] byArray = jSAFE_PublicKey.getKeyData(string);
            this.a = byArray[0];
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key. " + jSAFE_Exception.getMessage());
        }
    }

    public void setSubjectPublicKey(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null || n2 < 0) {
            throw new CRMFException("Public key encoding is null.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        try {
            byArray[n2] = 48;
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance(byArray, n2, "Java");
            this.setSubjectPublicKey(jSAFE_PublicKey);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key. " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.a == null) {
            return null;
        }
        try {
            return JSAFE_PublicKey.getInstance(this.a, 0, "Java");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Cannot retrieve the public key: " + jSAFE_Exception.getMessage());
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    protected int derEncodeValue(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Passed in array is null in PKIPublicationInfo control.");
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.");
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control." + aSN_Exception.getMessage());
        }
    }

    protected int derEncodeValueInit() throws CRMFException {
        try {
            this.b = null;
            if (this.a == null) {
                throw new CRMFException("Protocol Encryption Key value is not set.");
            }
            EncodedContainer encodedContainer = new EncodedContainer(77824, true, 0, this.a, 0, this.a.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{encodedContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode ProtocolEncryptionKey control." + aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ProtocolEncryptionKey protocolEncryptionKey = new ProtocolEncryptionKey();
        if (this.a != null) {
            protocolEncryptionKey.a = new byte[this.a.length];
            System.arraycopy(this.a, 0, protocolEncryptionKey.a, 0, this.a.length);
        }
        protocolEncryptionKey.c = this.c;
        super.copyValues(protocolEncryptionKey);
        return protocolEncryptionKey;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ProtocolEncryptionKey)) {
            return false;
        }
        ProtocolEncryptionKey protocolEncryptionKey = (ProtocolEncryptionKey)object;
        return CertJUtils.byteArraysEqual(this.a, protocolEncryptionKey.a);
    }
}

