/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathInterface;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;

abstract class CertPathCommon
extends ProviderImplementation
implements CertPathInterface {
    protected CertPathCommon(CertJ certJ, String string) throws InvalidParameterException {
        super(certJ, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean buildCertPath(CertPathCtx certPathCtx, Object object, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws NotSupportedException, CertPathException {
        if (this.a(certPathCtx)) {
            throw new CertPathException("CertPathCtx.buildCertPath: trustedCerts component of pathCtx should not be empty.");
        }
        if (vector2 == null && vector3 != null) {
            vector3 = null;
        }
        Vector vector5 = new Vector();
        if (object instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)object;
            if (!this.a(certPathCtx, x509Certificate)) {
                if (!this.isTrusted(certPathCtx, x509Certificate)) return false;
                if (vector == null) return true;
                if (!vector.contains(x509Certificate)) {
                    vector.addElement(x509Certificate);
                    return true;
                }
            }
            if (!this.a(certPathCtx, x509Certificate, vector5, vector2, vector3, vector4)) {
                return false;
            }
        } else {
            if (!(object instanceof X509CRL)) throw new NotSupportedException("CertPathCommon.buildCertPath: does not support startObjects other than X509Certificate or X509CRL.");
            if (!this.a(certPathCtx, (X509CRL)object, vector5, vector2, vector3, vector4)) {
                return false;
            }
        }
        CertJUtils.mergeLists(vector, vector5);
        CertJUtils.subtractLists(vector3, vector);
        return true;
    }

    public void getNextCertInPath(CertPathCtx certPathCtx, Object object, Vector vector) throws NotSupportedException, CertPathException {
        if (!(object instanceof X509Certificate) && !(object instanceof X509CRL)) {
            throw new NotSupportedException("CertPathCommon.getNextCertInPath: does not support startObjects other than X509Certificate or X509CRL.");
        }
        this.a(certPathCtx, object, vector);
    }

    private void a(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
        Vector vector2 = new Vector();
        this.getNextCertCandidates(certPathCtx, object, vector2);
        this.b(certPathCtx, object, vector2);
        CertJUtils.mergeLists(vector, vector2);
    }

    public boolean validateCertificate(CertPathCtx certPathCtx, Certificate certificate, JSAFE_PublicKey jSAFE_PublicKey) throws NotSupportedException, CertPathException {
        if (!(certificate instanceof X509Certificate)) {
            throw new NotSupportedException("CertPathCommon.validateCertificate: does not support certificate types other than X509Certificate.");
        }
        if (!this.a(certPathCtx, (X509Certificate)certificate)) {
            return false;
        }
        if ((certPathCtx.getPathOptions() & 1) != 0) {
            return true;
        }
        try {
            return certificate.verifyCertificateSignature(this.certJ.getDevice(), jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommon.validateCertificate: (no random service is registerd)" + noServiceException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean a(CertPathCtx certPathCtx, X509Certificate x509Certificate, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
        if (vector.contains(x509Certificate)) {
            return false;
        }
        vector.addElement(x509Certificate);
        if (this.isTrusted(certPathCtx, x509Certificate)) {
            if (this.verifyPath(certPathCtx, vector, vector2, vector3, vector4)) {
                return true;
            }
            vector.removeElement(x509Certificate);
            return false;
        }
        Vector vector5 = new Vector();
        this.a(certPathCtx, (Object)x509Certificate, vector5);
        for (int i2 = 0; i2 < vector5.size(); ++i2) {
            X509Certificate x509Certificate2 = (X509Certificate)vector5.elementAt(i2);
            if (!this.a(certPathCtx, x509Certificate2, vector, vector2, vector3, vector4)) continue;
            return true;
        }
        vector.removeElement(x509Certificate);
        return false;
    }

    private boolean a(CertPathCtx certPathCtx, X509CRL x509CRL, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
        Vector vector5 = new Vector();
        this.a(certPathCtx, (Object)x509CRL, vector5);
        for (int i2 = 0; i2 < vector5.size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)vector5.elementAt(i2);
            if (!this.a(certPathCtx, x509Certificate, vector, vector2, vector3, vector4)) continue;
            return true;
        }
        return false;
    }

    protected void getNextCertCandidates(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
        throw new CertPathException("CertPathCommon.getNextCertCandidates: subclass should override this method.");
    }

    protected boolean verifyPath(CertPathCtx certPathCtx, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
        throw new CertPathException("CertPathCommon.verifyPath: subclass should overrides this method.");
    }

    public boolean verifyRevocation(CertPathCtx certPathCtx, X509Certificate x509Certificate, Vector vector, Vector vector2) throws CertPathException {
        if ((certPathCtx.getPathOptions() & 4) != 0) {
            return true;
        }
        CertRevocationInfo certRevocationInfo = null;
        try {
            certRevocationInfo = this.certJ.checkCertRevocation(certPathCtx, x509Certificate);
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommon.verifyRevocation: (no Certificate Status Service is registered)" + noServiceException.getMessage());
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new CertPathException("CertPathCommon.verifyRevocation: (checkCertRevocation parameters)" + invalidParameterException.getMessage());
        }
        catch (CertStatusException certStatusException) {
            throw new CertPathException("CertPathCommon.verifyRevocation: " + certStatusException.getMessage());
        }
        if (certRevocationInfo.getStatus() != 0) {
            return false;
        }
        switch (certRevocationInfo.getType()) {
            case 1: {
                CRL cRL;
                CRLEvidence cRLEvidence = (CRLEvidence)certRevocationInfo.getEvidence();
                if (vector != null && !vector.contains(cRL = cRLEvidence.getCRL())) {
                    vector.addElement(cRL);
                }
                CertJUtils.mergeLists(vector, cRLEvidence.getCRLList());
                CertJUtils.mergeLists(vector2, cRLEvidence.getCertList());
                break;
            }
            case 2: {
                break;
            }
        }
        return true;
    }

    private void b(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
        int n2 = vector.size();
        while (n2 > 0) {
            X509Certificate x509Certificate = (X509Certificate)vector.elementAt(--n2);
            if (object instanceof X509Certificate) {
                if (!this.a(certPathCtx, (X509Certificate)object, x509Certificate)) {
                    vector.removeElementAt(n2);
                }
            } else if (!this.a(certPathCtx, (X509CRL)object, x509Certificate)) {
                vector.removeElementAt(n2);
            }
            if (this.a(certPathCtx, x509Certificate)) continue;
            vector.removeElementAt(n2);
        }
    }

    private boolean a(CertPathCtx certPathCtx, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertPathException {
        if ((certPathCtx.getPathOptions() & 1) != 0) {
            return true;
        }
        try {
            JSAFE_PublicKey jSAFE_PublicKey = x509Certificate2.getSubjectPublicKey(this.certJ.getDevice());
            return x509Certificate.verifyCertificateSignature(this.certJ.getDevice(), jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommon.verifyCertSignature:" + noServiceException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean a(CertPathCtx certPathCtx, X509CRL x509CRL, X509Certificate x509Certificate) throws CertPathException {
        if ((certPathCtx.getPathOptions() & 1) != 0) {
            return true;
        }
        String string = this.certJ.getDevice();
        try {
            JSAFE_PublicKey jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(string);
            return x509CRL.verifyCRLSignature(string, jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommon.verifyCrlSignature:" + noServiceException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean a(CertPathCtx certPathCtx, X509Certificate x509Certificate) {
        if ((certPathCtx.getPathOptions() & 2) != 0) {
            return true;
        }
        Date date = certPathCtx.getValidationTime();
        if (date == null) {
            date = new Date();
        }
        Date date2 = x509Certificate.getStartDate();
        Date date3 = x509Certificate.getEndDate();
        return date2 != null && date3 != null && !date.before(x509Certificate.getStartDate()) && !date.after(x509Certificate.getEndDate());
    }

    protected boolean isTrusted(CertPathCtx certPathCtx, Certificate certificate) {
        Certificate[] certificateArray = certPathCtx.getTrustedCerts();
        if (certificateArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            if (!certificate.equals(certificateArray[i2])) continue;
            return true;
        }
        return false;
    }

    private boolean a(CertPathCtx certPathCtx) {
        Certificate[] certificateArray = certPathCtx.getTrustedCerts();
        return certificateArray == null || certificateArray.length == 0;
    }

    protected void findCertBySubject(CertPathCtx certPathCtx, X500Name x500Name, Vector vector) throws CertPathException {
        Certificate[] certificateArray = certPathCtx.getTrustedCerts();
        if (certificateArray != null) {
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                X509Certificate x509Certificate;
                Certificate certificate = certificateArray[i2];
                if (!(certificate instanceof X509Certificate) || !x500Name.equals((x509Certificate = (X509Certificate)certificate).getSubjectName()) || vector.contains(x509Certificate)) continue;
                vector.addElement(x509Certificate);
            }
        }
        try {
            DatabaseService databaseService = certPathCtx.getDatabase();
            if (databaseService != null) {
                databaseService.selectCertificateBySubject(x500Name, vector);
            }
        }
        catch (NoServiceException noServiceException) {
            throw new CertPathException("CertPathCommon.findCertBySubject: " + noServiceException.getMessage());
        }
        catch (DatabaseException databaseException) {
            throw new CertPathException("CertPathCommon.findCertBySubject: " + databaseException.getMessage());
        }
    }
}

