/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.jsafe.JSAFE_PublicKey;

public final class CMPRevokeRequestMessage
extends CMPRequestCommon {
    private X509Certificate[] a = null;
    private X509V3Extensions[] b = null;

    public CMPRevokeRequestMessage(X509Certificate[] x509CertificateArray, X509V3Extensions[] x509V3ExtensionsArray) throws InvalidParameterException {
        super(11, null);
        int n2;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: certsToBeRevoked should not be empty.");
        }
        int n3 = x509CertificateArray.length;
        if (x509V3ExtensionsArray != null && n3 != x509V3ExtensionsArray.length) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: certsToBeRevoked and crlEntryExtensionsList should have the same number of elements.");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (x509CertificateArray[n2] != null) continue;
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: An element of certsToBeRevoked should not be null.");
        }
        if (x509V3ExtensionsArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                X509V3Extensions x509V3Extensions = x509V3ExtensionsArray[n2];
                if (x509V3Extensions == null) continue;
                this.a(x509V3Extensions);
            }
        }
        this.a = x509CertificateArray;
        this.b = x509V3ExtensionsArray;
    }

    public CMPRevokeRequestMessage(X509Certificate x509Certificate, X509V3Extensions x509V3Extensions) throws InvalidParameterException {
        super(11, null, null, null);
        if (x509Certificate == null) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.CMPRevokeRequestMessage: certToBeRevoked should not be null.");
        }
        this.a = new X509Certificate[1];
        this.a[0] = x509Certificate;
        if (x509V3Extensions != null) {
            this.a(x509V3Extensions);
            this.b = new X509V3Extensions[1];
            this.b[0] = x509V3Extensions;
        }
    }

    private void a(X509V3Extensions x509V3Extensions) throws InvalidParameterException {
        if (x509V3Extensions.getExtensionsType() != 3) {
            throw new InvalidParameterException("CMPRevokeRequestMessage.checkCRLEntryExtensions: extensions should be of type X509V3Extensions.X509_EXT_TYPE_CRL_ENTRY.");
        }
        for (int i2 = 0; i2 < x509V3Extensions.getExtensionCount(); ++i2) {
            try {
                X509V3Extension x509V3Extension = x509V3Extensions.getExtensionByIndex(i2);
                if (x509V3Extension instanceof CRLEntryExtension) continue;
                throw new InvalidParameterException("CMPRevokeRequestMessage.checkCRLEntryExtensions: extensions should consists of CRLEntryExtension.");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        try {
            Object object;
            Object object2;
            int n2 = 0xA00000 | this.getMessageType();
            OfContainer ofContainer = new OfContainer(n2, true, 0, 12288, new EncodedContainer(12288));
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                Object[] objectArray;
                EncodedContainer encodedContainer;
                byte[] byArray;
                object2 = this.a[i2];
                object = null;
                if (this.b != null) {
                    object = this.b[i2];
                }
                CertTemplate certTemplate = this.a((X509Certificate)object2, certJ);
                try {
                    byArray = new byte[certTemplate.getDERLen(0)];
                    certTemplate.getDEREncoding(byArray, 0, 0);
                }
                catch (CRMFException cRMFException) {
                    throw new CMPException("CMPRevokeRequestMessage.derEncode: unable to encode certDerails(" + cRMFException.getMessage() + ").");
                }
                EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
                if (object == null) {
                    encodedContainer = new EncodedContainer(65536, false, 0, null, 0, 0);
                } else {
                    objectArray = new byte[((X509V3Extensions)object).getDERLen(0)];
                    ((X509V3Extensions)object).getDEREncoding((byte[])objectArray, 0, 0);
                    encodedContainer = new EncodedContainer(65536, true, 0, (byte[])objectArray, 0, objectArray.length);
                }
                objectArray = new ASN1Container[]{new SequenceContainer(0, true, 0), encodedContainer2, encodedContainer, new EndContainer()};
                ASN1Template aSN1Template = new ASN1Template((ASN1Container[])objectArray);
                try {
                    byte[] byArray2 = new byte[aSN1Template.derEncodeInit()];
                    aSN1Template.derEncode(byArray2, 0);
                    ofContainer.addContainer(new EncodedContainer(0, true, 0, byArray2, 0, byArray2.length));
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new CMPException("CMPRevokeRequestMessage.derEncode: encoding RevDetails faild(" + aSN_Exception.getMessage() + ").");
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            object2 = new ASN1Template(aSN1ContainerArray);
            object = new byte[((ASN1Template)object2).derEncodeInit()];
            ((ASN1Template)object2).derEncode((byte[])object, 0);
            return object;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPRevokeRequestMessage.derEncode: encoding RevDetails faild(" + aSN_Exception.getMessage() + ").");
        }
    }

    private CertTemplate a(X509Certificate x509Certificate, CertJ certJ) throws CMPException {
        try {
            JSAFE_PublicKey jSAFE_PublicKey;
            CertTemplate certTemplate = new CertTemplate();
            byte[] byArray = x509Certificate.getSerialNumber();
            certTemplate.setSerialNumber(byArray, 0, byArray.length);
            X500Name x500Name = x509Certificate.getIssuerName();
            if (x500Name != null) {
                certTemplate.setIssuerName(x500Name);
            }
            if ((x500Name = x509Certificate.getSubjectName()) != null) {
                certTemplate.setSubjectName(x500Name);
            }
            if ((jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(certJ.getDevice())) != null) {
                certTemplate.setSubjectPublicKey(jSAFE_PublicKey);
            }
            return certTemplate;
        }
        catch (CRMFException cRMFException) {
            throw new CMPException("CMPRevokeRequestMessage.certToTemplate: unable to convert X509Certificate to CertTemplate(" + cRMFException.getMessage() + ").");
        }
        catch (CertificateException certificateException) {
            throw new CMPException("CMPRevokeRequestMessage.certToTemplate: unable to set public key of X509Certificate(" + certificateException.getMessage() + ").");
        }
    }
}

