/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JA_PQGGen;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ab;
import com.rsa.jsafe.ac;
import com.rsa.jsafe.bi;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JA_DSAParameters
extends JSAFE_Parameters
implements ab,
Cloneable,
Serializable {
    protected int a;
    protected int b;
    protected byte[] c;
    protected byte[] d;
    protected byte[] e;
    protected transient byte[] f;
    protected transient byte[] g;
    transient int[] h;
    protected SecureRandom i;
    protected byte[] j;
    protected String k;
    protected Class l;
    protected int m = 1;
    protected static final int n = 1;
    protected static final int o = 2;
    protected boolean p;

    public String getAlgorithm() {
        return "DSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DSAParameters", "DSAParametersBER", "DSAParametersX957BER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.c == null || this.d == null || this.e == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{"DSAParameters", "DSAParametersBER", "DSAParametersX957BER"};
        return stringArray;
    }

    public void a(byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        bi.a(this, byArray, n2);
    }

    public byte[] getDERAlgorithmID(String string) throws JSAFE_UnimplementedException {
        if (this.c == null || this.d == null || this.e == null) {
            throw new JSAFE_UnimplementedException("Cannot build the DER of the parameters, object not set.");
        }
        if (string != null) {
            if (string.compareTo("DSAParametersX957BER") == 0) {
                string = "DSAX957";
            } else if (string.compareTo("DSAParametersBER") == 0) {
                string = null;
            }
        }
        return bi.a(string, this.c, this.d, this.e);
    }

    protected void c() {
        if (this.l == null) {
            this.l = ac.a();
        }
    }

    public void a(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.l = clazz;
    }

    public void setParameterData(String string, byte[][] byArray) throws JSAFE_InputException, JSAFE_UnimplementedException {
        this.clearSensitiveData();
        if (string.equals("DSAParametersBER") || string.equals("DSAParametersX957BER")) {
            if (byArray.length != 1) {
                throw new JSAFE_InputException("Invalid BER DSA parameter data.");
            }
            this.a(byArray[0], 0);
            if (this.c == null || this.d == null || this.e == null) {
                throw new JSAFE_InputException("Invalid BER DSA parameter data.");
            }
            return;
        }
        if (string.compareTo("DSAParameters") == 0) {
            this.setParameterData(byArray);
            return;
        }
        throw new JSAFE_UnimplementedException("Unimplemented DSA parameter format.");
    }

    public void setParameterData(byte[][] byArray) throws JSAFE_InputException {
        if (byArray == null || byArray.length != 3) {
            throw new JSAFE_InputException("Invalid DSA parameters.");
        }
        this.a(-1, byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, byArray[2], 0, byArray[2].length);
    }

    void a(int n2, byte[] byArray, int n3, int n4, byte[] byArray2, int n5, int n6, byte[] byArray3, int n7, int n8) throws JSAFE_InputException {
        this.clearSensitiveData();
        while (byArray[n3] == 0) {
            --n4;
            ++n3;
        }
        this.c = new byte[n4];
        System.arraycopy(byArray, n3, this.c, 0, n4);
        this.a = this.c.length * 8;
        int n9 = this.c[0] & 0xFF;
        int n10 = n9 & 0x80;
        while (n10 == 0) {
            --this.a;
            n10 = (n9 <<= 1) & 0x80;
        }
        if (n2 != -1 && this.a > n2) {
            throw new JSAFE_InputException("DSA prime size mismatch.");
        }
        if (this.a < 512 || this.a > 4096) {
            throw new JSAFE_InputException("Invalid DSA prime size.");
        }
        while (byArray2[n5] == 0) {
            --n6;
            ++n5;
        }
        this.d = new byte[n6];
        System.arraycopy(byArray2, n5, this.d, 0, n6);
        this.b = this.d.length * 8;
        n9 = this.d[0] & 0xFF;
        n10 = n9 & 0x80;
        while (n10 == 0) {
            --this.b;
            n10 = (n9 <<= 1) & 0x80;
        }
        if (this.b < 160 || this.b > 160) {
            throw new JSAFE_InputException("Invalid DSA subprime size.");
        }
        while (byArray3[n7] == 0) {
            --n8;
            ++n7;
        }
        this.e = new byte[n8];
        System.arraycopy(byArray3, n7, this.e, 0, n8);
        if (this.e.length > this.c.length) {
            throw new JSAFE_InputException("Invalid DSA base size.");
        }
        if (this.e.length == this.c.length) {
            int n11;
            for (n11 = 0; n11 < this.e.length && (this.e[n11] & 0xFF) >= (this.c[n11] & 0xFF); ++n11) {
                if ((this.e[n11] & 0xFF) <= (this.c[n11] & 0xFF)) continue;
                throw new JSAFE_InputException("Invalid DSA base size.");
            }
            if (n11 >= this.e.length) {
                throw new JSAFE_InputException("Invalid DSA base size.");
            }
        }
    }

    public byte[][] getParameterData(String string) throws JSAFE_UnimplementedException {
        if (this.c == null || this.d == null || this.e == null) {
            return new byte[0][];
        }
        if (string.compareTo("DSAParametersBER") == 0) {
            byte[] byArray = bi.a(null, this.c, this.d, this.e);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        if (string.compareTo("DSAParametersX957BER") == 0) {
            byte[] byArray = bi.a("DSAX957", this.c, this.d, this.e);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        if (string.compareTo("DSAParameters") == 0) {
            return this.getParameterData();
        }
        throw new JSAFE_UnimplementedException("Unimplemented DSA parameter format.");
    }

    public byte[][] getParameterData() {
        if (this.c == null || this.d == null || this.e == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.c.length];
        System.arraycopy(this.c, 0, byArray, 0, this.c.length);
        byte[] byArray2 = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray2, 0, this.d.length);
        byte[] byArray3 = new byte[this.e.length];
        System.arraycopy(this.e, 0, byArray3, 0, this.e.length);
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    public byte[][] b(int[] nArray) {
        if (this.c == null || this.d == null || this.e == null || this.f == null || this.g == null) {
            return new byte[0][];
        }
        nArray[0] = this.h[0];
        byte[][] byArrayArray = new byte[][]{(byte[])this.c.clone(), (byte[])this.d.clone(), (byte[])this.e.clone(), (byte[])this.f.clone(), (byte[])this.g.clone()};
        return byArrayArray;
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.generateInit(nArray, secureRandom, null);
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidParameterException {
        this.a(nArray, secureRandom);
    }

    public void generateFIPSInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.p = true;
        this.a(nArray, secureRandom);
    }

    private void a(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        this.clearSensitiveData();
        if (secureRandom != null) {
            this.i = secureRandom;
        }
        if (nArray == null || nArray.length != 1) {
            throw new JSAFE_InvalidParameterException("Incorrect number of DSA param gen parameters: expected 1 - primeSize.");
        }
        int n2 = nArray[0];
        if (CryptoJ.getMode() == 0) {
            if (n2 < 512 || n2 % 64 != 0) {
                throw new JSAFE_InvalidParameterException("Invalid DSA FIPS 186 prime size.Should be at least 1024 and a multiple of 64 bits.");
            }
        } else if (n2 < 512 || n2 % 64 != 0) {
            throw new JSAFE_InvalidParameterException("Invalid DSA prime size.Should be at least 512 and a multiple of 64 bits.");
        }
        this.a = n2;
        if (this.i == null) {
            throw new JSAFE_InvalidParameterException("DSA parameter generation needs a random number generating object.");
        }
        this.b = 160;
        if (secureRandom != null) {
            this.i = secureRandom;
        }
        this.m = 2;
    }

    public void generateReInit() throws JSAFE_InvalidUseException {
        if (this.m != 2) {
            throw new JSAFE_InvalidUseException("Cannot reinitialize, object not initialized.");
        }
        this.c = null;
        this.d = null;
        this.e = null;
    }

    public void generate() throws JSAFE_InvalidUseException {
        if (this.m != 2) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        this.c();
        int n2 = (this.a + 7) / 8;
        this.c = new byte[n2];
        int n3 = (this.b + 7) / 8;
        this.d = new byte[n3];
        this.e = new byte[n2];
        this.f = new byte[n2];
        this.h = new int[1];
        this.g = new byte[20];
        if (this.p || CryptoJ.getMode() == 0) {
            JA_PQGGen.a(this.c, this.a, this.d, this.b, this.e, this.f, this.g, this.h, this.i, this.l);
        } else {
            JA_PQGGen.a(this.c, this.a, this.d, this.b, this.e, this.i, this.l);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.d();
        objectOutputStream.defaultWriteObject();
        this.a(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.e();
    }

    private JSAFE_SecureRandom d() {
        if (this.i == null) {
            return null;
        }
        if (!(this.i instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.i;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.k = jSAFE_SecureRandom.getAlgorithm();
        this.j = jSAFE_SecureRandom.d();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.i;
        this.i = null;
        return jSAFE_SecureRandom2;
    }

    private void a(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.j == null) {
            return;
        }
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            this.j[i2] = 0;
        }
        this.j = null;
        this.k = null;
        this.i = jSAFE_SecureRandom;
    }

    private void e() {
        if (this.j == null) {
            return;
        }
        this.i = JSAFE_SecureRandom.a(this.k, this.j);
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            this.j[i2] = 0;
        }
        this.j = null;
        this.k = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DSAParameters jA_DSAParameters = new JA_DSAParameters();
        if (this.c != null) {
            jA_DSAParameters.c = (byte[])this.c.clone();
        }
        if (this.d != null) {
            jA_DSAParameters.d = (byte[])this.d.clone();
        }
        if (this.e != null) {
            jA_DSAParameters.e = (byte[])this.e.clone();
        }
        jA_DSAParameters.a = this.a;
        jA_DSAParameters.b = this.b;
        jA_DSAParameters.l = this.l;
        jA_DSAParameters.m = this.m;
        jA_DSAParameters.i = this.i;
        jA_DSAParameters.a(this);
        return jA_DSAParameters;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.overwrite(this.c);
        this.overwrite(this.e);
        this.overwrite(this.d);
        this.b = 0;
        this.a = 0;
        this.e = null;
        this.d = null;
        this.c = null;
        this.m = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.clearSensitiveData();
        }
        finally {
            super.finalize();
        }
    }
}

