/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import java.io.IOException;

public final class Gsub
extends LookupTable {
    public static final ElementAttribute componentCountAttribute = new ElementAttribute("componentCount");
    public static final ElementAttribute ligatureComponentAttribute = new ElementAttribute("ligatureComponent");

    protected Gsub(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    protected int getScriptListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 4);
    }

    protected int getFeatureListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 6);
    }

    protected int getLookupListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 8);
    }

    protected LookupTable.LookupResult applyLookupSubtable(int n, int n2, int n3, AttributedRun attributedRun, int n4, int n5, int n6, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        switch (n) {
            case 1: {
                return this.applySingleSubst(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 2: {
                return this.applyMultipleSubst(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 3: {
                return this.applyAlternateSubst(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 4: {
                return this.applyLigatureSubst(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 5: {
                return this.applyContextualSubtable(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 6: {
                return this.applyChainingContextualSubtable(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 7: {
                return this.applyExtensionSubtable(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("Invalid GSUB lookup type (" + n + ")");
    }

    protected LookupTable.LookupResult applySingleSubst(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applySingleSubstFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 2: {
                return this.applySingleSubstFormat2(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB single subst format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applySingleSubstFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        if (this.getCoverageIndex(attributedRun.elementAt(n5), n6) == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n5)) {
            return lookupNotApplied;
        }
        int n7 = this.data.getint16(n2 + 4);
        int n8 = attributedRun.elementAt(n5) + n7 & 0xFFFF;
        attributedRun.replace(n5, n8);
        return new LookupTable.LookupResult(true, n5 + 1, 0);
    }

    protected LookupTable.LookupResult applySingleSubstFormat2(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n7)) {
            return lookupNotApplied;
        }
        int n9 = this.data.getuint16(n2 + 6 + 2 * n8);
        attributedRun.replace(n7, n9);
        return new LookupTable.LookupResult(true, n7 + 1, 0);
    }

    protected LookupTable.LookupResult applyMultipleSubst(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyMultipleSubstFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB multiple subst format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyMultipleSubstFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n7)) {
            return lookupNotApplied;
        }
        int n9 = this.data.getOffset(n2, 6 + 2 * n8);
        int n10 = this.data.getuint16(n9);
        int[] nArray = new int[n10];
        for (int i = 0; i < n10; ++i) {
            nArray[i] = this.data.getuint16(n9 + 2 + 2 * i);
        }
        attributedRun.replace(n7, nArray);
        return new LookupTable.LookupResult(true, n7 + n10, n10 - 1);
    }

    protected LookupTable.LookupResult applyAlternateSubst(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyAlternateSubstFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB alternate subst format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyAlternateSubstFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getOffset(n2, 2);
        int n8 = n5;
        int n9 = this.getCoverageIndex(attributedRun.elementAt(n8), n7);
        if (n9 == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n8)) {
            return lookupNotApplied;
        }
        int n10 = this.data.getOffset(n2, 6 + 2 * n9);
        int n11 = this.data.getuint16(n10);
        Integer n12 = (Integer)attributedRun.getElementStyle(n8, ElementAttribute.alternate);
        if (n12 != null && 0 < (n6 = n12.intValue()) && n6 <= n11) {
            int n13 = this.data.getuint16(n10 + 2 + 2 * (n6 - 1));
            attributedRun.replace(n8, n13);
        }
        return new LookupTable.LookupResult(true, n8 + 1, 0);
    }

    protected LookupTable.LookupResult applyLigatureSubst(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyLigatureSubstFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GSUB ligature subst format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyLigatureSubstFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        int n9 = this.data.getOffset(n2, 6 + 2 * n8);
        int n10 = this.data.getuint16(n9);
        for (int i = 0; i < n10; ++i) {
            int n11;
            int n12;
            int n13 = this.data.getOffset(n9, 2 + 2 * i);
            int[] nArray = this.matchOneLigature(n, n13, attributedRun, n7, n4, oTSelector, gdef);
            if (nArray == noMatch || !oTSelector.isApplied(attributedRun, nArray)) continue;
            int n14 = 0;
            for (n12 = 0; n12 < nArray.length; ++n12) {
                Integer n15;
                int n16;
                int n17 = n16 = n12 < nArray.length - 1 ? nArray[n12 + 1] : n4;
                for (n11 = nArray[n12] + 1; n11 < n16 && gdef != null && gdef.getGlyphClass(attributedRun.elementAt(n11)) == 3; ++n11) {
                    n15 = (Integer)attributedRun.getElementStyle(n11, ligatureComponentAttribute);
                    int n18 = n14 + (n15 == null ? 0 : n15);
                    attributedRun.setElementStyle(n11, ligatureComponentAttribute, new Integer(n18));
                }
                n15 = (Integer)attributedRun.getElementStyle(nArray[n12], componentCountAttribute);
                n14 += n15 == null ? 1 : n15;
            }
            n12 = nArray[nArray.length - 1] + 1;
            n11 = this.data.getuint16(n13);
            attributedRun.replace(nArray, n11);
            attributedRun.setElementStyle(nArray[0], componentCountAttribute, new Integer(n14));
            n12 = n12 - nArray.length + 1;
            return new LookupTable.LookupResult(true, n12, -(nArray.length - 1));
        }
        return lookupNotApplied;
    }

    int[] matchOneLigature(int n, int n2, AttributedRun attributedRun, int n3, int n4, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n5 = this.data.getuint16(n2 + 2);
        int[] nArray = new int[n5];
        nArray[0] = n3++;
        for (int i = 1; i < n5; ++i) {
            while (n3 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n3))) {
                ++n3;
            }
            if (n3 >= n4 || attributedRun.elementAt(n3) != this.data.getuint16(n2 + 4 + 2 * (i - 1))) {
                return noMatch;
            }
            nArray[i] = n3++;
        }
        return nArray;
    }
}

