/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDatabase;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSelector;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.ZapfDingbatsEncoding;
import java.util.List;

public final class PDF16RichTextFormatter {
    private final CSS20FontSelector cssFontSelector;

    private PDF16RichTextFormatter(CSS20FontSet cSS20FontSet) {
        this.cssFontSelector = new CSS20FontSelector(cSS20FontSet);
    }

    public static PDF16RichTextFormatter getFormatterInstance(CSS20FontSet cSS20FontSet) {
        if (cSS20FontSet == null) {
            return null;
        }
        return new PDF16RichTextFormatter(cSS20FontSet);
    }

    public static CSS20FontSet getFontSetInstance() {
        return new CSS20FontDatabase(true);
    }

    public static CSS20FontSet getFontSetInstance(FamilyNameNormalizer familyNameNormalizer) {
        return new CSS20FontDatabase(familyNameNormalizer, true);
    }

    public static CSS20FontSet getFontSetInstance(CSS20FontSet cSS20FontSet) {
        if (cSS20FontSet instanceof CSS20FontDatabase) {
            return new CSS20FontDatabase((CSS20FontDatabase)cSS20FontSet);
        }
        return null;
    }

    public int preFormat(AttributedRun attributedRun, int n, int n2) throws FontException, FormattingException {
        n2 = InFontFormatter.preFormat(attributedRun, n, n2);
        return n2;
    }

    public int format(AttributedRun attributedRun, int n, int n2) throws FontException, FormattingException {
        return this.format(attributedRun, n, n2, true);
    }

    public int format(AttributedRun attributedRun, int n, int n2, boolean bl) throws FontException, FormattingException {
        int n3 = n;
        while (n3 < n2) {
            int n4 = attributedRun.getSubrunLimit(n3, n2, ElementAttribute.CSS20Attribute);
            List list = ((CSS20Attribute)attributedRun.getElementStyle(n, ElementAttribute.CSS20Attribute)).getFamilyNamesList();
            if (list.size() > 0 && "Adobe Pi Std".equals(list.get(0))) {
                ZapfDingbatsEncoding.remap(attributedRun, n3, n4);
            }
            n3 = n4;
        }
        n2 = InFontFormatter.firstPass(attributedRun, n, n2);
        n2 = this.cssFontSelector.format(attributedRun, n, n2);
        return InFontFormatter.format(attributedRun, n, n2, bl);
    }
}

