/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.text.CanonicalIterator;
import com.adobe.agl.text.Normalizer;
import com.adobe.agl.text.UCharacterIterator;
import com.adobe.fontengine.Properties;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SWFFont4Description {
    private static final boolean DEBUG = false;

    protected SWFFont4Description() {
    }

    public abstract boolean canDisplay(int var1) throws UnsupportedFontException, InvalidFontException;

    public abstract int getFirstChar() throws InvalidFontException, UnsupportedFontException;

    public abstract int getLastChar() throws InvalidFontException, UnsupportedFontException;

    public abstract Permission getPermissions() throws InvalidFontException, UnsupportedFontException;

    public abstract String getFamily() throws InvalidFontException, UnsupportedFontException;

    public abstract String getSubFamily() throws InvalidFontException, UnsupportedFontException;

    public abstract boolean isBold() throws InvalidFontException, UnsupportedFontException;

    public abstract boolean isItalic() throws InvalidFontException, UnsupportedFontException;

    public abstract void streamFontData(Iterator<Integer> var1, OutputStream var2) throws InvalidFontException, UnsupportedFontException, IOException;

    public abstract void streamFontData(OutputStream var1) throws InvalidFontException, UnsupportedFontException, IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TLFSubsetCompletionIterator
    implements Iterator<Integer> {
        private static int[] additionsArray = new int[]{9, 8232, 8233};
        private Iterator<Integer> mIter1;
        private Iterator<Integer> mIter2;

        public TLFSubsetCompletionIterator(Iterator<Integer> iterator) {
            this.mIter1 = iterator;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n : additionsArray) {
                hashSet.add(n);
            }
            this.mIter2 = hashSet.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.mIter1 != null) {
                if (this.mIter1.hasNext()) {
                    return true;
                }
                this.mIter1 = null;
            }
            return this.mIter2.hasNext();
        }

        @Override
        public Integer next() {
            if (this.mIter1 != null) {
                return this.mIter1.next();
            }
            return this.mIter2.next();
        }

        @Override
        public void remove() {
            if (this.mIter1 != null) {
                this.mIter1.remove();
            } else {
                this.mIter2.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FTESubsetCompletionIterator
    implements Iterator<Integer> {
        private static final int[] additionsArray = new int[]{32};
        private static final Map<Integer, List<Integer>> REPLACEMENT_MAP;
        private static final int CROSSOVER_FOR_DECOMPOSITION = 900;
        private Iterator<Integer> completionIter;

        public FTESubsetCompletionIterator(Iterator<Integer> iterator) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            this.fillInternalSet(iterator, hashSet, hashSet2);
            Set set = this.caseCompletions(hashSet);
            hashSet.addAll(set);
            hashSet2.addAll(set);
            Set set2 = null;
            set2 = hashSet.size() < 900 ? this.expandCombiningSequences(hashSet, hashSet2) : this.decomposeUnicode(hashSet);
            hashSet.addAll(set2);
            this.completionIter = hashSet.iterator();
        }

        private void fillInternalSet(Iterator<Integer> iterator, Set<Integer> set, Set<Integer> set2) {
            for (int n : additionsArray) {
                set.add(n);
                set2.add(n);
            }
            Object object = new LinkedList();
            while (iterator.hasNext() || !object.isEmpty()) {
                Integer n = 0;
                if (!object.isEmpty()) {
                    n = (Integer)object.remove();
                } else {
                    List<Integer> list;
                    n = iterator.next();
                    int n2 = UCharacter.getMirror((int)n);
                    if (n2 != n) {
                        list = REPLACEMENT_MAP.get(n2);
                        if (list != null) {
                            object.addAll(list);
                        } else {
                            object.add(n2);
                        }
                    }
                    if ((list = REPLACEMENT_MAP.get(n)) != null) {
                        object.addAll(list);
                        n = (Integer)object.remove();
                    }
                }
                set.add(n);
                set2.add(n);
            }
        }

        private Set expandCombiningSequences(Set<Integer> set, Set<Integer> set2) {
            HashSet<Integer> hashSet = new HashSet<Integer>(set.size());
            Set<Integer> set3 = set;
            while (!set3.isEmpty()) {
                HashSet<Integer> hashSet2 = new HashSet<Integer>();
                for (Integer n : set3) {
                    for (Integer n2 : set2) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.appendCodePoint(n);
                        stringBuffer.appendCodePoint(n2);
                        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance((StringBuffer)stringBuffer);
                        Normalizer normalizer = new Normalizer(uCharacterIterator, Normalizer.NFC, 0);
                        int n3 = 0;
                        while ((n3 = normalizer.next()) != -1) {
                            if (set.contains(n3) || hashSet.contains(n3) || set2.contains(n3)) continue;
                            hashSet.add(n3);
                            hashSet2.add(n3);
                        }
                    }
                }
                set3 = hashSet2;
            }
            return hashSet;
        }

        private Set decomposeUnicode(Set<Integer> set) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            block0: for (int i = 0; i < 0x10FFFF; ++i) {
                int n = UCharacter.getIntPropertyValue((int)i, (int)4099);
                if (n != 1) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.appendCodePoint(i);
                CanonicalIterator canonicalIterator = new CanonicalIterator(stringBuffer.toString());
                String string = canonicalIterator.next();
                while (string != null) {
                    boolean bl = true;
                    UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance((String)string);
                    int n2 = uCharacterIterator.nextCodePoint();
                    while (n2 != -1) {
                        if (!set.contains(n2)) {
                            bl = false;
                            break;
                        }
                        n2 = uCharacterIterator.nextCodePoint();
                    }
                    if (bl) {
                        hashSet.add(i);
                        continue block0;
                    }
                    string = canonicalIterator.next();
                }
            }
            return hashSet;
        }

        private Set caseCompletions(Set<Integer> set) {
            int[] nArray = new int[]{4, 5};
            int[] nArray2 = new int[3];
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n : nArray) {
                for (int n2 : set) {
                    int n3;
                    int n4 = Properties.getFullUpperCase(n2, n, nArray2);
                    if (n4 > 0 && (n4 > 1 || n2 != nArray2[0])) {
                        for (n3 = 0; n3 < n4; ++n3) {
                            hashSet.add(nArray2[n3]);
                        }
                    }
                    if ((n4 = Properties.getFullLowerCase(n2, n, nArray2)) <= 0 || n4 <= 1 && n2 == nArray2[0]) continue;
                    for (n3 = 0; n3 < n4; ++n3) {
                        hashSet.add(nArray2[n3]);
                    }
                }
            }
            return hashSet;
        }

        @Override
        public boolean hasNext() {
            return this.completionIter.hasNext();
        }

        @Override
        public Integer next() {
            return this.completionIter.next();
        }

        @Override
        public void remove() {
            this.completionIter.remove();
        }

        static {
            int[][] nArrayArray = new int[][]{{9}, {32}, {10}, {32}, {13}, {32}, {133}, {32}, {173}, {32}, {847}, {32}, {4447}, {32}, {4448}, {32}, {6068}, {32}, {6069}, {32}, {8203}, {32}, {8204}, {32}, {8205}, {32}, {8206}, {32}, {8207}, {32}, {8232}, {32}, {8233}, {32}, {8234}, {32}, {8235}, {32}, {8236}, {32}, {8237}, {32}, {8238}, {32}, {8288}, {32}, {8289}, {32}, {8290}, {32}, {8291}, {32}, {8292}, {32}, {8293}, {32}, {8294}, {32}, {8295}, {32}, {8296}, {32}, {8297}, {32}, {8298}, {32}, {8299}, {32}, {8300}, {32}, {8301}, {32}, {8302}, {32}, {8303}, {32}, {12644}, {32}, {65279}, {32}, {65440}, {32}, {65520}, {32}, {65521}, {32}, {65522}, {32}, {65523}, {32}, {65524}, {32}, {65525}, {32}, {65526}, {32}, {65527}, {32}, {65528}, {32}, {119155}, {32}, {119156}, {32}, {119157}, {32}, {119158}, {32}, {119159}, {32}, {119160}, {32}, {119161}, {32}, {119162}, {32}, {2507}, {2503, 2494}, {2508}, {2503, 2519}, {2888}, {2887, 2902}, {2891}, {2887, 2878}, {2892}, {2887, 2903}, {3018}, {3014, 3006}, {3019}, {3015, 3006}, {3020}, {3014, 3031}, {3144}, {3142, 3158}, {3264}, {3263, 3285}, {3271}, {3270, 3285}, {3272}, {3270, 3286}, {3274}, {3270, 3266}, {3275}, {3270, 3266, 3285}, {3402}, {3398, 3390}, {3403}, {3399, 3390}, {3404}, {3398, 3415}, {3546}, {3545, 3530}, {3548}, {3545, 3535}, {3549}, {3545, 3535, 3530}, {3550}, {3545, 3551}, {3597}, {3597, 63247}, {3600}, {3600, 63232}, {3633}, {3633, 63248}, {3635}, {3661, 3634, 63249}, {3636}, {3636, 63233}, {3637}, {3637, 63234}, {3638}, {3638, 63235}, {3639}, {3639, 63236}, {3640}, {3640, 63256}, {3641}, {3641, 63257}, {3642}, {3642, 63258}, {3655}, {3655, 63250}, {3656}, {3656, 63251, 63242, 63237}, {3657}, {3657, 63252, 63243, 63238}, {3658}, {3658, 63253, 63244, 63239}, {3659}, {3659, 63254, 63245, 63240}, {3660}, {3660, 63255, 63246, 63241}, {3661}, {3661, 63249}, {3763}, {3789, 3762}, {3955}, {3953, 3954}, {3957}, {3953, 3956}, {3958}, {4018, 3968}, {3959}, {4018, 3953, 3968}, {3960}, {4019, 3968}, {3961}, {4019, 3953, 3968}, {3969}, {3953, 3968}, {6078}, {6081, 6078}, {6079}, {6081, 6079}, {6080}, {6081, 6080}, {6084}, {6081, 6084}, {6085}, {6081, 6085}, {160}, {160, 32}, {8192}, {8192, 32}, {8193}, {8193, 32}, {8194}, {8194, 32}, {8195}, {8195, 32}, {8196}, {8196, 32}, {8197}, {8197, 32}, {8198}, {8198, 32}, {8199}, {8199, 32, 48}, {8200}, {8200, 32, 46}, {8201}, {8201, 32}, {8202}, {8202, 32}, {8203}, {8203, 32}, {8239}, {8239, 32}, {8287}, {8287, 32}, {12288}, {12288, 32}};
            HashMap hashMap = new HashMap();
            for (int i = 0; i < nArrayArray.length; i += 2) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(nArrayArray[i].length);
                int[] nArray = nArrayArray[i + 1];
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    Integer n2 = nArray[j];
                    arrayList.add(n2);
                }
                hashMap.put(nArrayArray[i][0], arrayList);
            }
            REPLACEMENT_MAP = Collections.unmodifiableMap(hashMap);
        }
    }
}

