/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.math.Math2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NonOverlappingOutlineConsumer
implements OutlineConsumer {
    private static final int MAX_NUM_SUBPATHS = 1000;
    private static final int MAX_NUM_SEGMENTS = 1000;
    private static final int SEG_DELETE = 1;
    private static final int SEG_ISECT = 2;
    private static final int SEG_WIND_TEST = 4;
    float cpx;
    float cpy;
    private SubPath currentSubPath;
    private List path;
    private List newPath;
    private List savedPath;
    private List isectList;
    private List segList;
    private float unitsPerEm;
    boolean selfIsectFlag;
    OutlineConsumer oc;
    int debugNumGlyphsWithOverlaps;
    int debugNumFailures;

    private static float milliem(float f, float f2) {
        return (float)((double)(f * f2) / 1000.0);
    }

    public NonOverlappingOutlineConsumer(OutlineConsumer outlineConsumer, double d) {
        this.oc = outlineConsumer;
        this.currentSubPath = null;
        this.path = new ArrayList();
        this.segList = new ArrayList();
        this.cpx = 0.0f;
        this.cpy = 0.0f;
        this.unitsPerEm = (float)d;
        this.debugNumGlyphsWithOverlaps = 0;
        this.debugNumFailures = 0;
    }

    private void saveIsect(Point point, Segment segment, float f, long l) {
        ListIterator listIterator = this.isectList.listIterator();
        Point point2 = new Point(Math.round(point.x), Math.round(point.y));
        Intersect intersect = null;
        if (!this.selfIsectFlag) {
            while (listIterator.hasNext()) {
                float f2;
                float f3;
                intersect = (Intersect)listIterator.next();
                SubPath subPath = intersect.seg.subPath;
                if (subPath != segment.subPath || !Math2.epsilonEquals(f3 = (float)Math.round(intersect.p.x), point2.x) || !Math2.epsilonEquals(f2 = (float)Math.round(intersect.p.y), point2.y)) continue;
                return;
            }
        }
        Intersect intersect2 = new Intersect(f, point, segment, null, l);
        this.isectList.add(intersect2);
        segment.subPath.pathISected = true;
    }

    private void saveIsectPair(Segment segment, float f, Segment segment2, float f2) {
        long l;
        long l2;
        long l3;
        long l4;
        Segment segment3;
        Point point;
        long l5 = this.isectList.size();
        if (f == 0.0f) {
            point = new Point(segment.getFirstPoint());
        } else if (f2 == 0.0f) {
            point = new Point(segment2.getFirstPoint());
        } else if (f == 1.0f) {
            point = new Point(segment.getLastPoint());
        } else if (f2 == 1.0f) {
            point = new Point(segment2.getLastPoint());
        } else if (segment instanceof Line) {
            segment3 = (Line)segment;
            point = ((Line)segment3).computeISectPoint(f);
        } else if (segment2 instanceof Line) {
            segment3 = (Line)segment2;
            point = ((Line)segment3).computeISectPoint(f2);
        } else {
            segment3 = (Curve)segment;
            point = ((Curve)segment3).computeISectPoint(f);
        }
        long l6 = Math.round(point.x);
        long l7 = Math.round(point.y);
        if (0.0f < f && f < 1.0f) {
            l4 = Math.round(segment.getFirstPoint().x);
            l3 = Math.round(segment.getFirstPoint().y);
            l2 = Math.round(segment.getLastPoint().x);
            l = Math.round(segment.getLastPoint().y);
            if (l6 == l4 && l7 == l3 || l6 == l2 && l7 == l) {
                f = Math.round(f);
            }
        }
        if (0.0f < f2 && f2 < 1.0f) {
            l4 = Math.round(segment2.getFirstPoint().x);
            l3 = Math.round(segment2.getFirstPoint().y);
            l2 = Math.round(segment2.getLastPoint().x);
            l = Math.round(segment2.getLastPoint().y);
            if (l6 == l4 && l7 == l3 || l6 == l2 && l7 == l) {
                f2 = Math.round(f2);
            }
        }
        this.saveIsect(point, segment, f, l5);
        this.saveIsect(point, segment2, f2, l5 + 1L);
    }

    private void isectLineLineSegs(Segment segment, Segment segment2) {
        if (!(segment instanceof Line)) {
            return;
        }
        Line line = (Line)segment;
        if (!(segment2 instanceof Line)) {
            return;
        }
        Line line2 = (Line)segment2;
        List list = line.iSectLine(line2);
        if (list.size() == 2) {
            float[] fArray = (float[])list.get(1);
            this.saveIsectPair(segment, fArray[0], segment2, fArray[1]);
            fArray = (float[])list.get(0);
            this.saveIsectPair(segment, fArray[0], segment2, fArray[1]);
        } else if (list.size() == 1) {
            float[] fArray = (float[])list.get(0);
            this.saveIsectPair(segment, fArray[0], segment2, fArray[1]);
        }
    }

    private void isectLineCurveSegs(Segment segment, Segment segment2) {
        if (!(segment instanceof Line)) {
            return;
        }
        Line line = (Line)segment;
        if (!(segment2 instanceof Curve)) {
            return;
        }
        Curve curve = (Curve)segment2;
        while (true) {
            Object object;
            Object object2;
            if (curve.isFlatEnough(this.unitsPerEm)) {
                object2 = curve.makeLine();
                object = ((Line)object2).iSectLine(line);
                if (object.size() == 2) {
                    float[] fArray = (float[])object.get(1);
                    this.saveIsectPair(segment2.origSeg, curve.t0 + fArray[0] * (curve.t1 - curve.t0), segment.origSeg, line.t0 + fArray[1] * (line.t1 - line.t0));
                    fArray = (float[])object.get(0);
                    this.saveIsectPair(segment2.origSeg, curve.t0 + fArray[0] * (curve.t1 - curve.t0), segment.origSeg, line.t0 + fArray[1] * (line.t1 - line.t0));
                    return;
                }
                if (object.size() == 1) {
                    float[] fArray = (float[])object.get(0);
                    this.saveIsectPair(segment2.origSeg, curve.t0 + fArray[0] * (curve.t1 - curve.t0), segment.origSeg, line.t0 + fArray[1] * (line.t1 - line.t0));
                    return;
                }
                return;
            }
            if (!line.iSectRect(curve.getBounds())) break;
            object2 = curve.splitMid();
            object = (Curve)object2.get(0);
            curve = (Curve)object2.get(1);
            this.isectLineCurveSegs(line, (Segment)object);
        }
    }

    private void isectCurveCurve(Curve curve, Curve curve2) {
        if (!curve.getBounds().overlap(curve2.getBounds())) {
            return;
        }
        if (curve.isFlatEnough(this.unitsPerEm)) {
            Line line = curve.makeLine();
            this.isectLineCurveSegs(line, curve2);
        } else {
            List list = curve.splitMid();
            Curve curve3 = (Curve)list.get(0);
            curve = (Curve)list.get(1);
            this.isectCurveCurve(curve2, curve3);
            this.isectCurveCurve(curve2, curve);
        }
    }

    private void isectCurveCurveSegs(Segment segment, Segment segment2) {
        if (!(segment instanceof Curve)) {
            return;
        }
        Curve curve = (Curve)segment;
        if (!(segment2 instanceof Curve)) {
            return;
        }
        Curve curve2 = (Curve)segment2;
        if (curve.equalControlPoints(curve2)) {
            this.saveIsectPair(segment, 0.0f, segment2, 0.0f);
            this.saveIsectPair(segment, 1.0f, segment2, 1.0f);
        } else if (curve.reverseControlPoints(curve2)) {
            this.saveIsectPair(segment, 0.0f, segment2, 1.0f);
            this.saveIsectPair(segment, 1.0f, segment2, 0.0f);
        } else {
            this.isectCurveCurve(curve, curve2);
        }
    }

    private void isectSegPair(Segment segment, Segment segment2) {
        segment.origSeg = segment;
        segment2.origSeg = segment2;
        if (segment instanceof Line) {
            if (segment2 instanceof Line) {
                this.isectLineLineSegs(segment, segment2);
            } else {
                this.isectLineCurveSegs(segment, segment2);
            }
        } else if (segment2 instanceof Line) {
            this.isectLineCurveSegs(segment2, segment);
        } else {
            this.isectCurveCurveSegs(segment, segment2);
        }
    }

    private void isectPathPair(SubPath subPath, SubPath subPath2) {
        Segment segment = subPath.firstSegment;
        if (segment == null) {
            return;
        }
        do {
            Segment segment2;
            if ((segment2 = subPath2.firstSegment) == null) {
                return;
            }
            do {
                if (!segment.getBounds().overlap(segment2.getBounds())) continue;
                this.isectSegPair(segment, segment2);
            } while ((segment2 = segment2.nextSeg()) != subPath2.firstSegment);
        } while ((segment = segment.nextSeg()) != subPath.firstSegment);
    }

    private void splitSegment(Intersect intersect, Intersect intersect2) {
        Segment segment;
        Object object;
        float f = intersect2.t;
        Segment segment2 = intersect2.seg;
        if (intersect != null && intersect.seg == intersect2.seg) {
            if (f == intersect.t || f == 1.0f) {
                intersect2.splitSeg = intersect.splitSeg;
                return;
            }
            if (intersect.splitSeg != null) {
                f = (f - intersect.t) / (1.0f - intersect.t);
                segment2 = intersect.splitSeg;
            }
        } else if (f == 0.0f || f == 1.0f) {
            return;
        }
        if (segment2 instanceof Line) {
            object = (Line)segment2;
            Line line = new Line(intersect2.p, ((Line)object).p1);
            ((Line)object).p1.x = intersect2.p.x;
            ((Line)object).p1.y = intersect2.p.y;
            segment = line;
        } else {
            Object object2;
            object = (Curve)segment2;
            Point point = new Point(((Curve)object).p0);
            Point point2 = new Point(((Curve)object).p1);
            Point point3 = new Point(((Curve)object).p2);
            Point point4 = new Point(((Curve)object).p3);
            ((Curve)object).p1.x = Math.round(f * (point2.x - point.x) + ((Curve)object).p0.x);
            ((Curve)object).p1.y = Math.round(f * (point2.y - point.y) + ((Curve)object).p0.y);
            ((Curve)object).p2.x = Math.round(f * f * (point3.x - 2.0f * point2.x + point.x) + 2.0f * ((Curve)object).p1.x - ((Curve)object).p0.x);
            ((Curve)object).p2.y = Math.round(f * f * (point3.y - 2.0f * point2.y + point.y) + 2.0f * ((Curve)object).p1.y - ((Curve)object).p0.y);
            ((Curve)object).p3.x = Math.round(intersect2.p.x);
            ((Curve)object).p3.y = Math.round(intersect2.p.y);
            if (((Curve)object).isLine(this.unitsPerEm)) {
                object2 = ((Curve)object).makeLine();
                segment2.subPath.replaceSegment(segment2, (Segment)object2);
            }
            f = 1.0f - f;
            object2 = new Point(point4);
            Point point5 = new Point(Math.round(f * (point3.x - point4.x) + ((Point)object2).x), Math.round(f * (point3.y - point4.y) + ((Point)object2).y));
            Point point6 = new Point(Math.round(f * f * (point2.x - 2.0f * point3.x + point4.x) + 2.0f * point5.x - ((Point)object2).x), Math.round(f * f * (point2.y - 2.0f * point3.y + point4.y) + 2.0f * point5.y - ((Point)object2).y));
            Point point7 = new Point(((Curve)object).p3);
            Curve curve = new Curve(point7, point6, point5, (Point)object2);
            segment = curve;
            if (curve.isLine(this.unitsPerEm)) {
                Line line;
                segment = line = curve.makeLine();
            }
        }
        object = segment2.subPath;
        ((SubPath)object).splitSegment(segment2, segment);
        intersect2.splitSeg = segment;
    }

    private void splitIsectSegs() {
        Object object;
        Object[] objectArray2;
        SegComparator segComparator = new SegComparator();
        Collections.sort(this.isectList, segComparator);
        Object object2 = null;
        for (Object[] objectArray2 : this.isectList) {
            this.splitSegment((Intersect)object2, (Intersect)objectArray2);
            object2 = objectArray2;
        }
        objectArray2 = this.isectList.toArray();
        for (int i = objectArray2.length - 1; i > 0; --i) {
            object2 = (Intersect)objectArray2[i - 1];
            object = (Intersect)objectArray2[i];
            if (((Intersect)object).splitSeg == null || object2 == null || object2.seg != ((Intersect)object).seg || object2.splitSeg == null) continue;
            ((Intersect)object).seg = object2.splitSeg;
            ((Intersect)object).splitSeg = ((Intersect)object).seg.nextSeg();
        }
        for (Intersect intersect : this.isectList) {
            object = intersect.seg;
            if (intersect.splitSeg == null) {
                intersect.splitSeg = intersect.t == 0.0f ? ((Segment)object).prevSeg() : ((Segment)object).nextSeg();
            } else {
                ((Segment)object).round(this.unitsPerEm);
                intersect.splitSeg.round(this.unitsPerEm);
            }
            ((Segment)object).flags |= 2;
            intersect.splitSeg.flags |= 2;
        }
    }

    private void windTestSeg(Segment segment) {
        Segment segment2;
        Point point = new Point();
        if ((segment.flags & 5) != 0) {
            return;
        }
        if (segment instanceof Line) {
            segment2 = (Line)segment;
            point.x = (segment2.p0.x + segment2.p1.x) / 2.0f;
            point.y = (segment2.p0.y + segment2.p1.y) / 2.0f;
        } else {
            segment2 = (Curve)segment;
            point.x = (((Curve)segment2).p3.x + 3.0f * (((Curve)segment2).p2.x + ((Curve)segment2).p1.x) + ((Curve)segment2).p0.x) / 8.0f;
            point.y = (((Curve)segment2).p3.y + 3.0f * (((Curve)segment2).p2.y + ((Curve)segment2).p1.y) + ((Curve)segment2).p0.y) / 8.0f;
        }
        int n = 0;
        boolean bl = segment.horizontal();
        int n2 = bl ? segment.getWindingX() : segment.getWindingY();
        SubPath subPath = segment.subPath;
        do {
            if (bl) {
                if (subPath.bounds.top < point.y || subPath.bounds.left > point.x || subPath.bounds.right <= point.x) {
                    subPath = subPath.nextSubPath;
                    continue;
                }
            } else if (subPath.bounds.left > point.x || subPath.bounds.bottom > point.y || subPath.bounds.top <= point.y) {
                subPath = subPath.nextSubPath;
                continue;
            }
            Segment segment3 = subPath.firstSegment;
            do {
                List list;
                Rect rect;
                if (segment3 == segment) continue;
                if (bl) {
                    rect = segment3.getBounds();
                    if (rect.top < point.y || rect.left > point.x || rect.right <= point.x || rect.left == rect.right) continue;
                    if (rect.bottom > point.y) {
                        n += Segment.getWindingAtValue(segment3.getFirstPoint().x, segment3.getLastPoint().x, point.x);
                        continue;
                    }
                    if (segment3.reverseControlPoints(segment)) {
                        segment.flags |= 5;
                        return;
                    }
                    if (segment3.equalControlPoints(segment)) {
                        if (this.path.indexOf(segment3.subPath) < this.path.indexOf(segment.subPath)) {
                            segment.flags |= 1;
                        }
                        segment.flags |= 4;
                        return;
                    }
                    list = segment3.solveAtX(point.x);
                    for (ICept iCept : list) {
                        if (!(iCept.ic > point.y)) continue;
                        n += iCept.winding;
                    }
                } else {
                    rect = segment3.getBounds();
                    if (rect.left > point.x || rect.bottom > point.y || rect.top <= point.y || rect.top == rect.bottom) continue;
                    if (rect.right < point.x) {
                        n += Segment.getWindingAtValue(segment3.getFirstPoint().y, segment3.getLastPoint().y, point.y);
                        continue;
                    }
                    if (segment3.reverseControlPoints(segment)) {
                        segment.flags |= 5;
                        return;
                    }
                    if (segment3.equalControlPoints(segment)) {
                        if (this.path.indexOf(segment3.subPath) < this.path.indexOf(segment.subPath)) {
                            segment.flags |= 1;
                        }
                        segment.flags |= 4;
                        return;
                    }
                    list = segment3.solveAtY(point.y);
                    for (ICept iCept : list) {
                        if (!(iCept.ic < point.x)) continue;
                        n += iCept.winding;
                    }
                }
            } while ((segment3 = segment3.nextSeg()) != subPath.firstSegment);
            subPath = subPath.nextSubPath;
        } while (subPath != segment.subPath);
        if (n != 0 && n + n2 != 0) {
            segment.flags |= 1;
        }
        segment.flags |= 4;
    }

    private void deleteBadSegs() throws ISectException {
        if (this.isectList.size() % 2 != 0) {
            throw new ISectException("error - uneven intersects");
        }
        IDComparator iDComparator = new IDComparator();
        Collections.sort(this.isectList, iDComparator);
        for (Object object : this.isectList) {
            this.windTestSeg(((Intersect)object).seg);
            this.windTestSeg(((Intersect)object).splitSeg);
        }
        Iterator iterator = this.isectList.iterator();
        while (iterator.hasNext()) {
            Segment segment;
            Segment segment2;
            Segment segment3;
            Object object;
            Intersect intersect = (Intersect)iterator.next();
            Intersect intersect2 = (Intersect)iterator.next();
            if (intersect.seg.nextSeg() == intersect.splitSeg) {
                object = intersect.seg;
                segment3 = intersect.splitSeg;
            } else {
                object = intersect.splitSeg;
                segment3 = intersect.seg;
            }
            if (intersect2.seg.nextSeg() == intersect2.splitSeg) {
                segment2 = intersect2.seg;
                segment = intersect2.splitSeg;
            } else {
                segment2 = intersect2.splitSeg;
                segment = intersect2.seg;
            }
            switch ((((Segment)object).flags & 1) << 3 | (segment3.flags & 1) << 2 | (segment2.flags & 1) << 1 | (segment.flags & 1) << 0) {
                case 0: 
                case 3: 
                case 12: 
                case 15: {
                    break;
                }
                case 5: 
                case 10: {
                    throw new ISectException("error - illegal segment flags");
                }
                case 1: {
                    ((Segment)object).flags |= 1;
                    segment2.relink(segment3);
                    break;
                }
                case 2: {
                    segment3.flags |= 1;
                    ((Segment)object).relink(segment);
                    break;
                }
                case 4: {
                    segment2.flags |= 1;
                    ((Segment)object).relink(segment);
                    break;
                }
                case 6: {
                    ((Segment)object).relink(segment);
                    break;
                }
                case 7: {
                    if (!((Segment)object).getLastPoint().equals(segment.getFirstPoint())) break;
                    segment.flags &= 0xFFFFFFFE;
                    ((Segment)object).relink(segment);
                    break;
                }
                case 8: {
                    segment.flags |= 1;
                    segment2.relink(segment3);
                    break;
                }
                case 9: {
                    segment2.relink(segment3);
                    break;
                }
                case 11: {
                    if (!segment2.getLastPoint().equals(segment3.getFirstPoint())) break;
                    segment2.flags &= 0xFFFFFFFE;
                    segment2.relink(segment3);
                    break;
                }
                case 13: {
                    if (!segment2.getLastPoint().equals(segment3.getFirstPoint())) break;
                    segment3.flags &= 0xFFFFFFFE;
                    segment2.relink(segment3);
                    break;
                }
                case 14: {
                    if (!((Segment)object).getLastPoint().equals(segment.getFirstPoint())) break;
                    ((Segment)object).flags &= 0xFFFFFFFE;
                    ((Segment)object).relink(segment);
                }
            }
        }
    }

    private SubPath newSubPath(Segment segment) throws ISectException {
        SubPath subPath = new SubPath();
        subPath.addSegments(segment);
        return subPath;
    }

    private void buildSubPath(Segment segment) throws ISectException {
        if ((segment.flags & 1) != 0 || this.newPath.contains(segment.subPath)) {
            return;
        }
        SubPath subPath = this.newSubPath(segment);
        this.addPath(this.newPath, subPath);
    }

    private void buildNewPaths() throws ISectException {
        this.newPath = new ArrayList();
        for (Object object : this.path) {
            if (((SubPath)object).pathISected) continue;
            this.addPath(this.newPath, (SubPath)object);
        }
        for (Object object : this.isectList) {
            this.buildSubPath(((Intersect)object).seg);
            this.buildSubPath(((Intersect)object).splitSeg);
        }
        for (Object object : this.path) {
            if (!((SubPath)object).pathISected) continue;
            Segment segment = ((SubPath)object).firstSegment;
            SubPath subPath = segment.subPath;
            if (!this.newPath.contains(subPath) || (segment.flags & 1) == 1) continue;
            subPath.firstSegment = segment;
            subPath.lastSegment = segment.prevSegment;
        }
        for (Object object : this.newPath) {
            int n = 0;
            int n2 = 0;
            Segment segment = ((SubPath)object).firstSegment;
            do {
                int n3 = 0;
                if (segment instanceof Line) {
                    Line line = (Line)segment;
                    if (Math2.epsilonEquals(line.p0.x, line.p1.x)) {
                        n3 = 1;
                    } else if (Math2.epsilonEquals(line.p0.y, line.p1.y)) {
                        n3 = -1;
                    } else {
                        if (++n2 > this.segList.size()) {
                            throw new ISectException("Infinite loop condition!");
                        }
                        n = n3;
                        segment = segment.nextSeg();
                        continue;
                    }
                    if (segment != ((SubPath)object).firstSegment && n3 == n) {
                        Segment segment2;
                        Point point = new Point(line.p1);
                        Segment segment3 = segment.prevSegment;
                        ((SubPath)object).removeSegment(segment);
                        if (segment3 instanceof Line) {
                            segment2 = (Line)segment3;
                            ((Line)segment2).p1 = point;
                            ((Line)segment2).setBounds();
                        } else {
                            segment2 = (Curve)segment3;
                            ((Curve)segment2).p3 = point;
                            ((Curve)segment2).setBounds();
                        }
                    }
                    if (++n2 > this.segList.size()) {
                        throw new ISectException("Infinite loop condition!");
                    }
                }
                n = n3;
                segment = segment.nextSeg();
            } while (segment != ((SubPath)object).firstSegment);
        }
    }

    private void selfIsectPath(SubPath subPath) throws ISectException {
        if (subPath.getNumSegments() > 1000) {
            throw new ISectException("error - too many segments in subpath");
        }
        if (subPath.getNumSegments() < 3) {
            return;
        }
        Segment segment = subPath.firstSegment;
        while (segment.nextSeg() != subPath.lastSegment) {
            Segment segment2 = segment.nextSeg();
            do {
                if ((segment2 = segment2.nextSeg()).nextSeg() == segment || !segment.getBounds().overlap(segment2.getBounds())) continue;
                this.isectSegPair(segment, segment2);
            } while (segment2 != subPath.lastSegment);
            segment = segment.nextSeg();
        }
    }

    private void isectPath() throws ISectException {
        Object[] objectArray;
        List list = this.path;
        if (list == null) {
            return;
        }
        if (list.size() > 1000) {
            throw new ISectException("error - too many subpaths");
        }
        this.isectList = new ArrayList();
        Iterator iterator = list.iterator();
        this.selfIsectFlag = true;
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            this.selfIsectPath((SubPath)objectArray);
        }
        this.selfIsectFlag = false;
        objectArray = list.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            SubPath subPath = (SubPath)objectArray[i];
            for (int j = i + 1; j < objectArray.length; ++j) {
                SubPath subPath2 = (SubPath)objectArray[j];
                if (!subPath2.bounds.overlap(subPath.bounds)) continue;
                this.isectPathPair(subPath, subPath2);
            }
        }
        if (this.isectList.size() > 0) {
            this.savedPath = this.copyPath(this.path);
            this.splitIsectSegs();
            this.deleteBadSegs();
            this.buildNewPaths();
            ++this.debugNumGlyphsWithOverlaps;
        } else {
            this.newPath = this.path;
        }
    }

    private void addPath(List list, SubPath subPath) {
        int n = list.size();
        if (n > 0) {
            SubPath subPath2 = (SubPath)list.get(n - 1);
            subPath.nextSubPath = subPath2.nextSubPath;
            subPath2.nextSubPath = subPath;
        } else {
            subPath.nextSubPath = subPath;
        }
        list.add(subPath);
    }

    private List copyPath(List list) throws ISectException {
        ArrayList<SubPath> arrayList = new ArrayList<SubPath>();
        for (SubPath subPath : list) {
            SubPath subPath2 = new SubPath();
            subPath2.copySubPath(subPath);
            arrayList.add(subPath2);
        }
        return arrayList;
    }

    private void generateOutline(List list) {
        Segment segment;
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        if (this.savedPath != null) {
            boolean bl = false;
            int n = this.segList.size();
            while (iterator.hasNext() && !bl) {
                SubPath subPath = (SubPath)iterator.next();
                if (subPath == null) continue;
                segment = subPath.firstSegment;
                if (segment == null) {
                    return;
                }
                int n2 = 0;
                do {
                    if (++n2 <= n) continue;
                    list = this.savedPath;
                    bl = true;
                } while ((segment = segment.nextSeg()) != subPath.firstSegment && !bl);
            }
        }
        for (SubPath subPath : list) {
            if (subPath == null) continue;
            Segment segment2 = subPath.firstSegment;
            if (segment2 == null) {
                return;
            }
            boolean bl = true;
            do {
                if (segment2 instanceof Line) {
                    segment = (Line)segment2;
                    if (bl) {
                        this.oc.moveto(((Line)segment).p0.x, ((Line)segment).p0.y);
                        bl = false;
                    }
                    if (segment2 == subPath.lastSegment) continue;
                    this.oc.lineto(((Line)segment).p1.x, ((Line)segment).p1.y);
                    continue;
                }
                if (!(segment2 instanceof Curve)) continue;
                segment = (Curve)segment2;
                if (bl) {
                    this.oc.moveto(((Curve)segment).p0.x, ((Curve)segment).p0.y);
                    bl = false;
                }
                this.oc.curveto(((Curve)segment).p1.x, ((Curve)segment).p1.y, ((Curve)segment).p2.x, ((Curve)segment).p2.y, ((Curve)segment).p3.x, ((Curve)segment).p3.y);
            } while ((segment2 = segment2.nextSeg()) != subPath.firstSegment);
        }
    }

    public void setMatrix(Matrix matrix) {
        this.oc.setMatrix(matrix);
    }

    public void moveto(double d, double d2) {
        if (this.currentSubPath != null && this.currentSubPath.getNumSegments() > 0) {
            this.currentSubPath.closepath(this.cpx, this.cpy);
            this.addPath(this.path, this.currentSubPath);
        }
        this.currentSubPath = new SubPath((float)d, (float)d2);
        this.cpx = (float)d;
        this.cpy = (float)d2;
    }

    public void lineto(double d, double d2) {
        if (d == (double)this.cpx && d2 == (double)this.cpy) {
            return;
        }
        if (this.currentSubPath == null) {
            this.moveto(0.0, 0.0);
        }
        Line line = new Line(this.cpx, this.cpy, (float)d, (float)d2);
        this.currentSubPath.addSegment(line, true);
        this.cpx = (float)d;
        this.cpy = (float)d2;
    }

    public void curveto(double d, double d2, double d3, double d4) {
        this.curveto(Math.round(((double)this.cpx + 2.0 * d) / 3.0), Math.round(((double)this.cpy + 2.0 * d2) / 3.0), Math.round((2.0 * d + d3) / 3.0), Math.round((2.0 * d2 + d4) / 3.0), Math.round(d3), Math.round(d4));
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.currentSubPath == null) {
            this.moveto(0.0, 0.0);
        }
        Curve curve = new Curve(this.cpx, this.cpy, (float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
        this.currentSubPath.addSegment(curve, true);
        this.cpx = (float)d5;
        this.cpy = (float)d6;
    }

    public void reset() {
        this.currentSubPath = null;
        this.path.clear();
        this.savedPath = null;
        this.newPath = null;
        this.isectList = null;
        this.segList.clear();
        this.cpx = 0.0f;
        this.cpy = 0.0f;
    }

    public void endchar() {
        if (this.currentSubPath != null && this.currentSubPath.getNumSegments() > 0) {
            this.currentSubPath.closepath(this.cpx, this.cpy);
            this.addPath(this.path, this.currentSubPath);
        }
        try {
            this.isectPath();
        }
        catch (ISectException iSectException) {
            ++this.debugNumFailures;
            this.newPath = this.savedPath;
        }
        this.generateOutline(this.newPath);
        this.oc.endchar();
        this.reset();
    }

    public int getNumErrors() {
        return this.debugNumFailures;
    }

    private class SubPath {
        Rect bounds;
        Point startPoint;
        boolean pathISected;
        Segment firstSegment;
        Segment lastSegment;
        int numSegments;
        SubPath nextSubPath;

        SubPath() {
            this.bounds = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
            this.startPoint = null;
            this.firstSegment = null;
            this.lastSegment = null;
            this.numSegments = 0;
            this.nextSubPath = null;
            this.pathISected = false;
        }

        SubPath(float f, float f2) {
            this.bounds = new Rect(f, f2, f, f2);
            this.startPoint = new Point(f, f2);
            this.firstSegment = null;
            this.lastSegment = null;
            this.numSegments = 0;
            this.nextSubPath = null;
            this.pathISected = false;
        }

        public String toString() {
            String string = "Num Segments:" + this.numSegments;
            if (this.numSegments == 0) {
                return string;
            }
            Segment segment = this.firstSegment;
            do {
                string = string + segment.toString() + "\n";
            } while ((segment = segment.nextSeg()) != this.firstSegment);
            return string;
        }

        private int getNumSegments() {
            return this.numSegments;
        }

        private void addSegment(Segment segment, boolean bl) {
            if (bl) {
                NonOverlappingOutlineConsumer.this.segList.add(segment);
            }
            segment.subPath = this;
            if (this.lastSegment == null) {
                this.firstSegment = segment;
                this.lastSegment = segment;
                segment.link(segment);
            } else {
                this.lastSegment.link(segment);
                this.lastSegment = segment;
            }
            this.bounds.grow(segment.getBounds());
            ++this.numSegments;
        }

        private void copySubPath(SubPath subPath) throws ISectException {
            Segment segment = subPath.firstSegment;
            if (subPath.firstSegment.subPath == this) {
                return;
            }
            int n = NonOverlappingOutlineConsumer.this.segList.size();
            do {
                Segment segment2 = segment.copySegment();
                segment = segment.nextSeg();
                this.addSegment(segment2, true);
                if (this.numSegments <= n) continue;
                throw new ISectException("error - infinite loop");
            } while (segment != subPath.firstSegment);
        }

        private void addSegments(Segment segment) throws ISectException {
            int n = NonOverlappingOutlineConsumer.this.segList.size();
            if (segment.subPath == this) {
                return;
            }
            Segment segment2 = segment;
            do {
                segment2 = segment.nextSeg();
                this.addSegment(segment, false);
                if (this.numSegments > n) {
                    throw new ISectException("error - infinite loop");
                }
                segment = segment2;
            } while (segment.subPath != this);
        }

        private void splitSegment(Segment segment, Segment segment2) {
            NonOverlappingOutlineConsumer.this.segList.add(segment2);
            segment2.subPath = this;
            segment.link(segment2);
            ++this.numSegments;
        }

        private void replaceSegment(Segment segment, Segment segment2) {
            NonOverlappingOutlineConsumer.this.segList.add(segment2);
            segment2.subPath = this;
            segment.replace(segment2);
        }

        private void removeSegment(Segment segment) throws ISectException {
            if (segment.subPath == this) {
                if (this.numSegments == 1) {
                    if (this.firstSegment == segment) {
                        this.firstSegment = null;
                        this.lastSegment = null;
                    } else {
                        throw new ISectException("error - cant handle");
                    }
                }
                if (segment == this.firstSegment) {
                    this.firstSegment = segment.nextSeg();
                }
                if (segment == this.lastSegment) {
                    this.lastSegment = segment.prevSeg();
                }
                segment.remove();
                --this.numSegments;
            }
        }

        private void closepath(float f, float f2) {
            if (Math2.epsilonEquals(this.startPoint.x, f) && Math2.epsilonEquals(this.startPoint.y, f2)) {
                return;
            }
            Point point = new Point(f, f2);
            Line line = new Line(point, this.startPoint);
            this.addSegment(line, true);
        }
    }

    private class Intersect {
        float t;
        Point p;
        Segment seg;
        Segment splitSeg;
        long id;

        Intersect(float f, Point point, Segment segment, Segment segment2, long l) {
            this.p = point;
            this.t = f;
            this.seg = segment;
            this.splitSeg = segment2;
            this.id = l;
        }

        public String toString() {
            String string = "Isect point:" + this.p.toString() + ") t: " + this.t + "\n";
            if (this.seg != null) {
                string = string + "Segment:" + this.seg.toString() + "\n";
            }
            if (this.splitSeg != null) {
                string = string + "Split Segment:" + this.splitSeg.toString() + "\n";
            }
            return string;
        }

        private int cmpIds(Intersect intersect) {
            if (this.id < intersect.id) {
                return -1;
            }
            if (this.id > intersect.id) {
                return 1;
            }
            return 0;
        }

        private int cmpSegs(Intersect intersect) {
            int n;
            int n2 = NonOverlappingOutlineConsumer.this.segList.indexOf(this.seg);
            if (n2 < (n = NonOverlappingOutlineConsumer.this.segList.indexOf(intersect.seg))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            if (this.t < intersect.t) {
                return -1;
            }
            if (this.t > intersect.t) {
                return 1;
            }
            return 0;
        }
    }

    private static class IDComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private IDComparator() {
        }

        public int compare(Object object, Object object2) {
            Intersect intersect = (Intersect)object;
            Intersect intersect2 = (Intersect)object2;
            return intersect.cmpIds(intersect2);
        }

        boolean equals(Object object, Object object2) {
            Intersect intersect = (Intersect)object;
            Intersect intersect2 = (Intersect)object2;
            return intersect.cmpIds(intersect2) == 0;
        }
    }

    private static class SegComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SegComparator() {
        }

        public int compare(Object object, Object object2) {
            Intersect intersect = (Intersect)object;
            Intersect intersect2 = (Intersect)object2;
            return intersect.cmpSegs(intersect2);
        }

        boolean equals(Object object, Object object2) {
            Intersect intersect = (Intersect)object;
            Intersect intersect2 = (Intersect)object2;
            return intersect.cmpSegs(intersect2) == 0;
        }
    }

    private static abstract class Segment {
        SubPath subPath;
        int flags;
        Segment nextSegment;
        Segment prevSegment;
        Segment origSeg;

        private Segment() {
        }

        abstract Rect getBounds();

        abstract void setBounds();

        abstract Point getLastPoint();

        abstract Point getFirstPoint();

        abstract int getID();

        abstract void roundControlPoints(float var1);

        abstract boolean horizontal();

        abstract int getWindingX();

        abstract int getWindingY();

        abstract boolean equalControlPoints(Segment var1);

        abstract boolean reverseControlPoints(Segment var1);

        abstract Segment copySegment();

        abstract List solveAtX(float var1);

        abstract List solveAtY(float var1);

        public abstract String toString();

        private Segment nextSeg() {
            return this.nextSegment;
        }

        private Segment prevSeg() {
            return this.prevSegment;
        }

        private void link(Segment segment) {
            if (segment == this) {
                this.nextSegment = this;
                this.prevSegment = this;
            } else {
                segment.nextSegment = this.nextSegment;
                this.nextSegment.prevSegment = segment;
                segment.prevSegment = this;
                this.nextSegment = segment;
            }
        }

        private void relink(Segment segment) {
            this.nextSegment = segment;
            segment.prevSegment = this;
        }

        private void replace(Segment segment) {
            segment.nextSegment = this.nextSegment;
            segment.prevSegment = this.prevSegment;
        }

        private void remove() {
            this.prevSegment.nextSegment = this.nextSegment;
            this.nextSegment.prevSegment = this.prevSegment;
        }

        private void round(float f) {
            this.roundControlPoints(f);
            this.setBounds();
        }

        static int getWinding(float f, float f2) {
            return f > f2 ? 1 : -1;
        }

        static int getWindingAtValue(float f, float f2, float f3) {
            if (f3 < f && f3 < f2 || f3 > f && f3 > f2) {
                return 0;
            }
            return f > f2 ? 1 : -1;
        }
    }

    private static class Curve
    extends Segment {
        Point p0;
        Point p1;
        Point p2;
        Point p3;
        float t0;
        float t1;
        long depth;
        Rect bounds;
        int id;

        Curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.p0 = new Point(f, f2);
            this.p1 = new Point(f3, f4);
            this.p2 = new Point(f5, f6);
            this.p3 = new Point(f7, f8);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.depth = 0L;
            this.setBounds();
        }

        Curve(Point point, Point point2, Point point3, Point point4) {
            this.p0 = new Point(point);
            this.p1 = new Point(point2);
            this.p2 = new Point(point3);
            this.p3 = new Point(point4);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.depth = 0L;
            this.setBounds();
        }

        public String toString() {
            String string = (this.flags & 1) != 0 ? "Delete," : "";
            string = (this.flags & 4) != 0 ? string + " WindTested" : string;
            String string2 = "Point p0:" + this.p0.toString() + " Point p1:" + this.p1.toString() + "Point p2:" + this.p2.toString() + " Point p3:" + this.p3.toString() + "t0:" + this.t0 + " t1:" + this.t1 + "flag:" + string + " bounds:" + this.bounds.toString();
            return string2;
        }

        int getID() {
            return this.id;
        }

        private Limit getBezLimit(float f, float f2, float f3, float f4, float f5, float f6) {
            float f7;
            float[] fArray = new float[2];
            int n = 0;
            float f8 = f4 - 3.0f * (f3 - f2) - f;
            float f9 = f3 - 2.0f * f2 + f;
            float f10 = f2 - f;
            float f11 = f5;
            float f12 = f6;
            if (f8 == 0.0f) {
                if (f9 != 0.0f) {
                    fArray[n++] = -f10 / (2.0f * f9);
                }
            } else {
                f7 = f9 * f9 - f8 * f10;
                if (f7 >= 0.0f) {
                    f7 = (float)Math.sqrt(f7);
                    fArray[n++] = (-f9 + f7) / f8;
                    fArray[n++] = (-f9 - f7) / f8;
                }
            }
            --n;
            while (n >= 0) {
                if (fArray[n] > 0.0f && fArray[n] < 1.0f) {
                    f7 = fArray[n] * (fArray[n] * (fArray[n] * f8 + 3.0f * f9) + 3.0f * f10) + f;
                    if (f7 < f5) {
                        f11 = f7;
                    } else if (f7 > f6) {
                        f12 = f7;
                    }
                }
                --n;
            }
            Limit limit = new Limit(f11, f12);
            return limit;
        }

        Point getFirstPoint() {
            return this.p0;
        }

        Point getLastPoint() {
            return this.p3;
        }

        boolean horizontal() {
            return Math.abs(this.p3.x - this.p0.x) > Math.abs(this.p3.y - this.p0.y);
        }

        boolean equalControlPoints(Segment segment) {
            if (segment instanceof Curve) {
                Curve curve = (Curve)segment;
                return Math2.epsilonEquals(this.p0.x, curve.p0.x) && Math2.epsilonEquals(this.p0.y, curve.p0.y) && Math2.epsilonEquals(this.p1.x, curve.p1.x) && Math2.epsilonEquals(this.p1.y, curve.p1.y) && Math2.epsilonEquals(this.p2.x, curve.p2.x) && Math2.epsilonEquals(this.p2.y, curve.p2.y) && Math2.epsilonEquals(this.p3.x, curve.p3.x) && Math2.epsilonEquals(this.p3.y, curve.p3.y);
            }
            return false;
        }

        boolean reverseControlPoints(Segment segment) {
            if (segment instanceof Curve) {
                Curve curve = (Curve)segment;
                return Math2.epsilonEquals(this.p0.x, curve.p3.x) && Math2.epsilonEquals(this.p0.y, curve.p3.y) && Math2.epsilonEquals(this.p1.x, curve.p2.x) && Math2.epsilonEquals(this.p1.y, curve.p2.y) && Math2.epsilonEquals(this.p2.x, curve.p1.x) && Math2.epsilonEquals(this.p2.y, curve.p1.y) && Math2.epsilonEquals(this.p3.x, curve.p0.x) && Math2.epsilonEquals(this.p3.y, curve.p0.y);
            }
            return false;
        }

        Segment copySegment() {
            Curve curve = new Curve(this.p0, this.p1, this.p2, this.p3);
            curve.t0 = this.t0;
            curve.t1 = this.t1;
            curve.id = this.id;
            curve.flags = this.flags;
            curve.origSeg = this.origSeg;
            return curve;
        }

        void roundControlPoints(float f) {
            this.p0.x = Math.round(this.p0.x);
            this.p0.y = Math.round(this.p0.y);
            this.p1.x = Math.round(this.p1.x);
            this.p1.y = Math.round(this.p1.y);
            this.p2.x = Math.round(this.p2.x);
            this.p2.y = Math.round(this.p2.y);
            this.p3.x = Math.round(this.p3.x);
            this.p3.y = Math.round(this.p3.y);
            if (this.isLine(f)) {
                this.makeLine();
            }
        }

        void setBounds() {
            Limit limit;
            Line line = new Line(this.p0, this.p3);
            Rect rect = line.getBounds();
            if (this.p1.x < rect.left || this.p1.x > rect.right || this.p2.x < rect.left || this.p2.x > rect.right) {
                limit = this.getBezLimit(this.p0.x, this.p1.x, this.p2.x, this.p3.x, rect.left, rect.right);
                rect.left = limit.min;
                rect.right = limit.max;
            }
            if (this.p1.y < rect.bottom || this.p1.y > rect.top || this.p2.y < rect.bottom || this.p2.y > rect.top) {
                limit = this.getBezLimit(this.p0.y, this.p1.y, this.p2.y, this.p3.y, rect.bottom, rect.top);
                rect.bottom = limit.min;
                rect.top = limit.max;
            }
            this.bounds = rect;
        }

        Rect getBounds() {
            if (this.bounds != null) {
                return this.bounds;
            }
            this.setBounds();
            return this.bounds;
        }

        private Point computeISectPoint(float f) {
            float f2 = f * (f * (f * (this.p3.x - 3.0f * (this.p2.x - this.p1.x) - this.p0.x) + 3.0f * (this.p2.x - 2.0f * this.p1.x + this.p0.x)) + 3.0f * (this.p1.x - this.p0.x)) + this.p0.x;
            float f3 = f * (f * (f * (this.p3.y - 3.0f * (this.p2.y - this.p1.y) - this.p0.y) + 3.0f * (this.p2.y - 2.0f * this.p1.y + this.p0.y)) + 3.0f * (this.p1.y - this.p0.y)) + this.p0.y;
            return new Point(f2, f3);
        }

        private boolean isLine(float f) {
            float f2 = this.p3.y - this.p0.y;
            float f3 = this.p3.x - this.p0.x;
            if (Math.abs(f2) <= 1.0f && Math.abs(f3) <= 1.0f) {
                return true;
            }
            float f4 = f2 * (this.p1.x - this.p0.x) + f3 * (this.p0.y - this.p1.y);
            float f5 = f2 * (this.p2.x - this.p0.x) + f3 * (this.p0.y - this.p2.y);
            float f6 = NonOverlappingOutlineConsumer.milliem(f, 1.0f);
            return f4 * f4 + f5 * f5 < f6 * f6 * (f2 * f2 + f3 * f3);
        }

        private Line makeLine() {
            Line line = new Line(this.p0.x, this.p0.y, this.p3.x, this.p3.y);
            line.id = this.id;
            line.t0 = this.t0;
            line.t1 = this.t1;
            line.origSeg = this.origSeg;
            return line;
        }

        private List splitAtT(float f) {
            ArrayList<Curve> arrayList = new ArrayList<Curve>(2);
            float f2 = this.p0.x;
            float f3 = this.p0.y;
            float f4 = f * (this.p1.x - this.p0.x) + f2;
            float f5 = f * (this.p1.y - this.p0.y) + f3;
            float f6 = f * f * (this.p2.x - 2.0f * this.p1.x + this.p0.x) + 2.0f * f4 - f2;
            float f7 = f * f * (this.p2.y - 2.0f * this.p1.y + this.p0.y) + 2.0f * f5 - f3;
            float f8 = f * f * f * (this.p3.x - 3.0f * (this.p2.x - this.p1.x) - this.p0.x) + 3.0f * (f6 - f4) + f2;
            float f9 = f * f * f * (this.p3.y - 3.0f * (this.p2.y - this.p1.y) - this.p0.y) + 3.0f * (f7 - f5) + f3;
            Curve curve = new Curve(f2, f3, f4, f5, f6, f7, f8, f9);
            curve.t0 = 0.0f;
            curve.t1 = f;
            curve.origSeg = this.origSeg;
            arrayList.add(curve);
            f = 1.0f - f;
            float f10 = this.p3.x;
            float f11 = this.p3.y;
            float f12 = f * (this.p2.x - this.p3.x) + f10;
            float f13 = f * (this.p2.y - this.p3.y) + f11;
            float f14 = f * f * (this.p1.x - 2.0f * this.p2.x + this.p3.x) + 2.0f * f12 - f10;
            float f15 = f * f * (this.p1.y - 2.0f * this.p2.y + this.p3.y) + 2.0f * f13 - f11;
            float f16 = f8;
            float f17 = f9;
            Curve curve2 = new Curve(f16, f17, f14, f15, f12, f13, f10, f11);
            curve2.t0 = f;
            curve2.t1 = 1.0f;
            curve2.origSeg = this.origSeg;
            arrayList.add(curve2);
            return arrayList;
        }

        private List splitMid() {
            Point point = new Point();
            Point point2 = new Point();
            Point point3 = new Point();
            Point point4 = new Point();
            ArrayList<Curve> arrayList = new ArrayList<Curve>(2);
            point.x = (this.p2.x + this.p3.x) / 2.0f;
            point.y = (this.p2.y + this.p3.y) / 2.0f;
            point2.x = (this.p1.x + this.p2.x) / 2.0f;
            point2.y = (this.p1.y + this.p2.y) / 2.0f;
            point3.x = (this.p0.x + this.p1.x) / 2.0f;
            point3.y = (this.p0.y + this.p1.y) / 2.0f;
            point4.x = (point.x + 2.0f * point2.x + point3.x) / 4.0f;
            point4.y = (point.y + 2.0f * point2.y + point3.y) / 4.0f;
            float f = (this.t0 + this.t1) / 2.0f;
            Curve curve = new Curve(this.p0.x, this.p0.y, point3.x, point3.y, (point2.x + point3.x) / 2.0f, (point2.y + point3.y) / 2.0f, point4.x, point4.y);
            curve.t0 = this.t0;
            curve.t1 = f;
            curve.depth = this.depth + 1L;
            curve.origSeg = this.origSeg;
            arrayList.add(curve);
            curve = new Curve(point4.x, point4.y, (point.x + point2.x) / 2.0f, (point.y + point2.y) / 2.0f, point.x, point.y, this.p3.x, this.p3.y);
            curve.t0 = f;
            curve.t1 = this.t1;
            curve.depth = this.depth;
            curve.origSeg = this.origSeg;
            arrayList.add(curve);
            return arrayList;
        }

        private boolean isFlatEnough(float f) {
            if (this.depth == 6L) {
                return true;
            }
            if (Math.abs(this.bounds.right - this.bounds.left) > NonOverlappingOutlineConsumer.milliem(f, 127.0f) || Math.abs(this.bounds.top - this.bounds.bottom) > NonOverlappingOutlineConsumer.milliem(f, 127.0f)) {
                this.depth = 0L;
                return false;
            }
            if ((this.p0.x > this.p1.x || this.p1.x > this.p2.x || this.p2.x > this.p3.x) && (this.p3.x > this.p2.x || this.p2.x > this.p1.x || this.p1.x > this.p0.x) || (this.p0.y > this.p1.y || this.p1.y > this.p2.y || this.p2.y > this.p3.y) && (this.p3.y > this.p2.y || this.p2.y > this.p1.y || this.p1.y > this.p0.y)) {
                return false;
            }
            float f2 = NonOverlappingOutlineConsumer.milliem(f, 9.0f);
            float f3 = Math.abs(this.p1.x - this.p0.x);
            float f4 = Math.abs(this.p3.x - this.p0.x);
            if (Math.abs(f4 - 3.0f * f3) > f2) {
                return false;
            }
            float f5 = Math.abs(this.p2.x - this.p0.x);
            if (Math.abs(2.0f * (f4 - f5) - f5) > f2) {
                return false;
            }
            float f6 = Math.abs(this.p1.y - this.p0.y);
            float f7 = Math.abs(this.p3.y - this.p0.y);
            if (Math.abs(f7 - 3.0f * f6) > f2) {
                return false;
            }
            float f8 = Math.abs(this.p2.y - this.p0.y);
            return !(Math.abs(2.0f * (f7 - f8) - f8) > f2);
        }

        private List findExtrema(float f, float f2, float f3, float f4) {
            float[] fArray = new float[2];
            int n = 0;
            int n2 = 0;
            float f5 = f4 - 3.0f * (f3 - f2) - f;
            float f6 = f3 - 2.0f * f2 + f;
            float f7 = f2 - f;
            if (f5 == 0.0f) {
                if (f6 != 0.0f) {
                    fArray[n++] = -f7 / (2.0f * f6);
                }
            } else {
                float f8 = f6 * f6 - f5 * f7;
                if (f8 >= 0.0f) {
                    f8 = (float)Math.sqrt(f8);
                    fArray[n++] = (-f6 + f8) / f5;
                    fArray[n++] = (-f6 - f8) / f5;
                }
            }
            float[] fArray2 = new float[2];
            --n;
            while (n >= 0) {
                if (0.0f < fArray[n] && fArray[n] < 1.0f) {
                    fArray2[n2++] = fArray[n];
                }
                --n;
            }
            if (n2 == 2 && fArray2[0] > fArray2[1]) {
                fArray2[0] = fArray[1];
                fArray2[1] = fArray[0];
            }
            ArrayList<Float> arrayList = new ArrayList<Float>();
            for (n = 0; n < n2; ++n) {
                Float f9 = new Float(fArray2[n]);
                arrayList.add(f9);
            }
            return arrayList;
        }

        private float solveAtValue(float f, float f2, float f3, float f4, float f5) {
            float f6;
            float f7;
            float f8 = f2 - 3.0f * (f3 - f4) - f5;
            float f9 = 3.0f * (f3 - 2.0f * f4 + f5);
            float f10 = 3.0f * (f4 - f5);
            float f11 = 0.0f;
            float f12 = 1.0f;
            while (!((double)Math.abs(f7 = (f6 = (f11 + f12) / 2.0f) * (f6 * (f6 * f8 + f9) + f10) + f5 - f) < 0.01)) {
                if (f7 < 0.0f) {
                    f11 = f6;
                    continue;
                }
                f12 = f6;
            }
            return f6;
        }

        List solveAtY(float f) {
            List list = this.findExtrema(this.p3.y, this.p2.y, this.p1.y, this.p0.y);
            int n = list.size();
            Curve[] curveArray = new Curve[n + 1];
            if (n > 0) {
                Float f2 = (Float)list.get(0);
                List list2 = this.splitAtT(f2.floatValue());
                curveArray[0] = (Curve)list2.get(0);
                curveArray[1] = (Curve)list2.get(1);
                if (n > 1) {
                    Float f3 = (Float)list.get(1);
                    float f4 = (f3.floatValue() - f2.floatValue()) / (1.0f - f2.floatValue());
                    List list3 = curveArray[1].splitAtT(f4);
                    curveArray[1] = (Curve)list3.get(0);
                    curveArray[2] = (Curve)list2.get(1);
                }
            } else {
                curveArray[0] = new Curve(this.p0, this.p1, this.p2, this.p3);
            }
            ArrayList<ICept> arrayList = new ArrayList<ICept>();
            for (int i = 0; i <= n; ++i) {
                float f5;
                Point point;
                Point point2;
                Point point3;
                Point point4;
                if (curveArray[i].p3.y > curveArray[i].p0.y) {
                    point4 = curveArray[i].p0;
                    point3 = curveArray[i].p1;
                    point2 = curveArray[i].p2;
                    point = curveArray[i].p3;
                } else {
                    point4 = curveArray[i].p3;
                    point3 = curveArray[i].p2;
                    point2 = curveArray[i].p1;
                    point = curveArray[i].p0;
                }
                int n2 = curveArray[i].getWindingY();
                if (f < point4.y || f > point.y) continue;
                if (Math2.epsilonEquals(f, point4.y)) {
                    f5 = point4.x;
                } else if (Math2.epsilonEquals(f, point.y)) {
                    f5 = point.x;
                } else {
                    float f6 = this.solveAtValue(f, point.y, point2.y, point3.y, point4.y);
                    f5 = f6 * (f6 * (f6 * (point.x - 3.0f * (point2.x - point3.x) - point4.x) + 3.0f * (point2.x - 2.0f * point3.x + point4.x)) + 3.0f * (point3.x - point4.x)) + point4.x;
                }
                ICept iCept = new ICept(f5, n2);
                arrayList.add(iCept);
            }
            return arrayList;
        }

        List solveAtX(float f) {
            List list = this.findExtrema(this.p3.x, this.p2.x, this.p1.x, this.p0.x);
            int n = list.size();
            Curve[] curveArray = new Curve[n + 1];
            if (n > 0) {
                Float f2 = (Float)list.get(0);
                List list2 = this.splitAtT(f2.floatValue());
                curveArray[0] = (Curve)list2.get(0);
                curveArray[1] = (Curve)list2.get(1);
                if (n > 1) {
                    Float f3 = (Float)list.get(1);
                    float f4 = (f3.floatValue() - f2.floatValue()) / (1.0f - f2.floatValue());
                    List list3 = curveArray[1].splitAtT(f4);
                    curveArray[1] = (Curve)list3.get(0);
                    curveArray[2] = (Curve)list2.get(1);
                }
            } else {
                curveArray[0] = new Curve(this.p0, this.p1, this.p2, this.p3);
            }
            ArrayList<ICept> arrayList = new ArrayList<ICept>();
            for (int i = 0; i <= n; ++i) {
                float f5;
                Point point;
                Point point2;
                Point point3;
                Point point4;
                if (curveArray[i].p3.x > curveArray[i].p0.x) {
                    point4 = curveArray[i].p0;
                    point3 = curveArray[i].p1;
                    point2 = curveArray[i].p2;
                    point = curveArray[i].p3;
                } else {
                    point4 = curveArray[i].p3;
                    point3 = curveArray[i].p2;
                    point2 = curveArray[i].p1;
                    point = curveArray[i].p0;
                }
                int n2 = curveArray[i].getWindingX();
                if (f < point4.x || f > point.x) continue;
                if (Math2.epsilonEquals(f, point4.x)) {
                    f5 = point4.y;
                } else if (Math2.epsilonEquals(f, point.x)) {
                    f5 = point.y;
                } else {
                    float f6 = this.solveAtValue(f, point.x, point2.x, point3.x, point4.x);
                    f5 = f6 * (f6 * (f6 * (point.y - 3.0f * (point2.y - point3.y) - point4.y) + 3.0f * (point2.y - 2.0f * point3.y + point4.y)) + 3.0f * (point3.y - point4.y)) + point4.y;
                }
                ICept iCept = new ICept(f5, n2);
                arrayList.add(iCept);
            }
            return arrayList;
        }

        int getWindingX() {
            return Curve.getWinding(this.p0.x, this.p3.x);
        }

        int getWindingY() {
            return Curve.getWinding(this.p0.y, this.p3.y);
        }

        private static class Limit {
            float min;
            float max;

            Limit(float f, float f2) {
                this.min = f;
                this.max = f2;
            }
        }
    }

    private static class Line
    extends Segment {
        Point p0;
        Point p1;
        float t0;
        float t1;
        Rect bounds;
        int id;

        Line(float f, float f2, float f3, float f4) {
            this.p0 = new Point(f, f2);
            this.p1 = new Point(f3, f4);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.setBounds();
        }

        Line(Point point, Point point2) {
            this.p0 = new Point(point);
            this.p1 = new Point(point2);
            this.t0 = 0.0f;
            this.t1 = 1.0f;
            this.setBounds();
        }

        public String toString() {
            String string = (this.flags & 1) != 0 ? "Delete," : "";
            string = (this.flags & 4) != 0 ? string + " WindTested" : string;
            String string2 = "Point p0:" + this.p0.toString() + " Point p1:" + this.p1.toString() + "t0:" + this.t0 + " t1:" + this.t1 + "flag:" + string + " bounds:" + this.bounds.toString();
            return string2;
        }

        int getID() {
            return this.id;
        }

        Point getFirstPoint() {
            return this.p0;
        }

        Point getLastPoint() {
            return this.p1;
        }

        boolean horizontal() {
            return Math.abs(this.p1.x - this.p0.x) > Math.abs(this.p1.y - this.p0.y);
        }

        void setBounds() {
            float f;
            float f2;
            float f3;
            float f4;
            if (this.p0.x < this.p1.x) {
                f4 = this.p0.x;
                f3 = this.p1.x;
            } else {
                f3 = this.p0.x;
                f4 = this.p1.x;
            }
            if (this.p0.y < this.p1.y) {
                f2 = this.p0.y;
                f = this.p1.y;
            } else {
                f = this.p0.y;
                f2 = this.p1.y;
            }
            this.bounds = new Rect(f4, f2, f3, f);
        }

        void roundControlPoints(float f) {
            this.p0.x = Math.round(this.p0.x);
            this.p0.y = Math.round(this.p0.y);
            this.p1.x = Math.round(this.p1.x);
            this.p1.y = Math.round(this.p1.y);
        }

        Rect getBounds() {
            if (this.bounds != null) {
                return this.bounds;
            }
            this.setBounds();
            return this.bounds;
        }

        boolean equalControlPoints(Segment segment) {
            if (segment instanceof Line) {
                Line line = (Line)segment;
                return Math2.epsilonEquals(this.p0.x, line.p0.x) && Math2.epsilonEquals(this.p0.y, line.p0.y) && Math2.epsilonEquals(this.p1.x, line.p1.x) && Math2.epsilonEquals(this.p1.y, line.p1.y);
            }
            return false;
        }

        boolean reverseControlPoints(Segment segment) {
            if (segment instanceof Line) {
                Line line = (Line)segment;
                return Math2.epsilonEquals(this.p0.x, line.p1.x) && Math2.epsilonEquals(this.p0.y, line.p1.y) && Math2.epsilonEquals(this.p1.x, line.p0.x) && Math2.epsilonEquals(this.p1.y, line.p0.y);
            }
            return false;
        }

        Segment copySegment() {
            Line line = new Line(this.p0, this.p1);
            line.t0 = this.t0;
            line.t1 = this.t1;
            line.id = this.id;
            line.flags = this.flags;
            line.origSeg = this.origSeg;
            return line;
        }

        private Point computeISectPoint(float f) {
            float f2 = this.p0.x + f * (this.p1.x - this.p0.x);
            float f3 = this.p0.y + f * (this.p1.y - this.p0.y);
            return new Point(f2, f3);
        }

        private boolean iSectRect(Rect rect) {
            int n = this.p0.x < rect.left ? 1 : (this.p0.x > rect.right ? 2 : 0);
            if (this.p0.y > rect.top) {
                n |= 8;
            } else if (this.p0.y < rect.bottom) {
                n |= 4;
            }
            if (n == 0) {
                return true;
            }
            int n2 = this.p1.x < rect.left ? 1 : (this.p1.x > rect.right ? 2 : 0);
            if (this.p1.y > rect.top) {
                n2 |= 8;
            } else if (this.p1.y < rect.bottom) {
                n2 |= 4;
            }
            if (n2 == 0) {
                return true;
            }
            return (n & n2) == 0;
        }

        private List iSectLine(Line line) {
            float f = this.p1.y - this.p0.y;
            float f2 = this.p1.x - this.p0.x;
            float f3 = line.p1.y - line.p0.y;
            float f4 = line.p1.x - line.p0.x;
            float f5 = f3 * f2 - f4 * f;
            float f6 = this.p0.y - line.p0.y;
            float f7 = this.p0.x - line.p0.x;
            float f8 = f4 * f6 - f3 * f7;
            ArrayList<float[]> arrayList = new ArrayList<float[]>();
            if (f5 == 0.0f) {
                if (f8 == 0.0f) {
                    Rect rect = line.getBounds();
                    if (!this.bounds.overlap(rect)) {
                        return arrayList;
                    }
                    Rect rect2 = this.bounds.iSect(rect);
                    if (rect2.left == rect2.right && rect2.bottom == rect2.top) {
                        float[] fArray = new float[2];
                        if (f2 != 0.0f) {
                            fArray[0] = Math2.epsilonEquals(this.p1.x, rect2.left) ? 1.0f : 0.0f;
                            fArray[1] = Math2.epsilonEquals(line.p1.x, rect2.left) ? 1.0f : 0.0f;
                        } else {
                            fArray[0] = Math2.epsilonEquals(this.p1.y, rect2.bottom) ? 1.0f : 0.0f;
                            fArray[1] = Math2.epsilonEquals(line.p1.y, rect2.bottom) ? 1.0f : 0.0f;
                        }
                        arrayList.add(fArray);
                        return arrayList;
                    }
                    if (rect2.right - rect2.left > rect2.top - rect2.bottom) {
                        float[] fArray = new float[2];
                        float[] fArray2 = new float[2];
                        fArray[0] = (rect2.left - this.p0.x) / f2;
                        fArray[1] = (rect2.left - line.p0.x) / f4;
                        fArray2[0] = (rect2.right - this.p0.x) / f2;
                        fArray2[1] = (rect2.right - line.p0.x) / f4;
                        arrayList.add(fArray);
                        arrayList.add(fArray2);
                        return arrayList;
                    }
                    float[] fArray = new float[2];
                    float[] fArray3 = new float[2];
                    fArray[0] = (rect2.bottom - this.p0.y) / f;
                    fArray[1] = (rect2.bottom - line.p0.y) / f3;
                    fArray3[0] = (rect2.top - this.p0.y) / f;
                    fArray3[1] = (rect2.top - line.p0.y) / f3;
                    arrayList.add(fArray);
                    arrayList.add(fArray3);
                    return arrayList;
                }
                return arrayList;
            }
            float[] fArray = new float[2];
            fArray[0] = f8 / f5;
            if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
                return arrayList;
            }
            fArray[1] = (f2 * f6 - f * f7) / f5;
            if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
                return arrayList;
            }
            arrayList.add(fArray);
            return arrayList;
        }

        List solveAtX(float f) {
            float f2 = this.p0.y + (f - this.p0.x) * (this.p1.y - this.p0.y) / (this.p1.x - this.p0.x);
            ICept iCept = new ICept(f2, this.getWindingX());
            ArrayList<ICept> arrayList = new ArrayList<ICept>();
            arrayList.add(iCept);
            return arrayList;
        }

        List solveAtY(float f) {
            float f2 = this.p0.x + (f - this.p0.y) * (this.p1.x - this.p0.x) / (this.p1.y - this.p0.y);
            ICept iCept = new ICept(f2, this.getWindingY());
            ArrayList<ICept> arrayList = new ArrayList<ICept>();
            arrayList.add(iCept);
            return arrayList;
        }

        int getWindingX() {
            return Line.getWinding(this.p0.x, this.p1.x);
        }

        int getWindingY() {
            return Line.getWinding(this.p0.y, this.p1.y);
        }
    }

    private static class ICept {
        float ic;
        int winding;

        ICept(float f, int n) {
            this.ic = f;
            this.winding = n;
        }
    }

    private static class Rect {
        float left;
        float bottom;
        float right;
        float top;

        Rect(float f, float f2, float f3, float f4) {
            this.left = f;
            this.bottom = f2;
            this.right = f3;
            this.top = f4;
        }

        private void grow(Rect rect) {
            if (this.left > rect.left) {
                this.left = rect.left;
            }
            if (this.bottom > rect.bottom) {
                this.bottom = rect.bottom;
            }
            if (this.right < rect.right) {
                this.right = rect.right;
            }
            if (this.top < rect.top) {
                this.top = rect.top;
            }
        }

        private boolean overlap(Rect rect) {
            boolean bl = this.right < rect.left || this.left > rect.right || this.top < rect.bottom || this.bottom > rect.top;
            return !bl;
        }

        private Rect iSect(Rect rect) {
            float f = Math.max(this.left, rect.left);
            float f2 = Math.min(this.right, rect.right);
            float f3 = Math.min(this.top, rect.top);
            float f4 = Math.max(this.bottom, rect.bottom);
            return new Rect(f, f4, f2, f3);
        }

        public String toString() {
            return "left:" + this.left + " right:" + this.right + "bottom: " + this.bottom + "top: " + this.top;
        }
    }

    private static class Point {
        float x;
        float y;

        Point(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        Point() {
        }

        Point(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        public boolean equals(Point point) {
            return Math2.epsilonEquals(this.x, point.x) && Math2.epsilonEquals(this.y, point.y);
        }
    }

    private static class ISectException
    extends Exception {
        static final long serialVersionUID = 1L;

        public ISectException() {
        }

        public ISectException(String string) {
            super(string);
        }

        public ISectException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ISectException(Throwable throwable) {
            super(throwable);
        }
    }
}

