/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.Type2Consumer;
import com.adobe.fontengine.font.postscript.SeacPhase;
import com.adobe.fontengine.font.postscript.StandardEncoding;

public final class Type2Parser {
    private final double[] stack = new double[48];
    private final double[] storage = new double[32];
    private int nbHints;
    private int stackDepth;
    private int callDepth;
    private boolean widthMayBeThere;
    private SeacPhase seacPhase;
    private double seacAccentX;
    private double seacAccentY;

    private void check(boolean bl) throws InvalidGlyphException {
        if (!bl) {
            throw new InvalidGlyphException("invalid Type2 charstring");
        }
    }

    private int checkInt(double d) throws InvalidGlyphException {
        int n = (int)d;
        if ((double)n != d) {
            throw new InvalidGlyphException("unexpected non-integer value");
        }
        return n;
    }

    private boolean handleWidth(Type2Consumer type2Consumer) throws InvalidGlyphException {
        boolean bl = true;
        if (this.stackDepth == 1) {
            if (this.widthMayBeThere) {
                bl = type2Consumer.width(this.stack[0]);
            } else if (this.seacPhase == SeacPhase.seacNone) {
                throw new InvalidGlyphException("stack is non empty");
            }
            this.stackDepth = 0;
        }
        this.widthMayBeThere = false;
        return bl;
    }

    public void parse(CharStrings charStrings, int n, CharStrings charStrings2, CharStrings charStrings3, Type2Consumer type2Consumer, NameKeyedFont nameKeyedFont) throws InvalidGlyphException, UnsupportedFontException {
        int n2;
        int n3;
        this.widthMayBeThere = true;
        this.stackDepth = 0;
        this.callDepth = 0;
        this.nbHints = 0;
        this.seacPhase = SeacPhase.seacNone;
        try {
            n3 = charStrings.offsetOf(n);
            n2 = charStrings.offsetFollowing(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidGlyphException("Glyph past end of charstrings array", arrayIndexOutOfBoundsException);
        }
        try {
            boolean bl = this.parse(charStrings.data, n3, n2, charStrings2, charStrings3, type2Consumer, nameKeyedFont);
            if (bl) {
                type2Consumer.endchar(this.stack, this.stackDepth);
            }
        }
        catch (InvalidFontException invalidFontException) {
            throw new InvalidGlyphException(invalidFontException);
        }
    }

    private boolean parse(CFFByteArray cFFByteArray, int n, int n2, CharStrings charStrings, CharStrings charStrings2, Type2Consumer type2Consumer, NameKeyedFont nameKeyedFont) throws InvalidFontException, UnsupportedFontException {
        block56: while (n < n2) {
            int n3 = cFFByteArray.getcard8(n);
            ++n;
            switch (n3) {
                case 1: {
                    int n4;
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int n5 = n4 = this.stackDepth % 2 != 0 ? 1 : 0;
                        this.stack[n5] = this.stack[n5] + this.seacAccentY;
                    }
                    type2Consumer.hstem(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    n4 = this.handleWidth(type2Consumer) ? 1 : 0;
                    if (n4 != 0) continue block56;
                    return false;
                }
                case 3: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int n6;
                        int n7 = n6 = this.stackDepth % 2 != 0 ? 1 : 0;
                        this.stack[n7] = this.stack[n7] + this.seacAccentX;
                    }
                    type2Consumer.vstem(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean bl = this.handleWidth(type2Consumer);
                    if (bl) continue block56;
                    return false;
                }
                case 4: {
                    boolean bl;
                    this.check(this.stackDepth == 1 || this.stackDepth == 2);
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        if (this.stackDepth == 2) {
                            this.stack[2] = this.stack[1] + this.seacAccentY;
                            this.stack[1] = this.seacAccentX;
                        } else {
                            this.stack[1] = this.stack[0] + this.seacAccentY;
                            this.stack[0] = this.seacAccentX;
                        }
                        ++this.stackDepth;
                        type2Consumer.moveto(this.stack, this.stackDepth);
                        this.stackDepth -= 2;
                        this.seacPhase = SeacPhase.seacAccentPostMove;
                    } else {
                        type2Consumer.vmoveto(this.stack, this.stackDepth);
                        --this.stackDepth;
                    }
                    if (bl = this.handleWidth(type2Consumer)) continue block56;
                    return false;
                }
                case 5: {
                    this.check(this.stackDepth >= 2 && this.stackDepth % 2 == 0);
                    type2Consumer.rlineto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 6: {
                    this.check(this.stackDepth > 0);
                    type2Consumer.hlineto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 7: {
                    this.check(this.stackDepth > 0);
                    type2Consumer.vlineto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 8: {
                    this.check(this.stackDepth > 0 && this.stackDepth % 6 == 0);
                    type2Consumer.rrcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 10: {
                    this.check(this.stackDepth >= 1);
                    this.check(charStrings != null);
                    int n8 = this.checkInt(this.stack[--this.stackDepth]);
                    n8 = charStrings.getCount() < 1240 ? (n8 += 107) : (charStrings.getCount() < 33900 ? (n8 += 1131) : (n8 += 32768));
                    type2Consumer.callsubr(this.stack, this.stackDepth, n8);
                    ++this.callDepth;
                    boolean bl = this.parse(charStrings.data, charStrings.offsetOf(n8), charStrings.offsetFollowing(n8), charStrings, charStrings2, type2Consumer, nameKeyedFont);
                    --this.callDepth;
                    if (bl) continue block56;
                    return bl;
                }
                case 11: {
                    this.check(this.callDepth > 0);
                    type2Consumer.return_op(this.stack, this.stackDepth);
                    return true;
                }
                case 12: {
                    int n9 = cFFByteArray.getcard8(n);
                    ++n;
                    switch (n9) {
                        case 0: {
                            continue block56;
                        }
                        case 3: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.and(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d2 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d2 == 0.0 || d == 0.0 ? 0.0 : 1.0;
                            continue block56;
                        }
                        case 4: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.or(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d3 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d3 == 0.0 && d == 0.0 ? 0.0 : 1.0;
                            continue block56;
                        }
                        case 5: {
                            this.check(this.stackDepth >= 1);
                            type2Consumer.not(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d == 0.0 ? 1.0 : 0.0;
                            continue block56;
                        }
                        case 9: {
                            this.check(this.stackDepth >= 1);
                            type2Consumer.abs(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d < 0.0 ? -d : d;
                            continue block56;
                        }
                        case 10: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.add(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d4 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d4 + d;
                            continue block56;
                        }
                        case 11: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.sub(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d5 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d5 - d;
                            continue block56;
                        }
                        case 12: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.div(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d6 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d6 / d;
                            continue block56;
                        }
                        case 14: {
                            this.check(this.stackDepth >= 1);
                            type2Consumer.neg(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = -d;
                            continue block56;
                        }
                        case 15: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.eq(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d7 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d7 == d ? 1.0 : 0.0;
                            continue block56;
                        }
                        case 18: {
                            this.check(this.stackDepth >= 1);
                            type2Consumer.drop(this.stack, this.stackDepth);
                            --this.stackDepth;
                            continue block56;
                        }
                        case 20: {
                            double d;
                            this.check(this.stackDepth >= 2);
                            type2Consumer.put(this.stack, this.stackDepth);
                            int n10 = this.checkInt(this.stack[--this.stackDepth]);
                            this.storage[n10] = d = this.stack[--this.stackDepth];
                            continue block56;
                        }
                        case 21: {
                            this.check(this.stackDepth >= 1);
                            type2Consumer.get(this.stack, this.stackDepth);
                            int n11 = this.checkInt(this.stack[--this.stackDepth]);
                            this.stack[this.stackDepth++] = this.storage[n11];
                            continue block56;
                        }
                        case 22: {
                            this.check(this.stackDepth >= 4);
                            type2Consumer.ifelse(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d8 = this.stack[--this.stackDepth];
                            double d9 = this.stack[--this.stackDepth];
                            double d10 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d8 <= d ? d10 : d9;
                            continue block56;
                        }
                        case 23: {
                            this.check(this.stackDepth < this.stack.length);
                            type2Consumer.random(this.stack, this.stackDepth);
                            this.stack[this.stackDepth++] = 0.0;
                            continue block56;
                        }
                        case 24: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.mul(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d11 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d11 * d;
                            continue block56;
                        }
                        case 26: {
                            this.check(this.stackDepth >= 1);
                            type2Consumer.sqrt(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = Math.sqrt(d);
                            continue block56;
                        }
                        case 27: {
                            this.check(this.stackDepth >= 1);
                            this.check(this.stackDepth < this.stack.length);
                            type2Consumer.dup(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d;
                            this.stack[this.stackDepth++] = d;
                            continue block56;
                        }
                        case 28: {
                            this.check(this.stackDepth >= 2);
                            type2Consumer.exch(this.stack, this.stackDepth);
                            double d = this.stack[--this.stackDepth];
                            double d12 = this.stack[--this.stackDepth];
                            this.stack[this.stackDepth++] = d;
                            this.stack[this.stackDepth++] = d12;
                            continue block56;
                        }
                        case 29: {
                            this.check(this.stackDepth >= 1);
                            int n12 = this.checkInt(this.stack[this.stackDepth]);
                            this.check(this.stackDepth >= n12 + 1);
                            type2Consumer.index(this.stack, this.stackDepth);
                            --this.stackDepth;
                            this.stack[this.stackDepth++] = this.stack[this.stackDepth - n12 - 1];
                            continue block56;
                        }
                        case 30: {
                            this.check(this.stackDepth >= 2);
                            this.check(this.stack[this.stackDepth - 2] > 0.0);
                            this.check((double)this.stackDepth >= this.stack[this.stackDepth - 2] + 2.0);
                            type2Consumer.roll(this.stack, this.stackDepth);
                            int n13 = this.checkInt(this.stack[--this.stackDepth]);
                            int n14 = this.checkInt(this.stack[--this.stackDepth]);
                            if (n13 < 0) {
                                n13 = n14 - -n13 % n14;
                            }
                            int n15 = this.stackDepth - 1;
                            int n16 = this.stackDepth - n14;
                            this.reverseStackRange(n15 - (n13 %= n14) + 1, n15);
                            this.reverseStackRange(n16, n15 - n13);
                            this.reverseStackRange(n16, n15);
                            continue block56;
                        }
                        case 34: {
                            this.check(this.stackDepth == 7);
                            type2Consumer.hflex(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 35: {
                            this.check(this.stackDepth == 13);
                            type2Consumer.flex(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 36: {
                            this.check(this.stackDepth == 9);
                            type2Consumer.hflex1(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 37: {
                            this.check(this.stackDepth == 11);
                            type2Consumer.flex1(this.stack, this.stackDepth);
                            this.stackDepth = 0;
                            continue block56;
                        }
                        case 38: {
                            type2Consumer.globalColorMe(this.stack, this.stackDepth);
                            continue block56;
                        }
                    }
                    throw new InvalidGlyphException("Invalid Type2 operator (12, " + n9 + ")");
                }
                case 14: {
                    if (this.seacPhase != SeacPhase.seacNone) {
                        return false;
                    }
                    if (this.stackDepth == 4 || this.stackDepth == 5) {
                        int n17 = 0;
                        if (this.stackDepth == 5) {
                            this.stackDepth = 1;
                            if (!this.handleWidth(type2Consumer)) {
                                return false;
                            }
                            this.stackDepth = 5;
                            n17 = 1;
                        }
                        if (type2Consumer.seac(this.stack, this.stackDepth)) {
                            this.seacPhase = SeacPhase.seacBase;
                            this.seacAccentX = this.stack[n17++];
                            this.seacAccentY = this.stack[n17++];
                            int n18 = (int)this.stack[n17++];
                            int n19 = (int)this.stack[n17++];
                            if (nameKeyedFont == null) {
                                throw new InvalidGlyphException("Seac found in non-nk font");
                            }
                            n18 = nameKeyedFont.glyphName2gid(StandardEncoding.names[n18]);
                            n19 = nameKeyedFont.glyphName2gid(StandardEncoding.names[n19]);
                            this.stackDepth = 0;
                            this.parse(nameKeyedFont.charStrings.data, nameKeyedFont.charStrings.offsetOf(n18), nameKeyedFont.charStrings.offsetFollowing(n18), charStrings, charStrings2, type2Consumer, nameKeyedFont);
                            this.seacPhase = SeacPhase.seacAccentPreMove;
                            this.nbHints = 0;
                            this.stackDepth = 0;
                            this.parse(nameKeyedFont.charStrings.data, nameKeyedFont.charStrings.offsetOf(n19), nameKeyedFont.charStrings.offsetFollowing(n19), charStrings, charStrings2, type2Consumer, nameKeyedFont);
                        }
                        this.stackDepth = 0;
                    }
                    this.handleWidth(type2Consumer);
                    type2Consumer.endchar(this.stack, this.stackDepth);
                    return false;
                }
                case 18: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int n20 = this.stackDepth % 2;
                        this.stack[n20] = this.stack[n20] + this.seacAccentY;
                    }
                    type2Consumer.hstemhm(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean bl = this.handleWidth(type2Consumer);
                    if (bl) continue block56;
                    return false;
                }
                case 19: {
                    boolean bl;
                    if (this.stackDepth > 1) {
                        this.nbHints += this.stackDepth / 2;
                        if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                            int n21;
                            int n22 = n21 = this.stackDepth % 2 != 0 ? 1 : 0;
                            this.stack[n22] = this.stack[n22] + this.seacAccentX;
                        }
                        type2Consumer.implicit_vstemhm(this.stack, this.stackDepth);
                        this.stackDepth %= 2;
                    }
                    if (!(bl = this.handleWidth(type2Consumer))) {
                        return false;
                    }
                    int n23 = (this.nbHints + 7) / 8;
                    type2Consumer.hintmask(this.stack, this.stackDepth, cFFByteArray, n, n23);
                    n += n23;
                    this.stackDepth = 0;
                    continue block56;
                }
                case 20: {
                    boolean bl;
                    if (this.stackDepth > 1) {
                        this.nbHints += this.stackDepth / 2;
                        if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                            int n24;
                            int n25 = n24 = this.stackDepth % 2 != 0 ? 1 : 0;
                            this.stack[n25] = this.stack[n25] + this.seacAccentX;
                        }
                        type2Consumer.implicit_vstemhm(this.stack, this.stackDepth);
                        this.stackDepth %= 2;
                    }
                    if (!(bl = this.handleWidth(type2Consumer))) {
                        return false;
                    }
                    int n26 = (this.nbHints + 7) / 8;
                    type2Consumer.cntrmask(this.stack, this.stackDepth, cFFByteArray, n, n26);
                    n += n26;
                    this.stackDepth = 0;
                    continue block56;
                }
                case 21: {
                    this.check(this.stackDepth == 2 || this.stackDepth == 3);
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        if (this.stackDepth == 2) {
                            this.stack[0] = this.stack[0] + this.seacAccentX;
                            this.stack[1] = this.stack[1] + this.seacAccentY;
                        } else {
                            this.stack[1] = this.stack[1] + this.seacAccentX;
                            this.stack[2] = this.stack[2] + this.seacAccentY;
                        }
                        this.seacPhase = SeacPhase.seacAccentPostMove;
                        type2Consumer.moveto(this.stack, this.stackDepth);
                    } else {
                        type2Consumer.rmoveto(this.stack, this.stackDepth);
                    }
                    this.stackDepth -= 2;
                    boolean bl = this.handleWidth(type2Consumer);
                    if (bl) continue block56;
                    return false;
                }
                case 22: {
                    boolean bl;
                    this.check(this.stackDepth == 1 || this.stackDepth == 2);
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        if (this.stackDepth == 2) {
                            this.stack[2] = this.seacAccentY;
                            this.stack[1] = this.stack[1] + this.seacAccentX;
                        } else {
                            this.stack[1] = this.seacAccentY;
                            this.stack[0] = this.stack[0] + this.seacAccentX;
                        }
                        ++this.stackDepth;
                        type2Consumer.moveto(this.stack, this.stackDepth);
                        this.stackDepth -= 2;
                        this.seacPhase = SeacPhase.seacAccentPostMove;
                    } else {
                        type2Consumer.hmoveto(this.stack, this.stackDepth);
                        --this.stackDepth;
                    }
                    if (bl = this.handleWidth(type2Consumer)) continue block56;
                    return false;
                }
                case 23: {
                    this.check(this.stackDepth >= 2);
                    this.nbHints += this.stackDepth / 2;
                    if (this.seacPhase == SeacPhase.seacAccentPreMove) {
                        int n27;
                        int n28 = n27 = this.stackDepth % 2 != 0 ? 1 : 0;
                        this.stack[n28] = this.stack[n28] + this.seacAccentX;
                    }
                    type2Consumer.vstemhm(this.stack, this.stackDepth);
                    this.stackDepth %= 2;
                    boolean bl = this.handleWidth(type2Consumer);
                    if (bl) continue block56;
                    return false;
                }
                case 24: {
                    this.check(this.stackDepth >= 8 && this.stackDepth % 6 == 2);
                    type2Consumer.rcurveline(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 25: {
                    this.check(this.stackDepth >= 8 && this.stackDepth % 2 == 0);
                    type2Consumer.rlinecurve(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 26: {
                    this.check(this.stackDepth >= 4 && this.stackDepth % 4 <= 1);
                    type2Consumer.vvcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 27: {
                    this.check(this.stackDepth >= 4 && this.stackDepth % 4 <= 1);
                    type2Consumer.hhcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 28: {
                    this.check(this.stackDepth < this.stack.length);
                    int n29 = cFFByteArray.getint16(n);
                    n += 2;
                    type2Consumer.integer(this.stack, this.stackDepth, n29);
                    this.stack[this.stackDepth++] = n29;
                    continue block56;
                }
                case 29: {
                    this.check(this.stackDepth >= 1);
                    int n30 = this.checkInt(this.stack[--this.stackDepth]);
                    n30 = charStrings2.getCount() < 1240 ? (n30 += 107) : (charStrings2.getCount() < 33900 ? (n30 += 1131) : (n30 += 32768));
                    type2Consumer.callgsubr(this.stack, this.stackDepth, n30);
                    ++this.callDepth;
                    boolean bl = this.parse(charStrings2.data, charStrings2.offsetOf(n30), charStrings2.offsetFollowing(n30), charStrings, charStrings2, type2Consumer, nameKeyedFont);
                    --this.callDepth;
                    if (bl) continue block56;
                    return bl;
                }
                case 30: {
                    this.check(this.stackDepth >= 4 && (this.stackDepth % 8 == 0 || this.stackDepth % 8 == 1 || this.stackDepth % 8 == 4 || this.stackDepth % 8 == 5));
                    type2Consumer.vhcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 31: {
                    this.check(this.stackDepth >= 4 && (this.stackDepth % 8 == 0 || this.stackDepth % 8 == 1 || this.stackDepth % 8 == 4 || this.stackDepth % 8 == 5));
                    type2Consumer.hvcurveto(this.stack, this.stackDepth);
                    this.stackDepth = 0;
                    continue block56;
                }
                case 255: {
                    this.check(this.stackDepth < this.stack.length);
                    double d = (double)cFFByteArray.getint32(n) / 65536.0;
                    n += 4;
                    type2Consumer.real(this.stack, this.stackDepth, d);
                    this.stack[this.stackDepth++] = d;
                    continue block56;
                }
            }
            if (32 <= n3 && n3 <= 246) {
                this.check(this.stackDepth < this.stack.length);
                int n31 = n3 - 139;
                type2Consumer.integer(this.stack, this.stackDepth, n31);
                this.stack[this.stackDepth++] = n31;
                continue;
            }
            if (247 <= n3 && n3 <= 250) {
                this.check(this.stackDepth < this.stack.length);
                int n32 = cFFByteArray.getcard8(n);
                ++n;
                int n33 = (n3 - 247) * 256 + n32 + 108;
                type2Consumer.integer(this.stack, this.stackDepth, n33);
                this.stack[this.stackDepth++] = n33;
                continue;
            }
            if (251 <= n3 && n3 <= 254) {
                this.check(this.stackDepth < this.stack.length);
                int n34 = cFFByteArray.getcard8(n);
                ++n;
                int n35 = -(n3 - 251) * 256 - n34 - 108;
                type2Consumer.integer(this.stack, this.stackDepth, n35);
                this.stack[this.stackDepth++] = n35;
                continue;
            }
            throw new InvalidGlyphException("invalid Type2 operator (" + n3 + ")");
        }
        this.check(false);
        return false;
    }

    private void reverseStackRange(int n, int n2) {
        while (n < n2) {
            double d = this.stack[n];
            this.stack[n] = this.stack[n2];
            this.stack[n2] = d;
            ++n;
            --n2;
        }
    }
}

