/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.AutoColor;
import com.adobe.fontengine.font.cff.CFFSubrize;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.NonOverlappingOutlineConsumer;
import com.adobe.fontengine.font.cff.Type2CStringGenerator;
import com.adobe.fontengine.font.opentype.GlyfRaw;
import com.adobe.fontengine.font.opentype.LocaRaw;
import com.adobe.fontengine.font.opentype.Name;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.TTCompositeOutline;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.ZoneHint;
import com.adobe.fontengine.math.F16Dot16;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Glyf
extends Table {
    protected final LocaRaw loca;
    protected final GlyfRaw glyf;
    protected final int indexToLocFormat;
    private static final int MAX_GLYF_SIZE_FOR_SUBRIZE = 614400;

    protected Glyf(GlyfRaw glyfRaw, LocaRaw locaRaw, int n) {
        this.glyf = glyfRaw;
        this.loca = locaRaw;
        this.indexToLocFormat = n;
    }

    protected int getGlyphLocation(int n) throws UnsupportedFontException, InvalidFontException {
        return this.loca.getGlyphLocation(n, this.indexToLocFormat);
    }

    public Rect getGlyphBoundingBox(int n) throws UnsupportedFontException, InvalidFontException {
        return this.glyf.getGlyphBoundingBox(this.getGlyphLocation(n), this.getGlyphLocation(n + 1));
    }

    public boolean isComposite(int n) throws UnsupportedFontException, InvalidFontException {
        return this.glyf.isComposite(this.getGlyphLocation(n), this.getGlyphLocation(n + 1));
    }

    public void subsetAndStream(Subset subset, Map map) throws UnsupportedFontException, InvalidFontException {
        long l;
        int n;
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance((subset.getNumGlyphs() + 1) * 4);
        int n2 = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            n = subset.getFullGid(i);
            long l2 = this.getGlyphLocation(n);
            l = this.getGlyphLocation(n + 1);
            if (l < l2) {
                throw new InvalidFontException("gid " + n + " starts at " + l2 + " and ends at " + l + "!");
            }
            n2 = (int)((long)n2 + (l - l2));
        }
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder2 = OTByteArray.getOTByteArrayBuilderInstance(n2);
        n = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            oTByteArrayBuilder.setuint32(i * 4, n);
            int n3 = subset.getFullGid(i);
            l = this.getGlyphLocation(n3);
            long l3 = this.getGlyphLocation(n3 + 1);
            oTByteArrayBuilder2.replace(n, this.glyf.data, (int)l, (int)(l3 - l));
            if (l3 - l > 0L) {
                this.fixComponentGlyphs(subset, (int)l, oTByteArrayBuilder2, n);
            }
            n = (int)((long)n + (l3 - l));
        }
        oTByteArrayBuilder.setuint32(subset.getNumGlyphs() * 4, n);
        map.put(new Integer(1819239265), oTByteArrayBuilder);
        map.put(new Integer(1735162214), oTByteArrayBuilder2);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.loca.getDataAsByteArray();
        map.put(new Integer(1819239265), oTByteArrayBuilder);
        oTByteArrayBuilder = this.glyf.getDataAsByteArray();
        map.put(new Integer(1735162214), oTByteArrayBuilder);
    }

    public void pullComponentGlyphs(Subset subset, int n) throws UnsupportedFontException, InvalidFontException {
        int n2;
        int n3 = this.getGlyphLocation(n);
        if (n3 == (n2 = this.getGlyphLocation(n + 1))) {
            return;
        }
        if (this.glyf.data.getint16(n3) != -1) {
            return;
        }
        n3 += 10;
        boolean bl = true;
        while (bl) {
            subset.getSubsetGid(this.glyf.data.getuint16(n3 + 2));
            int n4 = this.glyf.data.getuint16(n3);
            int n5 = 4;
            n5 = (n4 & 1) != 0 ? (n5 += 4) : (n5 += 2);
            if ((n4 & 8) != 0) {
                n5 += 2;
            } else if ((n4 & 0x40) != 0) {
                n5 += 4;
            } else if ((n4 & 0x80) != 0) {
                n5 += 8;
            }
            n3 += n5;
            bl = (n4 & 0x20) != 0;
        }
    }

    void fixComponentGlyphs(Subset subset, int n, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n2) throws UnsupportedFontException, InvalidFontException {
        if (this.glyf.data.getint16(n) != -1) {
            return;
        }
        n += 10;
        n2 += 10;
        boolean bl = true;
        while (bl) {
            oTByteArrayBuilder.setuint16(n2 + 2, subset.getSubsetGid(this.glyf.data.getuint16(n + 2)));
            int n3 = this.glyf.data.getuint16(n);
            int n4 = 4;
            n4 = (n3 & 1) != 0 ? (n4 += 4) : (n4 += 2);
            if ((n3 & 8) != 0) {
                n4 += 2;
            } else if ((n3 & 0x40) != 0) {
                n4 += 4;
            } else if ((n3 & 0x80) != 0) {
                n4 += 8;
            }
            n += n4;
            n2 += n4;
            bl = (n3 & 0x20) != 0;
        }
    }

    public TTOutline createTTOutline(OpenTypeFont openTypeFont, int n) throws UnsupportedFontException, InvalidFontException {
        int n2;
        int n3 = this.getGlyphLocation(n);
        if (n3 == (n2 = this.getGlyphLocation(n + 1))) {
            return this.createTTSimpleOutline(openTypeFont, n, n3, n2);
        }
        int n4 = this.glyf.data.getint16(n3);
        if (n4 < 0) {
            return this.createTTCompositeOutline(openTypeFont, n, n3, n2);
        }
        if (n4 == 0) {
            throw new UnsupportedFontException("createTTOutline, numberOfContours == 0");
        }
        return this.createTTSimpleOutline(openTypeFont, n, n3, n2);
    }

    TTCompositeOutline createTTCompositeOutline(OpenTypeFont openTypeFont, int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
        int n4;
        int n5;
        ArrayList<TTCompositeOutline.TTComponent> arrayList = new ArrayList<TTCompositeOutline.TTComponent>();
        int n6 = this.glyf.data.getint16(n2 += 2);
        n2 += 8;
        boolean bl = true;
        boolean bl2 = false;
        while (bl) {
            TTCompositeOutline.TTComponent tTComponent = new TTCompositeOutline.TTComponent();
            n5 = this.glyf.data.getuint16(n2);
            bl = (n5 & 0x20) != 0;
            bl2 = (n5 & 0x100) != 0;
            n4 = this.glyf.data.getuint16(n2 += 2);
            n2 += 2;
            tTComponent.outline = this.createTTOutline(openTypeFont, n4);
            tTComponent.alignByPosition = (n5 & 2) != 0;
            tTComponent.roundXYToGrid = (n5 & 4) != 0;
            tTComponent.useThisMetrics = (n5 & 0x200) != 0;
            tTComponent.scaledOffsets = (n5 & 0x800) != 0;
            boolean bl3 = tTComponent.unscaledOffset = (n5 & 0x1000) != 0;
            if ((n5 & 1) != 0) {
                tTComponent.argument1 = this.glyf.data.getint16(n2);
                tTComponent.argument2 = this.glyf.data.getint16(n2 += 2);
                n2 += 2;
            } else {
                tTComponent.argument1 = this.glyf.data.getint8(n2);
                tTComponent.argument2 = this.glyf.data.getint8(++n2);
                ++n2;
            }
            if ((n5 & 8) != 0) {
                tTComponent.a = this.glyf.data.getuint16(n2);
                n2 += 2;
                tTComponent.b = 0;
                tTComponent.c = 0;
                tTComponent.d = tTComponent.a;
            } else if ((n5 & 0x40) != 0) {
                tTComponent.a = this.glyf.data.getuint16(n2);
                tTComponent.b = 0;
                tTComponent.c = 0;
                tTComponent.d = this.glyf.data.getuint16(n2 += 2);
                n2 += 2;
            } else if ((n5 & 0x80) != 0) {
                tTComponent.a = this.glyf.data.getuint16(n2);
                tTComponent.b = this.glyf.data.getuint16(n2 += 2);
                tTComponent.c = this.glyf.data.getuint16(n2 += 2);
                tTComponent.d = this.glyf.data.getuint16(n2 += 2);
                n2 += 2;
            } else {
                tTComponent.a = 16384;
                tTComponent.b = 0;
                tTComponent.c = 0;
                tTComponent.d = 16384;
            }
            arrayList.add(tTComponent);
        }
        int n7 = 0;
        n5 = 0;
        if (bl2) {
            n7 = this.glyf.data.getuint16(n2);
            n5 = n2 += 2;
        }
        n4 = n6 - openTypeFont.hmtx.getLeftSideBearing(n);
        int n8 = n4 + openTypeFont.hmtx.getHorizontalAdvance(n);
        int n9 = openTypeFont.os2.getTypoAscender();
        int n10 = openTypeFont.os2.getTypoDescender();
        TTCompositeOutline tTCompositeOutline = new TTCompositeOutline(arrayList, n4, n8, n9, n10, this.glyf.data, n5, n7);
        return tTCompositeOutline;
    }

    TTSimpleOutline createTTSimpleOutline(OpenTypeFont openTypeFont, int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
        int n4;
        int n5;
        int n6;
        int n7;
        TTSimpleOutline tTSimpleOutline = new TTSimpleOutline();
        if (n2 == n3) {
            tTSimpleOutline.points = new TTPoint[4];
            tTSimpleOutline.contourEndPoints = new int[0];
            int n8 = 0;
            int n9 = 0;
            int n10 = n9 - openTypeFont.hmtx.getLeftSideBearing(n);
            int n11 = n10 + openTypeFont.hmtx.getHorizontalAdvance(n);
            int n12 = openTypeFont.os2.getTypoAscender();
            int n13 = openTypeFont.os2.getTypoDescender();
            tTSimpleOutline.points[n8 + 0] = new TTPoint(n10, 0, false);
            tTSimpleOutline.points[n8 + 1] = new TTPoint(n11, 0, false);
            tTSimpleOutline.points[n8 + 2] = new TTPoint(0, n12, false);
            tTSimpleOutline.points[n8 + 3] = new TTPoint(0, n13, false);
            return tTSimpleOutline;
        }
        int n14 = this.glyf.data.getint16(n2);
        int n15 = this.glyf.data.getint16(n2 += 2);
        n2 += 8;
        if (n14 < 0) {
            throw new UnsupportedFontException("composite glyph");
        }
        if (n14 == 0) {
            throw new UnsupportedFontException();
        }
        tTSimpleOutline.contourEndPoints = new int[n14];
        for (n7 = 0; n7 < n14; ++n7) {
            tTSimpleOutline.contourEndPoints[n7] = this.glyf.data.getuint16(n2);
            n2 += 2;
        }
        n7 = tTSimpleOutline.contourEndPoints[n14 - 1] + 1;
        int n16 = n15 - openTypeFont.hmtx.getLeftSideBearing(n);
        int n17 = n16 + openTypeFont.hmtx.getHorizontalAdvance(n);
        int n18 = openTypeFont.os2.getTypoAscender();
        int n19 = openTypeFont.os2.getTypoDescender();
        tTSimpleOutline.points = new TTPoint[n7 + 4];
        tTSimpleOutline.points[n7 + 0] = new TTPoint(n16, 0, false);
        tTSimpleOutline.points[n7 + 1] = new TTPoint(n17, 0, false);
        tTSimpleOutline.points[n7 + 2] = new TTPoint(0, n18, false);
        tTSimpleOutline.points[n7 + 3] = new TTPoint(0, n19, false);
        tTSimpleOutline.instructions = this.glyf.data;
        tTSimpleOutline.instructionsLength = this.glyf.data.getuint16(n2);
        tTSimpleOutline.instructionsOffset = n2 += 2;
        int n20 = n2 += tTSimpleOutline.instructionsLength;
        int n21 = 0;
        int n22 = 0;
        while (n22 < n7) {
            n5 = ((n6 = this.glyf.data.getuint8(n2++)) & 8) == 0 ? 0 : this.glyf.data.getuint8(n2++);
            for (n4 = 0; n4 <= n5; ++n4) {
                if ((n6 & 2) != 0) {
                    ++n21;
                } else if ((n6 & 0x10) == 0) {
                    n21 += 2;
                }
                ++n22;
            }
        }
        n6 = n2;
        n5 = n6 + n21;
        n4 = 0;
        int n23 = 0;
        n22 = 0;
        while (n22 < n7) {
            int n24;
            int n25 = ((n24 = this.glyf.data.getuint8(n20++)) & 8) == 0 ? 0 : this.glyf.data.getuint8(n20++);
            for (int i = 0; i <= n25; ++i) {
                if ((n24 & 2) != 0) {
                    n4 = (n24 & 0x10) == 0 ? (n4 -= this.glyf.data.getuint8(n6)) : (n4 += this.glyf.data.getuint8(n6));
                    ++n6;
                } else if ((n24 & 0x10) == 0) {
                    n4 += this.glyf.data.getint16(n6);
                    n6 += 2;
                }
                if ((n24 & 4) != 0) {
                    n23 = (n24 & 0x20) == 0 ? (n23 -= this.glyf.data.getuint8(n5)) : (n23 += this.glyf.data.getuint8(n5));
                    ++n5;
                } else if ((n24 & 0x20) == 0) {
                    n23 += this.glyf.data.getint16(n5);
                    n5 += 2;
                }
                boolean bl = (n24 & 1) != 0;
                try {
                    tTSimpleOutline.points[n22] = new TTPoint(n4, n23, bl);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new InvalidGlyphException(arrayIndexOutOfBoundsException);
                }
                ++n22;
            }
        }
        return tTSimpleOutline;
    }

    private String nameGet(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u00a9': {
                    stringBuffer.append("(C)");
                    continue block5;
                }
                case '\u00ae': {
                    stringBuffer.append("(R)");
                    continue block5;
                }
                case '\u2122': {
                    stringBuffer.append("(TM)");
                    continue block5;
                }
                default: {
                    if ((c & 0xFF00) != 0) {
                        stringBuffer.append('?');
                        continue block5;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private Dict createTopDict(OpenTypeFont openTypeFont, boolean bl) throws InvalidFontException, UnsupportedFontException, UnsupportedEncodingException {
        Double d;
        Double d2;
        Double d3;
        Boolean bl2;
        String string = bl ? "Adobe" : null;
        String string2 = bl ? "Identity" : null;
        Matrix matrix = bl ? null : new Matrix(1.0 / openTypeFont.getUnitsPerEmX(), 0.0, 0.0, 1.0 / openTypeFont.getUnitsPerEmY(), 0.0, 0.0);
        String string3 = "/OrigFontType /" + OrigFontType.kTRUETYPE + " def";
        String string4 = openTypeFont.getXDCFontDescription(null).getPostscriptName();
        if (string4 == null || string4.length() == 0 || string4.charAt(0) == '\u0000') {
            string4 = "unknown";
        }
        Name name = openTypeFont.name;
        String string5 = this.nameGet(name.selectName(5));
        String string6 = this.nameGet(name.selectName(7));
        String string7 = this.nameGet(name.selectName(13));
        String string8 = this.nameGet(name.selectName(4));
        String string9 = this.nameGet(name.selectName(1));
        String string10 = this.nameGet(name.selectName(2));
        if (openTypeFont.post != null) {
            bl2 = new Boolean(openTypeFont.post.isFixedPitch());
            d3 = new Double(F16Dot16.toDouble(-openTypeFont.post.getItalicAngle()));
            d2 = new Double(openTypeFont.post.getUnderlinePosition());
            d = new Double(openTypeFont.post.getUnderlineThickness());
        } else {
            bl2 = Boolean.FALSE;
            d3 = new Double(0.0);
            d2 = new Double(-100.0);
            d = new Double(50.0);
        }
        Rect rect = openTypeFont.head.getFontBBox();
        Integer n = null;
        Integer n2 = null;
        Double d4 = null;
        int[] nArray = null;
        Integer n3 = null;
        int[] nArray2 = null;
        String string11 = null;
        return new Dict(string, string2, 0, string5, string6, string7, string8, string4, string9, string10, bl2, d3, d2, d, n, n2, rect, d4, nArray, string3, n3, nArray2, string11, matrix);
    }

    private Dict createPrivateDict(double d, double d2, ZoneHint zoneHint) {
        double[] dArray = null;
        double[] dArray2 = null;
        Double d3 = null;
        Integer n = null;
        Double d4 = null;
        if (zoneHint != null) {
            dArray = zoneHint.getBlueValues();
            if (dArray != null) {
                dArray2 = zoneHint.getOtherBlues();
                d3 = new Double(zoneHint.getBlueScale());
                n = new Integer(zoneHint.getBlueFuzz());
            }
            d4 = new Double(zoneHint.getStdVStem());
        }
        return new Dict(dArray, dArray2, null, null, d3, null, n, null, d4, null, null, null, null, null, null, new Double(d), new Double(d2));
    }

    public void streamForCFF(OpenTypeFont openTypeFont, Map map, boolean bl) throws UnsupportedFontException, InvalidFontException, IOException {
        this.subsetAndStreamForCFF(null, openTypeFont, map, bl);
    }

    private boolean checkSubrizeLimit(Subset subset, OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
        int n = this.glyf.data.getSize();
        if (n <= 614400) {
            return true;
        }
        if (subset == null) {
            return false;
        }
        return (double)n * (double)subset.getNumGlyphs() <= 614400.0 * (double)openTypeFont.getNumGlyphs();
    }

    public void subsetAndStreamForCFF(Subset subset, OpenTypeFont openTypeFont, Map map, boolean bl) throws UnsupportedFontException, InvalidFontException, IOException {
        Object object;
        String string;
        double d;
        int n;
        Type2CStringGenerator type2CStringGenerator;
        ZoneHint zoneHint = null;
        AutoColor autoColor = null;
        boolean bl2 = true;
        if (subset == null) {
            subset = new SubsetDefaultImpl(openTypeFont.getNumGlyphs(), false);
        }
        boolean bl3 = this.checkSubrizeLimit(subset, openTypeFont);
        if (!bl) {
            type2CStringGenerator = new Type2CStringGenerator(subset.getNumGlyphs(), 1, bl3);
            for (n = 0; n < subset.getNumGlyphs(); ++n) {
                d = openTypeFont.getHorizontalAdvance(subset.getFullGid(n));
                type2CStringGenerator.newGlyph(n, 0, d, 0.0);
                openTypeFont.getGlyphOutline(subset.getFullGid(n), type2CStringGenerator, 2);
            }
        } else {
            NonOverlappingOutlineConsumer nonOverlappingOutlineConsumer;
            if (bl2) {
                zoneHint = new ZoneHint(openTypeFont);
            }
            type2CStringGenerator = new Type2CStringGenerator(subset.getNumGlyphs(), 1, bl3);
            if (bl2) {
                autoColor = new AutoColor(type2CStringGenerator, openTypeFont.getUnitsPerEmY(), 6, true, false, zoneHint.getTopZones(), zoneHint.getBottomZones());
                nonOverlappingOutlineConsumer = new NonOverlappingOutlineConsumer(autoColor, openTypeFont.getUnitsPerEmY());
            } else {
                nonOverlappingOutlineConsumer = new NonOverlappingOutlineConsumer(type2CStringGenerator, openTypeFont.getUnitsPerEmY());
            }
            for (n = 0; n < subset.getNumGlyphs(); ++n) {
                d = openTypeFont.getHorizontalAdvance(subset.getFullGid(n));
                if (bl2) {
                    autoColor.newGlyph(n, d, 0);
                }
                type2CStringGenerator.newGlyph(n, 0, d, 0.0);
                openTypeFont.getGlyphOutline(subset.getFullGid(n), nonOverlappingOutlineConsumer, 2);
            }
        }
        if ((string = openTypeFont.getXDCFontDescription(null).getPostscriptName()) == null || string.length() == 0 || string.charAt(0) == '\u0000') {
            string = "unknown";
        }
        d = type2CStringGenerator.calculateNominalWidth(0);
        double d2 = type2CStringGenerator.calculateDefaultWidth(0);
        CharStrings charStrings = type2CStringGenerator.getCharstringIndex();
        CharStrings charStrings2 = null;
        CharStrings charStrings3 = null;
        if (bl3) {
            object = new CFFSubrize();
            charStrings = ((CFFSubrize)object).subrize(charStrings);
            charStrings2 = ((CFFSubrize)object).getLSubrs();
            charStrings3 = ((CFFSubrize)object).getGSubrs();
        }
        object = this.createTopDict(openTypeFont, true);
        Dict dict = this.createPrivateDict(d, d2, zoneHint);
        OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor oTByteArrayBuilderOutputStreamAdaptor = new OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor();
        Dict dict2 = new Dict(new Matrix(1.0 / openTypeFont.getUnitsPerEmX(), 0.0, 0.0, 1.0 / openTypeFont.getUnitsPerEmY(), 0.0, 0.0));
        CIDKeyedFont cIDKeyedFont = new CIDKeyedFont(string, (Dict)object, charStrings, subset.getNumGlyphs(), dict2, dict, charStrings2, charStrings3);
        cIDKeyedFont.subsetAndStream(subset, oTByteArrayBuilderOutputStreamAdaptor, false, null, false, false);
        map.put(new Integer(1128678944), oTByteArrayBuilderOutputStreamAdaptor.getBuilder());
    }

    public static interface CoordFlags {
        public static final int ON_CURVE = 1;
        public static final int X_SHORT_VECTOR = 2;
        public static final int Y_SHORT_VECTOR = 4;
        public static final int REPEAT = 8;
        public static final int THIS_X_IS_SAME = 16;
        public static final int THIS_Y_IS_SAME = 32;
    }

    public static interface Flags {
        public static final int ARG_1_AND_2_ARE_WORDS = 1;
        public static final int ARGS_ARE_XY_VALUES = 2;
        public static final int ROUND_XY_TO_GRID = 4;
        public static final int WE_HAVE_A_SCALE = 8;
        public static final int MORE_COMPONENTS = 32;
        public static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
        public static final int WE_HAVE_A_TWO_BY_TWO = 128;
        public static final int WE_HAVE_INSTRUCTIONS = 256;
        public static final int USE_MY_METRICS = 512;
        public static final int OVERLAP_COMPOUND = 1024;
        public static final int SCALED_COMPONENT_OFFSET = 2048;
        public static final int UNSCALED_COMPONENT_OFFSET = 4096;
    }
}

