/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingGenerator;
import com.adobe.fontengine.font.opentype.ContextualGenerator;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class GposSubsetter
extends LookupTableSubsetter {
    private final boolean preserveNonEmptyKernFeature;

    GposSubsetter(Gpos gpos, int n, boolean bl) {
        super(gpos, OTByteArray.getOTByteArrayBuilderInstance(), n);
        this.preserveNonEmptyKernFeature = bl;
    }

    void gatherCoveragesForSubtable(int n, int n2, int n3, Integer n4, Map map, Map map2, Subset subset) throws InvalidFontException, UnsupportedFontException {
        Map map3 = map;
        if (n2 == 9) {
            n2 = this.origTable.data.getuint16(n + 2);
            n += this.origTable.data.getuint32asint(n + 4, "Unhandled extension offset");
            map3 = map2;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                int n5 = this.origTable.data.getOffset(n, 2);
                GposSubsetter.addToCoveragesMap(this.origTable, n5, map3, n3, n4, subset);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                int n6 = this.origTable.data.getOffset(n, 2);
                GposSubsetter.addToCoveragesMap(this.origTable, n6, map3, n3, n4, subset);
                n6 = this.origTable.data.getOffset(n, 4);
                GposSubsetter.addToCoveragesMap(this.origTable, n6, map3, n3, n4, subset);
                break;
            }
            case 7: {
                ContextualGenerator.gatherCoveragesForSubtable(this.origTable, n, n2, n3, n4, map3, subset);
                break;
            }
            case 8: {
                ChainingGenerator.gatherCoveragesForSubtable(this.origTable, n, n2, n3, n4, map3, subset);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + n2 + ")");
            }
        }
    }

    int getExtensionSubtableSize() {
        return 8;
    }

    void patchSubtableCoverage(int n, int n2, Map map, int n3) throws InvalidFontException {
        switch (n3) {
            case 1: 
            case 2: 
            case 3: {
                GposSubsetter.patchCoverageAtOffset(this.origTable, this.builder, n, n2, 2, map);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                GposSubsetter.patchCoverageAtOffset(this.origTable, this.builder, n, n2, 2, map);
                GposSubsetter.patchCoverageAtOffset(this.origTable, this.builder, n, n2, 4, map);
                break;
            }
            case 7: {
                ContextualGenerator.patchSubtableCoverage(this.origTable, this.builder, n, n2, map, n3);
                break;
            }
            case 8: {
                ChainingGenerator.patchSubtableCoverage(this.origTable, this.builder, n, n2, map, n3);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type: " + n3);
            }
        }
    }

    private int targetValueFormat(int n) {
        return n & 0xF;
    }

    private void writeValueFormat(int n, int n2, int n3, int[] nArray) {
        int n4 = 0;
        int n5 = 0;
        for (int i = 1; i <= 8 && n4 < nArray.length; i <<= 1) {
            if ((n2 & i) == 0) continue;
            if ((n3 & i) != 0) {
                this.builder.setint16(n + 2 * n5, nArray[n4]);
                ++n5;
            }
            ++n4;
        }
    }

    private void writeValueFormatFromOriginal(int n, int n2, int n3, int n4) throws InvalidFontException {
        int n5 = 0;
        int n6 = 0;
        for (int i = 1; i <= 8; i <<= 1) {
            if ((n3 & i) == 0) continue;
            if ((n4 & i) != 0) {
                int n7 = this.origTable.data.getint16(n + 2 * n5);
                this.builder.setint16(n2 + 2 * n6, n7);
                ++n6;
            }
            ++n5;
        }
    }

    private int writeAnchorFromOriginal(int n, int n2) throws InvalidFontException {
        this.builder.ensureCapacity(n2 + 6);
        this.builder.setuint16(n2, 1);
        this.builder.setint16(n2 + 2, this.origTable.data.getint16(n + 2));
        this.builder.setint16(n2 + 4, this.origTable.data.getint16(n + 4));
        return 6;
    }

    private int writeLookup1Format1(int n, int n2, int[] nArray) throws InvalidFontException {
        int n3 = this.origTable.data.getuint16(n + 4);
        int n4 = this.targetValueFormat(n3);
        int n5 = ((Gpos)this.origTable).getValueRecordSize(n4);
        int n6 = 6 + n5;
        this.builder.ensureCapacity(n2 + n6);
        this.builder.setuint16(n2, 1);
        this.builder.setuint16(n2 + 4, n4);
        this.writeValueFormat(n2 + 6, n3, n4, nArray);
        return n6;
    }

    int writeSubtable(int n, int n2, Map map, int n3, Subset subset, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        LookupTableSubsetter.LookupSubtableGenerator lookupSubtableGenerator;
        block0 : switch (n3) {
            case 1: {
                int[] nArray;
                int n4;
                int n5 = this.origTable.data.getuint16(n);
                if (n5 == 2) {
                    L1F2TargetFormatDeterminer l1F2TargetFormatDeterminer = new L1F2TargetFormatDeterminer(n);
                    n4 = l1F2TargetFormatDeterminer.canUseFormat1(subset) ? 1 : 2;
                    nArray = l1F2TargetFormatDeterminer.bytes;
                } else {
                    n4 = 1;
                    nArray = new int[((Gpos)this.origTable).getValueRecordSize(this.origTable.data.getuint16(n + 4)) / 2];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = this.origTable.data.getint16(n + 6 + 2 * i);
                    }
                }
                if (n4 == 1) {
                    return this.writeLookup1Format1(n, n2, nArray);
                }
                lookupSubtableGenerator = new Type1Format2Generator(n, n2, subset);
                break;
            }
            case 2: {
                int n6 = this.origTable.data.getuint16(n);
                switch (n6) {
                    case 1: {
                        lookupSubtableGenerator = new Type2Format1Generator(this.origTable, subset, this.builder, n2, n, map);
                        break block0;
                    }
                    case 2: {
                        lookupSubtableGenerator = new Type2Format2Generator(n, n2, subset);
                        break block0;
                    }
                }
                throw new InvalidFontException("Invalid type 2 gpos lookup: " + n6);
            }
            case 3: {
                lookupSubtableGenerator = new Type3Generator(n, n2, subset);
                break;
            }
            case 4: 
            case 6: {
                lookupSubtableGenerator = new Type4Or6Generator(n, n2, subset);
                break;
            }
            case 5: {
                lookupSubtableGenerator = new Type5Generator(n, n2, subset);
                break;
            }
            case 7: {
                lookupSubtableGenerator = ContextualGenerator.newContextualGenerator(this.origTable, this.builder, n, n2, subset, map, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 8: {
                lookupSubtableGenerator = ChainingGenerator.newChainingInstance(this.origTable, this.builder, n, n2, subset, map, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 9: {
                this.builder.setuint16(n2, 1);
                this.builder.setuint16(n2 + 2, this.origTable.data.getuint16(n + 2));
                return 8;
            }
            default: {
                throw new InvalidFontException("Invalid GPOS lookup type (" + n3 + ")");
            }
        }
        return lookupSubtableGenerator.writeSubtable();
    }

    int getReferencedLookupType(int n) throws InvalidFontException {
        return this.origTable.data.getuint16(n + 2);
    }

    void patchExtensionOffset(int n, int n2) {
        this.builder.setuint32(n + 4, n2 - n);
    }

    int getReferencedSubtableOffset(int n) throws InvalidFontException, UnsupportedFontException {
        return n + this.origTable.data.getuint32asint(n + 4, "Only handle extensions that fit in 31 bits");
    }

    int getExtensionLookupType() {
        return 9;
    }

    int writeExtensionSubtable(int n, int n2) {
        this.builder.setuint16(n, 1);
        this.builder.setuint16(n + 2, n2);
        return 8;
    }

    boolean mustKeepFeature(int n) throws InvalidFontException {
        if (this.preserveNonEmptyKernFeature) {
            int n2;
            int[] nArray = new int[]{107, 101, 114, 110};
            for (n2 = 0; n2 < 4; ++n2) {
                if (this.origTable.data.getuint8(n + n2) == nArray[n2]) continue;
                return false;
            }
            n2 = this.origTable.data.getOffset(n, 4);
            int n3 = this.origTable.data.getuint16(n2 + 2);
            return n3 > 0;
        }
        return false;
    }

    private class Type5Generator
    extends MarkGenerator {
        Type5Generator(int n, int n2, Subset subset) {
            super(n, n2, subset);
        }

        int writeTargetArray(int n, int n2, ClassSubset classSubset, int n3) throws InvalidFontException {
            int n4 = 2 + 2 * this.entryCount;
            GposSubsetter.this.builder.ensureCapacity(n2 + n4);
            GposSubsetter.this.builder.setuint16(n2, this.entryCount);
            int n5 = 0;
            for (int i = 0; n5 < this.entryCount && i < this.subset.getNumGlyphs(); ++i) {
                if (this.subsetToCoverage[i] == -1) continue;
                GposSubsetter.this.builder.setuint16(n2 + 2 + 2 * n5, n4);
                n4 += this.writeArrayEntry(n, 2 + 2 * this.subsetToCoverage[i], n2 + n4, classSubset, n3, this.subsetToCoverage[i]);
                ++n5;
            }
            return n4;
        }

        int writeArrayEntry(int n, int n2, int n3, ClassSubset classSubset, int n4, int n5) throws InvalidFontException {
            int n6 = GposSubsetter.this.origTable.data.getOffset(n, n2);
            int n7 = GposSubsetter.this.origTable.data.getuint16(n6);
            int n8 = 2 + 2 * n7 * classSubset.getNumGlyphs();
            GposSubsetter.this.builder.ensureCapacity(n3 + n8);
            GposSubsetter.this.builder.setuint16(n3, n7);
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < classSubset.getNumGlyphs(); ++j) {
                    int n9 = 2 + 2 * (n4 * i + classSubset.getFullGid(j));
                    int n10 = GposSubsetter.this.origTable.data.getOffset(n6, n9);
                    if (n10 == 0) {
                        GposSubsetter.this.builder.setuint16(n3 + 2 + 2 * (i * classSubset.getNumGlyphs() + j), 0);
                        continue;
                    }
                    GposSubsetter.this.builder.setuint16(n3 + 2 + 2 * (i * classSubset.getNumGlyphs() + j), n8);
                    n8 += GposSubsetter.this.writeAnchorFromOriginal(n10, n3 + n8);
                }
            }
            return n8;
        }
    }

    private class Type4Or6Generator
    extends MarkGenerator {
        Type4Or6Generator(int n, int n2, Subset subset) {
            super(n, n2, subset);
        }

        int writeTargetArray(int n, int n2, ClassSubset classSubset, int n3) throws InvalidFontException {
            int n4 = 2 + 2 * classSubset.getNumGlyphs() * this.entryCount;
            GposSubsetter.this.builder.ensureCapacity(n2 + n4);
            GposSubsetter.this.builder.setuint16(n2, this.entryCount);
            int n5 = 0;
            for (int i = 0; n5 < this.entryCount && i < this.subset.getNumGlyphs(); ++i) {
                if (this.subsetToCoverage[i] == -1) continue;
                for (int j = 0; j < classSubset.getNumGlyphs(); ++j) {
                    GposSubsetter.this.builder.setuint16(n2 + 2 + 2 * (n5 * classSubset.getNumGlyphs() + j), n4);
                    n4 += GposSubsetter.this.writeAnchorFromOriginal(GposSubsetter.this.origTable.data.getOffset(n, 2 + 2 * (this.subsetToCoverage[i] * n3 + classSubset.getFullGid(j))), n2 + n4);
                }
                ++n5;
            }
            return n4;
        }
    }

    private abstract class MarkGenerator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        protected final Subset subset;
        private final int origSTOffset;
        private final int newSTOffset;
        protected int entryCount = 0;
        protected int[] subsetToCoverage;

        MarkGenerator(int n, int n2, Subset subset) {
            this.origSTOffset = n;
            this.newSTOffset = n2;
            this.subset = subset;
            this.subsetToCoverage = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToCoverage, -1);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            this.subsetToCoverage[this.subset.getExistingSubsetGid((int)n)] = n2;
            ++this.entryCount;
            return true;
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = 12;
            MarkArrayGenerator markArrayGenerator = new MarkArrayGenerator(this.subset);
            int n2 = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2);
            int n3 = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 8);
            int n4 = GposSubsetter.this.origTable.data.getuint16(this.origSTOffset + 6);
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + n);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 1);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 8, n);
            n += markArrayGenerator.writeMarkArray(n2, n3, this.newSTOffset + n, n4);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 6, markArrayGenerator.classSubset.getNumGlyphs());
            GposSubsetter.this.origTable.iterateCoverage(GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 4), this.subset, this);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 10, n);
            n += this.writeTargetArray(GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 10), this.newSTOffset + n, markArrayGenerator.classSubset, n4);
            return n;
        }

        abstract int writeTargetArray(int var1, int var2, ClassSubset var3, int var4) throws InvalidFontException;
    }

    private class MarkArrayGenerator
    implements LayoutTable.CoverageConsumer {
        private final Subset subset;
        private int[] subsetToCoverageIndex;
        private int entryCount = 0;
        int subtableSize;
        ClassSubset classSubset;

        MarkArrayGenerator(Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.subset = subset;
            this.subsetToCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToCoverageIndex, -1);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            this.subsetToCoverageIndex[this.subset.getExistingSubsetGid((int)n)] = n2;
            ++this.entryCount;
            return true;
        }

        int writeMarkArray(int n, int n2, int n3, int n4) throws InvalidFontException, UnsupportedFontException {
            GposSubsetter.this.origTable.iterateCoverage(n, this.subset, this);
            this.classSubset = new ClassSubset(n4);
            this.subtableSize = 2 + 4 * this.entryCount;
            GposSubsetter.this.builder.ensureCapacity(n3 + this.subtableSize);
            GposSubsetter.this.builder.setuint16(n3, this.entryCount);
            int n5 = 0;
            for (int i = 0; n5 < this.entryCount && i < this.subset.getNumGlyphs(); ++i) {
                if (this.subsetToCoverageIndex[i] == -1) continue;
                int n6 = GposSubsetter.this.origTable.data.getuint16(n2 + 2 + 4 * this.subsetToCoverageIndex[i]);
                GposSubsetter.this.builder.setuint16(n3 + 2 + 4 * n5, this.classSubset.getSubsetGid(n6));
                GposSubsetter.this.builder.setuint16(n3 + 4 + 4 * n5, this.subtableSize);
                this.subtableSize += GposSubsetter.this.writeAnchorFromOriginal(GposSubsetter.this.origTable.data.getOffset(n2, 4 + 4 * this.subsetToCoverageIndex[i]), n3 + this.subtableSize);
                ++n5;
            }
            return this.subtableSize;
        }
    }

    private class ClassSubset
    extends SubsetDefaultImpl {
        ClassSubset(int n) throws InvalidFontException, UnsupportedFontException {
            super(n, true);
        }
    }

    private class Type3Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private int subtableSize = 0;
        private final int origSTOffset;
        private final int newSTOffset;
        private final Subset subset;
        private int entryExitCount = 0;
        private int[] subsetGidToCoverageIndex;

        Type3Generator(int n, int n2, Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.origSTOffset = n;
            this.newSTOffset = n2;
            this.subset = subset;
            this.subsetGidToCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetGidToCoverageIndex, -1);
            int n3 = GposSubsetter.this.origTable.data.getOffset(n, 2);
            GposSubsetter.this.origTable.iterateCoverage(n3, subset, this);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            this.subsetGidToCoverageIndex[this.subset.getExistingSubsetGid((int)n)] = n2;
            ++this.entryExitCount;
            return true;
        }

        public int writeSubtable() throws InvalidFontException {
            this.subtableSize = 6 + 4 * this.entryExitCount;
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + this.subtableSize);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 1);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 4, this.entryExitCount);
            int n = 0;
            for (int i = 0; n < this.entryExitCount * 2 && i < this.subset.getNumGlyphs(); ++i) {
                if (this.subsetGidToCoverageIndex[i] == -1) continue;
                for (int j = 0; j < 2; ++j) {
                    int n2 = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 6 + 4 * this.subsetGidToCoverageIndex[i] + 2 * j);
                    if (n2 == 0) {
                        GposSubsetter.this.builder.setuint16(this.newSTOffset + 6 + 2 * n, 0);
                    } else {
                        GposSubsetter.this.builder.setuint16(this.newSTOffset + 6 + 2 * n, this.subtableSize);
                        this.subtableSize += GposSubsetter.this.writeAnchorFromOriginal(n2, this.newSTOffset + this.subtableSize);
                    }
                    ++n;
                }
            }
            return this.subtableSize;
        }
    }

    private class Type2Format2Generator
    implements LayoutTable.ClassConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private int subtableSize = 0;
        private int class1CountInSubset;
        private int class2CountInSubset;
        private final int origClass2Count;
        private int currentMax = 0;
        private final Subset subset;
        private final int value1Format;
        private final int value2Format;
        private final int value1Size;
        private final int value2Size;
        private final int target1Format;
        private final int target2Format;
        private final int target1Size;
        private final int target2Size;
        private final int newSTOffset;
        private final int origSTOffset;

        public Type2Format2Generator(int n, int n2, Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.subset = subset;
            this.newSTOffset = n2;
            this.origSTOffset = n;
            int n3 = GposSubsetter.this.origTable.data.getOffset(n, 8);
            int n4 = GposSubsetter.this.origTable.data.getOffset(n, 10);
            this.origClass2Count = GposSubsetter.this.origTable.data.getuint16(n + 14);
            GposSubsetter.this.origTable.iterateClass(n3, GposSubsetter.this.origNumGlyphs, this, -1);
            this.class1CountInSubset = this.currentMax + 1;
            if (n3 == n4) {
                this.class2CountInSubset = this.currentMax;
            } else {
                this.currentMax = 0;
                GposSubsetter.this.origTable.iterateClass(n4, GposSubsetter.this.origNumGlyphs, this, -1);
                this.class2CountInSubset = this.currentMax + 1;
            }
            this.value1Format = GposSubsetter.this.origTable.data.getuint16(n + 4);
            this.value2Format = GposSubsetter.this.origTable.data.getuint16(n + 6);
            this.value1Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.value1Format);
            this.value2Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.value2Format);
            this.target1Format = GposSubsetter.this.targetValueFormat(this.value1Format);
            this.target2Format = GposSubsetter.this.targetValueFormat(this.value2Format);
            this.target1Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.target1Format);
            this.target2Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.target2Format);
        }

        private void writeHeader() throws InvalidFontException, UnsupportedFontException {
            this.subtableSize = 16 + (this.target1Size + this.target2Size) * this.class2CountInSubset * this.class1CountInSubset;
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + this.subtableSize);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 2);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 4, this.target1Format);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 6, this.target2Format);
            this.subtableSize += GposSubsetter.this.writeClassDef(this.origSTOffset, 8, this.newSTOffset, this.subtableSize, this.subset, GposSubsetter.this.origNumGlyphs);
            int n = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 8);
            int n2 = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 10);
            if (n == n2) {
                GposSubsetter.this.builder.setuint16(this.newSTOffset + 10, GposSubsetter.this.builder.getuint16(this.newSTOffset + 8));
            } else {
                this.subtableSize += GposSubsetter.this.writeClassDef(this.origSTOffset, 10, this.newSTOffset, this.subtableSize, this.subset, GposSubsetter.this.origNumGlyphs);
            }
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 12, this.class1CountInSubset);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 14, this.class2CountInSubset);
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            this.writeHeader();
            for (int i = 0; i < this.class1CountInSubset; ++i) {
                for (int j = 0; j < this.class2CountInSubset; ++j) {
                    GposSubsetter.this.writeValueFormatFromOriginal(this.origSTOffset + 16 + (this.value1Size + this.value2Size) * (this.origClass2Count * i + j), this.newSTOffset + 16 + (this.target1Size + this.target2Size) * (this.class2CountInSubset * i + j), this.value1Format, this.target1Format);
                    GposSubsetter.this.writeValueFormatFromOriginal(this.origSTOffset + 16 + (this.value1Size + this.value2Size) * (this.origClass2Count * i + j) + this.value1Size, this.newSTOffset + 16 + (this.target1Size + this.target2Size) * (this.class2CountInSubset * i + j) + this.target1Size, this.value2Format, this.target2Format);
                }
            }
            return this.subtableSize;
        }

        public boolean glyph(int n, int n2) throws UnsupportedFontException, InvalidFontException {
            if (this.subset.getExistingSubsetGid(n) != -1 && n2 > this.currentMax) {
                this.currentMax = n2;
            }
            return true;
        }
    }

    private class Type2Format1Generator
    extends SetGenerator
    implements LookupTableSubsetter.LookupSubtableGenerator {
        private final int value1Size;
        private final int value2Size;
        private final int value1Format;
        private final int value2Format;
        private final int targetValue1Format;
        private final int targetValue2Format;
        private final int targetValue1Size;
        private final int targetValue2Size;

        Type2Format1Generator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map) throws InvalidFontException, UnsupportedFontException {
            super(layoutTable, subset, oTByteArrayBuilder, n, n2, ((LookupTableSubsetter.NewCoverage)map.get((Object)new Integer((int)layoutTable.data.getOffset((int)n2, (int)2)))).glyphCount, 8, false, false);
            this.value1Format = layoutTable.data.getuint16(n2 + 4);
            this.value1Size = ((Gpos)layoutTable).getValueRecordSize(this.value1Format);
            this.value2Format = layoutTable.data.getuint16(n2 + 6);
            this.value2Size = ((Gpos)layoutTable).getValueRecordSize(this.value2Format);
            this.targetValue1Format = GposSubsetter.this.targetValueFormat(this.value1Format);
            this.targetValue2Format = GposSubsetter.this.targetValueFormat(this.value2Format);
            this.targetValue1Size = ((Gpos)layoutTable).getValueRecordSize(this.targetValue1Format);
            this.targetValue2Size = ((Gpos)layoutTable).getValueRecordSize(this.targetValue2Format);
            this.writeHeader();
            layoutTable.iterateCoverage(layoutTable.data.getOffset(n2, 2), subset, this);
        }

        void writeHeader() {
            this.builder.ensureCapacity(this.newSTOffset + 8);
            this.builder.setuint16(this.newSTOffset, 1);
            this.builder.setuint16(this.newSTOffset + 4, this.targetValue1Format);
            this.builder.setuint16(this.newSTOffset + 6, this.targetValue2Format);
        }

        boolean[] computeMembersToKeep(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2);
            boolean[] blArray = new boolean[n3];
            Arrays.fill(blArray, true);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.origTable.data.getuint16(n2 + 2 + (2 + this.value1Size + this.value2Size) * i);
                if (this.subset.getExistingSubsetGid(n4) != -1) continue;
                blArray[i] = false;
            }
            return blArray;
        }

        int whichRuleSetIndexApplies(int n, int n2) throws InvalidFontException {
            return n2;
        }

        int writeMember(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            this.builder.ensureCapacity(n + 2 + this.targetValue1Size + this.targetValue2Size);
            int n3 = this.origTable.data.getuint16(n2);
            this.builder.setuint16(n, this.subset.getExistingSubsetGid(n3));
            GposSubsetter.this.writeValueFormatFromOriginal(n2 + 2, n + 2, this.value1Format, this.targetValue1Format);
            GposSubsetter.this.writeValueFormatFromOriginal(n2 + 2 + this.value1Size, n + 2 + this.targetValue1Size, this.value2Format, this.targetValue2Format);
            return 2 + this.targetValue1Size + this.targetValue2Size;
        }

        int getOrigRecordSize() {
            return 2 + this.value1Size + this.value2Size;
        }
    }

    private class Type1Format2Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private final Subset subset;
        private final int newSTOffset;
        private final int origSTOffset;
        int glyphCount = 0;
        private int[] subsetToOrigCoverageIndex;

        Type1Format2Generator(int n, int n2, Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.subset = subset;
            this.newSTOffset = n2;
            this.origSTOffset = n;
            this.subsetToOrigCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToOrigCoverageIndex, -1);
            GposSubsetter.this.origTable.iterateCoverage(GposSubsetter.this.origTable.data.getOffset(n, 2), subset, this);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.subset.getExistingSubsetGid(n);
            this.subsetToOrigCoverageIndex[n3] = n2;
            ++this.glyphCount;
            return true;
        }

        public int writeSubtable() throws InvalidFontException {
            int n = GposSubsetter.this.origTable.data.getuint16(this.origSTOffset + 4);
            int n2 = GposSubsetter.this.targetValueFormat(n);
            int n3 = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(n2);
            int n4 = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(n);
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + 8 + n3 * this.glyphCount);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 2);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 4, n2);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 6, this.glyphCount);
            int n5 = 0;
            for (int i = 0; i < this.subset.getNumGlyphs() && n5 < this.glyphCount; ++i) {
                if (this.subsetToOrigCoverageIndex[i] == -1) continue;
                GposSubsetter.this.writeValueFormatFromOriginal(this.origSTOffset + 8 + n4 * this.subsetToOrigCoverageIndex[i], this.newSTOffset + 8 + n3 * n5, n, n2);
                ++n5;
            }
            return 8 + n3 * this.glyphCount;
        }
    }

    private class L1F2TargetFormatDeterminer
    implements LayoutTable.CoverageConsumer {
        private boolean canUseFormat1 = true;
        private final int origSTOffset;
        private final int valueFormatSize;
        int[] bytes = null;

        public L1F2TargetFormatDeterminer(int n) throws InvalidFontException {
            this.origSTOffset = n;
            this.valueFormatSize = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(GposSubsetter.this.origTable.data.getuint16(n + 4)) / 2;
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            if (this.bytes == null) {
                this.bytes = new int[this.valueFormatSize];
                for (int i = 0; i < this.valueFormatSize; ++i) {
                    this.bytes[i] = GposSubsetter.this.origTable.data.getint16(this.origSTOffset + 8 + n2 * this.valueFormatSize * 2 + i);
                }
            } else {
                for (int i = 0; i < this.valueFormatSize; ++i) {
                    int n3 = GposSubsetter.this.origTable.data.getint16(this.origSTOffset + 8 + n2 * this.valueFormatSize * 2 + i);
                    if (n3 == this.bytes[i]) continue;
                    this.canUseFormat1 = false;
                    return false;
                }
            }
            return true;
        }

        boolean canUseFormat1(Subset subset) throws InvalidFontException, UnsupportedFontException {
            GposSubsetter.this.origTable.iterateCoverage(GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2), subset, this);
            return this.canUseFormat1;
        }
    }
}

