/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.math.F16Dot16;
import com.adobe.fontengine.math.F16Dot16Vector;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import com.adobe.fontengine.math.F2Dot14;
import com.adobe.fontengine.math.F2Dot14Vector;

public class TTInterpreter {
    private GraphicState gs;
    private GraphicParameters gp;
    private StorageArea storageArea;
    private Stack stack;
    private FunctionDefinitions functionDefs;
    private FunctionDefinitions instructionDefs = new FunctionDefinitions(256);
    private int unitsPerEm;
    private Matrix em2px;
    private TTPoint[] twilightZone;
    static Instr[] instructions = new Instr[]{new Instr(0, "SetVectorsToCoordAxis {x}", 0, 0), new Instr(1, "SetVectorsToCoordAxis {y}", 0, 0), new Instr(2, "SetPVToCoordAxis {x}", 0, 0), new Instr(3, "SetPVToCoordAxis {y}", 0, 0), new Instr(4, "SetFVToCoordAxis {x}", 0, 0), new Instr(5, "SetFVToCoordAxis {y}", 0, 0), new Instr(6, "SetPVToLine {para}", 2, 0), new Instr(7, "SetPVToLine {perp}", 2, 0), new Instr(8, "SetFVToLine {para}", 2, 0), new Instr(9, "SetFVToLine {para}", 2, 0), new Instr(10, "SetPVFromStack", 2, 0), new Instr(11, "SetFVFromStack", 2, 0), new Instr(12, "GetPV", 0, 2), new Instr(13, "GetFV", 0, 2), new Instr(14, "SetFVtoPV", 0, 0), new Instr(15, "movepointtoInterSECTion", 5, 0), new Instr(16, "SetRP0", 1, 0), new Instr(17, "SetRP1", 1, 0), new Instr(18, "SetRP2", 1, 0), new Instr(19, "SetZP0", 1, 0), new Instr(20, "SetZP1", 1, 0), new Instr(21, "SetZP2", 1, 0), new Instr(22, "SetZPS", 1, 0), new Instr(23, "SetLOOPvariable", 1, 0), new Instr(24, "RoundToGrid", 0, 0), new Instr(25, "RoundToHalfGrid", 0, 0), new Instr(26, "SetMinimumDistance", 1, 0), new Instr(27, "ELSE", 0, 0), new Instr(28, "JuMPRelative", 1, 0), new Instr(29, "SetCVTCutIn", 1, 0), new Instr(30, "SetSingleWidthCutIn", 1, 0), new Instr(31, "SetSingleWdith", 1, 0), new Instr(32, "DUP", 0, 1), new Instr(33, "POP", 0, 0), new Instr(34, "CLEAR", 0, 0), new Instr(35, "SWAP", 2, 2), new Instr(36, "DEPTH", 0, 1), new Instr(37, "CINDEX", 1, 1), new Instr(38, "MINDEX", 1, 1), new Instr(39, "ALIGNPoinTS", 2, 0), new Instr(40, "<idef>", 0, 0), new Instr(41, "UnTouchPoint", 1, 0), new Instr(42, "LOOPCALL", 2, 0), new Instr(43, "CALL", 1, 0), new Instr(44, "FDEF", 1, 0), new Instr(45, "ENDF", 0, 0), new Instr(46, "MoveDirectAbsolutePoint {noround}", 1, 0), new Instr(47, "MoveDirectAbsolutePoint {round}", 1, 0), new Instr(48, "InterpolateUntouchedPoints {y}", 0, 0), new Instr(49, "InterpolateUntouchedPoints {x}", 0, 0), new Instr(50, "ShiftPoint {zp1-rp2}", 0, 0), new Instr(51, "ShiftPoint {zp0-rp1}", 0, 0), new Instr(52, "SHiftContour {zp1-rp2}", 0, 0), new Instr(53, "SHiftContour {zp0-rp1}", 0, 0), new Instr(54, "SHiftZone {zp1-rp2}", 0, 0), new Instr(55, "SHiftZone {zp0-rp1}", 0, 0), new Instr(56, "SHiftpointbyPIXelamount", 0, 0), new Instr(57, "InterPolate", 0, 0), new Instr(58, "MoveStackIndirectRelativePoint", 2, 0), new Instr(59, "MoveStackIndirectRelativePoint {setRp0}", 2, 0), new Instr(60, "ALIGNRelativePoint", 0, 0), new Instr(61, "RoundToDoubleGrid", 0, 0), new Instr(62, "MoveIndirectAbsolutePoint {noround}", 2, 0), new Instr(63, "MoveIndirectAbsolutePoint {round}", 2, 0), new Instr(64, "NPUSHB", 0, 0), new Instr(65, "NPUSHW", 0, 0), new Instr(66, "WriteStore", 2, 0), new Instr(67, "ReadStore", 1, 1), new Instr(68, "WriteCVTPixel", 2, 0), new Instr(69, "ReadCVT", 1, 1), new Instr(70, "GetCoordinate (proj)", 1, 1), new Instr(71, "GetCoordinate (unhinted)", 1, 1), new Instr(72, "SetCoordinateFromStack", 2, 0), new Instr(73, "MeasureDistance (hinted)", 2, 1), new Instr(74, "MeasureDistance (original)", 2, 1), new Instr(75, "MeasurePPEM", 0, 1), new Instr(76, "MeasurePointSize", 0, 1), new Instr(77, "FLIPON", 0, 0), new Instr(78, "FLIPOFF", 0, 0), new Instr(79, "DEBUG", 1, 0), new Instr(80, "LessThan", 2, 1), new Instr(81, "LessThanEQ", 2, 1), new Instr(82, "GreaterThan", 2, 1), new Instr(83, "GreateThanEQ", 2, 1), new Instr(84, "EQual", 2, 1), new Instr(85, "NotEQual", 2, 1), new Instr(86, "ODD", 1, 1), new Instr(87, "EVEN", 1, 1), new Instr(88, "IF", 1, 0), new Instr(89, "EIF", 0, 0), new Instr(90, "AND", 2, 1), new Instr(91, "OR", 2, 1), new Instr(92, "NOT", 1, 1), new Instr(93, "DELTAP1", 1, 0), new Instr(94, "SetDeltaBase", 1, 0), new Instr(95, "SetDeltaShift", 1, 0), new Instr(96, "ADD", 2, 1), new Instr(97, "SUB", 2, 1), new Instr(98, "DIV", 2, 1), new Instr(99, "MUL", 2, 1), new Instr(100, "ABS", 1, 1), new Instr(101, "NEG", 1, 1), new Instr(102, "FLOOR", 1, 1), new Instr(103, "CEILING", 1, 1), new Instr(104, "ROUND {comp0}", 1, 1), new Instr(105, "ROUND {comp1}", 1, 1), new Instr(106, "ROUND {comp2}", 1, 1), new Instr(107, "ROUND {comp3}", 1, 1), new Instr(108, "NROUND {comp0}", 1, 1), new Instr(109, "NROUND {comp1}", 1, 1), new Instr(110, "NROUND {comp2}", 1, 1), new Instr(111, "NROUND {comp3}", 1, 1), new Instr(112, "WriteCVTFunits", 2, 0), new Instr(113, "DELTAP2", 1, 0), new Instr(114, "DELTAP3", 1, 0), new Instr(115, "DELTAC1", 1, 0), new Instr(116, "DELTAC2", 1, 0), new Instr(117, "DELTAC3", 1, 0), new Instr(118, "SuperROUND", 1, 0), new Instr(119, "S45ROUND", 1, 0), new Instr(120, "JumpRelativeOnTrue", 2, 0), new Instr(121, "JumpRelativeOnFalse", 2, 0), new Instr(122, "RoundOFF", 0, 0), new Instr(123, "<idef>", 0, 0), new Instr(124, "RoundUpToGrid", 0, 0), new Instr(125, "RoundDownToGrid", 0, 0), new Instr(126, "SetANGleWeight", 1, 0), new Instr(127, "AdjustAngle", 0, 0), new Instr(128, "FliPPoinT", 0, 0), new Instr(129, "FLIPRanGeON", 2, 0), new Instr(130, "FLIPRanGeOFF", 2, 0), new Instr(131, "<idef>", 0, 0), new Instr(132, "<idef>", 0, 0), new Instr(133, "SCANCTRL", 1, 0), new Instr(134, "SetDPVToLine {para}", 2, 0), new Instr(135, "SetDPVToLine {perp}", 2, 0), new Instr(136, "GETINFO", 1, 1), new Instr(137, "IDEF", 1, 0), new Instr(138, "ROLL", 3, 3), new Instr(139, "MAX", 2, 1), new Instr(140, "MIN", 2, 1), new Instr(141, "SCANTYPE", 1, 0), new Instr(142, "INSTCRL", 2, 0), new Instr(143, "<idef>", 0, 0), new Instr(144, "<idef>", 0, 0), new Instr(145, "<idef>", 0, 0), new Instr(146, "<idef>", 0, 0), new Instr(147, "<idef>", 0, 0), new Instr(148, "<idef>", 0, 0), new Instr(149, "<idef>", 0, 0), new Instr(150, "<idef>", 0, 0), new Instr(151, "<idef>", 0, 0), new Instr(152, "<idef>", 0, 0), new Instr(153, "<idef>", 0, 0), new Instr(154, "<idef>", 0, 0), new Instr(155, "<idef>", 0, 0), new Instr(156, "<idef>", 0, 0), new Instr(157, "<idef>", 0, 0), new Instr(158, "<idef>", 0, 0), new Instr(159, "<idef>", 0, 0), new Instr(160, "<idef>", 0, 0), new Instr(161, "<idef>", 0, 0), new Instr(162, "<idef>", 0, 0), new Instr(163, "<idef>", 0, 0), new Instr(164, "<idef>", 0, 0), new Instr(165, "<idef>", 0, 0), new Instr(166, "<idef>", 0, 0), new Instr(167, "<idef>", 0, 0), new Instr(168, "<idef>", 0, 0), new Instr(169, "<idef>", 0, 0), new Instr(170, "<idef>", 0, 0), new Instr(171, "<idef>", 0, 0), new Instr(172, "<idef>", 0, 0), new Instr(173, "<idef>", 0, 0), new Instr(174, "<idef>", 0, 0), new Instr(175, "<idef>", 0, 0), new Instr(176, "PUSHB1", 0, 1), new Instr(177, "PUSHB2", 0, 2), new Instr(178, "PUSHB3", 0, 3), new Instr(179, "PUSHB4", 0, 4), new Instr(180, "PUSHB5", 0, 5), new Instr(181, "PUSHB6", 0, 6), new Instr(182, "PUSHB7", 0, 7), new Instr(183, "PUSHB8", 0, 8), new Instr(184, "PUSHW1", 0, 1), new Instr(185, "PUSHW2", 0, 2), new Instr(186, "PUSHW3", 0, 3), new Instr(187, "PUSHW4", 0, 4), new Instr(188, "PUSHW5", 0, 5), new Instr(189, "PUSHW6", 0, 6), new Instr(190, "PUSHW7", 0, 7), new Instr(191, "PUSHW8", 0, 8), new Instr(192, "MoveDirectRelativePoint {comp0}", 1, 0), new Instr(193, "MoveDirectRelativePoint {comp1}", 1, 0), new Instr(194, "MoveDirectRelativePoint {comp2}", 1, 0), new Instr(195, "MoveDirectRelativePoint {comp3}", 1, 0), new Instr(196, "MoveDirectRelativePoint {round, comp0}", 1, 0), new Instr(197, "MoveDirectRelativePoint {round, comp1}", 1, 0), new Instr(198, "MoveDirectRelativePoint {round, comp2}", 1, 0), new Instr(199, "MoveDirectRelativePoint {round, comp3}", 1, 0), new Instr(200, "MoveDirectRelativePoint {keepMin, comp0}", 1, 0), new Instr(201, "MoveDirectRelativePoint {keepMin, comp1}", 1, 0), new Instr(202, "MoveDirectRelativePoint {keepMin, comp2}", 1, 0), new Instr(203, "MoveDirectRelativePoint {keepMin, comp3}", 1, 0), new Instr(204, "MoveDirectRelativePoint {keepMin, round, comp0}", 1, 0), new Instr(205, "MoveDirectRelativePoint {keepMin, round, comp1}", 1, 0), new Instr(206, "MoveDirectRelativePoint {keepMin, round, comp2}", 1, 0), new Instr(207, "MoveDirectRelativePoint {keepMin, round, comp3}", 1, 0), new Instr(208, "MoveDirectRelativePoint {setRp0, comp0}", 1, 0), new Instr(209, "MoveDirectRelativePoint {setRp0, comp1}", 1, 0), new Instr(210, "MoveDirectRelativePoint {setRp0, comp2}", 1, 0), new Instr(211, "MoveDirectRelativePoint {setRp0, comp3}", 1, 0), new Instr(212, "MoveDirectRelativePoint {setRp0, round, comp0}", 1, 0), new Instr(213, "MoveDirectRelativePoint {setRp0, round, comp1}", 1, 0), new Instr(214, "MoveDirectRelativePoint {setRp0, round, comp2}", 1, 0), new Instr(215, "MoveDirectRelativePoint {setRp0, round, comp3}", 1, 0), new Instr(216, "MoveDirectRelativePoint {setRp0, keepMin, comp0}", 1, 0), new Instr(217, "MoveDirectRelativePoint {setRp0, keepMin, comp1}", 1, 0), new Instr(218, "MoveDirectRelativePoint {setRp0, keepMin, comp2}", 1, 0), new Instr(219, "MoveDirectRelativePoint {setRp0, keepMin, comp3}", 1, 0), new Instr(220, "MoveDirectRelativePoint {setRp0, keepMin, round, comp0}", 1, 0), new Instr(221, "MoveDirectRelativePoint {setRp0, keepMin, round, comp1}", 1, 0), new Instr(222, "MoveDirectRelativePoint {setRp0, keepMin, round, comp2}", 1, 0), new Instr(223, "MoveDirectRelativePoint {setRp0, keepMin, round, comp3}", 1, 0), new Instr(224, "MoveIndirectRelativePoint {comp0}", 2, 0), new Instr(225, "MoveIndirectRelativePoint {comp1}", 2, 0), new Instr(226, "MoveIndirectRelativePoint {comp2}", 2, 0), new Instr(227, "MoveIndirectRelativePoint {comp3}", 2, 0), new Instr(228, "MoveIndirectRelativePoint {round, comp0}", 2, 0), new Instr(229, "MoveIndirectRelativePoint {round, comp1}", 2, 0), new Instr(230, "MoveIndirectRelativePoint {round, comp2}", 2, 0), new Instr(231, "MoveIndirectRelativePoint {round, comp3}", 2, 0), new Instr(232, "MoveIndirectRelativePoint {keepMin, comp0}", 2, 0), new Instr(233, "MoveIndirectRelativePoint {keepMin, comp1}", 2, 0), new Instr(234, "MoveIndirectRelativePoint {keepMin, comp2}", 2, 0), new Instr(235, "MoveIndirectRelativePoint {keepMin, comp3}", 2, 0), new Instr(236, "MoveIndirectRelativePoint {keepMin, round, comp0}", 2, 0), new Instr(237, "MoveIndirectRelativePoint {keepMin, round, comp1}", 2, 0), new Instr(238, "MoveIndirectRelativePoint {keepMin, round, comp2}", 2, 0), new Instr(239, "MoveIndirectRelativePoint {keepMin, round, comp3}", 2, 0), new Instr(240, "MoveIndirectRelativePoint {setRp0, comp0}", 2, 0), new Instr(241, "MoveIndirectRelativePoint {setRp0, comp1}", 2, 0), new Instr(242, "MoveIndirectRelativePoint {setRp0, comp2}", 2, 0), new Instr(243, "MoveIndirectRelativePoint {setRp0, comp3}", 2, 0), new Instr(244, "MoveIndirectRelativePoint {setRp0, round, comp0}", 2, 0), new Instr(245, "MoveIndirectRelativePoint {setRp0, round, comp1}", 2, 0), new Instr(246, "MoveIndirectRelativePoint {setRp0, round, comp2}", 2, 0), new Instr(247, "MoveIndirectRelativePoint {setRp0, round, comp3}", 2, 0), new Instr(248, "MoveIndirectRelativePoint {setRp0, keepMin, comp0}", 2, 0), new Instr(249, "MoveIndirectRelativePoint {setRp0, keepMin, comp1}", 2, 0), new Instr(250, "MoveIndirectRelativePoint {setRp0, keepMin, comp2}", 2, 0), new Instr(251, "MoveIndirectRelativePoint {setRp0, keepMin, comp3}", 2, 0), new Instr(252, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp0}", 2, 0), new Instr(253, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp1}", 2, 0), new Instr(254, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp2}", 2, 0), new Instr(255, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp3}", 2, 0)};
    private ScalerDebugger debugger;
    private Instr currentInstr;
    private StringBuffer sb = new StringBuffer();
    private StringBuffer sbDetails = new StringBuffer();

    public TTInterpreter(int n, int n2, int n3, OTByteArray oTByteArray, int n4, int n5) throws InvalidFontException, UnsupportedFontException {
        this.gs = new GraphicState(n3, oTByteArray);
        this.gp = new GraphicParameters();
        this.storageArea = new StorageArea(n);
        this.stack = new Stack(n2);
        this.functionDefs = new FunctionDefinitions(n4);
        this.instructionDefs = new FunctionDefinitions(256);
        this.twilightZone = new TTPoint[n5];
        for (int i = 0; i < this.twilightZone.length; ++i) {
            this.twilightZone[i] = new TTPoint(0, 0, false);
        }
    }

    public void setUnitsPerEm(int n) {
        this.unitsPerEm = n;
    }

    public void setScaling(double d, double d2, double d3, double d4, double d5) throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2;
        this.gs.setPointSize(d);
        boolean bl = false;
        boolean bl2 = false;
        this.em2px = new Matrix(d2, 0.0, 0.0, d3, d4, d5);
        if (bl) {
            n2 = F16Dot16.fromInt(this.unitsPerEm);
            n = F16Dot16.fromInt(this.unitsPerEm);
        } else {
            n2 = F16Dot16.fromDouble(Math.max(this.em2px.a, this.em2px.c));
            n = F16Dot16.fromDouble(Math.max(this.em2px.b, this.em2px.d));
            if (bl2) {
                n2 = F16Dot16.round(n2);
                n = F16Dot16.round(n);
            }
        }
        this.gs.cvtxN = n2;
        this.gs.cvtD = F16Dot16.fromInt(this.unitsPerEm);
        this.gs.cvtyN = n;
        if (n2 >= n) {
            ((GraphicState)this.gs).cvtStretch.x = 65536;
            ((GraphicState)this.gs).cvtStretch.y = F16Dot16.divide(n, n2);
            this.gs.setPixelsPerEm(d2);
        } else {
            ((GraphicState)this.gs).cvtStretch.x = F16Dot16.divide(n2, n);
            ((GraphicState)this.gs).cvtStretch.y = 65536;
            this.gs.setPixelsPerEm(d3);
        }
        this.gs.resetAndScaleCVT();
    }

    private TTPoint getPoint(TTOutline tTOutline, int n, int n2) throws InvalidGlyphException {
        if (n == 0) {
            return this.twilightZone[n2];
        }
        return tTOutline.getPoint(n2);
    }

    private int getNumOutlinePoints(TTOutline tTOutline, int n) throws InvalidGlyphException {
        if (n == 0) {
            return this.twilightZone.length;
        }
        return tTOutline.getNumOutlinePoints();
    }

    public int getScanType() {
        int n = this.gs.getScanControl();
        int n2 = n & 0xFF;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = (n & 0x100) != 0 && this.gs.getPixelsPerEm() <= n2 ? true : ((n & 0x100) != 0 && n2 == 255 ? true : ((n & 0x200) != 0 && bl ? true : ((n & 0x400) != 0 && bl2 ? true : ((n & 0x800) != 0 && this.gs.getPixelsPerEm() > n2 ? false : ((n & 0x1000) != 0 && !bl ? false : ((n & 0x2000) != 0 && !bl2 ? false : false))))));
        if (bl3) {
            return n >> 16;
        }
        return 2;
    }

    public void runFpgm(OTByteArray oTByteArray, int n, int n2) throws InvalidFontException, UnsupportedFontException {
        this.run(null, oTByteArray, n, n2);
    }

    public void runPrep(OTByteArray oTByteArray, int n, int n2) throws InvalidFontException, UnsupportedFontException {
        this.gs.setAutoFlip(true);
        this.gs.setDeltaBase(9);
        this.gs.setDeltaShift(3);
        this.gs.setRoundMode(this.gs.ROUND_TO_GRID);
        this.gs.setMinimumDistance(64);
        this.gs.setControlValueCutIn(F26Dot6.fromDouble(1.0625));
        this.gs.setSingleWidth(0);
        this.gs.setSingleWidthCutIn(0);
        this.gs.setAngleWeight(128);
        this.gs.setScanControl(0);
        this.gs.setInstrControl(0);
        try {
            this.gs.defaultGraphicState = (LocalGraphicState)this.gs.localGraphicState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("LocalGraphicState cannot be cloned!");
        }
        this.run(null, oTByteArray, n, n2);
        if ((this.gs.getInstrControl() & 2) == 0) {
            try {
                this.gs.defaultGraphicState = (LocalGraphicState)this.gs.localGraphicState.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("LocalGraphicState cannot be cloned!");
            }
        }
    }

    public void runGlyf(TTSimpleOutline tTSimpleOutline, OTByteArray oTByteArray, int n, int n2) throws InvalidGlyphException, UnsupportedFontException {
        if ((this.gs.getInstrControl() & 1) != 0) {
            return;
        }
        try {
            this.gs.localGraphicState = (LocalGraphicState)this.gs.defaultGraphicState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("LocalGraphicState cannot be cloned!");
        }
        this.run(tTSimpleOutline, oTByteArray, n, n2);
    }

    private void run(TTSimpleOutline tTSimpleOutline, OTByteArray oTByteArray, int n, int n2) throws InvalidGlyphException, UnsupportedFontException {
        this.gs.setRp0(0);
        this.gs.setRp1(0);
        this.gs.setRp2(0);
        this.gs.setZp0(1);
        this.gs.setZp1(1);
        this.gs.setZp2(1);
        this.gs.setVector(this.gs.projectionVector, 16384, 0, false);
        this.gs.setVector(this.gs.freedomVector, 16384, 0, false);
        this.gs.setVector(this.gs.originalProjectionVector, 16384, 0, false);
        this.gs.setLoopVariable(1);
        this.runWithoutInit(tTSimpleOutline, oTByteArray, n, n2);
    }

    private int scaleAndRound(int n, int n2, int n3) {
        int n4 = n3 >> 1;
        n = n < 0 ? -(-n * n2 + n4) / n3 : (n * n2 + n4) / n3;
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runWithoutInit(TTSimpleOutline var1_1, OTByteArray var2_2, int var3_3, int var4_4) throws InvalidGlyphException, UnsupportedFontException {
        block243: {
            var5_5 = var3_3;
            try {
                block153: while (var3_3 < var4_4) {
                    var6_6 = var2_2.getuint8(var3_3);
                    ++var3_3;
                    switch (var6_6) {
                        case 64: {
                            var7_9 = var2_2.getuint8(var3_3);
                            ++var3_3;
                            for (var8_75 = 0; var8_75 < var7_9; ++var3_3, ++var8_75) {
                                this.stack.push(var2_2.getuint8(var3_3));
                            }
                            continue block153;
                        }
                        case 65: {
                            var7_10 = var2_2.getuint8(var3_3);
                            ++var3_3;
                            for (var8_76 = 0; var8_76 < var7_10; var3_3 += 2, ++var8_76) {
                                this.stack.push(var2_2.getint16(var3_3));
                            }
                            continue block153;
                        }
                        case 176: 
                        case 177: 
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: {
                            var7_11 = (var6_6 & 7) + 1;
                            for (var8_77 = 0; var8_77 < var7_11; ++var3_3, ++var8_77) {
                                this.stack.push(var2_2.getuint8(var3_3));
                            }
                            continue block153;
                        }
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: {
                            var7_12 = (var6_6 & 7) + 1;
                            for (var8_78 = 0; var8_78 < var7_12; var3_3 += 2, ++var8_78) {
                                this.stack.push(var2_2.getint16(var3_3));
                            }
                            continue block153;
                        }
                        case 67: {
                            this.stack.push(this.storageArea.getuint32(this.stack.pop()));
                            break;
                        }
                        case 66: {
                            var7_13 = this.stack.pop();
                            var8_79 = this.stack.pop();
                            this.storageArea.setuint32(var8_79, var7_13);
                            break;
                        }
                        case 68: {
                            var7_14 = this.stack.pop();
                            var8_80 = this.stack.pop();
                            this.gs.putCVT(var8_80, var7_14);
                            break;
                        }
                        case 112: {
                            var7_15 = this.stack.pop();
                            var8_81 = this.stack.pop();
                            this.gs.putCVTPixels(var8_81, var7_15);
                            break;
                        }
                        case 69: {
                            this.stack.push(this.gs.getCVT(this.stack.pop()));
                            break;
                        }
                        case 0: 
                        case 1: {
                            var7_16 = (var6_6 & 1) == 0;
                            this.gs.setVector(GraphicState.access$2000(this.gs), 16384, 0, var7_16);
                            this.gs.setVector(GraphicState.access$2200(this.gs), 16384, 0, var7_16);
                            this.gs.setVector(GraphicState.access$2100(this.gs), 16384, 0, var7_16);
                            break;
                        }
                        case 2: 
                        case 3: {
                            var7_17 = (var6_6 & 1) == 0;
                            this.gs.setVector(GraphicState.access$2000(this.gs), 16384, 0, var7_17);
                            this.gs.setVector(GraphicState.access$2200(this.gs), 16384, 0, var7_17);
                            break;
                        }
                        case 4: 
                        case 5: {
                            var7_18 = (var6_6 & 1) == 0;
                            this.gs.setVector(GraphicState.access$2100(this.gs), 16384, 0, var7_18);
                            break;
                        }
                        case 6: 
                        case 7: {
                            var7_19 = (var6_6 & 1) == 1;
                            var8_82 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                            var9_128 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            this.gs.setVector(GraphicState.access$2000(this.gs), var8_82.hinted, var9_128.hinted, var7_19);
                            break;
                        }
                        case 8: 
                        case 9: {
                            var7_20 = (var6_6 & 1) == 1;
                            var8_83 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                            var9_129 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            this.gs.setVector(GraphicState.access$2100(this.gs), var8_83.hinted, var9_129.hinted, var7_20);
                            break;
                        }
                        case 134: 
                        case 135: {
                            var7_21 = (var6_6 & 1) == 1;
                            var8_84 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                            var9_130 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            this.gs.setVector(GraphicState.access$2200(this.gs), var8_84.unhinted, var9_130.unhinted, var7_21);
                            this.gs.setVector(GraphicState.access$2000(this.gs), var8_84.hinted, var9_130.hinted, var7_21);
                            break;
                        }
                        case 14: {
                            this.gs.setVector(GraphicState.access$2100(this.gs), GraphicState.access$2000((GraphicState)this.gs).x, GraphicState.access$2000((GraphicState)this.gs).y, false);
                            break;
                        }
                        case 10: {
                            var7_22 = this.stack.pop();
                            var8_85 = this.stack.pop();
                            this.gs.setVector(GraphicState.access$2000(this.gs), var8_85, var7_22, false);
                            this.gs.setVector(GraphicState.access$2200(this.gs), var8_85, var7_22, false);
                            break;
                        }
                        case 11: {
                            var7_23 = this.stack.pop();
                            var8_86 = this.stack.pop();
                            this.gs.setVector(GraphicState.access$2100(this.gs), var8_86, var7_23, false);
                            break;
                        }
                        case 12: {
                            this.stack.push(GraphicState.access$2000((GraphicState)this.gs).x);
                            this.stack.push(GraphicState.access$2000((GraphicState)this.gs).y);
                            break;
                        }
                        case 13: {
                            this.stack.push(GraphicState.access$2100((GraphicState)this.gs).x);
                            this.stack.push(GraphicState.access$2100((GraphicState)this.gs).y);
                            break;
                        }
                        case 16: {
                            this.gs.setRp0(this.stack.pop());
                            break;
                        }
                        case 17: {
                            this.gs.setRp1(this.stack.pop());
                            break;
                        }
                        case 18: {
                            this.gs.setRp2(this.stack.pop());
                            break;
                        }
                        case 19: {
                            this.gs.setZp0(this.stack.pop());
                            break;
                        }
                        case 20: {
                            this.gs.setZp1(this.stack.pop());
                            break;
                        }
                        case 21: {
                            this.gs.setZp2(this.stack.pop());
                            break;
                        }
                        case 22: {
                            var7_24 = this.stack.pop();
                            this.gs.setZp0(var7_24);
                            this.gs.setZp1(var7_24);
                            this.gs.setZp2(var7_24);
                            break;
                        }
                        case 25: {
                            this.gs.setRoundMode(this.gs.ROUND_TO_HALF_GRID);
                            break;
                        }
                        case 24: {
                            this.gs.setRoundMode(this.gs.ROUND_TO_GRID);
                            break;
                        }
                        case 61: {
                            this.gs.setRoundMode(this.gs.ROUND_TO_DOUBLE_GRID);
                            break;
                        }
                        case 125: {
                            this.gs.setRoundMode(this.gs.ROUND_DOWN_TO_GRID);
                            break;
                        }
                        case 124: {
                            this.gs.setRoundMode(this.gs.ROUND_UP_TO_GRID);
                            break;
                        }
                        case 122: {
                            this.gs.setRoundMode(this.gs.ROUND_OFF);
                            break;
                        }
                        case 118: 
                        case 119: {
                            var7_25 = this.stack.pop();
                            var10_159 = 0;
                            if ((var6_6 & 1) == 0) {
                                switch (var7_25 & 192) {
                                    case 0: {
                                        var8_87 = 32;
                                        break;
                                    }
                                    case 64: {
                                        var8_87 = 64;
                                        break;
                                    }
                                    case 128: {
                                        var8_87 = 128;
                                        break;
                                    }
                                    default: {
                                        var8_87 = 999;
                                        break;
                                    }
                                }
                            } else {
                                var9_131 = 11591;
                                switch (var7_25 & 192) {
                                    case 0: {
                                        var9_131 >>= 1;
                                        break;
                                    }
                                    case 64: {
                                        break;
                                    }
                                    case 128: {
                                        var9_131 <<= 1;
                                        break;
                                    }
                                    default: {
                                        var9_131 = 999;
                                    }
                                }
                                var12_191 = 8;
                                var8_87 = var9_131 + (1 << var12_191 - 1) >> var12_191;
                            }
                            switch (var7_25 & 48) {
                                case 0: {
                                    var10_159 = 0;
                                    break;
                                }
                                case 16: {
                                    var10_159 = var8_87 + 2 >> 2;
                                    break;
                                }
                                case 32: {
                                    var10_159 = var8_87 + 1 >> 1;
                                    break;
                                }
                                case 48: {
                                    var10_159 = var8_87 + var8_87 + var8_87 + 2 >> 2;
                                    break;
                                }
                            }
                            var11_176 = (var7_25 & 15) == 0 ? var8_87 - 1 : ((var7_25 & 15) - 4) * var8_87 + 4 >> 3;
                            this.gs.setRounding(var8_87, var10_159, var11_176, (var6_6 & 1) == 0 ? this.gs.SUPER_ROUND : this.gs.SUPER_45_ROUND);
                            break;
                        }
                        case 23: {
                            this.gs.setLoopVariable(this.stack.pop());
                            break;
                        }
                        case 26: {
                            this.gs.setMinimumDistance(this.stack.pop());
                            break;
                        }
                        case 142: {
                            var7_26 = this.stack.pop();
                            var8_88 = this.stack.pop();
                            var9_132 = this.gs.getInstrControl();
                            if (var7_26 == 1) {
                                var9_132 &= -2;
                            } else if (var7_26 == 2) {
                                var9_132 &= -3;
                            }
                            this.gs.setInstrControl(var9_132 |= var8_88);
                            break;
                        }
                        case 133: {
                            this.gs.setScanControl(this.gs.getScanControl() & -65536 | this.stack.pop() & 65535);
                            break;
                        }
                        case 141: {
                            this.gs.setScanControl(this.stack.pop() << 16 | this.gs.getScanControl() & 65535);
                            break;
                        }
                        case 29: {
                            this.gs.setControlValueCutIn(this.stack.pop());
                            break;
                        }
                        case 30: {
                            this.gs.setSingleWidthCutIn(this.stack.pop());
                            break;
                        }
                        case 31: {
                            this.gs.setSingleWidth(this.stack.pop());
                            break;
                        }
                        case 77: {
                            this.gs.setAutoFlip(true);
                            break;
                        }
                        case 78: {
                            this.gs.setAutoFlip(false);
                            break;
                        }
                        case 126: {
                            this.gs.setAngleWeight(this.stack.pop());
                            break;
                        }
                        case 94: {
                            this.gs.setDeltaBase(this.stack.pop());
                            break;
                        }
                        case 95: {
                            this.gs.setDeltaShift(this.stack.pop());
                            break;
                        }
                        case 70: 
                        case 71: {
                            var7_27 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                            if ((var6_6 & 1) == 0) {
                                this.stack.push(this.gs.project(GraphicState.access$2000(this.gs), var7_27.hinted));
                                break;
                            }
                            this.stack.push(this.gs.project(GraphicState.access$2200(this.gs), var7_27.unhinted));
                            break;
                        }
                        case 72: {
                            var7_28 = this.stack.pop();
                            var8_89 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                            var9_133 = this.gs.project(GraphicState.access$2000(this.gs), var8_89.hinted);
                            this.gs.move(var8_89, var7_28 - var9_133);
                            if (this.gs.getZp2() != 0) continue block153;
                            var8_89.unhinted.x = var8_89.hinted.x;
                            var8_89.unhinted.y = var8_89.hinted.y;
                            break;
                        }
                        case 73: 
                        case 74: {
                            var7_29 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            var8_90 = this.getPoint(var1_1, this.gs.getZp0(), this.stack.pop());
                            var9_134 = (var6_6 & 1) == 0 ? this.gs.project(GraphicState.access$2200(this.gs), var7_29.unhinted, var8_90.unhinted) : this.gs.project(GraphicState.access$2000(this.gs), var7_29.hinted, var8_90.hinted);
                            this.stack.push(var9_134);
                            break;
                        }
                        case 75: {
                            this.stack.push(this.gs.getPixelsPerEm());
                            break;
                        }
                        case 76: {
                            this.stack.push(this.gs.getPointSize());
                            break;
                        }
                        case 128: {
                            var7_30 = this.gs.getZp0();
                            for (var8_91 = this.gs.getAndResetLoopVariable(); var8_91 > 0; --var8_91) {
                                var9_135 = this.getPoint(var1_1, var7_30, this.stack.pop());
                                var9_135.onCurve = var9_135.onCurve == false;
                            }
                            continue block153;
                        }
                        case 129: 
                        case 130: {
                            var7_31 = this.gs.getZp0();
                            var8_92 = this.stack.pop();
                            var9_136 = this.stack.pop();
                            var10_160 = (var6_6 & 1) == 1;
                            for (var11_177 = var9_136; var11_177 <= var8_92; ++var11_177) {
                                this.getPoint((TTOutline)var1_1, (int)var7_31, (int)var11_177).onCurve = var10_160;
                            }
                            continue block153;
                        }
                        case 50: 
                        case 51: {
                            var7_32 = (var6_6 & 1) == 0 ? this.getPoint(var1_1, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp1());
                            var8_93 = this.gs.project(GraphicState.access$2000(this.gs), var7_32.unhinted, var7_32.hinted);
                            var9_137 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(var8_93, GraphicState.access$2100((GraphicState)this.gs).x, GraphicState.access$2300(this.gs));
                            var10_161 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(var8_93, GraphicState.access$2100((GraphicState)this.gs).y, GraphicState.access$2300(this.gs));
                            for (var11_178 = this.gs.getAndResetLoopVariable(); var11_178 > 0; --var11_178) {
                                var12_192 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                                if (var12_192 == var7_32) continue;
                                this.gs.move(var12_192, var9_137, var10_161);
                            }
                            continue block153;
                        }
                        case 52: 
                        case 53: {
                            var7_33 = this.stack.pop();
                            var8_94 = (var6_6 & 1) == 0 ? this.getPoint(var1_1, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp1());
                            var9_138 = this.gs.project(GraphicState.access$2000(this.gs), var8_94.unhinted, var8_94.hinted);
                            var10_162 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(var9_138, GraphicState.access$2100((GraphicState)this.gs).x, GraphicState.access$2300(this.gs));
                            var11_179 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(var9_138, GraphicState.access$2100((GraphicState)this.gs).y, GraphicState.access$2300(this.gs));
                            var12_191 = var1_1.getContourFirstPoint(var7_33);
                            var13_193 = var1_1.getContourLastPoint(var7_33);
                            for (var14_195 = var12_191; var14_195 <= var13_193; ++var14_195) {
                                var15_196 = this.getPoint(var1_1, this.gs.getZp2(), var14_195);
                                if (var15_196 == var8_94) continue;
                                this.gs.move(var15_196, var10_162, var11_179);
                            }
                            continue block153;
                        }
                        case 54: 
                        case 55: {
                            var7_34 = this.stack.pop();
                            var8_95 = (var6_6 & 1) == 0 ? this.getPoint(var1_1, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp1());
                            var9_139 = this.gs.project(GraphicState.access$2000(this.gs), var8_95.unhinted, var8_95.hinted);
                            var10_163 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(var9_139, GraphicState.access$2100((GraphicState)this.gs).x, GraphicState.access$2300(this.gs));
                            var11_180 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(var9_139, GraphicState.access$2100((GraphicState)this.gs).y, GraphicState.access$2300(this.gs));
                            var12_191 = 0;
                            var13_193 = this.getNumOutlinePoints(var1_1, var7_34) - 1;
                            for (var14_195 = var12_191; var14_195 <= var13_193; ++var14_195) {
                                var15_197 = this.getPoint(var1_1, var7_34, var14_195);
                                if (var15_197 == var8_95) continue;
                                this.gs.move(var15_197, var10_163, var11_180);
                            }
                            continue block153;
                        }
                        case 56: {
                            var7_35 = this.stack.pop();
                            var8_96 = F26Dot6.multiplyByF2Dot14(var7_35, GraphicState.access$2100((GraphicState)this.gs).x);
                            var9_140 = F26Dot6.multiplyByF2Dot14(var7_35, GraphicState.access$2100((GraphicState)this.gs).y);
                            for (var10_164 = this.gs.getAndResetLoopVariable(); var10_164 > 0; --var10_164) {
                                var11_181 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                                this.gs.move(var11_181, var8_96, var9_140);
                            }
                            continue block153;
                        }
                        case 58: 
                        case 59: {
                            var7_36 = this.stack.pop();
                            var8_97 = this.stack.pop();
                            var9_141 = this.getPoint(var1_1, this.gs.getZp1(), var8_97);
                            var10_165 = this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp0());
                            if (this.gs.getZp1() == 0) {
                                var9_141.unhinted.x = F26Dot6.multiplyByF2Dot14(var7_36, GraphicState.access$2000((GraphicState)this.gs).x);
                                var9_141.unhinted.y = F26Dot6.multiplyByF2Dot14(var7_36, GraphicState.access$2000((GraphicState)this.gs).y);
                                var9_141.hinted.x = var9_141.unhinted.x;
                                var9_141.hinted.y = var9_141.unhinted.y;
                            }
                            var11_182 = this.gs.project(GraphicState.access$2000(this.gs), var10_165.hinted, var9_141.hinted);
                            this.gs.move(var9_141, var7_36 - var11_182);
                            this.gs.setRp1(this.gs.getRp0());
                            this.gs.setRp2(var8_97);
                            if ((var6_6 & 1) == 0) continue block153;
                            this.gs.setRp0(var8_97);
                            break;
                        }
                        case 46: 
                        case 47: {
                            var7_37 = this.stack.pop();
                            var8_98 = this.getPoint(var1_1, this.gs.getZp0(), var7_37);
                            this.gs.setRp0(var7_37);
                            this.gs.setRp1(var7_37);
                            var9_142 = 0;
                            if ((var6_6 & 1) != 0) {
                                var10_166 = this.gs.project(GraphicState.access$2000(this.gs), var8_98.hinted);
                                var9_142 = this.gs.round(var10_166, this.gp.getEngineCompensation(0)) - var10_166;
                            }
                            this.gs.move(var8_98, var9_142);
                            break;
                        }
                        case 62: 
                        case 63: {
                            var7_38 = this.gs.getCVT(this.stack.pop());
                            var8_99 = this.stack.pop();
                            var9_143 = this.getPoint(var1_1, this.gs.getZp0(), var8_99);
                            this.gs.setRp0(var8_99);
                            this.gs.setRp1(var8_99);
                            if (this.gs.getZp0() == 0) {
                                var9_143.unhinted.x = F26Dot6.multiplyByF2Dot14(var7_38, GraphicState.access$2000((GraphicState)this.gs).x);
                                var9_143.unhinted.y = F26Dot6.multiplyByF2Dot14(var7_38, GraphicState.access$2000((GraphicState)this.gs).y);
                                var9_143.hinted.x = var9_143.unhinted.x;
                                var9_143.hinted.y = var9_143.unhinted.y;
                            }
                            var10_167 = this.gs.project(GraphicState.access$2000(this.gs), var9_143.hinted);
                            if ((var6_6 & 1) != 0) {
                                if (Math.abs(var7_38 - var10_167) > this.gs.getControlValueCutIn()) {
                                    var7_38 = var10_167;
                                }
                                var7_38 = this.gs.round(var7_38, this.gp.getEngineCompensation(0));
                            }
                            this.gs.move(var9_143, var7_38 - var10_167);
                            break;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: {
                            var7_39 = this.stack.pop();
                            var8_100 = this.getPoint(var1_1, this.gs.getZp1(), var7_39);
                            var9_144 = this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp0());
                            if (this.gs.getZp0() == 0 || this.gs.getZp1() == 0 || var1_1.unscaledCoordinatesAreInvalid) {
                                var10_168 = this.gs.project(GraphicState.access$2200(this.gs), var9_144.unhinted, var8_100.unhinted);
                            } else {
                                var11_183 = this.scaleAndRound(var8_100.unscaled.x - var9_144.unscaled.x, GraphicState.access$1600(this.gs) >> 10, GraphicState.access$1700(this.gs) >> 16);
                                var12_191 = this.scaleAndRound(var8_100.unscaled.y - var9_144.unscaled.y, GraphicState.access$1800(this.gs) >> 10, GraphicState.access$1700(this.gs) >> 16);
                                var10_168 = this.gs.project(GraphicState.access$2200(this.gs), var11_183, var12_191);
                            }
                            var11_184 = var10_168 = this.gs.snapToSingleWidth(var10_168);
                            var12_191 = this.gp.getEngineCompensation(var6_6 & 3);
                            var10_168 = (var6_6 & 4) != 0 ? this.gs.round(var10_168, var12_191) : this.gs.roundOff(var10_168, var12_191);
                            if ((var6_6 & 8) != 0) {
                                var13_193 = this.gs.getMinimumDistance();
                                if (var11_184 >= 0) {
                                    if (var10_168 < var13_193) {
                                        var10_168 = var13_193;
                                    }
                                } else if (var10_168 > -var13_193) {
                                    var10_168 = -var13_193;
                                }
                            }
                            var13_193 = this.gs.project(GraphicState.access$2000(this.gs), var9_144.hinted, var8_100.hinted);
                            this.gs.move(var8_100, var10_168 - var13_193);
                            this.gs.setRp1(this.gs.getRp0());
                            this.gs.setRp2(var7_39);
                            if ((var6_6 & 16) == 0) continue block153;
                            this.gs.setRp0(var7_39);
                            break;
                        }
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: {
                            var7_40 = this.gs.getCVT(this.stack.pop());
                            var8_101 = this.stack.pop();
                            var9_145 = this.getPoint(var1_1, this.gs.getZp1(), var8_101);
                            var10_169 = this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp0());
                            var7_40 = this.gs.snapToSingleWidth(var7_40);
                            if (this.gs.getZp1() == 0) {
                                var9_145.unhinted.x = var10_169.unhinted.x + F26Dot6.multiplyByF2Dot14(var7_40, GraphicState.access$2000((GraphicState)this.gs).x);
                                var9_145.unhinted.y = var10_169.unhinted.y + F26Dot6.multiplyByF2Dot14(var7_40, GraphicState.access$2000((GraphicState)this.gs).y);
                                var9_145.hinted.x = var9_145.unhinted.x;
                                var9_145.hinted.y = var9_145.unhinted.y;
                            }
                            var11_185 = this.gs.project(GraphicState.access$2200(this.gs), var10_169.unhinted, var9_145.unhinted);
                            var12_191 = this.gs.project(GraphicState.access$2000(this.gs), var10_169.hinted, var9_145.hinted);
                            if (this.gs.getAutoFlip() && !F26Dot6.sameSign(var11_185, var7_40)) {
                                var7_40 = -var7_40;
                            }
                            var13_193 = this.gp.getEngineCompensation(var6_6 & 3);
                            if ((var6_6 & 4) != 0) {
                                if (Math.abs(var7_40 - var11_185) > this.gs.getControlValueCutIn()) {
                                    var7_40 = var11_185;
                                }
                                var7_40 = this.gs.round(var7_40, var13_193);
                            } else {
                                var7_40 = this.gs.roundOff(var7_40, var13_193);
                            }
                            if ((var6_6 & 8) != 0) {
                                var14_195 = this.gs.getMinimumDistance();
                                if (var11_185 >= 0) {
                                    if (var7_40 < var14_195) {
                                        var7_40 = var14_195;
                                    }
                                } else if (var7_40 > -var14_195) {
                                    var7_40 = -var14_195;
                                }
                            }
                            this.gs.move(var9_145, var7_40 - var12_191);
                            this.gs.setRp1(this.gs.getRp0());
                            this.gs.setRp2(var8_101);
                            if ((var6_6 & 16) == 0) continue block153;
                            this.gs.setRp0(var8_101);
                            break;
                        }
                        case 60: {
                            var7_41 = this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp0());
                            for (var8_102 = this.gs.getAndResetLoopVariable(); var8_102 > 0; --var8_102) {
                                var9_146 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                                this.gs.move(var9_146, -this.gs.project(GraphicState.access$2000(this.gs), var7_41.hinted, var9_146.hinted));
                            }
                            continue block153;
                        }
                        case 127: {
                            throw new InvalidGlyphException("TT instruction AA is no longer supported");
                        }
                        case 15: {
                            var7_42 = this.getPoint(var1_1, this.gs.getZp0(), this.stack.pop());
                            var8_103 = this.getPoint(var1_1, this.gs.getZp0(), this.stack.pop());
                            var9_147 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            var10_170 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            var11_186 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                            var12_191 = var7_42.hinted.x - var8_103.hinted.x;
                            var13_193 = var7_42.hinted.y - var8_103.hinted.y;
                            var14_195 = var9_147.hinted.x - var10_170.hinted.x;
                            var15_198 = var9_147.hinted.y - var10_170.hinted.y;
                            if (var13_193 == 0) {
                                if (var14_195 == 0) {
                                    this.gs.set(var11_186, var10_170.hinted.x, var8_103.hinted.y);
                                    break;
                                }
                                var16_201 = var10_170.hinted.y - var8_103.hinted.y;
                                var17_203 = -var15_198;
                            } else if (var12_191 == 0) {
                                if (var15_198 == 0) {
                                    this.gs.set(var11_186, var8_103.hinted.x, var10_170.hinted.y);
                                    break;
                                }
                                var16_201 = var10_170.hinted.x - var8_103.hinted.x;
                                var17_203 = -var14_195;
                            } else if (F26Dot6.abs(var12_191) >= F26Dot6.abs(var13_193)) {
                                var16_201 = var10_170.hinted.y - var8_103.hinted.y - F26Dot6.multiplyDivide(var10_170.hinted.x - var8_103.hinted.x, var13_193, var12_191);
                                var17_203 = F26Dot6.multiplyDivide(var14_195, var13_193, var12_191) - var15_198;
                            } else {
                                var16_201 = F26Dot6.multiplyDivide(var10_170.hinted.y - var8_103.hinted.y, var12_191, var13_193) - (var10_170.hinted.x - var8_103.hinted.x);
                                var17_203 = var14_195 - F26Dot6.multiplyDivide(var15_198, var12_191, var13_193);
                            }
                            if (var17_203 != 0) {
                                this.gs.set(var11_186, var10_170.hinted.x + F26Dot6.multiplyDivide(var14_195, var16_201, var17_203), var10_170.hinted.y + F26Dot6.multiplyDivide(var15_198, var16_201, var17_203));
                                break;
                            }
                            this.gs.set(var11_186, var10_170.hinted.x + (var14_195 >> 1) + var8_103.hinted.x + (var12_191 >> 1) >> 1, var10_170.hinted.y + (var15_198 >> 1) + var8_103.hinted.y + (var13_193 >> 1) >> 1);
                            break;
                        }
                        case 39: {
                            var7_43 = this.getPoint(var1_1, this.gs.getZp1(), this.stack.pop());
                            var8_104 = this.getPoint(var1_1, this.gs.getZp0(), this.stack.pop());
                            var9_148 = this.gs.project(GraphicState.access$2000(this.gs), var7_43.hinted, var8_104.hinted);
                            this.gs.move(var7_43, var9_148 / 2);
                            this.gs.move(var8_104, var9_148 - var9_148 / 2);
                            break;
                        }
                        case 57: {
                            var7_44 = this.getPoint(var1_1, this.gs.getZp0(), this.gs.getRp1());
                            var8_105 = this.getPoint(var1_1, this.gs.getZp1(), this.gs.getRp2());
                            var9_149 = this.gs.getZp0() == 0 || this.gs.getZp1() == 0 || this.gs.getZp2() == 0 || var1_1.unscaledCoordinatesAreInvalid != false;
                            var10_171 = var9_149 != false ? this.gs.project(GraphicState.access$2200(this.gs), var7_44.unhinted, var8_105.unhinted) : this.gs.project(GraphicState.access$2200(this.gs), var8_105.unscaled.x - var7_44.unscaled.x, var8_105.unscaled.y - var7_44.unscaled.y);
                            var11_187 = this.gs.project(GraphicState.access$2000(this.gs), var7_44.hinted, var8_105.hinted);
                            for (var12_191 = this.gs.getAndResetLoopVariable(); var12_191 > 0; --var12_191) {
                                var13_194 = this.getPoint(var1_1, this.gs.getZp2(), this.stack.pop());
                                var14_195 = var9_149 != false ? this.gs.project(GraphicState.access$2000(this.gs), var7_44.unhinted, var13_194.unhinted) : this.gs.project(GraphicState.access$2000(this.gs), var13_194.unscaled.x - var7_44.unscaled.x, var13_194.unscaled.y - var7_44.unscaled.y);
                                var15_198 = this.gs.project(GraphicState.access$2000(this.gs), var7_44.hinted, var13_194.hinted);
                                var16_201 = var10_171 == 0 ? var14_195 : F26Dot6.multiplyDivide(var11_187, var14_195, var10_171);
                                this.gs.move(var13_194, var16_201 - var15_198);
                            }
                            continue block153;
                        }
                        case 41: {
                            var7_45 = this.getPoint(var1_1, this.gs.getZp0(), this.stack.pop());
                            this.gs.untouch(var7_45);
                            break;
                        }
                        case 48: 
                        case 49: {
                            v0 = var7_46 = (var6_6 & 1) == 1;
                            if (this.gs.getZp2() != 1) {
                                throw new InvalidGlyphException("ZP2 should be 1 instead of " + this.gs.getZp2() + " in an IUP instruction");
                            }
                            var8_106 = 0;
lbl523:
                            // 2 sources

                            while (var8_106 < var1_1.getNumContours()) {
                                var9_150 = var1_1.getContourFirstPoint(var8_106);
                                var10_172 = var1_1.getContourLastPoint(var8_106);
                                for (var11_188 = var9_150; var11_188 <= var10_172 && !this.getPoint(var1_1, 1, var11_188).touched(var7_46); ++var11_188) {
                                }
                                if (var11_188 > var10_172) break block243;
                                var12_191 = var11_188;
                                var13_193 = var1_1.getContourNextPoint(var8_106, var11_188);
                                while (var13_193 != var11_188) {
                                    if (this.getPoint(var1_1, 1, var13_193).touched(var7_46)) {
                                        var12_191 = var13_193;
                                        var13_193 = var1_1.getContourNextPoint(var8_106, var13_193);
                                        continue;
                                    }
                                    var14_195 = var1_1.getContourNextPoint(var8_106, var13_193);
                                    while (!this.getPoint(var1_1, 1, var14_195).touched(var7_46)) {
                                        var14_195 = var1_1.getContourNextPoint(var8_106, var14_195);
                                    }
                                    var15_199 = this.getPoint(var1_1, 1, var12_191);
                                    var16_202 = this.getPoint(var1_1, 1, var14_195);
                                    v1 = var7_46 ? (var1_1.unscaledCoordinatesAreInvalid ? var15_199.unhinted.x : var15_199.unscaled.x) : (var17_203 = var1_1.unscaledCoordinatesAreInvalid != false ? var15_199.unhinted.y : var15_199.unscaled.y);
                                    v2 = var7_46 ? (var1_1.unscaledCoordinatesAreInvalid ? var16_202.unhinted.x : var16_202.unscaled.x) : (var18_204 = var1_1.unscaledCoordinatesAreInvalid != false ? var16_202.unhinted.y : var16_202.unscaled.y);
                                    if (var17_203 > var18_204) {
                                        var19_205 = var15_199;
                                        var15_199 = var16_202;
                                        var16_202 = var19_205;
                                        var19_206 = var17_203;
                                        var17_203 = var18_204;
                                        var18_204 = var19_206;
                                    }
                                    while (var13_193 != var14_195) {
                                        var19_207 = this.getPoint(var1_1, 1, var13_193);
                                        var20_208 = var7_46 ? (var1_1.unscaledCoordinatesAreInvalid ? var19_207.unhinted.x : var19_207.unscaled.x) : (var1_1.unscaledCoordinatesAreInvalid != false ? var19_207.unhinted.y : var19_207.unscaled.y);
                                        var21_209 = var19_207.hinted.x;
                                        var22_210 = var19_207.hinted.y;
                                        if (var17_203 != var18_204) ** GOTO lbl562
                                        if (var7_46) {
                                            var19_207.hinted.x += var16_202.hinted.x - var16_202.unhinted.x;
                                        } else {
                                            var19_207.hinted.y += var16_202.hinted.y - var16_202.unhinted.y;
                                        }
                                        ** GOTO lbl578
lbl562:
                                        // 1 sources

                                        if (var17_203 >= var20_208 || var20_208 >= var18_204) ** GOTO lbl568
                                        if (var7_46) {
                                            var19_207.hinted.x = var15_199.hinted.x + F26Dot6.multiplyDivide(var20_208 - var17_203, var16_202.hinted.x - var15_199.hinted.x, var18_204 - var17_203);
                                        } else {
                                            var19_207.hinted.y = var15_199.hinted.y + F26Dot6.multiplyDivide(var20_208 - var17_203, var16_202.hinted.y - var15_199.hinted.y, var18_204 - var17_203);
                                        }
                                        ** GOTO lbl578
lbl568:
                                        // 1 sources

                                        if (var20_208 > var17_203) ** GOTO lbl574
                                        if (var7_46) {
                                            var19_207.hinted.x += var15_199.hinted.x - var15_199.unhinted.x;
                                        } else {
                                            var19_207.hinted.y += var15_199.hinted.y - var15_199.unhinted.y;
                                        }
                                        ** GOTO lbl578
lbl574:
                                        // 1 sources

                                        if (var7_46) {
                                            var19_207.hinted.x += var16_202.hinted.x - var16_202.unhinted.x;
                                        } else {
                                            var19_207.hinted.y += var16_202.hinted.y - var16_202.unhinted.y;
                                        }
lbl578:
                                        // 8 sources

                                        var13_193 = var1_1.getContourNextPoint(var8_106, var13_193);
                                    }
                                }
                                break block243;
                            }
                            continue block153;
                        }
                        case 93: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            var7_47 = var6_6 == 114 || var6_6 == 117 ? this.gs.getDeltaBase() + 32 : (var6_6 == 113 || var6_6 == 116 ? this.gs.getDeltaBase() + 16 : this.gs.getDeltaBase());
                            var8_107 = this.gs.getPixelsPerEm();
                            var9_151 = this.stack.pop();
                            for (var10_173 = 0; var10_173 < var9_151; ++var10_173) {
                                var11_189 = this.stack.pop();
                                var12_191 = this.stack.pop();
                                var13_193 = var7_47 + (var12_191 >> 4 & 15);
                                if (var13_193 != var8_107) continue;
                                var15_200 = var14_195 - ((var14_195 = var12_191 & 15) < 8 ? 8 : 7);
                                var16_201 = var15_200 << 6 - this.gs.getDeltaShift();
                                if (var6_6 < 115) {
                                    this.gs.move(this.getPoint(var1_1, this.gs.getZp0(), var11_189), var16_201);
                                    continue;
                                }
                                this.gs.incrementCVT(var11_189, var16_201);
                            }
                            continue block153;
                        }
                        case 32: {
                            this.stack.copy(1);
                            break;
                        }
                        case 33: {
                            this.stack.pop();
                            break;
                        }
                        case 34: {
                            this.stack.clear();
                            break;
                        }
                        case 35: {
                            var7_48 = this.stack.pop();
                            var8_108 = this.stack.pop();
                            this.stack.push(var7_48);
                            this.stack.push(var8_108);
                            break;
                        }
                        case 36: {
                            this.stack.pushDepth();
                            break;
                        }
                        case 37: {
                            this.stack.copy(this.stack.pop());
                            break;
                        }
                        case 38: {
                            this.stack.bubbleUp(this.stack.pop());
                            break;
                        }
                        case 138: {
                            var7_49 = this.stack.pop();
                            var8_109 = this.stack.pop();
                            var9_152 = this.stack.pop();
                            this.stack.push(var8_109);
                            this.stack.push(var7_49);
                            this.stack.push(var9_152);
                            break;
                        }
                        case 88: {
                            var7_50 = this.stack.pop();
                            if (var7_50 != 0) continue block153;
                            var8_110 = 0;
                            var9_153 = var3_3;
                            var10_174 = false;
                            while (var9_153 < var4_4 && !var10_174) {
                                switch (var2_2.getuint8(var9_153)) {
                                    case 88: {
                                        ++var8_110;
                                        break;
                                    }
                                    case 27: {
                                        if (var8_110 != 0) break;
                                        var10_174 = true;
                                        break;
                                    }
                                    case 89: {
                                        if (var8_110 == 0) {
                                            var10_174 = true;
                                            break;
                                        }
                                        --var8_110;
                                        break;
                                    }
                                }
                                var9_153 = this.skipInstruction(var2_2, var9_153);
                            }
                            if (!var10_174) {
                                throw new InvalidFontException("incorrect IF - no ELSE or EIF in TT outline");
                            }
                            var3_3 = var9_153;
                            break;
                        }
                        case 27: {
                            var7_51 = 0;
                            var8_111 = var3_3;
                            var9_154 = false;
                            while (var8_111 < var4_4 && !var9_154) {
                                switch (var2_2.getuint8(var8_111)) {
                                    case 88: {
                                        ++var7_51;
                                        break;
                                    }
                                    case 89: {
                                        if (var7_51 == 0) {
                                            var9_154 = true;
                                            break;
                                        }
                                        --var7_51;
                                        break;
                                    }
                                }
                                var8_111 = this.skipInstruction(var2_2, var8_111);
                            }
                            if (!var9_154) {
                                throw new InvalidGlyphException("incorrect IF - ELSE - no EIF in TT outline");
                            }
                            var3_3 = var8_111;
                            break;
                        }
                        case 89: {
                            break;
                        }
                        case 120: {
                            var7_52 = this.stack.pop();
                            var8_112 = this.stack.pop();
                            if (var7_52 == 0 || (var3_3 += var8_112 - 1) >= var5_5 && var4_4 >= var3_3) continue block153;
                            throw new InvalidGlyphException("JROF outside of hinted instruction block");
                        }
                        case 28: {
                            var7_53 = this.stack.pop();
                            if ((var3_3 += var7_53 - 1) >= var5_5 && var4_4 >= var3_3) continue block153;
                            throw new InvalidGlyphException("JROF outside of hinted instruction block");
                        }
                        case 121: {
                            var7_54 = this.stack.pop();
                            var8_113 = this.stack.pop();
                            if (var7_54 != 0 || (var3_3 += var8_113 - 1) >= var5_5 && var4_4 >= var3_3) continue block153;
                            throw new InvalidGlyphException("JROF outside of hinted instruction block");
                        }
                        case 80: {
                            var7_55 = this.stack.pop();
                            var8_114 = this.stack.pop();
                            this.stack.push(var8_114 < var7_55 ? 1 : 0);
                            break;
                        }
                        case 81: {
                            var7_56 = this.stack.pop();
                            var8_115 = this.stack.pop();
                            this.stack.push(var8_115 <= var7_56 ? 1 : 0);
                            break;
                        }
                        case 82: {
                            var7_57 = this.stack.pop();
                            var8_116 = this.stack.pop();
                            this.stack.push(var8_116 > var7_57 ? 1 : 0);
                            break;
                        }
                        case 83: {
                            var7_58 = this.stack.pop();
                            var8_117 = this.stack.pop();
                            this.stack.push(var8_117 >= var7_58 ? 1 : 0);
                            break;
                        }
                        case 84: {
                            var7_59 = this.stack.pop();
                            var8_118 = this.stack.pop();
                            this.stack.push(var8_118 == var7_59 ? 1 : 0);
                            break;
                        }
                        case 85: {
                            var7_60 = this.stack.pop();
                            var8_119 = this.stack.pop();
                            this.stack.push(var8_119 != var7_60 ? 1 : 0);
                            break;
                        }
                        case 86: {
                            var7_61 = this.stack.pop();
                            this.stack.push(F26Dot6.isEven(this.gs.roundToGrid(var7_61, 0)) != false ? 0 : 1);
                            break;
                        }
                        case 87: {
                            var7_62 = this.stack.pop();
                            this.stack.push(F26Dot6.isEven(this.gs.roundToGrid(var7_62, 0)) != false ? 1 : 0);
                            break;
                        }
                        case 90: {
                            var7_63 = this.stack.pop();
                            var8_120 = this.stack.pop();
                            this.stack.push(var8_120 != 0 && var7_63 != 0 ? 1 : 0);
                            break;
                        }
                        case 91: {
                            var7_64 = this.stack.pop();
                            var8_121 = this.stack.pop();
                            this.stack.push(var8_121 != 0 || var7_64 != 0 ? 1 : 0);
                            break;
                        }
                        case 92: {
                            var7_65 = this.stack.pop();
                            this.stack.push(var7_65 == 0 ? 1 : 0);
                            break;
                        }
                        case 96: {
                            this.stack.push(F26Dot6.add(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 97: {
                            var7_66 = this.stack.pop();
                            var8_122 = this.stack.pop();
                            this.stack.push(F26Dot6.subtract(var8_122, var7_66));
                            break;
                        }
                        case 98: {
                            var7_67 = this.stack.pop();
                            var8_123 = this.stack.pop();
                            this.stack.push(F26Dot6.divide(var8_123, var7_67));
                            break;
                        }
                        case 99: {
                            this.stack.push(F26Dot6.multiply(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 100: {
                            this.stack.push(F26Dot6.abs(this.stack.pop()));
                            break;
                        }
                        case 101: {
                            this.stack.push(F26Dot6.negate(this.stack.pop()));
                            break;
                        }
                        case 102: {
                            this.stack.push(F26Dot6.floor(this.stack.pop()));
                            break;
                        }
                        case 103: {
                            this.stack.push(F26Dot6.ceiling(this.stack.pop()));
                            break;
                        }
                        case 139: {
                            this.stack.push(Math.max(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 140: {
                            this.stack.push(Math.min(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: {
                            var7_68 = this.stack.pop();
                            this.stack.push(this.gs.round(var7_68, this.gp.getEngineCompensation(var6_6 & 3)));
                            break;
                        }
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: {
                            var7_69 = this.stack.pop();
                            this.stack.push(this.gs.roundOff(var7_69, this.gp.getEngineCompensation(var6_6 & 3)));
                            break;
                        }
                        case 44: {
                            var7_70 = this.stack.pop();
                            if (var7_70 < 0 || var7_70 > FunctionDefinitions.access$2400(this.functionDefs).length) {
                                throw new InvalidGlyphException("Invalid function identifier in FDEF (" + var7_70 + ")");
                            }
                            if (FunctionDefinitions.access$2400(this.functionDefs)[var7_70] != null) {
                                throw new InvalidGlyphException("Redefined function identifier in FDEF (" + var7_70 + ")");
                            }
                            var8_124 = var3_3;
                            var9_155 = false;
                            while (var8_124 < var4_4 && !var9_155) {
                                switch (var2_2.getuint8(var8_124)) {
                                    case 44: 
                                    case 137: {
                                        throw new InvalidGlyphException("Nested FDEF/IDEF definitions");
                                    }
                                    case 45: {
                                        var9_155 = true;
                                        break;
                                    }
                                }
                                var8_124 = this.skipInstruction(var2_2, var8_124);
                            }
                            if (!var9_155) {
                                throw new InvalidGlyphException("FDEF without IDEF in TT outline");
                            }
                            this.functionDefs.setFunction(var7_70, var2_2, var3_3, var8_124 - 1);
                            var3_3 = var8_124;
                            break;
                        }
                        case 45: {
                            throw new InvalidGlyphException("dangling ENDF");
                        }
                        case 43: {
                            var7_71 = this.stack.pop();
                            if (var7_71 < 0 || var7_71 > FunctionDefinitions.access$2400(this.functionDefs).length) {
                                throw new InvalidGlyphException("Invalid function identifier in CALL (" + var7_71 + ")");
                            }
                            if (FunctionDefinitions.access$2500(this.functionDefs)[var7_71] == -1) {
                                throw new InvalidGlyphException("Undefined function identifier in CALL (" + var7_71 + ")");
                            }
                            this.runWithoutInit(var1_1, FunctionDefinitions.access$2400(this.functionDefs)[var7_71], FunctionDefinitions.access$2600(this.functionDefs)[var7_71], FunctionDefinitions.access$2500(this.functionDefs)[var7_71]);
                            break;
                        }
                        case 42: {
                            var7_72 = this.stack.pop();
                            var8_125 = this.stack.pop();
                            if (var7_72 < 0 || var7_72 > FunctionDefinitions.access$2400(this.functionDefs).length) {
                                throw new InvalidGlyphException("Invalid function identifier in LOOPCALL (" + var7_72 + ")");
                            }
                            if (FunctionDefinitions.access$2500(this.functionDefs)[var7_72] == -1) {
                                throw new InvalidGlyphException("Undefined function identifier in LOOPCALL (" + var7_72 + ")");
                            }
                            for (var9_156 = 0; var9_156 < var8_125; ++var9_156) {
                                this.runWithoutInit(var1_1, FunctionDefinitions.access$2400(this.functionDefs)[var7_72], FunctionDefinitions.access$2600(this.functionDefs)[var7_72], FunctionDefinitions.access$2500(this.functionDefs)[var7_72]);
                            }
                            continue block153;
                        }
                        case 137: {
                            var7_73 = this.stack.pop();
                            if (var7_73 < 0 || var7_73 > 255) {
                                throw new InvalidGlyphException("Illegal IDEF opcode (" + var7_73 + ")");
                            }
                            var8_126 = var3_3;
                            var9_157 = false;
                            while (var8_126 < var4_4 && !var9_157) {
                                switch (var2_2.getuint8(var8_126)) {
                                    case 44: 
                                    case 137: {
                                        throw new InvalidGlyphException("Nested FDEF/IDEF definitions");
                                    }
                                    case 45: {
                                        var9_157 = true;
                                        break;
                                    }
                                }
                                var8_126 = this.skipInstruction(var2_2, var8_126);
                            }
                            if (!var9_157) {
                                throw new InvalidGlyphException("IDEF without ENDF TT outline");
                            }
                            var3_3 = var8_126;
                            this.instructionDefs.setFunction(var7_73, var2_2, var3_3, var8_126 - 1);
                            var3_3 = var8_126;
                            break;
                        }
                        case 79: {
                            this.stack.pop();
                            break;
                        }
                        case 136: {
                            var7_74 = this.stack.pop();
                            var8_127 = 0;
                            var9_158 = false;
                            var10_175 = false;
                            var11_190 = false;
                            if ((var7_74 & 1) != 0) {
                                var8_127 |= 37;
                            }
                            if ((var7_74 & 2) != 0) {
                                var8_127 |= var9_158 != false ? 256 : 0;
                            }
                            if ((var7_74 & 4) != 0) {
                                var8_127 |= var10_175 != false ? 512 : 0;
                            }
                            if ((var7_74 & 16) != 0) {
                                var8_127 |= var11_190 != false ? 4096 : 0;
                            }
                            this.stack.push(var8_127);
                            break;
                        }
                        default: {
                            if (FunctionDefinitions.access$2400(this.instructionDefs)[var6_6] == null) continue block153;
                            this.runWithoutInit(var1_1, FunctionDefinitions.access$2400(this.instructionDefs)[var6_6], FunctionDefinitions.access$2600(this.instructionDefs)[var6_6], FunctionDefinitions.access$2500(this.instructionDefs)[var6_6]);
                            break;
                        }
                    }
                }
                return;
            }
            catch (InvalidGlyphException var6_7) {
                throw var6_7;
            }
            catch (InvalidFontException var6_8) {
                throw new InvalidGlyphException(var6_8);
            }
        }
        ++var8_106;
        ** GOTO lbl523
    }

    private int skipInstruction(OTByteArray oTByteArray, int n) throws InvalidFontException {
        int n2 = oTByteArray.getuint8(n);
        ++n;
        switch (n2) {
            case 64: {
                int n3 = oTByteArray.getuint8(n);
                ++n;
                n += n3;
                break;
            }
            case 65: {
                int n4 = oTByteArray.getuint8(n);
                ++n;
                n += 2 * n4;
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                n += (n2 & 7) + 1;
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                n += 2 * ((n2 & 7) + 1);
            }
        }
        return n;
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
        this.debugger = scalerDebugger;
    }

    private void logInstruction(int n, int n2) {
        this.sb.setLength(0);
        this.sbDetails.setLength(0);
        this.currentInstr = instructions[n2];
        this.sb.append(n);
        this.sb.append(" ");
        this.sb.append(this.currentInstr.name);
        this.sb.append(" (");
        this.logStack(this.sb, this.currentInstr.stackPop);
        this.sb.append(")");
    }

    private void logResult() {
        if (this.currentInstr.stackPush != 0) {
            this.sb.append(" -> ");
            this.logStack(this.sb, this.currentInstr.stackPush);
        }
        this.sb.append("\n");
        this.sb.append(this.sbDetails);
        this.debugger.ttInterpLog(this.sb.toString());
    }

    private void logDetail(String string) {
        this.sbDetails.append("  ");
        this.sbDetails.append(string);
        this.sbDetails.append("\n");
    }

    private void logDetailNoLn(String string) {
        this.sbDetails.append(string);
    }

    private void logStack(StringBuffer stringBuffer, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string + Integer.toHexString(this.stack.peek(i)));
            string = ", ";
        }
    }

    static class Instr {
        int opcode;
        String name;
        int stackPop;
        int stackPush;

        public Instr(int n, String string, int n2, int n3) {
            this.opcode = n;
            this.name = string;
            this.stackPop = n2;
            this.stackPush = n3;
        }
    }

    private final class FunctionDefinitions {
        private OTByteArray[] instructionStreams;
        private int[] start;
        private int[] limit;

        public FunctionDefinitions(int n) {
            this.instructionStreams = new OTByteArray[n];
            this.start = new int[n];
            this.limit = new int[n];
        }

        public void setFunction(int n, OTByteArray oTByteArray, int n2, int n3) {
            this.instructionStreams[n] = oTByteArray;
            this.start[n] = n2;
            this.limit[n] = n3;
        }

        static /* synthetic */ OTByteArray[] access$2400(FunctionDefinitions functionDefinitions) {
            return functionDefinitions.instructionStreams;
        }

        static /* synthetic */ int[] access$2500(FunctionDefinitions functionDefinitions) {
            return functionDefinitions.limit;
        }

        static /* synthetic */ int[] access$2600(FunctionDefinitions functionDefinitions) {
            return functionDefinitions.start;
        }
    }

    private final class ControlValueTable {
        private int[] originalData;
        private int[] data;

        ControlValueTable(int n, OTByteArray oTByteArray) throws InvalidFontException {
            if (n < 0 || 200000 <= n) {
                throw new InvalidFontException("attempt to CVT table with " + n + " entries");
            }
            this.originalData = new int[n];
            for (int i = 0; i < n; ++i) {
                this.originalData[i] = oTByteArray.getint16(2 * i);
            }
            this.data = new int[n];
        }

        void resetAndScale(int n, int n2) {
            for (int i = 0; i < this.originalData.length; ++i) {
                this.data[i] = this.scale(this.originalData[i], n, n2);
            }
        }

        int countLowZeros(int n) {
            for (int i = 0; i < 32; ++i) {
                if ((n & 1) != 0) {
                    return i;
                }
                n >>= 1;
            }
            return 32;
        }

        int getShift(int n) {
            if ((n & n - 1) != 0 || n == 0) {
                return -1;
            }
            return this.countLowZeros(n);
        }

        int scale(int n, int n2, int n3) {
            int n4 = this.countLowZeros(n2 | n3) - 1;
            if (n4 > 0) {
                n2 >>= n4;
                n3 >>= n4;
            }
            if (n2 < 0x2000000) {
                n2 <<= 6;
            } else {
                n3 >>= 6;
            }
            if (n2 <= Short.MAX_VALUE) {
                n4 = this.getShift(n3);
                if (n4 >= 0) {
                    return n * n2 + (n3 >> 1) >> n4;
                }
                if (n < 0) {
                    return -(-n * n2 + (n3 >> 1)) / n3;
                }
                return (n * n2 + (n3 >> 1)) / n3;
            }
            return F16Dot16.multiply(n, F16Dot16.divide(n2, n3));
        }

        void put(int n, int n2) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                throw new InvalidGlyphException("attempt to write CVT entry " + n + " (" + this.data.length + " actual entries)");
            }
            this.data[n] = n2;
        }

        int get(int n) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                return 0;
            }
            return this.data[n];
        }
    }

    private final class Stack {
        private final int[] data;
        private int currentDepth;

        public Stack(int n) {
            this.data = new int[n];
            this.currentDepth = 0;
        }

        public int pop() throws InvalidGlyphException {
            if (this.currentDepth == 0) {
                throw new InvalidGlyphException("pop on empty TT stack");
            }
            --this.currentDepth;
            return this.data[this.currentDepth];
        }

        public void push(int n) throws InvalidGlyphException {
            if (this.currentDepth > this.data.length) {
                throw new InvalidGlyphException("push on full TT stack");
            }
            this.data[this.currentDepth] = n;
            ++this.currentDepth;
        }

        public int peek(int n) {
            if (this.currentDepth - n < 0) {
                System.err.println("*** peek below stack bottom");
            }
            return this.data[this.currentDepth - n - 1];
        }

        public void clear() {
            this.currentDepth = 0;
        }

        public void copy(int n) throws InvalidGlyphException {
            if (n > this.currentDepth) {
                throw new InvalidGlyphException("index of non-existing TT stack element (" + n + ", currentDepth=" + this.currentDepth + ")");
            }
            this.push(this.data[this.currentDepth - n]);
        }

        public void pushDepth() throws InvalidGlyphException {
            this.push(this.currentDepth);
        }

        public void bubbleUp(int n) throws InvalidGlyphException {
            if (n > this.currentDepth) {
                throw new InvalidGlyphException("index of non-existing TT stack element (" + n + ", currentDepth=" + this.currentDepth + ")");
            }
            int n2 = this.data[this.currentDepth - n];
            for (int i = this.currentDepth - n; i < this.currentDepth - 1; ++i) {
                this.data[i] = this.data[i + 1];
            }
            this.data[this.currentDepth - 1] = n2;
        }
    }

    private final class StorageArea {
        private final int[] data;

        public StorageArea(int n) {
            this.data = new int[n];
        }

        public int getuint32(int n) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                throw new InvalidGlyphException("attempting to access TT storage area location " + n + " (must be in [" + 0 + ", " + this.data.length + "[)");
            }
            return this.data[n];
        }

        public void setuint32(int n, int n2) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                throw new InvalidGlyphException("attempting to access TT storage area location " + n + " (must be in [" + 0 + ", " + this.data.length + "[)");
            }
            this.data[n] = n2;
        }
    }

    private final class GraphicParameters {
        private GraphicParameters() {
        }

        int getEngineCompensation(int n) {
            return 0;
        }
    }

    private final class GraphicState {
        LocalGraphicState defaultGraphicState;
        LocalGraphicState localGraphicState;
        final int ROUND_TO_DOUBLE_GRID = 0;
        final int ROUND_TO_GRID = 1;
        final int ROUND_TO_HALF_GRID = 2;
        final int ROUND_OFF = 3;
        final int ROUND_DOWN_TO_GRID = 4;
        final int ROUND_UP_TO_GRID = 5;
        final int SUPER_ROUND = 6;
        final int SUPER_45_ROUND = 7;
        private F2Dot14Vector projectionVector = new F2Dot14Vector(0, 0);
        private F2Dot14Vector freedomVector = new F2Dot14Vector(0, 0);
        private F2Dot14Vector originalProjectionVector = new F2Dot14Vector(0, 0);
        private int fDotP;
        private F16Dot16Vector cvtStretch = new F16Dot16Vector();
        private ControlValueTable controlValueTable;
        private int cvtxN;
        private int cvtyN;
        private int cvtD;
        private double pixelsPerEm;
        private double pointSize;
        private int rp0;
        private int rp1;
        private int rp2;
        private int zp0;
        private int zp1;
        private int zp2;
        private int loopVariable;

        public GraphicState(int n, OTByteArray oTByteArray) throws InvalidFontException {
            this.cvtStretch.x = 65536;
            this.cvtStretch.y = 65536;
            this.controlValueTable = new ControlValueTable(n, oTByteArray);
            this.localGraphicState = new LocalGraphicState();
        }

        boolean getAutoFlip() {
            return this.localGraphicState.autoFlip;
        }

        void setAutoFlip(boolean bl) {
            this.localGraphicState.autoFlip = bl;
        }

        int getAngleWeight() {
            return this.localGraphicState.angleWeight;
        }

        void setAngleWeight(int n) {
            this.localGraphicState.angleWeight = n;
        }

        int getMinimumDistance() {
            return this.localGraphicState.minimumDistance;
        }

        void setMinimumDistance(int n) {
            this.localGraphicState.minimumDistance = n;
        }

        int getControlValueCutIn() {
            return this.localGraphicState.controlValueCutIn;
        }

        void setControlValueCutIn(int n) {
            this.localGraphicState.controlValueCutIn = n;
        }

        int snapToSingleWidth(int n) {
            if (this.localGraphicState.singleWidth - this.localGraphicState.singleWidthCutIn < n && n < this.localGraphicState.singleWidth + this.localGraphicState.singleWidthCutIn) {
                return this.localGraphicState.singleWidth;
            }
            if (-(this.localGraphicState.singleWidth + this.localGraphicState.singleWidthCutIn) < n && n < -(this.localGraphicState.singleWidth - this.localGraphicState.singleWidthCutIn)) {
                return -this.localGraphicState.singleWidth;
            }
            return n;
        }

        void setSingleWidthCutIn(int n) {
            this.localGraphicState.singleWidthCutIn = n;
        }

        void setSingleWidth(int n) {
            this.localGraphicState.singleWidth = n;
        }

        int getDeltaBase() {
            return this.localGraphicState.deltaBase;
        }

        void setDeltaBase(int n) {
            this.localGraphicState.deltaBase = n;
        }

        int getDeltaShift() {
            return this.localGraphicState.deltaShift;
        }

        void setDeltaShift(int n) {
            this.localGraphicState.deltaShift = n;
        }

        void setScanControl(int n) {
            this.localGraphicState.scanControl = n;
        }

        int getScanControl() {
            return this.localGraphicState.scanControl;
        }

        void setInstrControl(int n) {
            this.localGraphicState.instrControl = n;
        }

        int getInstrControl() {
            return this.localGraphicState.instrControl;
        }

        void setRoundMode(int n) {
            this.localGraphicState.roundMode = n;
        }

        void setRounding(int n, int n2, int n3, int n4) {
            this.localGraphicState.roundPeriod = n;
            this.localGraphicState.roundPhase = n2;
            this.localGraphicState.roundThreshold = n3;
            this.localGraphicState.roundMode = n4;
        }

        int round(int n, int n2) {
            return this.round(n, n2, this.localGraphicState.roundMode);
        }

        int roundOff(int n, int n2) {
            return this.round(n, n2, 3);
        }

        int roundToGrid(int n, int n2) {
            return this.round(n, n2, 1);
        }

        int round(int n, int n2, int n3) {
            boolean bl;
            int n4;
            if (n < 0) {
                n4 = -n;
                bl = true;
            } else {
                n4 = n;
                bl = false;
            }
            n4 += n2;
            switch (n3) {
                case 0: {
                    n4 += 16;
                    n4 &= 0xFFFFFFE0;
                    break;
                }
                case 1: {
                    n4 += 32;
                    n4 &= 0xFFFFFFC0;
                    break;
                }
                case 2: {
                    n4 &= 0xFFFFFFC0;
                    n4 += 32;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n4 &= 0xFFFFFFC0;
                    break;
                }
                case 5: {
                    n4 += 63;
                    n4 &= 0xFFFFFFC0;
                    break;
                }
                case 6: {
                    n4 += this.localGraphicState.roundThreshold - this.localGraphicState.roundPhase;
                    n4 &= ~(this.localGraphicState.roundPeriod - 1);
                    n4 += this.localGraphicState.roundPhase;
                    break;
                }
                case 7: {
                    n4 = F26Dot6.divideByF2Dot14(n4, this.localGraphicState.roundPeriod);
                    n4 = F26Dot6.truncate(n4);
                    n4 = F26Dot6.multiplyByF2Dot14(n4, this.localGraphicState.roundPeriod);
                    n4 += this.localGraphicState.roundPhase;
                }
            }
            if (bl) {
                n4 = -n4;
            }
            if (!F26Dot6.sameSign(n4, n) && n != 0) {
                n4 = 0;
            }
            return n4;
        }

        void setVector(F2Dot14Vector f2Dot14Vector, F26Dot6Vector f26Dot6Vector, F26Dot6Vector f26Dot6Vector2, boolean bl) {
            int n = f26Dot6Vector2.x - f26Dot6Vector.x;
            int n2 = f26Dot6Vector2.y - f26Dot6Vector.y;
            if (n == 0 && n2 == 0) {
                this.setVector(f2Dot14Vector, 16384, 0, bl);
            } else {
                double d = F26Dot6.toDouble(n);
                double d2 = F26Dot6.toDouble(n2);
                double d3 = Math.sqrt(d * d + d2 * d2);
                this.setVector(f2Dot14Vector, F2Dot14.fromDouble(d / d3), F2Dot14.fromDouble(d2 / d3), bl);
            }
        }

        void setVector(F2Dot14Vector f2Dot14Vector, int n, int n2, boolean bl) {
            if (bl) {
                f2Dot14Vector.x = -n2;
                f2Dot14Vector.y = n;
            } else {
                f2Dot14Vector.x = n;
                f2Dot14Vector.y = n2;
            }
            if (f2Dot14Vector == this.projectionVector || f2Dot14Vector == this.freedomVector) {
                this.fDotP = F2Dot14.multiply(this.projectionVector.x, this.freedomVector.x) + F2Dot14.multiply(this.projectionVector.y, this.freedomVector.y);
                if (-1024 < this.fDotP && this.fDotP < 1024) {
                    this.fDotP = this.fDotP < 0 ? -16384 : 16384;
                }
            }
        }

        int project(F2Dot14Vector f2Dot14Vector, int n, int n2) {
            return F26Dot6.multiplyByF2Dot14(n, f2Dot14Vector.x) + F26Dot6.multiplyByF2Dot14(n2, f2Dot14Vector.y);
        }

        int project(F2Dot14Vector f2Dot14Vector, F26Dot6Vector f26Dot6Vector) {
            return this.project(f2Dot14Vector, f26Dot6Vector.x, f26Dot6Vector.y);
        }

        int project(F2Dot14Vector f2Dot14Vector, F26Dot6Vector f26Dot6Vector, F26Dot6Vector f26Dot6Vector2) {
            return this.project(f2Dot14Vector, f26Dot6Vector2.x - f26Dot6Vector.x, f26Dot6Vector2.y - f26Dot6Vector.y);
        }

        void resetAndScaleCVT() {
            this.controlValueTable.resetAndScale(this.cvtxN, this.cvtD);
        }

        int getCVTscale() {
            int n = F16Dot16.multiplyByF2Dot14(F16Dot16.square(this.cvtStretch.x), F2Dot14.square(this.projectionVector.x)) + F16Dot16.multiplyByF2Dot14(F16Dot16.square(this.cvtStretch.y), F2Dot14.square(this.projectionVector.y));
            if (n >= 65536) {
                return 65536;
            }
            return F16Dot16.fromDouble(Math.sqrt(F16Dot16.toDouble(n)));
        }

        int getCVT(int n) throws InvalidGlyphException {
            return F26Dot6.multiplyByF16Dot16(this.controlValueTable.get(n), this.getCVTscale());
        }

        void putCVT(int n, int n2) throws InvalidGlyphException {
            this.controlValueTable.put(n, F26Dot6.divideByF16Dot16(n2, this.getCVTscale()));
        }

        void putCVTPixels(int n, int n2) throws InvalidGlyphException {
            this.controlValueTable.put(n, F16Dot16.multiplyDivide(F26Dot6.fromDouble(n2), this.cvtxN, this.cvtD));
        }

        void incrementCVT(int n, int n2) throws InvalidGlyphException {
            this.controlValueTable.put(n, this.controlValueTable.get(n) + F26Dot6.divideByF16Dot16(n2, this.getCVTscale()));
        }

        int getPixelsPerEm() {
            return F26Dot6.toInt(F26Dot6.multiplyByF16Dot16(F26Dot6.fromDouble(this.pixelsPerEm), this.getCVTscale()));
        }

        void setPixelsPerEm(double d) {
            this.pixelsPerEm = d;
        }

        int getPointSize() {
            return F26Dot6.fromDouble(this.pointSize);
        }

        void setPointSize(double d) {
            this.pointSize = d;
        }

        void move(TTPoint tTPoint, int n) {
            if (this.fDotP != 16384) {
                if (this.freedomVector.x != 0) {
                    tTPoint.hinted.x = this.fDotP == this.freedomVector.x ? (tTPoint.hinted.x += n) : (tTPoint.hinted.x += F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n, this.freedomVector.x, this.fDotP));
                    tTPoint.touchedX = true;
                }
                if (this.freedomVector.y != 0) {
                    tTPoint.hinted.y = this.fDotP == this.freedomVector.y ? (tTPoint.hinted.y += n) : (tTPoint.hinted.y += F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n, this.freedomVector.y, this.fDotP));
                    tTPoint.touchedY = true;
                }
            } else if (this.freedomVector.x == 16384) {
                tTPoint.hinted.x += n;
                tTPoint.touchedX = true;
            } else if (this.freedomVector.y == 16384) {
                tTPoint.hinted.y += n;
                tTPoint.touchedY = true;
            } else {
                if (this.freedomVector.x != 0) {
                    tTPoint.hinted.x += F26Dot6.multiplyByF2Dot14(n, this.freedomVector.x);
                    tTPoint.touchedX = true;
                }
                if (this.freedomVector.y != 0) {
                    tTPoint.hinted.y += F26Dot6.multiplyByF2Dot14(n, this.freedomVector.y);
                    tTPoint.touchedY = true;
                }
            }
        }

        void move(TTPoint tTPoint, int n, int n2) {
            if (this.freedomVector.x != 0) {
                tTPoint.hinted.x += n;
                tTPoint.touchedX = true;
            }
            if (this.freedomVector.y != 0) {
                tTPoint.hinted.y += n2;
                tTPoint.touchedY = true;
            }
        }

        void set(TTPoint tTPoint, int n, int n2) {
            tTPoint.hinted.x = n;
            tTPoint.touchedX = true;
            tTPoint.hinted.y = n2;
            tTPoint.touchedY = true;
        }

        void untouch(TTPoint tTPoint) {
            if (this.freedomVector.x != 0) {
                tTPoint.touchedX = false;
            }
            if (this.freedomVector.x != 0) {
                tTPoint.touchedY = false;
            }
        }

        void setRp0(int n) {
            this.rp0 = n;
        }

        int getRp0() {
            return this.rp0;
        }

        void setRp1(int n) {
            this.rp1 = n;
        }

        int getRp1() {
            return this.rp1;
        }

        void setRp2(int n) {
            this.rp2 = n;
        }

        int getRp2() {
            return this.rp2;
        }

        void setZp0(int n) {
            this.zp0 = n;
        }

        int getZp0() {
            return this.zp0;
        }

        void setZp1(int n) {
            this.zp1 = n;
        }

        int getZp1() {
            return this.zp1;
        }

        void setZp2(int n) {
            this.zp2 = n;
        }

        int getZp2() {
            return this.zp2;
        }

        void setLoopVariable(int n) {
            this.loopVariable = n;
        }

        int getAndResetLoopVariable() {
            int n = this.loopVariable;
            this.loopVariable = 1;
            return n;
        }

        static /* synthetic */ int access$2300(GraphicState graphicState) {
            return graphicState.fDotP;
        }

        static /* synthetic */ int access$1600(GraphicState graphicState) {
            return graphicState.cvtxN;
        }

        static /* synthetic */ int access$1700(GraphicState graphicState) {
            return graphicState.cvtD;
        }

        static /* synthetic */ int access$1800(GraphicState graphicState) {
            return graphicState.cvtyN;
        }
    }

    private final class LocalGraphicState
    implements Cloneable {
        private boolean autoFlip;
        private int angleWeight;
        private int minimumDistance;
        private int controlValueCutIn;
        private int singleWidthCutIn;
        private int singleWidth;
        private int deltaBase;
        private int deltaShift;
        private int scanControl;
        private int instrControl;
        private int roundMode;
        private int roundPeriod;
        private int roundPhase;
        private int roundThreshold;

        private LocalGraphicState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

