/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Vhea
extends Table {
    protected Vhea(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        int n = this.getTableMajorVersion();
        if (n != 1) {
            throw new UnsupportedFontException("'vhea' tables with major version " + n + "are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getAscent() throws InvalidFontException {
        return this.data.getint16(4);
    }

    public int getNumberOfVMetrics() throws InvalidFontException {
        return this.data.getuint16(34);
    }

    public void subsetAndStream(Subset subset, Map map) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        oTByteArrayBuilder.setuint16(34, subset.getNumGlyphs());
        map.put(new Integer(1986553185), oTByteArrayBuilder);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1986553185), oTByteArrayBuilder);
    }
}

