/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import java.io.Serializable;

public final class FontResolutionPriority
implements Serializable {
    public static final FontResolutionPriority INTELLIGENT_LAST;
    public static final FontResolutionPriority INTELLIGENT;
    public static final FontResolutionPriority INTELLIGENT_FIRST;
    public static final FontResolutionPriority FIRST;
    public static final FontResolutionPriority LAST;
    private static final FontResolutionPriority[] priorityValues;
    static final long serialVersionUID = 1L;
    private final int id;
    private final String[] names;

    private FontResolutionPriority(String[] stringArray, int n) {
        this.names = stringArray;
        this.id = n;
    }

    private Object readResolve() {
        for (int i = 0; i < priorityValues.length; ++i) {
            if (this.id != FontResolutionPriority.priorityValues[i].id) continue;
            return priorityValues[i];
        }
        return null;
    }

    public static FontResolutionPriority parse(String string) {
        for (int i = 0; i < priorityValues.length; ++i) {
            for (int j = 0; j < FontResolutionPriority.priorityValues[i].names.length; ++j) {
                if (!FontResolutionPriority.priorityValues[i].names[j].equalsIgnoreCase(string)) continue;
                return priorityValues[i];
            }
        }
        return null;
    }

    public String toString() {
        return this.names[0];
    }

    static {
        INTELLIGENT = INTELLIGENT_LAST = new FontResolutionPriority(new String[]{"intelligent last", "intelligent"}, 1);
        INTELLIGENT_FIRST = new FontResolutionPriority(new String[]{"intelligent first"}, 4);
        FIRST = new FontResolutionPriority(new String[]{"first"}, 2);
        LAST = new FontResolutionPriority(new String[]{"last"}, 3);
        priorityValues = new FontResolutionPriority[]{INTELLIGENT_LAST, INTELLIGENT_FIRST, FIRST, LAST};
    }
}

