/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontProxy;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.FontSetStack;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.inlineformatting.FallbackFontSet;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.fontengine.inlineformatting.css20.CSS20GenericFontFamily;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.css20.PassThroughFamilyNameNormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class CSS20FontDatabase
extends FontSetStack
implements CSS20FontSet {
    static final long serialVersionUID = 1L;
    private final FamilyNameNormalizer normalizer;
    private final boolean ignoreVariant;
    private HashMap fontsByFamilyName = new HashMap();
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private ArrayList serif = new ArrayList();
    private ArrayList sansSerif = new ArrayList();
    private ArrayList monospace = new ArrayList();
    private ArrayList fantasy = new ArrayList();
    private ArrayList cursive = new ArrayList();
    private FallbackFontSet fallbackFontSet = new FallbackFontSet();

    public CSS20FontDatabase() {
        this(new PassThroughFamilyNameNormalizer(), true);
    }

    public CSS20FontDatabase(boolean bl) {
        this(new PassThroughFamilyNameNormalizer(), bl);
    }

    public CSS20FontDatabase(FamilyNameNormalizer familyNameNormalizer) {
        this(familyNameNormalizer, true);
    }

    public CSS20FontDatabase(FamilyNameNormalizer familyNameNormalizer, boolean bl) {
        if (familyNameNormalizer == null) {
            familyNameNormalizer = new PassThroughFamilyNameNormalizer();
        }
        this.normalizer = familyNameNormalizer;
        this.ignoreVariant = bl;
    }

    public CSS20FontDatabase(CSS20FontDatabase cSS20FontDatabase) {
        super(cSS20FontDatabase);
        this.normalizer = cSS20FontDatabase.normalizer;
        this.ignoreVariant = cSS20FontDatabase.ignoreVariant;
        this.resolutionPriority = cSS20FontDatabase.resolutionPriority;
        this.serif = (ArrayList)cSS20FontDatabase.serif.clone();
        this.sansSerif = (ArrayList)cSS20FontDatabase.sansSerif.clone();
        this.monospace = (ArrayList)cSS20FontDatabase.monospace.clone();
        this.fantasy = (ArrayList)cSS20FontDatabase.fantasy.clone();
        this.cursive = (ArrayList)cSS20FontDatabase.cursive.clone();
        this.fallbackFontSet = cSS20FontDatabase.fallbackFontSet;
        Set set = cSS20FontDatabase.fontsByFamilyName.keySet();
        for (Object k : set) {
            CSSFontsWithSameName cSSFontsWithSameName = new CSSFontsWithSameName((CSSFontsWithSameName)cSS20FontDatabase.fontsByFamilyName.get(k));
            this.fontsByFamilyName.put(k, cSSFontsWithSameName);
        }
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority fontResolutionPriority) {
        FontResolutionPriority fontResolutionPriority2 = this.resolutionPriority;
        this.resolutionPriority = fontResolutionPriority;
        return fontResolutionPriority2;
    }

    public void addFont(Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        CSS20FontDescription[] cSS20FontDescriptionArray = font.getCSS20FontDescription();
        if (cSS20FontDescriptionArray == null) {
            throw new InvalidFontException("Font has no CSS20FontDescription", font);
        }
        for (int i = 0; i < cSS20FontDescriptionArray.length; ++i) {
            FontProxy fontProxy = new FontProxy(cSS20FontDescriptionArray[i], font);
            this.addFontProxy(fontProxy);
        }
    }

    public void addFont(CSS20FontDescription cSS20FontDescription, Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontProxy fontProxy = new FontProxy(cSS20FontDescription, font);
        this.addFontProxy(fontProxy);
    }

    private boolean addFontProxy(FontProxy fontProxy) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        boolean bl;
        String string = this.normalizer.normalize(((CSS20FontDescription)fontProxy.getFontDescription()).getFamilyName());
        CSSFontsWithSameName cSSFontsWithSameName = (CSSFontsWithSameName)this.fontsByFamilyName.get(string);
        if (cSSFontsWithSameName == null) {
            cSSFontsWithSameName = new CSSFontsWithSameName();
            this.fontsByFamilyName.put(string, cSSFontsWithSameName);
        }
        if (bl = cSSFontsWithSameName.addFont(fontProxy)) {
            super.fontAdded(fontProxy);
        }
        return bl;
    }

    protected void removeFontProxy(FontProxy fontProxy) {
        String string = this.normalizer.normalize(((CSS20FontDescription)fontProxy.getFontDescription()).getFamilyName());
        CSSFontsWithSameName cSSFontsWithSameName = (CSSFontsWithSameName)this.fontsByFamilyName.get(string);
        if (cSSFontsWithSameName != null) {
            cSSFontsWithSameName.removeFont(fontProxy);
        }
    }

    public boolean isEmpty() {
        return this.fontsByFamilyName.isEmpty();
    }

    public void setGenericFont(CSS20GenericFontFamily cSS20GenericFontFamily, String[] stringArray) {
        ArrayList arrayList = null;
        if (cSS20GenericFontFamily == CSS20GenericFontFamily.SERIF) {
            arrayList = this.serif;
        } else if (cSS20GenericFontFamily == CSS20GenericFontFamily.SANS_SERIF) {
            arrayList = this.sansSerif;
        } else if (cSS20GenericFontFamily == CSS20GenericFontFamily.CURSIVE) {
            arrayList = this.cursive;
        } else if (cSS20GenericFontFamily == CSS20GenericFontFamily.FANTASY) {
            arrayList = this.fantasy;
        } else if (cSS20GenericFontFamily == CSS20GenericFontFamily.MONOSPACE) {
            arrayList = this.monospace;
        } else {
            return;
        }
        arrayList.clear();
        arrayList.ensureCapacity(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(i, stringArray[i]);
        }
    }

    public void setFallbackFonts(FallbackFontSet fallbackFontSet) {
        this.fallbackFontSet = fallbackFontSet;
    }

    protected List getGenericFont(CSS20GenericFontFamily cSS20GenericFontFamily) {
        if (cSS20GenericFontFamily == CSS20GenericFontFamily.SERIF) {
            return this.serif;
        }
        if (cSS20GenericFontFamily == CSS20GenericFontFamily.SANS_SERIF) {
            return this.sansSerif;
        }
        if (cSS20GenericFontFamily == CSS20GenericFontFamily.CURSIVE) {
            return this.cursive;
        }
        if (cSS20GenericFontFamily == CSS20GenericFontFamily.FANTASY) {
            return this.fantasy;
        }
        if (cSS20GenericFontFamily == CSS20GenericFontFamily.MONOSPACE) {
            return this.monospace;
        }
        return null;
    }

    protected FallbackFontSet getFallbackFontSet() {
        return this.fallbackFontSet;
    }

    protected boolean replaceGenericFontFamily(List list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            List list2;
            String string = (String)list.get(i);
            if (string.equals("serif")) {
                list2 = this.getGenericFont(CSS20GenericFontFamily.SERIF);
                list.remove(i);
                if (list2 == null) continue;
                list.addAll(i, list2);
                bl = true;
                continue;
            }
            if (string.equals("sans-serif")) {
                list2 = this.getGenericFont(CSS20GenericFontFamily.SANS_SERIF);
                list.remove(i);
                if (list2 == null) continue;
                list.addAll(i, list2);
                bl = true;
                continue;
            }
            if (string.equals("cursive")) {
                list2 = this.getGenericFont(CSS20GenericFontFamily.CURSIVE);
                list.remove(i);
                if (list2 == null) continue;
                list.addAll(i, list2);
                bl = true;
                continue;
            }
            if (string.equals("fantasy")) {
                list2 = this.getGenericFont(CSS20GenericFontFamily.FANTASY);
                list.remove(i);
                if (list2 == null) continue;
                list.addAll(i, list2);
                bl = true;
                continue;
            }
            if (!string.equals("monospace")) continue;
            list2 = this.getGenericFont(CSS20GenericFontFamily.MONOSPACE);
            list.remove(i);
            if (list2 == null) continue;
            list.addAll(i, list2);
            bl = true;
        }
        return bl;
    }

    protected Font[] findFont(String string, CSS20Attribute cSS20Attribute) {
        Font[] fontArray = null;
        CSSFontsWithSameName cSSFontsWithSameName = (CSSFontsWithSameName)this.fontsByFamilyName.get(this.normalizer.normalize(string));
        if (cSSFontsWithSameName != null) {
            fontArray = cSSFontsWithSameName.findFont(cSS20Attribute);
        }
        return fontArray;
    }

    public Font findFont(CSS20Attribute cSS20Attribute, ULocale uLocale) throws FontException {
        List list = cSS20Attribute.getFamilyNamesList();
        this.replaceGenericFontFamily(list);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            Font[] fontArray = this.findFont(string, cSS20Attribute);
            if (fontArray == null) continue;
            return fontArray[0];
        }
        Iterator iterator = this.getFallbackFontSet().getFallbackFonts(uLocale);
        if (iterator.hasNext()) {
            return (Font)iterator.next();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSS20FontDatabase)) {
            return false;
        }
        CSS20FontDatabase cSS20FontDatabase = (CSS20FontDatabase)object;
        return this.fontsByFamilyName.equals(cSS20FontDatabase.fontsByFamilyName) && this.serif.equals(cSS20FontDatabase.serif) && this.sansSerif.equals(cSS20FontDatabase.sansSerif) && this.monospace.equals(cSS20FontDatabase.monospace) && this.fantasy.equals(cSS20FontDatabase.fantasy) && this.cursive.equals(cSS20FontDatabase.cursive) && this.fallbackFontSet.equals(cSS20FontDatabase.fallbackFontSet);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.fontsByFamilyName.hashCode();
        int n3 = this.serif.hashCode();
        int n4 = this.sansSerif.hashCode();
        int n5 = this.monospace.hashCode();
        int n6 = this.fantasy.hashCode();
        int n7 = this.cursive.hashCode();
        int n8 = this.fallbackFontSet.hashCode();
        n = n2 ^ n3 ^ n4 ^ n5 ^ n6 ^ n7 ^ n8;
        return n;
    }

    public String toString() {
        TreeSet treeSet = new TreeSet();
        Object object = this.fontsByFamilyName.keySet().iterator();
        while (object.hasNext()) {
            treeSet.add(object.next());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("family names:\n");
        for (String string : treeSet) {
            ((StringBuffer)object).append("  ");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(" = ");
            ((StringBuffer)object).append(this.fontsByFamilyName.get(string).toString());
            ((StringBuffer)object).append("\n");
        }
        ((StringBuffer)object).append("generic names:\n");
        this.toString((StringBuffer)object, "serif", this.serif);
        this.toString((StringBuffer)object, "sans", this.sansSerif);
        this.toString((StringBuffer)object, "mono", this.monospace);
        this.toString((StringBuffer)object, "fantasy", this.fantasy);
        this.toString((StringBuffer)object, "cursive", this.cursive);
        ((StringBuffer)object).append("fallback fonts:\n");
        ((StringBuffer)object).append(this.fallbackFontSet.toString());
        return ((StringBuffer)object).toString();
    }

    protected void toString(StringBuffer stringBuffer, String string, ArrayList arrayList) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (Object object : arrayList) {
            int n = 0;
            if (treeMap.containsKey(object)) {
                n = (Integer)treeMap.get(object);
            }
            treeMap.put((String)object, new Integer(++n));
        }
        stringBuffer.append("  ");
        stringBuffer.append(string);
        stringBuffer.append(" = {");
        Object object = "'";
        for (String string2 : treeMap.keySet()) {
            int n = (Integer)treeMap.get(string2);
            while (n-- > 0) {
                stringBuffer.append((String)object);
                stringBuffer.append("'");
                stringBuffer.append(string2);
                stringBuffer.append("'");
                object = ", ";
            }
        }
        stringBuffer.append("}\n");
    }

    final class CSSFontsWithSameName
    implements Serializable {
        static final long serialVersionUID = 1L;
        private ArrayList[][] fonts = new ArrayList[2][3];
        private static final int kVariantNormal = 0;
        private static final int kVariantSmallCaps = 1;
        private static final int kVariantSize = 2;
        private static final int kStyleNormal = 0;
        private static final int kStyleOblique = 1;
        private static final int kStyleItalic = 2;
        private static final int kStyleSize = 3;

        protected CSSFontsWithSameName() {
        }

        protected CSSFontsWithSameName(CSSFontsWithSameName cSSFontsWithSameName) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (cSSFontsWithSameName.fonts[i][j] == null) continue;
                    this.fonts[i][j] = (ArrayList)cSSFontsWithSameName.fonts[i][j].clone();
                }
            }
        }

        protected boolean addFont(FontProxy fontProxy) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
            CSS20FontDescription cSS20FontDescription = (CSS20FontDescription)fontProxy.getFontDescription();
            ArrayList arrayList = this.pickStyleVariantList(cSS20FontDescription.getVariant(), cSS20FontDescription.getStyle(), true);
            return this.insertFontInList(arrayList, fontProxy);
        }

        protected boolean insertFontInList(ArrayList arrayList, FontProxy fontProxy) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
            boolean bl = true;
            if (arrayList.size() == 0) {
                arrayList.add(fontProxy);
            }
            CSS20FontDescription cSS20FontDescription = (CSS20FontDescription)fontProxy.getFontDescription();
            int[] nArray = new int[]{0, arrayList.size()};
            this.findWeightRange(cSS20FontDescription.getWeight(), arrayList, nArray);
            int n = ((CSS20FontDescription)((FontProxy)arrayList.get(nArray[0])).getFontDescription()).getWeight();
            if (cSS20FontDescription.getWeight() < n) {
                arrayList.add(nArray[0], fontProxy);
            } else if (cSS20FontDescription.getWeight() > n) {
                arrayList.add(nArray[1], fontProxy);
            } else {
                this.findStretchRange(cSS20FontDescription.getStretch(), arrayList, nArray);
                int n2 = ((CSS20FontDescription)((FontProxy)arrayList.get(nArray[0])).getFontDescription()).getStretch().getValue();
                if (cSS20FontDescription.getStretch().getValue() < n2) {
                    arrayList.add(nArray[0], fontProxy);
                } else if (cSS20FontDescription.getStretch().getValue() > n2) {
                    arrayList.add(nArray[1], fontProxy);
                } else if (CSS20FontDatabase.this.resolutionPriority == FontResolutionPriority.LAST) {
                    arrayList.add(nArray[0], fontProxy);
                } else if (CSS20FontDatabase.this.resolutionPriority == FontResolutionPriority.FIRST) {
                    arrayList.add(nArray[1], fontProxy);
                } else {
                    Font font = ((FontProxy)arrayList.get(nArray[0])).getFont();
                    Font font2 = IntelligentResolver.choosePreferredFont(font, fontProxy.getFont(), CSS20FontDatabase.this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST);
                    if (font2 == font) {
                        arrayList.add(nArray[1], fontProxy);
                    } else {
                        arrayList.add(nArray[0], fontProxy);
                    }
                }
            }
            return bl;
        }

        protected int findWeightRange(int n, ArrayList arrayList, int[] nArray) {
            int n2 = 0;
            int[] nArray2 = new int[]{nArray[0], nArray[0]};
            for (int i = nArray[0]; i < nArray[1]; ++i) {
                FontProxy fontProxy = (FontProxy)arrayList.get(i);
                CSS20FontDescription cSS20FontDescription = (CSS20FontDescription)fontProxy.getFontDescription();
                int n3 = cSS20FontDescription.getWeight();
                if (n3 == n2) {
                    nArray2[1] = i;
                    continue;
                }
                if (n3 <= n2) continue;
                if (n3 <= n) {
                    nArray2[0] = i;
                    nArray2[1] = i;
                    n2 = n3;
                    continue;
                }
                if (n2 == 0) {
                    nArray2[0] = i;
                    nArray2[1] = i;
                    n2 = n3;
                    continue;
                }
                if (n <= CSS20Attribute.CSSWeightValue.W500.getValue() || n2 >= n) break;
                nArray2[0] = i;
                nArray2[1] = i;
                n2 = n3;
            }
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1] + 1;
            return nArray[0];
        }

        protected int findStretchRange(CSS20Attribute.CSSStretchValue cSSStretchValue, ArrayList arrayList, int[] nArray) {
            int n = 0;
            int[] nArray2 = new int[]{nArray[0], nArray[0]};
            int n2 = cSSStretchValue.getValue();
            for (int i = nArray[0]; i < nArray[1]; ++i) {
                FontProxy fontProxy = (FontProxy)arrayList.get(i);
                CSS20FontDescription cSS20FontDescription = (CSS20FontDescription)fontProxy.getFontDescription();
                int n3 = cSS20FontDescription.getStretch().getValue();
                if (n3 == n) {
                    nArray2[1] = i;
                    continue;
                }
                if (n3 <= n) continue;
                if (n3 <= n2) {
                    nArray2[0] = i;
                    nArray2[1] = i;
                    n = n3;
                    continue;
                }
                if (n == 0) {
                    nArray2[0] = i;
                    nArray2[1] = i;
                    n = n3;
                    continue;
                }
                if (n2 <= CSS20Attribute.CSSStretchValue.NORMAL.getValue() || n >= n2) break;
                nArray2[0] = i;
                nArray2[1] = i;
                n = n3;
            }
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1] + 1;
            return nArray[0];
        }

        protected int findOpticalSize(double d, ArrayList arrayList, int[] nArray) {
            for (int i = nArray[0]; i < nArray[1]; ++i) {
                FontProxy fontProxy = (FontProxy)arrayList.get(i);
                CSS20FontDescription cSS20FontDescription = (CSS20FontDescription)fontProxy.getFontDescription();
                double d2 = cSS20FontDescription.getLowPointSize();
                double d3 = cSS20FontDescription.getHighPointSize();
                if (!(d >= d2) || !(d < d3)) continue;
                return i;
            }
            return nArray[0];
        }

        protected Font[] findFont(CSS20Attribute cSS20Attribute) {
            ArrayList arrayList = this.pickStyleVariantList(cSS20Attribute.getVariant(), cSS20Attribute.getStyle(), false);
            Font[] fontArray = null;
            if (arrayList != null) {
                int n = 0;
                int[] nArray = new int[]{0, arrayList.size()};
                this.findWeightRange(cSS20Attribute.getWeight(), arrayList, nArray);
                this.findStretchRange(cSS20Attribute.getStretch(), arrayList, nArray);
                n = this.findOpticalSize(cSS20Attribute.getOpticalSize(), arrayList, nArray);
                fontArray = new Font[nArray[1] - nArray[0]];
                for (int i = 0; i < fontArray.length; ++i) {
                    fontArray[i] = ((FontProxy)arrayList.get(n)).getFont();
                    n = ++n == nArray[1] ? nArray[0] : n;
                }
            }
            return fontArray;
        }

        protected void removeFont(FontProxy fontProxy) {
            CSS20FontDescription cSS20FontDescription = (CSS20FontDescription)fontProxy.getFontDescription();
            ArrayList arrayList = this.pickStyleVariantList(cSS20FontDescription.getVariant(), cSS20FontDescription.getStyle(), true);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                FontProxy fontProxy2 = (FontProxy)iterator.next();
                if (fontProxy != fontProxy2) continue;
                iterator.remove();
                break;
            }
        }

        private ArrayList pickStyleVariantList(CSS20Attribute.CSSVariantValue cSSVariantValue, CSS20Attribute.CSSStyleValue cSSStyleValue, boolean bl) {
            int n = cSSVariantValue == CSS20Attribute.CSSVariantValue.NORMAL || CSS20FontDatabase.this.ignoreVariant ? 0 : 1;
            int n2 = cSSStyleValue == CSS20Attribute.CSSStyleValue.NORMAL ? 0 : (cSSStyleValue == CSS20Attribute.CSSStyleValue.OBLIQUE ? 1 : 2);
            if (bl && this.fonts[n][n2] == null) {
                this.fonts[n][n2] = new ArrayList();
            }
            return this.fonts[n][n2];
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof CSSFontsWithSameName)) {
                return false;
            }
            CSSFontsWithSameName cSSFontsWithSameName = (CSSFontsWithSameName)object;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (!(this.fonts[i][j] != null ? !this.fonts[i][j].equals(cSSFontsWithSameName.fonts[i][j]) : cSSFontsWithSameName.fonts[i][j] != null)) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.fonts[i][j] == null) continue;
                    n ^= this.fonts[i][j].hashCode();
                }
            }
            return n;
        }

        public String toString() {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.fonts.length; ++i) {
                for (int j = 0; j < this.fonts[i].length; ++j) {
                    if (this.fonts[i][j] == null) continue;
                    Iterator iterator = this.fonts[i][j].iterator();
                    while (iterator.hasNext()) {
                        String string = iterator.next().toString();
                        int n = 0;
                        if (treeMap.containsKey(string)) {
                            n = (Integer)treeMap.get(string);
                        }
                        treeMap.put(string, new Integer(++n));
                    }
                }
            }
            for (String string : treeMap.keySet()) {
                int n = (Integer)treeMap.get(string);
                while (n-- > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
            }
            return stringBuffer.toString();
        }
    }
}

