/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.mac.FONDResourceHandler;
import com.adobe.fontengine.font.mac.ResourceFontData;
import com.adobe.fontengine.font.mac.sfntResourceHandler;
import com.adobe.fontengine.font.mac.versResourceHandler;
import com.adobe.fontengine.fontmanagement.ResourceFont;
import com.adobe.internal.io.ExtendedDataInputStream;
import com.adobe.internal.mac.resource.ResourceParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class FontFactory {
    private static final String RESOURCE_FORK_EXTENSION = "/..namedfork/rsrc";
    private static final String DFONT_SUFFIX = ".dfont";
    public static final int UNKNOWN = 0;
    public static final int RESOURCE_FORK_FONT = 1;
    public static final int DATA_FORK_FONT = 2;
    private static final String[] SCRIPTID_TO_ULOCALE = new String[]{"en", "ja", "zh-Hant", "ko", "ar", "he", "el", "ru", "MacSymbol", "hi", "pa", "gu", null, null, null, null, null, null, null, null, null, "th", null, null, null, "zh-Hans", null, null, null, "MacCentralEuropean", null, null, null};

    public static FontData load(URL uRL, int n, int n2, int n3) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        ResourceFontData resourceFontData = null;
        ResourceParser resourceParser = new ResourceParser();
        FONDResourceHandler fONDResourceHandler = new FONDResourceHandler();
        versResourceHandler versResourceHandler2 = new versResourceHandler();
        sfntResourceHandler sfntResourceHandler2 = new sfntResourceHandler(n2);
        resourceParser.addHandler((ResourceParser.ResourceHandler)fONDResourceHandler);
        resourceParser.addHandler((ResourceParser.ResourceHandler)versResourceHandler2);
        resourceParser.addHandler((ResourceParser.ResourceHandler)sfntResourceHandler2);
        try {
            resourceParser.setURL(uRL);
            resourceParser.parse();
        }
        catch (IOException iOException) {
            throw new FontLoadingException(iOException);
        }
        Map<Integer, sfntResourceHandler.SfntResource> map = sfntResourceHandler2.getResources();
        Set<FONDResourceHandler.Association> set = fONDResourceHandler.getAssociations();
        for (FONDResourceHandler.Association association : set) {
            Font font;
            sfntResourceHandler.SfntResource sfntResource;
            if (n3 != association.getFondID() || n2 != association.getFontID() || (sfntResource = map.get(n2)) == null || (font = sfntResource.getFont()) == null) continue;
            resourceFontData = new ResourceFontData(((FontImpl)font).getFontData(), FontFactory.scriptCodeToCharset(sfntResource.getScriptCode()), association.getName(), sfntResource.getName(), association.isBold(), association.isItalic());
            break;
        }
        return resourceFontData;
    }

    public static ResourceFont[] load(URL uRL, int n) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        ResourceParser resourceParser = new ResourceParser();
        FONDResourceHandler fONDResourceHandler = new FONDResourceHandler();
        versResourceHandler versResourceHandler2 = new versResourceHandler();
        sfntResourceHandler sfntResourceHandler2 = new sfntResourceHandler();
        resourceParser.addHandler((ResourceParser.ResourceHandler)fONDResourceHandler);
        resourceParser.addHandler((ResourceParser.ResourceHandler)versResourceHandler2);
        resourceParser.addHandler((ResourceParser.ResourceHandler)sfntResourceHandler2);
        try {
            if (n == 1) {
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + RESOURCE_FORK_EXTENSION);
            }
            resourceParser.setURL(uRL);
            resourceParser.parse();
        }
        catch (IOException iOException) {
            throw new FontLoadingException(iOException);
        }
        Map<Integer, sfntResourceHandler.SfntResource> map = sfntResourceHandler2.getResources();
        Set<FONDResourceHandler.Association> set = fONDResourceHandler.getAssociations();
        ArrayList<ResourceFont> arrayList = new ArrayList<ResourceFont>();
        for (FONDResourceHandler.Association association : set) {
            Font font;
            int n2 = association.getFontID();
            sfntResourceHandler.SfntResource sfntResource = map.get(n2);
            if (sfntResource == null || (font = sfntResource.getFont()) == null) continue;
            ResourceFontData resourceFontData = new ResourceFontData(((FontImpl)font).getFontData(), FontFactory.scriptCodeToCharset(sfntResource.getScriptCode()), association.getName(), sfntResource.getName(), association.isBold(), association.isItalic());
            ResourceFont resourceFont = new ResourceFont(uRL, n, n2, association.getFondID(), resourceFontData);
            arrayList.add(resourceFont);
        }
        ResourceFont[] resourceFontArray = new ResourceFont[arrayList.size()];
        return arrayList.toArray(resourceFontArray);
    }

    public static int getNumBytesNeededToIdentify() {
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int isResourceFont(byte[] byArray, URL uRL) throws IOException {
        InputStream inputStream = null;
        int n = 0;
        try {
            long l;
            long l2;
            long l3;
            long l4;
            inputStream = FontFactory.getDataResourceFontStream(uRL);
            if (inputStream != null) {
                n = 2;
            } else {
                inputStream = FontFactory.getResourceStream(uRL);
                if (inputStream != null) {
                    n = 1;
                }
            }
            if (inputStream == null) {
                int n2 = 0;
                return n2;
            }
            try {
                ExtendedDataInputStream extendedDataInputStream = new ExtendedDataInputStream(inputStream);
                l4 = extendedDataInputStream.readUnsignedInt();
                l3 = extendedDataInputStream.readUnsignedInt();
                l2 = extendedDataInputStream.readUnsignedInt();
                l = extendedDataInputStream.readUnsignedInt();
            }
            catch (Exception exception) {
                int n3 = 0;
                if (inputStream != null) {
                    inputStream.close();
                }
                return n3;
            }
            if (l3 > l4 && l3 < l4 + l2 || l4 > l3 && l4 < l3 + l) {
                int n4 = 0;
                return n4;
            }
            int n5 = n;
            return n5;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static InputStream getResourceStream(URL uRL) throws IOException {
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + RESOURCE_FORK_EXTENSION);
        InputStream inputStream = null;
        try {
            inputStream = uRL2.openStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return inputStream;
    }

    private static InputStream getDataResourceFontStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        String string = uRL.getFile();
        if (string.endsWith(DFONT_SUFFIX)) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    static final ULocale scriptCodeToCharset(int n) {
        String string = SCRIPTID_TO_ULOCALE[n = Math.min(n, SCRIPTID_TO_ULOCALE.length - 1)];
        if (string == null) {
            string = SCRIPTID_TO_ULOCALE[0];
        }
        return new ULocale(string);
    }
}

